/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.BaseWriterContainer;
import org.apache.spark.sql.sources.HadoopFsRelation;
import org.apache.spark.sql.sources.OutputWriter;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;

@ScalaSignature(bytes="\u0006\u0001Y3Q!\u0001\u0002\u0001\r9\u0011a\u0003R3gCVdGo\u0016:ji\u0016\u00148i\u001c8uC&tWM\u001d\u0006\u0003\u0007\u0011\t1\u0002Z1uCN|WO]2fg*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\t\u0001q\u0002\u0005\u0002\u0011#5\t!!\u0003\u0002\u0013\u0005\t\u0019\")Y:f/JLG/\u001a:D_:$\u0018-\u001b8fe\"IA\u0003\u0001B\u0001B\u0003%a\u0003H\u0001\te\u0016d\u0017\r^5p]\u000e\u0001\u0001CA\f\u001b\u001b\u0005A\"BA\r\u0007\u0003\u001d\u0019x.\u001e:dKNL!a\u0007\r\u0003!!\u000bGm\\8q\rN\u0014V\r\\1uS>t\u0017B\u0001\u000b\u0012\u0011!q\u0002A!A!\u0002\u0013y\u0012a\u00016pEB\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!\u0001\n\u0006\u0002\r!\fGm\\8q\u0013\t1\u0013EA\u0002K_\nD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\tSN\f\u0005\u000f]3oIB\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t9!i\\8mK\u0006t\u0007\"\u0002\u0019\u0001\t\u0003\t\u0014A\u0002\u001fj]&$h\b\u0006\u00033gQ*\u0004C\u0001\t\u0001\u0011\u0015!r\u00061\u0001\u0017\u0011\u0015qr\u00061\u0001 \u0011\u0015As\u00061\u0001*\u0011\u00159\u0004\u0001\"\u00019\u0003%9(/\u001b;f%><8\u000fF\u0002:y\t\u0003\"A\u000b\u001e\n\u0005mZ#\u0001B+oSRDQ!\u0010\u001cA\u0002y\n1\u0002^1tW\u000e{g\u000e^3yiB\u0011q\bQ\u0007\u0002\u0011%\u0011\u0011\t\u0003\u0002\f)\u0006\u001c8nQ8oi\u0016DH\u000fC\u0003Dm\u0001\u0007A)\u0001\u0005ji\u0016\u0014\u0018\r^8s!\r)U\n\u0015\b\u0003\r.s!a\u0012&\u000e\u0003!S!!S\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013B\u0001',\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u0011%#XM]1u_JT!\u0001T\u0016\u0011\u0005E#V\"\u0001*\u000b\u0005M3\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005U\u0013&aC%oi\u0016\u0014h.\u00197S_^\u0004")
public class DefaultWriterContainer
extends BaseWriterContainer {
    @Override
    public void writeRows(TaskContext taskContext, Iterator<InternalRow> iterator) {
        this.executorSideSetup(taskContext);
        Configuration configuration = SparkHadoopUtil$.MODULE$.get().getConfigurationFromJobContext((JobContext)this.taskAttemptContext());
        configuration.set("spark.sql.sources.output.path", this.outputPath());
        OutputWriter writer = this.newOutputWriter(this.getWorkPath());
        writer.initConverter(this.dataSchema());
        BooleanRef writerClosed = BooleanRef.create((boolean)false);
        try {
            while (iterator.hasNext()) {
                InternalRow internalRow = (InternalRow)iterator.next();
                writer.writeInternal(internalRow);
            }
            this.commitTask$1(writer, writerClosed);
            return;
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Aborting task.";
                }
            }, throwable);
            this.abortTask$1(writer, writerClosed);
            throw new SparkException("Task failed while writing rows.", throwable);
        }
    }

    private final void commitTask$1(OutputWriter writer$1, BooleanRef writerClosed$1) {
        try {
            Predef$.MODULE$.assert(writer$1 != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "OutputWriter instance should have been initialized";
                }
            });
            if (!writerClosed$1.elem) {
                writer$1.close();
                writerClosed$1.elem = true;
            }
            super.commitTask();
            return;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to commit task", throwable);
        }
    }

    private final void abortTask$1(OutputWriter writer$1, BooleanRef writerClosed$1) {
        try {
            if (!writerClosed$1.elem) {
                writer$1.close();
                writerClosed$1.elem = true;
            }
            return;
        }
        finally {
            super.abortTask();
        }
    }

    public DefaultWriterContainer(HadoopFsRelation relation, Job job, boolean isAppend) {
        super(relation, job, isAppend);
    }
}

