/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.parquet.io.api.Binary;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.RowWriteSupport;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001q2Q!\u0001\u0002\u0001\u0005A\u0011a#T;uC\ndWMU8x/JLG/Z*vaB|'\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001]1scV,GO\u0003\u0002\u0006\r\u0005YA-\u0019;bg>,(oY3t\u0015\t9\u0001\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0014\u0005\u0001\t\u0002C\u0001\n\u0014\u001b\u0005\u0011\u0011B\u0001\u000b\u0003\u0005=\u0011vn^,sSR,7+\u001e9q_J$\b\"\u0002\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003e\u0001\"A\u0005\u0001\t\u000bm\u0001A\u0011\t\u000f\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDQ\u0001\n\u000eA\u0002\u0015\naA]3d_J$\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\t\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u0016(\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000b1\u0002A\u0011B\u0017\u0002\u0017\r|gn];nKRK\b/\u001a\u000b\u0005;92t\u0007C\u00030W\u0001\u0007\u0001'A\u0003dif\u0004X\r\u0005\u00022i5\t!G\u0003\u00024\u0011\u0005)A/\u001f9fg&\u0011QG\r\u0002\t\t\u0006$\u0018\rV=qK\")Ae\u000ba\u0001K!)\u0001h\u000ba\u0001s\u0005)\u0011N\u001c3fqB\u0011aDO\u0005\u0003w}\u00111!\u00138u\u0001")
public class MutableRowWriteSupport
extends RowWriteSupport {
    @Override
    public void write(InternalRow record) {
        int attributesSize = Predef$.MODULE$.refArrayOps((Object[])this.attributes()).size();
        if (attributesSize > record.numFields()) {
            throw new IndexOutOfBoundsException(new StringBuilder().append((Object)"Trying to write more fields than contained in row ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " > ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)attributesSize), BoxesRunTime.boxToInteger((int)record.numFields())}))).toString());
        }
        this.writer().startMessage();
        for (int index = 0; index < attributesSize; ++index) {
            if (record.isNullAt(index) || record.isNullAt(index)) continue;
            this.writer().startField(this.attributes()[index].name(), index);
            this.consumeType(this.attributes()[index].dataType(), record, index);
            this.writer().endField(this.attributes()[index].name(), index);
        }
        this.writer().endMessage();
    }

    private void consumeType(DataType ctype, InternalRow record, int index) {
        block13: {
            block3: {
                DecimalType decimalType;
                Option option;
                DataType dataType;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block2: {
                                                        dataType = ctype;
                                                        if (!BooleanType$.MODULE$.equals(dataType)) break block2;
                                                        this.writer().addBoolean(record.getBoolean(index));
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block3;
                                                    }
                                                    if (!ByteType$.MODULE$.equals(dataType)) break block4;
                                                    this.writer().addInteger((int)record.getByte(index));
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (!ShortType$.MODULE$.equals(dataType)) break block5;
                                                this.writer().addInteger((int)record.getShort(index));
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType);
                                            if (!bl) break block6;
                                            this.writer().addInteger(record.getInt(index));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (!LongType$.MODULE$.equals(dataType)) break block7;
                                        this.writer().addLong(record.getLong(index));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!TimestampType$.MODULE$.equals(dataType)) break block8;
                                    this.writeTimestamp(record.getLong(index));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                if (!FloatType$.MODULE$.equals(dataType)) break block9;
                                this.writer().addFloat(record.getFloat(index));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!DoubleType$.MODULE$.equals(dataType)) break block10;
                            this.writer().addDouble(record.getDouble(index));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!StringType$.MODULE$.equals(dataType)) break block11;
                        this.writer().addBinary(Binary.fromByteArray((byte[])record.getUTF8String(index).getBytes()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!BinaryType$.MODULE$.equals(dataType)) break block12;
                    this.writer().addBinary(Binary.fromByteArray((byte[])record.getBinary(index)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(dataType instanceof DecimalType) || (option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) break block13;
                int precision = ((Tuple2)option.get())._1$mcI$sp();
                int scale = ((Tuple2)option.get())._2$mcI$sp();
                this.writeDecimal(record.getDecimal(index, precision, scale), precision);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported datatype ", ", cannot write to consumer"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctype})));
    }
}

