/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.analysis.HiveTypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.types.ArrayType;
import org.apache.spark.sql.catalyst.types.BinaryType$;
import org.apache.spark.sql.catalyst.types.BooleanType$;
import org.apache.spark.sql.catalyst.types.ByteType$;
import org.apache.spark.sql.catalyst.types.DataType;
import org.apache.spark.sql.catalyst.types.DateType$;
import org.apache.spark.sql.catalyst.types.DecimalType$;
import org.apache.spark.sql.catalyst.types.DoubleType$;
import org.apache.spark.sql.catalyst.types.FloatType$;
import org.apache.spark.sql.catalyst.types.IntegerType$;
import org.apache.spark.sql.catalyst.types.LongType$;
import org.apache.spark.sql.catalyst.types.MapType;
import org.apache.spark.sql.catalyst.types.NullType$;
import org.apache.spark.sql.catalyst.types.ShortType$;
import org.apache.spark.sql.catalyst.types.StringType$;
import org.apache.spark.sql.catalyst.types.StructField;
import org.apache.spark.sql.catalyst.types.StructField$;
import org.apache.spark.sql.catalyst.types.StructType;
import org.apache.spark.sql.catalyst.types.TimestampType$;
import org.apache.spark.sql.catalyst.types.UserDefinedType;
import org.apache.spark.sql.catalyst.types.decimal.Decimal;
import org.apache.spark.sql.catalyst.types.decimal.Decimal$;
import org.apache.spark.sql.json.JsonRDD$;
import org.apache.spark.sql.json.JsonRDD$$anonfun$org$apache$spark$sql$json$JsonRDD$;
import org.apache.spark.sql.types.util.DataTypeConversions$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.Wrappers;
import scala.collection.convert.Wrappers$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class JsonRDD$
implements Logging {
    public static final JsonRDD$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new JsonRDD$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Row> jsonStringToRow(RDD<String> json, StructType schema, String columnNameOfCorruptRecords) {
        return this.parseJson(json, columnNameOfCorruptRecords).map((Function1)new Serializable(schema){
            private final StructType schema$1;

            public final Row apply(Map<String, Object> parsed) {
                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$asRow(parsed, this.schema$1);
            }
            {
                this.schema$1 = schema$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
    }

    public StructType inferSchema(RDD<String> json, double samplingRatio, String columnNameOfCorruptRecords) {
        Predef$.MODULE$.require(samplingRatio > 0.0, (Function0)new Serializable(samplingRatio){
            private final double samplingRatio$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"samplingRatio (", ") should be greater than 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.samplingRatio$1)}));
            }
            {
                this.samplingRatio$1 = samplingRatio$1;
            }
        });
        RDD schemaData = samplingRatio > 0.99 ? json : json.sample(false, samplingRatio, 1L);
        Set allKeys = (Set)this.parseJson((RDD<String>)schemaData, columnNameOfCorruptRecords).map((Function1)new Serializable(){

            public final Set<Tuple2<String, DataType>> apply(Map<String, Object> m) {
                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(m);
            }
        }, ClassTag$.MODULE$.apply(Set.class)).reduce((Function2)new Serializable(){

            public final Set<Tuple2<String, DataType>> apply(Set<Tuple2<String, DataType>> x$1, Set<Tuple2<String, DataType>> x$2) {
                return (Set)x$1.$plus$plus(x$2);
            }
        });
        return this.createSchema((Set<Tuple2<String, DataType>>)allKeys);
    }

    public double inferSchema$default$2() {
        return 1.0;
    }

    private StructType createSchema(Set<Tuple2<String, DataType>> allKeys) {
        scala.collection.immutable.Map resolved = (scala.collection.immutable.Map)allKeys.groupBy((Function1)new Serializable(){

            public final String apply(Tuple2<String, DataType> x0$1) {
                Tuple2<String, DataType> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key;
                    String string = key = (String)tuple2._1();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(){

            public final Tuple2<Seq<String>, DataType> apply(Tuple2<String, Set<Tuple2<String, DataType>>> x0$2) {
                Tuple2<String, Set<Tuple2<String, DataType>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Set typeSet = (Set)tuple2._2();
                    Seq fieldName = Predef$.MODULE$.refArrayOps((Object[])key.substring(1, key.length() - 1).split("`.`")).toSeq();
                    DataType dataType = (DataType)((TraversableOnce)typeSet.map((Function1)new Serializable(this){

                        public final DataType apply(Tuple2<String, DataType> x0$3) {
                            Tuple2<String, DataType> tuple2 = x0$3;
                            if (tuple2 != null) {
                                DataType dataType;
                                DataType dataType2 = dataType = (DataType)tuple2._2();
                                return dataType2;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Set$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){

                        public final DataType apply(DataType type1, DataType type2) {
                            return JsonRDD$.MODULE$.compatibleType(type1, type2);
                        }
                    });
                    Tuple2 tuple22 = new Tuple2((Object)fieldName, (Object)dataType);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return this.org$apache$spark$sql$json$JsonRDD$$makeStruct$1(resolved.keySet().toSeq(), (Seq)Nil$.MODULE$, resolved);
    }

    public StructType nullTypeToStringType(StructType struct) {
        Seq fields = (Seq)struct.fields().map((Function1)new Serializable(){

            public final StructField apply(StructField x0$6) {
                StructField structField;
                block2: {
                    DataType dataType;
                    block8: {
                        StringType$ stringType$;
                        boolean nullable;
                        String fieldName;
                        block4: {
                            block7: {
                                block6: {
                                    ArrayType arrayType;
                                    boolean bl;
                                    block5: {
                                        block3: {
                                            structField = x0$6;
                                            if (structField == null) break block2;
                                            fieldName = structField.name();
                                            DataType dataType2 = structField.dataType();
                                            nullable = structField.nullable();
                                            bl = false;
                                            arrayType = null;
                                            dataType = dataType2;
                                            if (!NullType$.MODULE$.equals(dataType)) break block3;
                                            stringType$ = StringType$.MODULE$;
                                            break block4;
                                        }
                                        if (!(dataType instanceof ArrayType)) break block5;
                                        bl = true;
                                        arrayType = (ArrayType)dataType;
                                        DataType dataType3 = arrayType.elementType();
                                        boolean containsNull = arrayType.containsNull();
                                        if (!NullType$.MODULE$.equals(dataType3)) break block5;
                                        stringType$ = new ArrayType((DataType)StringType$.MODULE$, containsNull);
                                        break block4;
                                    }
                                    if (!bl) break block6;
                                    DataType struct = arrayType.elementType();
                                    boolean containsNull = arrayType.containsNull();
                                    if (!(struct instanceof StructType)) break block6;
                                    StructType structType = (StructType)struct;
                                    stringType$ = new ArrayType((DataType)JsonRDD$.MODULE$.nullTypeToStringType(structType), containsNull);
                                    break block4;
                                }
                                if (!(dataType instanceof StructType)) break block7;
                                StructType structType = (StructType)dataType;
                                stringType$ = JsonRDD$.MODULE$.nullTypeToStringType(structType);
                                break block4;
                            }
                            if (dataType == null) break block8;
                            DataType dataType4 = dataType;
                            stringType$ = dataType4;
                        }
                        StringType$ newType = stringType$;
                        StructField structField2 = new StructField(fieldName, (DataType)newType, nullable, StructField$.MODULE$.apply$default$4());
                        return structField2;
                    }
                    throw new MatchError((Object)dataType);
                }
                throw new MatchError((Object)structField);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new StructType(fields);
    }

    public DataType compatibleType(DataType t1, DataType t2) {
        Option option;
        block4: {
            Tuple2 tuple2;
            block10: {
                DataType dataType;
                block3: {
                    StringType$ stringType$;
                    block6: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        block2: {
                                            DataType commonType;
                                            option = HiveTypeCoercion$.MODULE$.findTightestCommonType(t1, t2);
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            dataType = commonType = (DataType)some.x();
                                            break block3;
                                        }
                                        if (!None$.MODULE$.equals(option)) break block4;
                                        tuple2 = new Tuple2((Object)t1, (Object)t2);
                                        if (tuple2 == null) break block5;
                                        DataType other = (DataType)tuple2._1();
                                        DataType dataType2 = (DataType)tuple2._2();
                                        if (other == null) break block5;
                                        DataType dataType3 = other;
                                        if (!NullType$.MODULE$.equals(dataType2)) break block5;
                                        stringType$ = dataType3;
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    DataType dataType4 = (DataType)tuple2._1();
                                    DataType other = (DataType)tuple2._2();
                                    if (!NullType$.MODULE$.equals(dataType4) || other == null) break block7;
                                    DataType dataType5 = other;
                                    stringType$ = dataType5;
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                DataType dataType6 = (DataType)tuple2._1();
                                DataType dataType7 = (DataType)tuple2._2();
                                if (!(dataType6 instanceof StructType)) break block8;
                                StructType structType = (StructType)dataType6;
                                Seq fields1 = structType.fields();
                                if (!(dataType7 instanceof StructType)) break block8;
                                StructType structType2 = (StructType)dataType7;
                                Seq fields2 = structType2.fields();
                                scala.collection.immutable.Iterable newFields = (scala.collection.immutable.Iterable)((TraversableLike)fields1.$plus$plus((GenTraversableOnce)fields2, Seq$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){

                                    public final String apply(StructField field) {
                                        return field.name();
                                    }
                                }).map((Function1)new Serializable(){

                                    public final StructField apply(Tuple2<String, Seq<StructField>> x0$7) {
                                        Tuple2<String, Seq<StructField>> tuple2 = x0$7;
                                        if (tuple2 != null) {
                                            String name = (String)tuple2._1();
                                            Seq fieldTypes = (Seq)tuple2._2();
                                            DataType dataType = (DataType)((TraversableOnce)fieldTypes.map((Function1)new Serializable(this){

                                                public final DataType apply(StructField field) {
                                                    return field.dataType();
                                                }
                                            }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){

                                                public final DataType apply(DataType type1, DataType type2) {
                                                    return JsonRDD$.MODULE$.compatibleType(type1, type2);
                                                }
                                            });
                                            StructField structField = new StructField(name, dataType, true, StructField$.MODULE$.apply$default$4());
                                            return structField;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                }, Iterable$.MODULE$.canBuildFrom());
                                stringType$ = new StructType((Seq)newFields.toSeq().sortBy((Function1)new Serializable(){

                                    public final String apply(StructField x$9) {
                                        return x$9.name();
                                    }
                                }, (Ordering)Ordering.String$.MODULE$));
                                break block6;
                            }
                            if (tuple2 == null) break block9;
                            DataType dataType8 = (DataType)tuple2._1();
                            DataType dataType9 = (DataType)tuple2._2();
                            if (!(dataType8 instanceof ArrayType)) break block9;
                            ArrayType arrayType = (ArrayType)dataType8;
                            DataType elementType1 = arrayType.elementType();
                            boolean containsNull1 = arrayType.containsNull();
                            if (!(dataType9 instanceof ArrayType)) break block9;
                            ArrayType arrayType2 = (ArrayType)dataType9;
                            DataType elementType2 = arrayType2.elementType();
                            boolean containsNull2 = arrayType2.containsNull();
                            stringType$ = new ArrayType(this.compatibleType(elementType1, elementType2), containsNull1 || containsNull2);
                            break block6;
                        }
                        if (tuple2 == null) break block10;
                        stringType$ = StringType$.MODULE$;
                    }
                    dataType = stringType$;
                }
                return dataType;
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError((Object)option);
    }

    public PartialFunction<Object, DataType> org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue() {
        return ScalaReflection$.MODULE$.typeOfObject().orElse((PartialFunction)new Serializable(){

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof BigInteger ? DecimalType$.MODULE$.Unlimited() : (A1 instanceof BigDecimal ? DecimalType$.MODULE$.Unlimited() : StringType$.MODULE$);
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof BigInteger ? true : (object instanceof BigDecimal ? true : true);
                return bl;
            }
        });
    }

    public ArrayType org$apache$spark$sql$json$JsonRDD$$typeOfArray(Seq<Object> l) {
        ArrayType arrayType;
        boolean containsNull = l.exists((Function1)new Serializable(){

            public final boolean apply(Object v) {
                return v == null;
            }
        });
        Seq elements = (Seq)l.flatMap((Function1)new Serializable(){

            public final Iterable<Object> apply(Object v) {
                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(v));
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (elements.isEmpty()) {
            arrayType = new ArrayType((DataType)NullType$.MODULE$, containsNull);
        } else {
            DataType elementType = (DataType)((TraversableOnce)elements.map((Function1)new Serializable(){

                public final DataType apply(Object e) {
                    StructType structType;
                    Object object = e;
                    if (object instanceof Map) {
                        structType = new StructType((Seq)Nil$.MODULE$);
                    } else if (object instanceof Seq) {
                        Seq seq = (Seq)object;
                        structType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfArray((Seq<Object>)seq);
                    } else {
                        structType = (DataType)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue().apply(object);
                    }
                    return structType;
                }
            }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){

                public final DataType apply(DataType type1, DataType type2) {
                    return JsonRDD$.MODULE$.compatibleType(type1, type2);
                }
            });
            arrayType = new ArrayType(elementType, containsNull);
        }
        return arrayType;
    }

    public Set<Tuple2<String, DataType>> org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(Map<String, Object> m) {
        Set keyValuePairs = ((TraversableOnce)m.map((Function1)new Serializable(){

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$8) {
                Tuple2<String, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), value);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom())).toSet();
        return (Set)keyValuePairs.flatMap((Function1)new Serializable(){

            public final Iterable<Tuple2<String, DataType>> apply(Tuple2<String, Object> x0$9) {
                Tuple2<String, Object> tuple2;
                block5: {
                    List list;
                    block3: {
                        block4: {
                            block2: {
                                tuple2 = x0$9;
                                if (tuple2 == null) break block2;
                                String key = (String)tuple2._1();
                                Object struct = tuple2._2();
                                if (key == null) break block2;
                                String string = key;
                                if (!(struct instanceof Map)) break block2;
                                Map map = (Map)struct;
                                list = ((SetLike)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes((Map<String, Object>)map).map((Function1)new Serializable(this, string){
                                    private final String x2$1;

                                    public final Tuple2<String, DataType> apply(Tuple2<String, DataType> x0$10) {
                                        Tuple2<String, DataType> tuple2 = x0$10;
                                        if (tuple2 != null) {
                                            String k = (String)tuple2._1();
                                            DataType dataType = (DataType)tuple2._2();
                                            Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1, k})), (Object)dataType);
                                            return tuple22;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        this.x2$1 = x2$1;
                                    }
                                }, Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)string, (Object)new StructType((Seq)Nil$.MODULE$))})));
                                break block3;
                            }
                            if (tuple2 == null) break block4;
                            String key = (String)tuple2._1();
                            Object array = tuple2._2();
                            if (key == null) break block4;
                            String string = key;
                            if (!(array instanceof Seq)) break block4;
                            Seq seq = (Seq)array;
                            ArrayType elementType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfArray((Seq<Object>)seq);
                            list = (Iterable)this.org$apache$spark$sql$json$JsonRDD$$anonfun$$buildKeyPathForInnerStructs$1(seq, (DataType)elementType, string).$colon$plus((Object)new Tuple2((Object)string, (Object)elementType), Seq$.MODULE$.canBuildFrom());
                            break block3;
                        }
                        if (tuple2 == null) break block5;
                        String key = (String)tuple2._1();
                        Object value = tuple2._2();
                        if (key == null) break block5;
                        String string = key;
                        Tuple2 tuple22 = new Tuple2((Object)string, JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$typeOfPrimitiveValue().apply(value));
                        list = Nil$.MODULE$.$colon$colon((Object)tuple22);
                    }
                    return list;
                }
                throw new MatchError(tuple2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Seq org$apache$spark$sql$json$JsonRDD$$anonfun$$buildKeyPathForInnerStructs$1(Object v, DataType t, String x4$1) {
                boolean bl = false;
                ArrayType arrayType = null;
                DataType dataType = t;
                if (dataType instanceof ArrayType) {
                    StructType structType;
                    Seq seq;
                    bl = true;
                    arrayType = (ArrayType)dataType;
                    DataType dataType2 = arrayType.elementType();
                    if (dataType2 instanceof StructType && Nil$.MODULE$.equals(seq = (structType = (StructType)dataType2).fields())) {
                        return (Seq)((TraversableLike)((TraversableLike)((Seq)v).flatMap((Function1)new Serializable(this){

                            public final Iterable<Map<String, Object>> apply(Map<String, Object> x$10) {
                                return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$10));
                            }
                        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){

                            public final Set<Tuple2<String, DataType>> apply(Map<String, Object> element) {
                                return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes(element);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, x4$1){
                            private final String x4$1;

                            public final Tuple2<String, DataType> apply(Tuple2<String, DataType> x0$11) {
                                Tuple2<String, DataType> tuple2 = x0$11;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    DataType t = (DataType)tuple2._2();
                                    Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x4$1, k})), (Object)t);
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.x4$1 = x4$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                }
                if (!bl) return Nil$.MODULE$;
                DataType t1 = arrayType.elementType();
                return (Seq)((TraversableLike)((Seq)v).flatMap((Function1)new Serializable(this){

                    public final Iterable<Object> apply(Object x$11) {
                        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(x$11));
                    }
                }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this, t1, x4$1){
                    private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$allKeysWithValueTypes$1 $outer;
                    private final DataType t1$1;
                    private final String x4$1;

                    public final Seq<Tuple2<String, DataType>> apply(Object element) {
                        return this.$outer.org$apache$spark$sql$json$JsonRDD$$anonfun$$buildKeyPathForInnerStructs$1(element, this.t1$1, this.x4$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.t1$1 = t1$1;
                        this.x4$1 = x4$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public Object org$apache$spark$sql$json$JsonRDD$$scalafy(Object obj) {
        Object object;
        Object object2 = obj;
        if (object2 instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object2;
            object = new Wrappers.JMapWrapper((Wrappers)Wrappers$.MODULE$, map).mapValues((Function1)new Serializable(){

                public final Object apply(Object obj) {
                    return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(obj);
                }
            }).map((Function1)new Serializable(){

                public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x) {
                    return (Tuple2)Predef$.MODULE$.identity(x);
                }
            }, Map$.MODULE$.canBuildFrom());
        } else if (object2 instanceof java.util.List) {
            java.util.List list = (java.util.List)object2;
            object = new Wrappers.JListWrapper((Wrappers)Wrappers$.MODULE$, list).map((Function1)new Serializable(){

                public final Object apply(Object obj) {
                    return JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(obj);
                }
            }, Buffer$.MODULE$.canBuildFrom());
        } else {
            object = object2;
        }
        return object;
    }

    private RDD<Map<String, Object>> parseJson(RDD<String> json, String columnNameOfCorruptRecords) {
        return json.mapPartitions((Function1)new Serializable(columnNameOfCorruptRecords){
            public final String columnNameOfCorruptRecords$1;

            public final Iterator<Map<String, Object>> apply(Iterator<String> iter) {
                ObjectMapper mapper = new ObjectMapper();
                return iter.flatMap((Function1)new Serializable(this, mapper){
                    private final /* synthetic */ anonfun.parseJson.1 $outer;
                    private final ObjectMapper mapper$1;

                    public final GenTraversableOnce<Map<String, Object>> apply(String record) {
                        Seq seq;
                        try {
                            Seq parsed;
                            Seq seq2;
                            Object object = this.mapper$1.readValue(record, Object.class);
                            if (object instanceof java.util.Map) {
                                java.util.Map map = (java.util.Map)object;
                                Map map2 = (Map)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(map);
                                seq2 = Nil$.MODULE$.$colon$colon((Object)map2);
                            } else if (object instanceof java.util.List) {
                                java.util.List list = (java.util.List)object;
                                seq2 = (Seq)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$scalafy(list);
                            } else {
                                throw new MatchError(object);
                            }
                            seq = parsed = seq2;
                        }
                        catch (JsonProcessingException jsonProcessingException) {
                            Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.columnNameOfCorruptRecords$1), (Object)record)}));
                            seq = Nil$.MODULE$.$colon$colon((Object)map);
                        }
                        return seq;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.mapper$1 = mapper$1;
                    }
                });
            }
            {
                this.columnNameOfCorruptRecords$1 = columnNameOfCorruptRecords$1;
            }
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Map.class));
    }

    private long toLong(Object value) {
        Object object;
        block4: {
            long l;
            block3: {
                block2: {
                    object = value;
                    if (!(object instanceof Integer)) break block2;
                    Integer n = (Integer)object;
                    l = BoxesRunTime.unboxToInt((Object)n);
                    break block3;
                }
                if (!(object instanceof Long)) break block4;
                Long l2 = (Long)object;
                l = BoxesRunTime.unboxToLong((Object)l2);
            }
            return l;
        }
        throw new MatchError(object);
    }

    private double toDouble(Object value) {
        Object object;
        block5: {
            double d;
            block3: {
                block4: {
                    block2: {
                        object = value;
                        if (!(object instanceof Integer)) break block2;
                        Integer n = (Integer)object;
                        d = BoxesRunTime.unboxToInt((Object)n);
                        break block3;
                    }
                    if (!(object instanceof Long)) break block4;
                    Long l = (Long)object;
                    d = BoxesRunTime.unboxToLong((Object)l);
                    break block3;
                }
                if (!(object instanceof Double)) break block5;
                Double d2 = (Double)object;
                d = BoxesRunTime.unboxToDouble((Object)d2);
            }
            return d;
        }
        throw new MatchError(object);
    }

    private Decimal toDecimal(Object value) {
        Object object;
        block7: {
            Decimal decimal;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                object = value;
                                if (!(object instanceof Integer)) break block2;
                                Integer n = (Integer)object;
                                decimal = Decimal$.MODULE$.apply(Predef$.MODULE$.Integer2int(n));
                                break block3;
                            }
                            if (!(object instanceof Long)) break block4;
                            Long l = (Long)object;
                            decimal = Decimal$.MODULE$.apply(Predef$.MODULE$.Long2long(l));
                            break block3;
                        }
                        if (!(object instanceof BigInteger)) break block5;
                        BigInteger bigInteger = (BigInteger)object;
                        decimal = Decimal$.MODULE$.apply(BigDecimal$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(bigInteger)));
                        break block3;
                    }
                    if (!(object instanceof Double)) break block6;
                    Double d = (Double)object;
                    decimal = Decimal$.MODULE$.apply(Predef$.MODULE$.Double2double(d));
                    break block3;
                }
                if (!(object instanceof BigDecimal)) break block7;
                BigDecimal bigDecimal = (BigDecimal)object;
                decimal = Decimal$.MODULE$.apply(BigDecimal$.MODULE$.apply(bigDecimal));
            }
            return decimal;
        }
        throw new MatchError(object);
    }

    private String toJsonArrayString(Seq<Object> seq) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        IntRef count = IntRef.create((int)0);
        seq.foreach((Function1)new Serializable(builder, count){
            private final StringBuilder builder$1;
            private final IntRef count$1;

            public final StringBuilder apply(Object element) {
                Object object = this.count$1.elem > 0 ? this.builder$1.append(",") : BoxedUnit.UNIT;
                ++this.count$1.elem;
                return this.builder$1.append(JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$toString(element));
            }
            {
                this.builder$1 = builder$1;
                this.count$1 = count$1;
            }
        });
        builder.append("]");
        return builder.toString();
    }

    private String toJsonObjectString(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        IntRef count = IntRef.create((int)0);
        map.foreach((Function1)new Serializable(builder, count){
            private final StringBuilder builder$2;
            private final IntRef count$2;

            public final StringBuilder apply(Tuple2<String, Object> x0$12) {
                Tuple2<String, Object> tuple2 = x0$12;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    Object object = this.count$2.elem > 0 ? this.builder$2.append(",") : BoxedUnit.UNIT;
                    ++this.count$2.elem;
                    String stringValue = value instanceof String ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\"", "\\\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})) : JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$toString(value);
                    StringBuilder stringBuilder = this.builder$2.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\"", "\\\":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, stringValue})));
                    return stringBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$2 = builder$2;
                this.count$2 = count$2;
            }
        });
        builder.append("}");
        return builder.toString();
    }

    public String org$apache$spark$sql$json$JsonRDD$$toString(Object value) {
        String string;
        Object object = value;
        if (object instanceof Map) {
            Map map = (Map)object;
            string = this.toJsonObjectString((Map<String, Object>)map);
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            string = this.toJsonArrayString((Seq<Object>)seq);
        } else {
            string = (String)Option$.MODULE$.apply(object).map((Function1)new Serializable(){

                public final String apply(Object x$15) {
                    return x$15.toString();
                }
            }).orNull(Predef$.MODULE$.$conforms());
        }
        return string;
    }

    private Date toDate(Object value) {
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            Date date = new Date(DataTypeConversions$.MODULE$.stringToTime(string).getTime());
            return date;
        }
        throw new MatchError(object);
    }

    private Timestamp toTimestamp(Object value) {
        Object object;
        while (true) {
            block5: {
                Timestamp timestamp;
                block4: {
                    block3: {
                        if (!((object = value) instanceof Integer)) break block3;
                        Integer n = (Integer)object;
                        timestamp = new Timestamp(BoxesRunTime.unboxToInt((Object)n));
                        break block4;
                    }
                    if (!(object instanceof Long)) break block5;
                    Long l = (Long)object;
                    timestamp = new Timestamp(Predef$.MODULE$.Long2long(l));
                }
                return timestamp;
            }
            if (!(object instanceof String)) break;
            String string = (String)object;
            value = BoxesRunTime.boxToLong((long)DataTypeConversions$.MODULE$.stringToTime(string).getTime());
        }
        throw new MatchError(object);
    }

    public Object enforceCorrectType(Object value, DataType desiredType) {
        DataType dataType;
        block15: {
            String string;
            block3: {
                Object object;
                block5: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block6: {
                                                        block4: {
                                                            block2: {
                                                                if (value != null) break block2;
                                                                string = null;
                                                                break block3;
                                                            }
                                                            dataType = desiredType;
                                                            if (!StringType$.MODULE$.equals(dataType)) break block4;
                                                            object = this.org$apache$spark$sql$json$JsonRDD$$toString(value);
                                                            break block5;
                                                        }
                                                        if (!IntegerType$.MODULE$.equals(dataType)) break block6;
                                                        object = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value));
                                                        break block5;
                                                    }
                                                    if (!LongType$.MODULE$.equals(dataType)) break block7;
                                                    object = BoxesRunTime.boxToLong((long)this.toLong(value));
                                                    break block5;
                                                }
                                                if (!DoubleType$.MODULE$.equals(dataType)) break block8;
                                                object = BoxesRunTime.boxToDouble((double)this.toDouble(value));
                                                break block5;
                                            }
                                            if (!DecimalType$.MODULE$.unapply(dataType)) break block9;
                                            object = this.toDecimal(value);
                                            break block5;
                                        }
                                        if (!BooleanType$.MODULE$.equals(dataType)) break block10;
                                        object = BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value));
                                        break block5;
                                    }
                                    if (!NullType$.MODULE$.equals(dataType)) break block11;
                                    object = null;
                                    break block5;
                                }
                                if (!(dataType instanceof ArrayType)) break block12;
                                ArrayType arrayType = (ArrayType)dataType;
                                DataType elementType = arrayType.elementType();
                                object = ((Seq)value).map((Function1)new Serializable(elementType){
                                    private final DataType elementType$1;

                                    public final Object apply(Object x$16) {
                                        return JsonRDD$.MODULE$.enforceCorrectType(x$16, this.elementType$1);
                                    }
                                    {
                                        this.elementType$1 = elementType$1;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                break block5;
                            }
                            if (!(dataType instanceof StructType)) break block13;
                            StructType structType = (StructType)dataType;
                            object = this.org$apache$spark$sql$json$JsonRDD$$asRow((Map<String, Object>)((Map)value), structType);
                            break block5;
                        }
                        if (!DateType$.MODULE$.equals(dataType)) break block14;
                        object = this.toDate(value);
                        break block5;
                    }
                    if (!TimestampType$.MODULE$.equals(dataType)) break block15;
                    object = this.toTimestamp(value);
                }
                string = object;
            }
            return string;
        }
        throw new MatchError((Object)dataType);
    }

    /*
     * WARNING - void declaration
     */
    public Row org$apache$spark$sql$json$JsonRDD$$asRow(Map<String, Object> json, StructType schema) {
        void var3_3;
        GenericMutableRow row = new GenericMutableRow(schema.fields().length());
        ((IterableLike)schema.fields().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(json, row){
            private final Map json$1;
            private final GenericMutableRow row$1;

            public final void apply(Tuple2<StructField, Object> x0$13) {
                Tuple2<StructField, Object> tuple2 = x0$13;
                if (tuple2 != null) {
                    StructField structField = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (structField != null) {
                        String name = structField.name();
                        DataType dataType = structField.dataType();
                        this.row$1.update(i, this.json$1.get((Object)name).flatMap((Function1)new Serializable(this){

                            public final Option<Object> apply(Object v) {
                                return Option$.MODULE$.apply(v);
                            }
                        }).map((Function1)new Serializable(this, dataType){
                            private final DataType dataType$1;

                            public final Object apply(Object x$17) {
                                return JsonRDD$.MODULE$.enforceCorrectType(x$17, this.dataType$1);
                            }
                            {
                                this.dataType$1 = dataType$1;
                            }
                        }).orNull(Predef$.MODULE$.$conforms()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.json$1 = json$1;
                this.row$1 = row$1;
            }
        });
        return var3_3;
    }

    public String rowToJSON(StructType rowSchema, JsonFactory jsonFactory, Row row) {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = jsonFactory.createGenerator((Writer)writer);
        this.org$apache$spark$sql$json$JsonRDD$$valWriter$1(gen).apply((Object)rowSchema, (Object)row);
        gen.close();
        return writer.toString();
    }

    public final StructType org$apache$spark$sql$json$JsonRDD$$makeStruct$1(Seq values, Seq prefix, scala.collection.immutable.Map resolved$1) {
        Tuple2 tuple2 = values.partition((Function1)new anonfun.7());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq topLevel = (Seq)tuple2._1();
            Seq structLike = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)topLevel, (Object)structLike);
            Seq topLevel2 = (Seq)tuple23._1();
            Seq structLike2 = (Seq)tuple23._2();
            Seq topLevelFields = (Seq)((TraversableLike)topLevel2.filter((Function1)new Serializable(resolved$1, prefix){
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final boolean apply(Seq<String> name) {
                    ArrayType arrayType;
                    DataType elementType;
                    DataType dataType = (DataType)this.resolved$1.get(this.prefix$1.$plus$plus(name, Seq$.MODULE$.canBuildFrom())).get();
                    boolean bl = dataType instanceof ArrayType ? !this.hasInnerStruct$1(elementType = (arrayType = (ArrayType)dataType).elementType()) : !(dataType instanceof StructType);
                    return bl;
                }

                private final boolean hasInnerStruct$1(DataType t) {
                    boolean bl;
                    block2: {
                        while (true) {
                            DataType t1;
                            DataType dataType;
                            if ((dataType = t) instanceof StructType) {
                                bl = true;
                                break block2;
                            }
                            if (!(dataType instanceof ArrayType)) break;
                            ArrayType arrayType = (ArrayType)dataType;
                            t = t1 = arrayType.elementType();
                        }
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            })).map((Function1)new Serializable(resolved$1, prefix){
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final StructField apply(Seq<String> a) {
                    return new StructField((String)a.head(), (DataType)this.resolved$1.get(this.prefix$1.$plus$plus(a, Seq$.MODULE$.canBuildFrom())).get(), true, StructField$.MODULE$.apply$default$4());
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq topLevelFieldNameSet = (Seq)topLevelFields.map((Function1)new Serializable(){

                public final String apply(StructField x$5) {
                    return x$5.name();
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq structFields = ((TraversableOnce)((TraversableLike)((TraversableLike)structLike2.groupBy((Function1)new Serializable(){

                public final String apply(Seq<String> x$6) {
                    return (String)x$6.apply(0);
                }
            }).filter((Function1)new Serializable(topLevelFieldNameSet){
                private final Seq topLevelFieldNameSet$1;

                public final boolean apply(Tuple2<String, Seq<Seq<String>>> x0$4) {
                    Tuple2<String, Seq<Seq<String>>> tuple2 = x0$4;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        boolean bl = !this.topLevelFieldNameSet$1.contains((Object)name);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.topLevelFieldNameSet$1 = topLevelFieldNameSet$1;
                }
            })).map((Function1)new Serializable(resolved$1, prefix){
                private final scala.collection.immutable.Map resolved$1;
                private final Seq prefix$1;

                public final Option<StructField> apply(Tuple2<String, Seq<Seq<String>>> x0$5) {
                    Tuple2<String, Seq<Seq<String>>> tuple2;
                    block2: {
                        DataType dataType;
                        block6: {
                            None$ none$;
                            block4: {
                                block5: {
                                    StructType structType;
                                    String name;
                                    block3: {
                                        tuple2 = x0$5;
                                        if (tuple2 == null) break block2;
                                        name = (String)tuple2._1();
                                        Seq fields = (Seq)tuple2._2();
                                        Seq nestedFields = (Seq)fields.map((Function1)new Serializable(this){

                                            public final Seq<String> apply(Seq<String> x$7) {
                                                return (Seq)x$7.tail();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                        structType = JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$makeStruct$1(nestedFields, (Seq)this.prefix$1.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()), this.resolved$1);
                                        DataType dataType2 = (DataType)this.resolved$1.get(this.prefix$1.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).get();
                                        dataType = dataType2;
                                        if (!(dataType instanceof ArrayType)) break block3;
                                        ArrayType arrayType = (ArrayType)dataType;
                                        none$ = new Some((Object)new StructField(name, (DataType)this.getActualArrayType$1(structType, arrayType), true, StructField$.MODULE$.apply$default$4()));
                                        break block4;
                                    }
                                    if (!(dataType instanceof StructType)) break block5;
                                    none$ = new Some((Object)new StructField(name, (DataType)structType, true, StructField$.MODULE$.apply$default$4()));
                                    break block4;
                                }
                                if (!StringType$.MODULE$.equals(dataType)) break block6;
                                none$ = None$.MODULE$;
                            }
                            None$ none$2 = none$;
                            return none$2;
                        }
                        throw new MatchError((Object)dataType);
                    }
                    throw new MatchError(tuple2);
                }

                private final ArrayType getActualArrayType$1(StructType innerStruct, ArrayType currentArray) {
                    ArrayType arrayType;
                    block4: {
                        ArrayType arrayType2;
                        block3: {
                            block2: {
                                arrayType = currentArray;
                                if (arrayType == null) break block2;
                                DataType s = arrayType.elementType();
                                boolean containsNull = arrayType.containsNull();
                                if (!(s instanceof StructType)) break block2;
                                arrayType2 = new ArrayType((DataType)innerStruct, containsNull);
                                break block3;
                            }
                            if (arrayType == null) break block4;
                            DataType a = arrayType.elementType();
                            boolean containsNull = arrayType.containsNull();
                            if (!(a instanceof ArrayType)) break block4;
                            ArrayType arrayType3 = (ArrayType)a;
                            arrayType2 = new ArrayType((DataType)this.getActualArrayType$1(innerStruct, arrayType3), containsNull);
                        }
                        return arrayType2;
                    }
                    throw new MatchError((Object)arrayType);
                }
                {
                    this.resolved$1 = resolved$1;
                    this.prefix$1 = prefix$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){

                public final Iterable<StructField> apply(Option<StructField> field) {
                    return Option$.MODULE$.option2Iterable(field);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            return new StructType((Seq)((SeqLike)topLevelFields.$plus$plus((GenTraversableOnce)structFields, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(){

                public final String apply(StructField x$8) {
                    return x$8.name();
                }
            }, (Ordering)Ordering.String$.MODULE$));
        }
        throw new MatchError((Object)tuple2);
    }

    public final Function2 org$apache$spark$sql$json$JsonRDD$$valWriter$1(JsonGenerator gen$1) {
        return new Serializable(gen$1){
            public final JsonGenerator gen$1;

            public final void apply(DataType x0$14, Object x1$1) {
                Tuple2 tuple2;
                block20: {
                    block3: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block10: {
                                                                block9: {
                                                                    block8: {
                                                                        block7: {
                                                                            block6: {
                                                                                block5: {
                                                                                    block4: {
                                                                                        block2: {
                                                                                            DataType dataType;
                                                                                            Object object;
                                                                                            tuple2 = new Tuple2((Object)x0$14, x1$1);
                                                                                            boolean bl = tuple2 != null && (object = tuple2._2()) == null ? true : tuple2 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple2._1());
                                                                                            if (!bl) break block2;
                                                                                            this.gen$1.writeNull();
                                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                            break block3;
                                                                                        }
                                                                                        if (tuple2 == null) break block4;
                                                                                        DataType dataType = (DataType)tuple2._1();
                                                                                        Object v = tuple2._2();
                                                                                        if (!StringType$.MODULE$.equals(dataType) || !(v instanceof String)) break block4;
                                                                                        String string = (String)v;
                                                                                        this.gen$1.writeString(string);
                                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                        break block3;
                                                                                    }
                                                                                    if (tuple2 == null) break block5;
                                                                                    DataType dataType = (DataType)tuple2._1();
                                                                                    Object v = tuple2._2();
                                                                                    if (!TimestampType$.MODULE$.equals(dataType) || !(v instanceof Timestamp)) break block5;
                                                                                    Timestamp timestamp = (Timestamp)v;
                                                                                    this.gen$1.writeString(timestamp.toString());
                                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                    break block3;
                                                                                }
                                                                                if (tuple2 == null) break block6;
                                                                                DataType dataType = (DataType)tuple2._1();
                                                                                Object v = tuple2._2();
                                                                                if (!IntegerType$.MODULE$.equals(dataType) || !(v instanceof Integer)) break block6;
                                                                                int n = BoxesRunTime.unboxToInt((Object)v);
                                                                                this.gen$1.writeNumber(n);
                                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                                break block3;
                                                                            }
                                                                            if (tuple2 == null) break block7;
                                                                            DataType dataType = (DataType)tuple2._1();
                                                                            Object v = tuple2._2();
                                                                            if (!ShortType$.MODULE$.equals(dataType) || !(v instanceof Short)) break block7;
                                                                            short s = BoxesRunTime.unboxToShort((Object)v);
                                                                            this.gen$1.writeNumber(s);
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            break block3;
                                                                        }
                                                                        if (tuple2 == null) break block8;
                                                                        DataType dataType = (DataType)tuple2._1();
                                                                        Object v = tuple2._2();
                                                                        if (!FloatType$.MODULE$.equals(dataType) || !(v instanceof Float)) break block8;
                                                                        float f = BoxesRunTime.unboxToFloat((Object)v);
                                                                        this.gen$1.writeNumber(f);
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                        break block3;
                                                                    }
                                                                    if (tuple2 == null) break block9;
                                                                    DataType dataType = (DataType)tuple2._1();
                                                                    Object v = tuple2._2();
                                                                    if (!DoubleType$.MODULE$.equals(dataType) || !(v instanceof Double)) break block9;
                                                                    double d = BoxesRunTime.unboxToDouble((Object)v);
                                                                    this.gen$1.writeNumber(d);
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    break block3;
                                                                }
                                                                if (tuple2 == null) break block10;
                                                                DataType dataType = (DataType)tuple2._1();
                                                                Object v = tuple2._2();
                                                                if (!LongType$.MODULE$.equals(dataType) || !(v instanceof Long)) break block10;
                                                                long l = BoxesRunTime.unboxToLong((Object)v);
                                                                this.gen$1.writeNumber(l);
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                break block3;
                                                            }
                                                            if (tuple2 == null) break block11;
                                                            DataType dataType = (DataType)tuple2._1();
                                                            Object v = tuple2._2();
                                                            if (!DecimalType$.MODULE$.unapply(dataType) || !(v instanceof scala.math.BigDecimal)) break block11;
                                                            scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)v;
                                                            this.gen$1.writeNumber(bigDecimal.bigDecimal());
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block3;
                                                        }
                                                        if (tuple2 == null) break block12;
                                                        DataType dataType = (DataType)tuple2._1();
                                                        Object v = tuple2._2();
                                                        if (!DecimalType$.MODULE$.unapply(dataType) || !(v instanceof BigDecimal)) break block12;
                                                        BigDecimal bigDecimal = (BigDecimal)v;
                                                        this.gen$1.writeNumber(bigDecimal);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block3;
                                                    }
                                                    if (tuple2 == null) break block13;
                                                    DataType dataType = (DataType)tuple2._1();
                                                    Object v = tuple2._2();
                                                    if (!ByteType$.MODULE$.equals(dataType) || !(v instanceof Byte)) break block13;
                                                    byte by = BoxesRunTime.unboxToByte((Object)v);
                                                    this.gen$1.writeNumber((int)by);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block3;
                                                }
                                                if (tuple2 == null) break block14;
                                                DataType dataType = (DataType)tuple2._1();
                                                Object v = tuple2._2();
                                                if (!BinaryType$.MODULE$.equals(dataType) || !(v instanceof byte[])) break block14;
                                                byte[] byArray = (byte[])v;
                                                this.gen$1.writeBinary(byArray);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block3;
                                            }
                                            if (tuple2 == null) break block15;
                                            DataType dataType = (DataType)tuple2._1();
                                            Object v = tuple2._2();
                                            if (!BooleanType$.MODULE$.equals(dataType) || !(v instanceof Boolean)) break block15;
                                            boolean bl = BoxesRunTime.unboxToBoolean((Object)v);
                                            this.gen$1.writeBoolean(bl);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (tuple2 == null) break block16;
                                        DataType dataType = (DataType)tuple2._1();
                                        Object v = tuple2._2();
                                        if (!DateType$.MODULE$.equals(dataType)) break block16;
                                        this.gen$1.writeString(v.toString());
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (tuple2 == null) break block17;
                                    DataType udt = (DataType)tuple2._1();
                                    Object v = tuple2._2();
                                    if (!(udt instanceof UserDefinedType)) break block17;
                                    UserDefinedType userDefinedType = (UserDefinedType)udt;
                                    BoxedUnit boxedUnit = (BoxedUnit)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$valWriter$1(this.gen$1).apply((Object)userDefinedType.sqlType(), v);
                                    break block3;
                                }
                                if (tuple2 == null) break block18;
                                DataType dataType = (DataType)tuple2._1();
                                Object v = tuple2._2();
                                if (!(dataType instanceof ArrayType)) break block18;
                                ArrayType arrayType = (ArrayType)dataType;
                                DataType ty = arrayType.elementType();
                                if (!(v instanceof Seq)) break block18;
                                Seq seq = (Seq)v;
                                this.gen$1.writeStartArray();
                                seq.foreach((Function1)new Serializable(this, ty){
                                    private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$valWriter$1$1 $outer;
                                    private final DataType ty$1;

                                    public final void apply(Object x$18) {
                                        JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$valWriter$1(this.$outer.gen$1).apply((Object)this.ty$1, x$18);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.ty$1 = ty$1;
                                    }
                                });
                                this.gen$1.writeEndArray();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (tuple2 == null) break block19;
                            DataType dataType = (DataType)tuple2._1();
                            Object v = tuple2._2();
                            if (!(dataType instanceof MapType)) break block19;
                            MapType mapType = (MapType)dataType;
                            DataType vv = mapType.valueType();
                            if (!(v instanceof Map)) break block19;
                            Map map = (Map)v;
                            this.gen$1.writeStartObject();
                            map.foreach((Function1)new Serializable(this, vv){
                                private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$valWriter$1$1 $outer;
                                private final DataType vv$1;

                                public final void apply(Tuple2<Object, Object> p) {
                                    this.$outer.gen$1.writeFieldName(p._1().toString());
                                    JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$valWriter$1(this.$outer.gen$1).apply((Object)this.vv$1, p._2());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.vv$1 = vv$1;
                                }
                            });
                            this.gen$1.writeEndObject();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (tuple2 == null) break block20;
                        DataType dataType = (DataType)tuple2._1();
                        Object v = tuple2._2();
                        if (!(dataType instanceof StructType)) break block20;
                        StructType structType = (StructType)dataType;
                        Seq ty = structType.fields();
                        if (!(v instanceof Seq)) break block20;
                        Seq seq = (Seq)v;
                        this.gen$1.writeStartObject();
                        ((IterableLike)ty.zip((GenIterable)seq, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun$org$apache$spark$sql$json$JsonRDD$$valWriter$1$1 $outer;

                            public final void apply(Tuple2<StructField, Object> x0$15) {
                                Tuple2<StructField, Object> tuple2;
                                block4: {
                                    block3: {
                                        block2: {
                                            Object object;
                                            tuple2 = x0$15;
                                            if (tuple2 == null || (object = tuple2._2()) != null) break block2;
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        StructField field = (StructField)tuple2._1();
                                        Object v = tuple2._2();
                                        this.$outer.gen$1.writeFieldName(field.name());
                                        BoxedUnit boxedUnit = (BoxedUnit)JsonRDD$.MODULE$.org$apache$spark$sql$json$JsonRDD$$valWriter$1(this.$outer.gen$1).apply((Object)field.dataType(), v);
                                    }
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.gen$1.writeEndObject();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.gen$1 = gen$1;
            }
        };
    }

    private JsonRDD$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

