/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.joins;

import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.execution.joins.GeneralHashedRelation;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.joins.UniqueKeyHashedRelation;
import org.apache.spark.util.collection.CompactBuffer;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;

public final class HashedRelation$ {
    public static final HashedRelation$ MODULE$;

    static {
        new HashedRelation$();
    }

    public HashedRelation apply(Iterator<Row> input, package.Projection keyGenerator, int sizeEstimate) {
        HashedRelation hashedRelation;
        HashMap<Row, CompactBuffer<Row>> hashTable = new HashMap<Row, CompactBuffer<Row>>(sizeEstimate);
        Row currentRow = null;
        boolean keyIsUnique = true;
        while (input.hasNext()) {
            CompactBuffer compactBuffer;
            BoxedUnit boxedUnit;
            currentRow = (Row)input.next();
            Row rowKey = (Row)keyGenerator.apply((Object)currentRow);
            if (rowKey.anyNull()) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            CompactBuffer existingMatchList = hashTable.get(rowKey);
            if (existingMatchList == null) {
                CompactBuffer newMatchList = new CompactBuffer();
                hashTable.put(rowKey, (CompactBuffer<Row>)newMatchList);
                compactBuffer = newMatchList;
            } else {
                keyIsUnique = false;
                compactBuffer = existingMatchList;
            }
            CompactBuffer matchList = compactBuffer;
            boxedUnit = matchList.$plus$eq((Object)currentRow.copy());
        }
        if (keyIsUnique) {
            HashMap<Row, Row> uniqHashTable = new HashMap<Row, Row>(hashTable.size());
            for (Map.Entry<Row, CompactBuffer<Row>> entry : hashTable.entrySet()) {
                uniqHashTable.put(entry.getKey(), (Row)entry.getValue().apply(0));
            }
            hashedRelation = new UniqueKeyHashedRelation(uniqHashTable);
        } else {
            hashedRelation = new GeneralHashedRelation(hashTable);
        }
        return hashedRelation;
    }

    public int apply$default$3() {
        return 64;
    }

    private HashedRelation$() {
        MODULE$ = this;
    }
}

