/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.catalyst.types.LongType$;
import org.apache.spark.sql.catalyst.types.NativeType;
import org.apache.spark.sql.columnar.ColumnType;
import org.apache.spark.sql.columnar.LONG$;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.compression.Encoder$class;
import org.apache.spark.sql.columnar.compression.LongDelta$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tUqAB\u0001\u0003\u0011\u00033a\"A\u0005M_:<G)\u001a7uC*\u00111\u0001B\u0001\fG>l\u0007O]3tg&|gN\u0003\u0002\u0006\r\u0005A1m\u001c7v[:\f'O\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u0004\"a\u0004\t\u000e\u0003\t1a!\u0005\u0002\t\u0002\u001a\u0011\"!\u0003'p]\u001e$U\r\u001c;b'\u0015\u00012#\u0007\u000f !\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fMB\u0011qBG\u0005\u00037\t\u0011\u0011cQ8naJ,7o]5p]N\u001b\u0007.Z7f!\t!R$\u0003\u0002\u001f+\t9\u0001K]8ek\u000e$\bC\u0001\u000b!\u0013\t\tSC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003$!\u0011\u0005Q%\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0001\"B\u0014\u0011\t\u0003B\u0013A\u0002;za\u0016LE-F\u0001*!\t!\"&\u0003\u0002,+\t\u0019\u0011J\u001c;\t\u000b5\u0002B\u0011\t\u0018\u0002\u000f\u0011,7m\u001c3feV\u0011q&\u000e\u000b\u0004a\rk\u0005cA\b2g%\u0011!G\u0001\u0002\b\t\u0016\u001cw\u000eZ3s!\t!T\u0007\u0004\u0001\u0005\u000bYb#\u0019A\u001c\u0003\u0003Q\u000b\"\u0001O\u001e\u0011\u0005QI\u0014B\u0001\u001e\u0016\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u000bQL\b/Z:\u000b\u0005\u00013\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\tk$A\u0003(bi&4X\rV=qK\")A\t\fa\u0001\u000b\u00061!-\u001e4gKJ\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u00079LwNC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%A\u0003\"zi\u0016\u0014UO\u001a4fe\")a\n\fa\u0001\u001f\u0006Q1m\u001c7v[:$\u0016\u0010]3\u0011\u0007A\u000b6'D\u0001\u0005\u0013\t\u0011FA\u0001\tOCRLg/Z\"pYVlg\u000eV=qK\")A\u000b\u0005C!+\u00069QM\\2pI\u0016\u0014XC\u0001,\\)\t9F\fE\u0002\u00101jK!!\u0017\u0002\u0003\u000f\u0015s7m\u001c3feB\u0011Ag\u0017\u0003\u0006mM\u0013\ra\u000e\u0005\u0006\u001dN\u0003\r!\u0018\t\u0004!FS\u0006\"B0\u0011\t\u0003\u0002\u0017\u0001C:vaB|'\u000f^:\u0015\u0005\u0005$\u0007C\u0001\u000bc\u0013\t\u0019WCA\u0004C_>dW-\u00198\t\u000b9s\u0006\u0019A31\u0007\u0019T\u0017\u000f\u0005\u0003QO&\u0004\u0018B\u00015\u0005\u0005)\u0019u\u000e\\;n]RK\b/\u001a\t\u0003i)$\u0011b\u001b3\u0002\u0002\u0003\u0005)\u0011\u00017\u0003\t}#\u0013'M\t\u0003q5\u0004\"\u0001\u00068\n\u0005=,\"aA!osB\u0011A'\u001d\u0003\ne\u0012\f\t\u0011!A\u0003\u00021\u0014Aa\u0018\u00132e\u0019!\u0011\f\u0005\u0001u'\r\u00198#\u001e\t\u0004\u001fa3hB\u0001\u001fx\u0013\tAX(\u0001\u0005M_:<G+\u001f9f\u0011\u0015\u00193\u000f\"\u0001{)\u0005Y\bC\u0001?t\u001b\u0005\u0001\u0002b\u0002@t\u0001\u0004%\t\u0002K\u0001\u0010?\u000e|W\u000e\u001d:fgN,GmU5{K\"I\u0011\u0011A:A\u0002\u0013E\u00111A\u0001\u0014?\u000e|W\u000e\u001d:fgN,GmU5{K~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u0002\u0015\u0003\u000fI1!!\u0003\u0016\u0005\u0011)f.\u001b;\t\u0011\u00055q0!AA\u0002%\n1\u0001\u001f\u00132\u0011\u001d\t\tb\u001dQ!\n%\n\u0001cX2p[B\u0014Xm]:fINK'0\u001a\u0011\t\u0011\u0005U1\u000f1A\u0005\u0012!\n\u0011cX;oG>l\u0007O]3tg\u0016$7+\u001b>f\u0011%\tIb\u001da\u0001\n#\tY\"A\u000b`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016|F%Z9\u0015\t\u0005\u0015\u0011Q\u0004\u0005\n\u0003\u001b\t9\"!AA\u0002%Bq!!\ttA\u0003&\u0011&\u0001\n`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\u0004\u0003BBA\u0013g\u0012\u0005\u0003&\u0001\bd_6\u0004(/Z:tK\u0012\u001c\u0016N_3\t\r\u0005%2\u000f\"\u0011)\u0003A)hnY8naJ,7o]3e'&TX\rC\u0006\u0002.M\u0004\r\u00111A\u0005\n\u0005=\u0012!\u00039sKZ4\u0016\r\\;f+\t\t\t\u0004E\u0002\u0015\u0003gI1!!\u000e\u0016\u0005\u0011auN\\4\t\u0017\u0005e2\u000f1AA\u0002\u0013%\u00111H\u0001\u000eaJ,gOV1mk\u0016|F%Z9\u0015\t\u0005\u0015\u0011Q\b\u0005\u000b\u0003\u001b\t9$!AA\u0002\u0005E\u0002\u0002CA!g\u0002\u0006K!!\r\u0002\u0015A\u0014XM\u001e,bYV,\u0007\u0005C\u0004\u0002FM$\t%a\u0012\u00025\u001d\fG\u000f[3s\u0007>l\u0007O]3tg&\u0014\u0017\u000e\\5usN#\u0018\r^:\u0015\r\u0005\u0015\u0011\u0011JA9\u0011!\tY%a\u0011A\u0002\u00055\u0013a\u0001:poB!\u0011qJA6\u001d\u0011\t\t&a\u001a\u000f\t\u0005M\u0013Q\r\b\u0005\u0003+\n\u0019G\u0004\u0003\u0002X\u0005\u0005d\u0002BA-\u0003?j!!a\u0017\u000b\u0007\u0005uC%\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0007\u0005%d!A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0014q\u000e\u0002\u0004%><(bAA5\r!9\u00111OA\"\u0001\u0004I\u0013aB8sI&t\u0017\r\u001c\u0005\b\u0003o\u001aH\u0011IA=\u0003!\u0019w.\u001c9sKN\u001cH#B#\u0002|\u0005}\u0004bBA?\u0003k\u0002\r!R\u0001\u0005MJ|W\u000eC\u0004\u0002\u0002\u0006U\u0004\u0019A#\u0002\u0005Q|g!\u0002\u001a\u0011\u0001\u0005\u00155#BAB'\u0005\u001d\u0005cA\b2m\"IA)a!\u0003\u0002\u0003\u0006I!\u0012\u0005\u000b\u001d\u0006\r%\u0011!Q\u0001\n\u00055\u0005c\u0001)Rm\"91%a!\u0005\u0002\u0005EECBAJ\u0003+\u000b9\nE\u0002}\u0003\u0007Ca\u0001RAH\u0001\u0004)\u0005b\u0002(\u0002\u0010\u0002\u0007\u0011Q\u0012\u0005\r\u00037\u000b\u0019\t1AA\u0002\u0013%\u0011qF\u0001\u0005aJ,g\u000f\u0003\u0007\u0002 \u0006\r\u0005\u0019!a\u0001\n\u0013\t\t+\u0001\u0005qe\u00164x\fJ3r)\u0011\t)!a)\t\u0015\u00055\u0011QTA\u0001\u0002\u0004\t\t\u0004C\u0005\u0002(\u0006\r\u0005\u0015)\u0003\u00022\u0005)\u0001O]3wA!A\u00111VAB\t\u0003\ni+A\u0004iCNtU\r\u001f;\u0016\u0003\u0005D\u0001\"!-\u0002\u0004\u0012\u0005\u00131W\u0001\u0005]\u0016DH\u000f\u0006\u0004\u0002\u0006\u0005U\u00161\u0019\u0005\t\u0003\u0017\ny\u000b1\u0001\u00028B!\u0011\u0011XA`\u001b\t\tYLC\u0002\u0002>~\n1\"\u001a=qe\u0016\u001c8/[8og&!\u0011\u0011YA^\u0005)iU\u000f^1cY\u0016\u0014vn\u001e\u0005\b\u0003g\ny\u000b1\u0001*\u0011%\t9\rEA\u0001\n\u0003\nI-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0017\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0004\u0003#L\u0015\u0001\u00027b]\u001eLA!!6\u0002P\n11\u000b\u001e:j]\u001eD\u0001\"!7\u0011\u0003\u0003%\t\u0001K\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003;\u0004\u0012\u0011!C\u0001\u0003?\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002n\u0003CD\u0011\"!\u0004\u0002\\\u0006\u0005\t\u0019A\u0015\t\u0013\u0005\u0015\b#!A\u0005B\u0005\u001d\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\b#BAv\u0003clWBAAw\u0015\r\ty/F\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAz\u0003[\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003o\u0004\u0012\u0011!C\u0001\u0003s\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004C\u0006m\b\"CA\u0007\u0003k\f\t\u00111\u0001n\u0011%\ty\u0010EA\u0001\n\u0003\u0012\t!\u0001\u0005iCND7i\u001c3f)\u0005I\u0003\"\u0003B\u0003!\u0005\u0005I\u0011\tB\u0004\u0003!!xn\u0015;sS:<GCAAf\u0011%\u0011Y\u0001EA\u0001\n\u0013\u0011i!A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\b!\u0011\tiM!\u0005\n\t\tM\u0011q\u001a\u0002\u0007\u001f\nTWm\u0019;")
public final class LongDelta {
    public static String toString() {
        return LongDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return LongDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return LongDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return LongDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return LongDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return LongDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return LongDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?, ?> columnType) {
        return LongDelta$.MODULE$.supports(columnType);
    }

    public static <T extends NativeType> org.apache.spark.sql.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends NativeType> org.apache.spark.sql.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return LongDelta$.MODULE$.typeId();
    }

    public static class Encoder
    implements org.apache.spark.sql.columnar.compression.Encoder<LongType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private long prevValue;

        @Override
        public double compressionRatio() {
            return Encoder$class.compressionRatio(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private long prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(long x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(Row row, int ordinal) {
            long value = row.getLong(ordinal);
            long delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= (long)-128 || delta > (long)127) {
                this._compressedSize_$eq(this._compressedSize() + LONG$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + LONG$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(LongDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                long prev = from.getLong();
                to.put((byte)-128);
                to.putLong(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    long current = from.getLong();
                    long delta = current - prev;
                    prev = current;
                    if ((long)-128 < delta && delta <= (long)127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putLong(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            Encoder$class.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }

    public static class Decoder
    implements org.apache.spark.sql.columnar.compression.Decoder<LongType$> {
        private final ByteBuffer buffer;
        private long prev;

        private long prev() {
            return this.prev;
        }

        private void prev_$eq(long x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(MutableRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + (long)delta : this.buffer.getLong());
            row.setLong(ordinal, this.prev());
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<LongType$> columnType) {
            this.buffer = buffer;
        }
    }
}

