/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.expressions.Row;
import org.apache.spark.sql.columnar.NativeColumnBuilder;
import org.apache.spark.sql.columnar.NativeColumnType;
import org.apache.spark.sql.columnar.compression.CompressionScheme;
import org.apache.spark.sql.columnar.compression.Encoder;
import org.apache.spark.sql.columnar.compression.PassThrough;
import org.apache.spark.sql.columnar.compression.PassThrough$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public abstract class CompressibleColumnBuilder$class {
    public static void initialize(NativeColumnBuilder $this, int initialSize, String columnName, boolean useCompression) {
        $this.compressionEncoders_$eq(useCompression ? (Seq)((TraversableLike)$this.schemes().filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NativeColumnBuilder $outer;

            public final boolean apply(CompressionScheme x$1) {
                return x$1.supports(this.$outer.columnType());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NativeColumnBuilder $outer;

            public final Encoder<T> apply(CompressionScheme x$2) {
                return x$2.encoder(this.$outer.columnType());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PassThrough.Encoder[]{PassThrough$.MODULE$.encoder((NativeColumnType)$this.columnType())})));
        $this.org$apache$spark$sql$columnar$compression$CompressibleColumnBuilder$$super$initialize(initialSize, columnName, useCompression);
    }

    public static boolean isWorthCompressing(NativeColumnBuilder $this, Encoder encoder) {
        return encoder.compressionRatio() < 0.8;
    }

    private static void gatherCompressibilityStats(NativeColumnBuilder $this, Row row, int ordinal) {
        for (int i = 0; i < $this.compressionEncoders().length(); ++i) {
            ((Encoder)$this.compressionEncoders().apply(i)).gatherCompressibilityStats(row, ordinal);
        }
    }

    public static void appendFrom(NativeColumnBuilder $this, Row row, int ordinal) {
        $this.org$apache$spark$sql$columnar$compression$CompressibleColumnBuilder$$super$appendFrom(row, ordinal);
        if (!row.isNullAt(ordinal)) {
            CompressibleColumnBuilder$class.gatherCompressibilityStats($this, row, ordinal);
        }
    }

    public static ByteBuffer build(NativeColumnBuilder $this) {
        ByteBuffer nonNullBuffer = $this.buildNonNulls();
        int typeId = nonNullBuffer.getInt();
        Encoder candidate = (Encoder)$this.compressionEncoders().minBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(Encoder<T> x$3) {
                return x$3.compressionRatio();
            }
        }, (Ordering)Ordering.Double$.MODULE$);
        Encoder encoder = $this.isWorthCompressing(candidate) ? candidate : PassThrough$.MODULE$.encoder((NativeColumnType)$this.columnType());
        int headerSize = 8 + $this.nulls().limit();
        int compressedSize = encoder.compressedSize() == 0 ? nonNullBuffer.remaining() : encoder.compressedSize();
        ByteBuffer compressedBuffer = ByteBuffer.allocate(headerSize + 4 + compressedSize).order(ByteOrder.nativeOrder()).putInt(typeId).putInt($this.nullCount()).put($this.nulls());
        $this.logDebug((Function0<String>)new Serializable($this, encoder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NativeColumnBuilder $outer;
            private final Encoder encoder$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compressor for [", "]: ", ", ratio: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.columnName(), this.encoder$1, BoxesRunTime.boxToDouble((double)this.encoder$1.compressionRatio())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.encoder$1 = encoder$1;
            }
        });
        return encoder.compress(nonNullBuffer, compressedBuffer);
    }

    public static void $init$(NativeColumnBuilder $this) {
    }
}

