/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.catalyst.parser.DataTypeParser$;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.catalyst.util.StringConcat;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$JSortedObject$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringConstraint;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.SparkClassUtils$;
import org.json4s.AsJsonInput$;
import org.json4s.JArray;
import org.json4s.JBool;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@Stable
public final class DataType$ {
    public static final DataType$ MODULE$ = new DataType$();
    private static final Regex FIXED_DECIMAL = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("decimal\\(\\s*(\\d+)\\s*,\\s*(\\-?\\d+)\\s*\\)"));
    private static final Regex CHAR_TYPE = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("char\\(\\s*(\\d+)\\s*\\)"));
    private static final Regex VARCHAR_TYPE = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("varchar\\(\\s*(\\d+)\\s*\\)"));
    private static final Regex STRING_WITH_COLLATION = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("string\\s+collate\\s+(\\w+)"));
    private static final String COLLATIONS_METADATA_KEY = "__COLLATIONS";
    private static final Map<String, DataType> otherTypes = ((IterableOnceOps)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{NullType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, BinaryType$.MODULE$, IntegerType$.MODULE$, BooleanType$.MODULE$, LongType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, ShortType$.MODULE$, ByteType$.MODULE$, StringType$.MODULE$, CalendarIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()), DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.HOUR()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()), DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.MINUTE()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND()), DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()), YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()), YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH()), new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()), TimestampNTZType$.MODULE$, VariantType$.MODULE$})).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(TimeType$.MODULE$.MIN_PRECISION()), TimeType$.MODULE$.MAX_PRECISION()).map((Function1 & Serializable)x$1 -> DataType$.$anonfun$otherTypes$1(BoxesRunTime.unboxToInt((Object)x$1))))).map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.typeName()), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());

    private Regex FIXED_DECIMAL() {
        return FIXED_DECIMAL;
    }

    private Regex CHAR_TYPE() {
        return CHAR_TYPE;
    }

    private Regex VARCHAR_TYPE() {
        return VARCHAR_TYPE;
    }

    private Regex STRING_WITH_COLLATION() {
        return STRING_WITH_COLLATION;
    }

    public String COLLATIONS_METADATA_KEY() {
        return COLLATIONS_METADATA_KEY;
    }

    public DataType fromDDL(String ddl) {
        return this.parseTypeWithFallback(ddl, (Function1<String, DataType>)(Function1 & Serializable)sqlText -> DataTypeParser$.MODULE$.parseDataType((String)sqlText), (Function1<String, DataType>)(Function1 & Serializable)str -> DataTypeParser$.MODULE$.parseTableSchema((String)str));
    }

    public DataType parseTypeWithFallback(String schema, Function1<String, DataType> parser, Function1<String, DataType> fallbackParser) {
        DataType dataType;
        try {
            dataType = (DataType)parser.apply((Object)schema);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                try {
                    dataType = (DataType)fallbackParser.apply((Object)schema);
                }
                catch (Throwable throwable4) {
                    Throwable throwable5;
                    Throwable throwable6 = throwable4;
                    if (throwable6 != null && NonFatal$.MODULE$.apply(throwable5 = throwable6)) {
                        throwable2.addSuppressed(throwable5);
                        if (throwable2 instanceof SparkThrowable) {
                            throw throwable2;
                        }
                        throw DataTypeErrors$.MODULE$.schemaFailToParseError(schema, throwable2);
                    }
                    throw throwable4;
                }
            }
            throw throwable;
        }
        return dataType;
    }

    public DataType fromJson(String json) {
        return this.parseDataType(JsonMethods$.MODULE$.parse((Object)json, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
    }

    private Map<String, DataType> otherTypes() {
        return otherTypes;
    }

    private DataType nameToType(String name) {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        String string = name;
        if ("decimal".equals(string)) {
            return DecimalType$.MODULE$.USER_DEFAULT();
        }
        if (string != null && !(option4 = this.FIXED_DECIMAL().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(2) == 0) {
            String precision = (String)((LinearSeqOps)option4.get()).apply(0);
            String scale = (String)((LinearSeqOps)option4.get()).apply(1);
            return new DecimalType(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(precision)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(scale)));
        }
        if (string != null && !(option3 = this.CHAR_TYPE().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(1) == 0) {
            String length = (String)((LinearSeqOps)option3.get()).apply(0);
            return new CharType(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(length)));
        }
        if (string != null && !(option2 = this.VARCHAR_TYPE().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            String length = (String)((LinearSeqOps)option2.get()).apply(0);
            return new VarcharType(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(length)));
        }
        if (string != null && !(option = this.STRING_WITH_COLLATION().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String collation = (String)((LinearSeqOps)option.get()).apply(0);
            return StringType$.MODULE$.apply(collation);
        }
        if ("null".equals(string)) {
            return NullType$.MODULE$;
        }
        if ("timestamp_ltz".equals(string)) {
            return TimestampType$.MODULE$;
        }
        return (DataType)this.otherTypes().getOrElse((Object)string, (Function0 & Serializable)() -> {
            throw new SparkIllegalArgumentException("INVALID_JSON_DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidType"), (Object)name)})));
        });
    }

    public DataType parseDataType(JValue json) {
        return this.parseDataType(json, "", (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public DataType parseDataType(JValue json2, String fieldPath, Map<String, String> collationsMap) {
        Option<List<Tuple2<String, JValue>>> option;
        Option<List<Tuple2<String, JValue>>> option2;
        Option<List<Tuple2<String, JValue>>> option3;
        Option<List<Tuple2<String, JValue>>> option4;
        Option<List<Tuple2<String, JValue>>> option5;
        JValue jValue = json2;
        if (jValue instanceof JString) {
            JString jString = (JString)jValue;
            String name = jString.s();
            Option option6 = collationsMap.get((Object)fieldPath);
            if (option6 instanceof Some) {
                Some some = (Some)option6;
                String collation = (String)some.value();
                this.assertValidTypeForCollations(fieldPath, name, collationsMap);
                return this.stringTypeWithCollation(collation);
            }
            return this.nameToType(name);
        }
        if (jValue != null && !(option5 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option5.get() != null && ((List)option5.get()).lengthCompare(3) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOps)option5.get()).apply(0);
            Tuple2 tuple22 = (Tuple2)((LinearSeqOps)option5.get()).apply(1);
            Tuple2 tuple23 = (Tuple2)((LinearSeqOps)option5.get()).apply(2);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JValue jValue2 = (JValue)tuple2._2();
                if ("containsNull".equals(string) && jValue2 instanceof JBool) {
                    JBool jBool = (JBool)jValue2;
                    boolean n = jBool.value();
                    if (tuple22 != null) {
                        String string2 = (String)tuple22._1();
                        JValue t = (JValue)tuple22._2();
                        if ("elementType".equals(string2) && t != null) {
                            JValue jValue3 = t;
                            if (tuple23 != null) {
                                JString jString;
                                String string3;
                                String string4 = (String)tuple23._1();
                                JValue jValue4 = (JValue)tuple23._2();
                                if ("type".equals(string4) && jValue4 instanceof JString && "array".equals(string3 = (jString = (JString)jValue4).s())) {
                                    this.assertValidTypeForCollations(fieldPath, "array", collationsMap);
                                    DataType elementType = this.parseDataType(jValue3, this.appendFieldToPath(fieldPath, "element"), collationsMap);
                                    return new ArrayType(elementType, n);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (jValue != null && !(option4 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(4) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOps)option4.get()).apply(0);
            Tuple2 tuple24 = (Tuple2)((LinearSeqOps)option4.get()).apply(1);
            Tuple2 tuple25 = (Tuple2)((LinearSeqOps)option4.get()).apply(2);
            Tuple2 tuple26 = (Tuple2)((LinearSeqOps)option4.get()).apply(3);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JValue k = (JValue)tuple2._2();
                if ("keyType".equals(string) && k != null) {
                    JValue jValue5 = k;
                    if (tuple24 != null) {
                        JString jString;
                        String string5;
                        String string6 = (String)tuple24._1();
                        JValue jValue6 = (JValue)tuple24._2();
                        if ("type".equals(string6) && jValue6 instanceof JString && "map".equals(string5 = (jString = (JString)jValue6).s()) && tuple25 != null) {
                            String string7 = (String)tuple25._1();
                            JValue jValue7 = (JValue)tuple25._2();
                            if ("valueContainsNull".equals(string7) && jValue7 instanceof JBool) {
                                JBool jBool = (JBool)jValue7;
                                boolean n = jBool.value();
                                if (tuple26 != null) {
                                    String string8 = (String)tuple26._1();
                                    JValue v = (JValue)tuple26._2();
                                    if ("valueType".equals(string8) && v != null) {
                                        JValue jValue8 = v;
                                        this.assertValidTypeForCollations(fieldPath, "map", collationsMap);
                                        DataType keyType = this.parseDataType(jValue5, this.appendFieldToPath(fieldPath, "key"), collationsMap);
                                        DataType valueType = this.parseDataType(jValue8, this.appendFieldToPath(fieldPath, "value"), collationsMap);
                                        return new MapType(keyType, valueType, n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (jValue != null && !(option3 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOps)option3.get()).apply(0);
            Tuple2 tuple27 = (Tuple2)((LinearSeqOps)option3.get()).apply(1);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JValue jValue9 = (JValue)tuple2._2();
                if ("fields".equals(string) && jValue9 instanceof JArray) {
                    JArray jArray = (JArray)jValue9;
                    List fields = jArray.arr();
                    if (tuple27 != null) {
                        JString jString;
                        String string9;
                        String string10 = (String)tuple27._1();
                        JValue jValue10 = (JValue)tuple27._2();
                        if ("type".equals(string10) && jValue10 instanceof JString && "struct".equals(string9 = (jString = (JString)jValue10).s())) {
                            this.assertValidTypeForCollations(fieldPath, "struct", collationsMap);
                            return StructType$.MODULE$.apply((Seq<StructField>)fields.map((Function1 & Serializable)json -> MODULE$.parseStructField((JValue)json)));
                        }
                    }
                }
            }
        }
        if (jValue != null && !(option2 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(4) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOps)option2.get()).apply(0);
            Tuple2 tuple28 = (Tuple2)((LinearSeqOps)option2.get()).apply(1);
            Tuple2 tuple29 = (Tuple2)((LinearSeqOps)option2.get()).apply(2);
            Tuple2 tuple210 = (Tuple2)((LinearSeqOps)option2.get()).apply(3);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JValue jValue11 = (JValue)tuple2._2();
                if ("class".equals(string) && jValue11 instanceof JString) {
                    String string11;
                    String string12;
                    JString jString = (JString)jValue11;
                    String udtClass = jString.s();
                    if (tuple28 != null && "pyClass".equals(string12 = (String)tuple28._1()) && tuple29 != null && "sqlType".equals(string11 = (String)tuple29._1()) && tuple210 != null) {
                        JString jString2;
                        String string13;
                        String string14 = (String)tuple210._1();
                        JValue jValue12 = (JValue)tuple210._2();
                        if ("type".equals(string14) && jValue12 instanceof JString && "udt".equals(string13 = (jString2 = (JString)jValue12).s())) {
                            return (DataType)SparkClassUtils$.MODULE$.classForName(udtClass, SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                    }
                }
            }
        }
        if (jValue != null && !(option = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(4) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOps)option.get()).apply(0);
            Tuple2 tuple211 = (Tuple2)((LinearSeqOps)option.get()).apply(1);
            Tuple2 tuple212 = (Tuple2)((LinearSeqOps)option.get()).apply(2);
            Tuple2 tuple213 = (Tuple2)((LinearSeqOps)option.get()).apply(3);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JValue jValue13 = (JValue)tuple2._2();
                if ("pyClass".equals(string) && jValue13 instanceof JString) {
                    JString jString = (JString)jValue13;
                    String pyClass = jString.s();
                    if (tuple211 != null) {
                        String string15 = (String)tuple211._1();
                        JValue jValue14 = (JValue)tuple211._2();
                        if ("serializedClass".equals(string15) && jValue14 instanceof JString) {
                            JString jString3 = (JString)jValue14;
                            String serialized = jString3.s();
                            if (tuple212 != null) {
                                String string16 = (String)tuple212._1();
                                JValue v = (JValue)tuple212._2();
                                if ("sqlType".equals(string16) && v != null) {
                                    JValue jValue15 = v;
                                    if (tuple213 != null) {
                                        JString jString4;
                                        String string17;
                                        String string18 = (String)tuple213._1();
                                        JValue jValue16 = (JValue)tuple213._2();
                                        if ("type".equals(string18) && jValue16 instanceof JString && "udt".equals(string17 = (jString4 = (JString)jValue16).s())) {
                                            return new PythonUserDefinedType(this.parseDataType(jValue15), pyClass, serialized);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        throw new SparkIllegalArgumentException("INVALID_JSON_DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidType"), (Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(jValue, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())))})));
    }

    private StructField parseStructField(JValue json) {
        Option<List<Tuple2<String, JValue>>> option;
        Option<List<Tuple2<String, JValue>>> option2;
        Option<List<Tuple2<String, JValue>>> option3;
        JValue jValue = json;
        if (jValue != null && !(option3 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(4) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOps)option3.get()).apply(0);
            Tuple2 tuple22 = (Tuple2)((LinearSeqOps)option3.get()).apply(1);
            Tuple2 tuple23 = (Tuple2)((LinearSeqOps)option3.get()).apply(2);
            Tuple2 tuple24 = (Tuple2)((LinearSeqOps)option3.get()).apply(3);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JValue jValue2 = (JValue)tuple2._2();
                if ("metadata".equals(string) && jValue2 instanceof JObject) {
                    JObject jObject = (JObject)jValue2;
                    List metadataFields = jObject.obj();
                    if (tuple22 != null) {
                        String string2 = (String)tuple22._1();
                        JValue jValue3 = (JValue)tuple22._2();
                        if ("name".equals(string2) && jValue3 instanceof JString) {
                            JString jString = (JString)jValue3;
                            String name = jString.s();
                            if (tuple23 != null) {
                                String string3 = (String)tuple23._1();
                                JValue jValue4 = (JValue)tuple23._2();
                                if ("nullable".equals(string3) && jValue4 instanceof JBool) {
                                    JBool jBool = (JBool)jValue4;
                                    boolean nullable = jBool.value();
                                    if (tuple24 != null) {
                                        String string4 = (String)tuple24._1();
                                        JValue dataType = (JValue)tuple24._2();
                                        if ("type".equals(string4) && dataType != null) {
                                            JValue jValue5 = dataType;
                                            Map<String, String> collationsMap = this.getCollationsMap((List<Tuple2<String, JValue>>)metadataFields);
                                            JObject metadataWithoutCollations = new JObject(metadataFields.filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$parseStructField$1(x$3))));
                                            return new StructField(name, this.parseDataType(jValue5, name, collationsMap), nullable, Metadata$.MODULE$.fromJObject(metadataWithoutCollations));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (jValue != null && !(option2 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(3) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOps)option2.get()).apply(0);
            Tuple2 tuple25 = (Tuple2)((LinearSeqOps)option2.get()).apply(1);
            Tuple2 tuple26 = (Tuple2)((LinearSeqOps)option2.get()).apply(2);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JValue jValue6 = (JValue)tuple2._2();
                if ("name".equals(string) && jValue6 instanceof JString) {
                    JString jString = (JString)jValue6;
                    String name = jString.s();
                    if (tuple25 != null) {
                        String string5 = (String)tuple25._1();
                        JValue jValue7 = (JValue)tuple25._2();
                        if ("nullable".equals(string5) && jValue7 instanceof JBool) {
                            JBool jBool = (JBool)jValue7;
                            boolean nullable = jBool.value();
                            if (tuple26 != null) {
                                String string6 = (String)tuple26._1();
                                JValue dataType = (JValue)tuple26._2();
                                if ("type".equals(string6) && dataType != null) {
                                    JValue jValue8 = dataType;
                                    return new StructField(name, this.parseDataType(jValue8), nullable, StructField$.MODULE$.apply$default$4());
                                }
                            }
                        }
                    }
                }
            }
        }
        if (jValue != null && !(option = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOps)option.get()).apply(0);
            Tuple2 tuple27 = (Tuple2)((LinearSeqOps)option.get()).apply(1);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JValue jValue9 = (JValue)tuple2._2();
                if ("name".equals(string) && jValue9 instanceof JString) {
                    JString jString = (JString)jValue9;
                    String name = jString.s();
                    if (tuple27 != null) {
                        String string7 = (String)tuple27._1();
                        JValue dataType = (JValue)tuple27._2();
                        if ("type".equals(string7) && dataType != null) {
                            JValue jValue10 = dataType;
                            return new StructField(name, this.parseDataType(jValue10), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                        }
                    }
                }
            }
        }
        throw new SparkIllegalArgumentException("INVALID_JSON_DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidType"), (Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(jValue, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())))})));
    }

    private void assertValidTypeForCollations(String fieldPath, String fieldType, Map<String, String> collationMap) {
        if (collationMap.contains((Object)fieldPath)) {
            String string = fieldType;
            String string2 = "string";
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new SparkIllegalArgumentException("INVALID_JSON_DATA_TYPE_FOR_COLLATIONS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jsonType"), (Object)fieldType)})));
            }
        }
    }

    private String appendFieldToPath(String basePath, String fieldName) {
        if (basePath.isEmpty()) {
            return fieldName;
        }
        return basePath + "." + fieldName;
    }

    private Map<String, String> getCollationsMap(List<Tuple2<String, JValue>> metadataFields) {
        Some some;
        JValue jValue;
        Option collationsJsonOpt = metadataFields.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$getCollationsMap$1(x$4))).map((Function1 & Serializable)x$5 -> (JValue)x$5._2());
        Option option = collationsJsonOpt;
        if (option instanceof Some && (jValue = (JValue)(some = (Some)option).value()) instanceof JObject) {
            JObject jObject = (JObject)jValue;
            List fields = jObject.obj();
            return fields.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        String fieldPath = (String)A1._1();
                        JValue jValue = (JValue)A1._2();
                        if (jValue instanceof JString) {
                            Object object;
                            JString jString = (JString)jValue;
                            String collation = jString.s();
                            String[] stringArray = collation.split("\\.", 2);
                            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                                String provider = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                                String collationName = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                                if (provider != null) {
                                    String string = provider;
                                    if (collationName != null) {
                                        String string2 = collationName;
                                        CollationFactory.assertValidProvider((String)string);
                                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fieldPath), (Object)string2);
                                    }
                                }
                            }
                            throw new MatchError((Object)stringArray);
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<String, JValue> x1) {
                    JValue jValue;
                    Tuple2<String, JValue> tuple2 = x1;
                    return tuple2 != null && (jValue = (JValue)tuple2._2()) instanceof JString;
                }
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return Predef$.MODULE$.Map().empty();
    }

    private StringType stringTypeWithCollation(String collationName) {
        return StringType$.MODULE$.apply(CollationFactory.collationNameToId((String)collationName));
    }

    public void buildFormattedString(DataType dataType, String prefix, StringConcat stringConcat, int maxDepth) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            arrayType.buildFormattedString(prefix, stringConcat, maxDepth - 1);
            return;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            structType.buildFormattedString(prefix, stringConcat, maxDepth - 1);
            return;
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            mapType.buildFormattedString(prefix, stringConcat, maxDepth - 1);
            return;
        }
    }

    public boolean equalsIgnoreCompatibleNullability(DataType from, DataType to) {
        return this.equalsIgnoreCompatibleNullability(from, to, false);
    }

    public boolean equalsIgnoreNameAndCompatibleNullability(DataType from, DataType to) {
        return this.equalsIgnoreCompatibleNullability(from, to, true);
    }

    private boolean equalsIgnoreCompatibleNullability(DataType from, DataType to, boolean ignoreName) {
        Tuple2 tuple2;
        block9: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType2 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType fromElement = arrayType.elementType();
                        boolean fn = arrayType.containsNull();
                        if (dataType2 instanceof ArrayType) {
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            DataType toElement = arrayType2.elementType();
                            boolean tn = arrayType2.containsNull();
                            if (tn || !fn) {
                                to = toElement;
                                from = fromElement;
                                continue;
                            }
                            return false;
                        }
                    }
                }
                if (tuple2 == null) break block9;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block9;
                MapType mapType = (MapType)dataType;
                DataType fromKey = mapType.keyType();
                DataType fromValue = mapType.valueType();
                boolean fn = mapType.valueContainsNull();
                if (!(dataType3 instanceof MapType)) break block9;
                MapType mapType2 = (MapType)dataType3;
                DataType toKey = mapType2.keyType();
                DataType toValue = mapType2.valueType();
                boolean tn = mapType2.valueContainsNull();
                if (!tn && fn || !this.equalsIgnoreCompatibleNullability(fromKey, toKey, ignoreName)) break;
                to = toValue;
                from = fromValue;
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    return fromFields.length == toFields.length && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fromFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])toFields))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsIgnoreCompatibleNullability$1(ignoreName, x0$1)));
                }
            }
        }
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            DataType dataType = fromDataType;
            DataType dataType5 = toDataType;
            return !(dataType != null ? !dataType.equals(dataType5) : dataType5 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    private boolean equalsIgnoreCompatibleNullability$default$3() {
        return false;
    }

    public boolean equalsIgnoreCompatibleCollation(DataType from, DataType to, boolean checkComplexTypes) {
        if (checkComplexTypes) {
            DataType dataType = from.transformRecursively((PartialFunction<DataType, DataType>)DataType$.transform$1());
            DataType dataType2 = to.transformRecursively((PartialFunction<DataType, DataType>)DataType$.transform$1());
            return !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null);
        }
        Tuple2 tuple2 = new Tuple2((Object)from, (Object)to);
        if (tuple2 != null) {
            DataType a = (DataType)tuple2._1();
            DataType b = (DataType)tuple2._2();
            if (a instanceof StringType) {
                StringType stringType = (StringType)a;
                if (b instanceof StringType) {
                    StringType stringType2 = (StringType)b;
                    StringConstraint stringConstraint = stringType.constraint();
                    StringConstraint stringConstraint2 = stringType2.constraint();
                    return !(stringConstraint != null ? !stringConstraint.equals(stringConstraint2) : stringConstraint2 != null);
                }
            }
        }
        if (tuple2 != null) {
            DataType x = (DataType)tuple2._1();
            DataType y = (DataType)tuple2._2();
            if (x instanceof DayTimeIntervalType && y instanceof DayTimeIntervalType) {
                return true;
            }
        }
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            DataType dataType = fromDataType;
            DataType dataType3 = toDataType;
            return !(dataType != null ? !dataType.equals(dataType3) : dataType3 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsIgnoreCompatibleCollation(Seq<DataType> from, Seq<DataType> to) {
        return from.length() == to.length() && ((IterableOnceOps)from.zip(to)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsIgnoreCompatibleCollation$1(x0$1)));
    }

    public boolean equalsIgnoreCompatibleCollation$default$3() {
        return true;
    }

    public boolean equalsStructurally(DataType from, DataType to, boolean ignoreNullability) {
        Tuple2 tuple2 = new Tuple2((Object)from, (Object)to);
        if (tuple2 != null) {
            DataType left = (DataType)tuple2._1();
            DataType right = (DataType)tuple2._2();
            if (left instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)left;
                if (right instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)right;
                    return this.equalsStructurally(arrayType.elementType(), arrayType2.elementType(), ignoreNullability) && (ignoreNullability || arrayType.containsNull() == arrayType2.containsNull());
                }
            }
        }
        if (tuple2 != null) {
            DataType left = (DataType)tuple2._1();
            DataType right = (DataType)tuple2._2();
            if (left instanceof MapType) {
                MapType mapType = (MapType)left;
                if (right instanceof MapType) {
                    MapType mapType2 = (MapType)right;
                    return this.equalsStructurally(mapType.keyType(), mapType2.keyType(), ignoreNullability) && this.equalsStructurally(mapType.valueType(), mapType2.valueType(), ignoreNullability) && (ignoreNullability || mapType.valueContainsNull() == mapType2.valueContainsNull());
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType2 instanceof StructType) {
                    StructType structType2 = (StructType)dataType2;
                    StructField[] toFields = structType2.fields();
                    return fromFields.length == toFields.length && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fromFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])toFields))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsStructurally$1(ignoreNullability, x0$1)));
                }
            }
        }
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            DataType dataType = fromDataType;
            DataType dataType3 = toDataType;
            return !(dataType != null ? !dataType.equals(dataType3) : dataType3 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsStructurally$default$3() {
        return false;
    }

    public boolean equalsStructurallyByName(DataType from, DataType to, Function2<String, String, Object> resolver) {
        Tuple2 tuple2;
        block7: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                    DataType left = (DataType)tuple2._1();
                    DataType right = (DataType)tuple2._2();
                    if (left instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)left;
                        if (right instanceof ArrayType) {
                            ArrayType arrayType2 = (ArrayType)right;
                            to = arrayType2.elementType();
                            from = arrayType.elementType();
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block7;
                DataType left = (DataType)tuple2._1();
                DataType right = (DataType)tuple2._2();
                if (!(left instanceof MapType)) break block7;
                MapType mapType = (MapType)left;
                if (!(right instanceof MapType)) break block7;
                MapType mapType2 = (MapType)right;
                if (!this.equalsStructurallyByName(mapType.keyType(), mapType2.keyType(), resolver)) break;
                to = mapType2.valueType();
                from = mapType.valueType();
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType2 instanceof StructType) {
                    StructType structType2 = (StructType)dataType2;
                    StructField[] toFields = structType2.fields();
                    return fromFields.length == toFields.length && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fromFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])toFields))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsStructurallyByName$1(resolver, x0$1)));
                }
            }
        }
        return true;
    }

    public boolean equalsIgnoreNullability(DataType left, DataType right) {
        Tuple2 tuple2;
        block8: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)left, (Object)right)) != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType2 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType leftElementType = arrayType.elementType();
                        if (dataType2 instanceof ArrayType) {
                            DataType rightElementType;
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            right = rightElementType = arrayType2.elementType();
                            left = leftElementType;
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block8;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block8;
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                if (!(dataType3 instanceof MapType)) break block8;
                MapType mapType2 = (MapType)dataType3;
                DataType rightKeyType = mapType2.keyType();
                DataType rightValueType = mapType2.valueType();
                if (!this.equalsIgnoreNullability(leftKeyType, rightKeyType)) break;
                right = rightValueType;
                left = leftValueType;
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] leftFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] rightFields = structType2.fields();
                    return leftFields.length == rightFields.length && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])leftFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])rightFields))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsIgnoreNullability$1(x0$1)));
                }
            }
        }
        if (tuple2 != null) {
            DataType l = (DataType)tuple2._1();
            DataType r = (DataType)tuple2._2();
            DataType dataType = l;
            DataType dataType5 = r;
            return !(dataType != null ? !dataType.equals(dataType5) : dataType5 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsIgnoreCaseAndNullability(DataType from, DataType to) {
        Tuple2 tuple2;
        block8: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType2 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType fromElement = arrayType.elementType();
                        if (dataType2 instanceof ArrayType) {
                            DataType toElement;
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            to = toElement = arrayType2.elementType();
                            from = fromElement;
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block8;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block8;
                MapType mapType = (MapType)dataType;
                DataType fromKey = mapType.keyType();
                DataType fromValue = mapType.valueType();
                if (!(dataType3 instanceof MapType)) break block8;
                MapType mapType2 = (MapType)dataType3;
                DataType toKey = mapType2.keyType();
                DataType toValue = mapType2.valueType();
                if (!this.equalsIgnoreCaseAndNullability(fromKey, toKey)) break;
                to = toValue;
                from = fromValue;
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    return fromFields.length == toFields.length && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fromFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])toFields))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsIgnoreCaseAndNullability$1(x0$1)));
                }
            }
        }
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            DataType dataType = fromDataType;
            DataType dataType5 = toDataType;
            return !(dataType != null ? !dataType.equals(dataType5) : dataType5 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ TimeType $anonfun$otherTypes$1(int x$1) {
        return new TimeType(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$parseStructField$1(Tuple2 x$3) {
        Object object = x$3._1();
        String string = MODULE$.COLLATIONS_METADATA_KEY();
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$getCollationsMap$1(Tuple2 x$4) {
        Object object = x$4._1();
        String string = MODULE$.COLLATIONS_METADATA_KEY();
        return !(object != null ? !object.equals(string) : string != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$equalsIgnoreCompatibleNullability$1(boolean ignoreName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        StructField fromField = (StructField)tuple2._1();
        StructField toField = (StructField)tuple2._2();
        if (!ignoreName$1) {
            String string = fromField.name();
            String string2 = toField.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
        }
        if (!toField.nullable()) {
            if (fromField.nullable()) return false;
        }
        if (!MODULE$.equalsIgnoreCompatibleNullability(fromField.dataType(), toField.dataType(), ignoreName$1)) return false;
        return true;
    }

    private static final PartialFunction transform$1() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends DataType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CharType ? true : A1 instanceof VarcharType) {
                    return (B1)A1;
                }
                if (A1 instanceof StringType) {
                    return (B1)StringType$.MODULE$;
                }
                if (A1 instanceof DayTimeIntervalType) {
                    return (B1)DayTimeIntervalType$.MODULE$.DEFAULT();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(DataType x1) {
                DataType dataType = x1;
                if (dataType instanceof CharType ? true : dataType instanceof VarcharType) {
                    return true;
                }
                if (dataType instanceof StringType) {
                    return true;
                }
                return dataType instanceof DayTimeIntervalType;
            }
        };
    }

    public static final /* synthetic */ boolean $anonfun$equalsIgnoreCompatibleCollation$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            return MODULE$.equalsIgnoreCompatibleCollation(fromDataType, toDataType, MODULE$.equalsIgnoreCompatibleCollation$default$3());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$equalsStructurally$1(boolean ignoreNullability$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField l = (StructField)tuple2._1();
            StructField r = (StructField)tuple2._2();
            return MODULE$.equalsStructurally(l.dataType(), r.dataType(), ignoreNullability$1) && (ignoreNullability$1 || l.nullable() == r.nullable());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$equalsStructurallyByName$1(Function2 resolver$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField l = (StructField)tuple2._1();
            StructField r = (StructField)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)l.name(), (Object)r.name())) && MODULE$.equalsStructurallyByName(l.dataType(), r.dataType(), (Function2<String, String, Object>)resolver$1);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$equalsIgnoreNullability$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField l = (StructField)tuple2._1();
            StructField r = (StructField)tuple2._2();
            String string = l.name();
            String string2 = r.name();
            return !(string != null ? !string.equals(string2) : string2 != null) && MODULE$.equalsIgnoreNullability(l.dataType(), r.dataType());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$equalsIgnoreCaseAndNullability$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField l = (StructField)tuple2._1();
            StructField r = (StructField)tuple2._2();
            return l.name().equalsIgnoreCase(r.name()) && MODULE$.equalsIgnoreCaseAndNullability(l.dataType(), r.dataType());
        }
        throw new MatchError((Object)tuple2);
    }

    private DataType$() {
    }
}

