/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.lib;

import com.github.fommil.netlib.BLAS;
import java.io.Serializable;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.lib.SVDPlusPlus;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

public final class SVDPlusPlus$ {
    public static SVDPlusPlus$ MODULE$;

    static {
        new SVDPlusPlus$();
    }

    public Tuple2<Graph<Tuple4<double[], double[], Object, Object>, Object>, Object> run(RDD<Edge<Object>> edges, SVDPlusPlus.Conf conf) {
        Predef$.MODULE$.require(conf.maxIters() > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Maximum of iterations must be greater than 0,").append(new StringBuilder(9).append(" but got ").append(conf.maxIters()).toString()).toString());
        Predef$.MODULE$.require(conf.maxVal() > conf.minVal(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("MaxVal must be greater than MinVal,").append(new StringBuilder(29).append(" but got {maxVal: ").append(conf.maxVal()).append(", minVal: ").append(conf.minVal()).append("}").toString()).toString());
        edges.cache();
        Tuple2 tuple2 = (Tuple2)edges.map((Function1 & Serializable & scala.Serializable)e -> new Tuple2.mcDJ.sp(e.attr$mcD$sp(), 1L), ClassTag$.MODULE$.apply(Tuple2.class)).fold((Object)new Tuple2.mcDJ.sp(0.0, 0L), (Function2 & Serializable & scala.Serializable)(a, b) -> new Tuple2.mcDJ.sp(a._1$mcD$sp() + b._1$mcD$sp(), a._2$mcJ$sp() + b._2$mcJ$sp()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double rs = tuple2._1$mcD$sp();
        long rc = tuple2._2$mcJ$sp();
        Tuple2.mcDJ.sp sp2 = new Tuple2.mcDJ.sp(rs, rc);
        Tuple2.mcDJ.sp sp3 = sp2;
        double rs2 = sp3._1$mcD$sp();
        long rc2 = sp3._2$mcJ$sp();
        double u = rs2 / (double)rc2;
        ObjectRef g = ObjectRef.create(Graph$.MODULE$.fromEdges(edges, SVDPlusPlus$.defaultF$1(conf.rank()), Graph$.MODULE$.fromEdges$default$3(), Graph$.MODULE$.fromEdges$default$4(), ClassTag$.MODULE$.apply(Tuple4.class), ClassTag$.MODULE$.Double()).cache());
        this.materialize((Graph)g.elem);
        edges.unpersist(edges.unpersist$default$1());
        Graph qual$1 = (Graph)g.elem;
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)ctx -> {
            SVDPlusPlus$.$anonfun$run$7(ctx);
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(g1, g2) -> new Tuple2.mcJD.sp(g1._1$mcJ$sp() + g2._1$mcJ$sp(), g1._2$mcD$sp() + g2._2$mcD$sp());
        TripletFields x$3 = qual$1.aggregateMessages$default$3();
        VertexRDD t0 = qual$1.aggregateMessages(x$1, x$2, x$3, ClassTag$.MODULE$.apply(Tuple2.class));
        Graph gJoinT0 = ((Graph)g.elem).outerJoinVertices(t0, (Function3 & Serializable & scala.Serializable)(vid, vd, msg) -> SVDPlusPlus$.$anonfun$run$9(u, BoxesRunTime.unboxToLong((Object)vid), vd, msg), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple4.class), Predef.$eq$colon$eq$.MODULE$.tpEquals()).cache();
        this.materialize(gJoinT0);
        Graph qual$2 = (Graph)g.elem;
        boolean x$4 = qual$2.unpersist$default$1();
        qual$2.unpersist(x$4);
        g.elem = gJoinT0;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), conf.maxIters()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ((Graph)g$1.elem).cache();
            Graph qual$3 = (Graph)g$1.elem;
            Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)ctx -> {
                ctx.sendToSrc(((Tuple4)ctx.dstAttr())._2());
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable x$6 = (Function2 & Serializable & scala.Serializable)(g1, g2) -> {
                void var2_2;
                double[] out = (double[])g1.clone();
                BLAS.getInstance().daxpy(out.length, 1.0, g2, 1, out, 1);
                return var2_2;
            };
            TripletFields x$7 = qual$3.aggregateMessages$default$3();
            VertexRDD t1 = qual$3.aggregateMessages(x$5, x$6, x$7, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Graph gJoinT1 = ((Graph)g$1.elem).outerJoinVertices(t1, (Function3 & Serializable & scala.Serializable)(vid, vd, msg) -> SVDPlusPlus$.$anonfun$run$13(BoxesRunTime.unboxToLong((Object)vid), vd, msg), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), ClassTag$.MODULE$.apply(Tuple4.class), Predef.$eq$colon$eq$.MODULE$.tpEquals()).cache();
            MODULE$.materialize(gJoinT1);
            Graph qual$4 = (Graph)g$1.elem;
            boolean x$8 = qual$4.unpersist$default$1();
            qual$4.unpersist(x$8);
            g$1.elem = gJoinT1;
            ((Graph)g$1.elem).cache();
            Graph qual$5 = (Graph)g$1.elem;
            Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)ctx -> {
                SVDPlusPlus$.sendMsgTrainF$1(conf, u, ctx);
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable x$10 = (Function2 & Serializable & scala.Serializable)(g1, g2) -> {
                double[] out1 = (double[])((double[])g1._1()).clone();
                BLAS.getInstance().daxpy(out1.length, 1.0, (double[])g2._1(), 1, out1, 1);
                double[] out2 = (double[])((double[])g2._2()).clone();
                BLAS.getInstance().daxpy(out2.length, 1.0, (double[])g2._2(), 1, out2, 1);
                return new Tuple3((Object)out1, (Object)out2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)g1._3()) + BoxesRunTime.unboxToDouble((Object)g2._3()))));
            };
            TripletFields x$11 = qual$5.aggregateMessages$default$3();
            VertexRDD t2 = qual$5.aggregateMessages(x$9, x$10, x$11, ClassTag$.MODULE$.apply(Tuple3.class));
            Graph gJoinT2 = ((Graph)g$1.elem).outerJoinVertices(t2, (Function3 & Serializable & scala.Serializable)(vid, vd, msg) -> SVDPlusPlus$.$anonfun$run$16(BoxesRunTime.unboxToLong((Object)vid), vd, msg), ClassTag$.MODULE$.apply(Tuple3.class), ClassTag$.MODULE$.apply(Tuple4.class), Predef.$eq$colon$eq$.MODULE$.tpEquals()).cache();
            MODULE$.materialize(gJoinT2);
            Graph qual$6 = (Graph)g$1.elem;
            boolean x$12 = qual$6.unpersist$default$1();
            qual$6.unpersist(x$12);
            g$1.elem = gJoinT2;
        });
        ((Graph)g.elem).cache();
        Graph qual$7 = (Graph)g.elem;
        Function1 & Serializable & scala.Serializable x$13 = (Function1 & Serializable & scala.Serializable)ctx -> {
            SVDPlusPlus$.sendMsgTestF$1(conf, u, ctx);
            return BoxedUnit.UNIT;
        };
        JFunction2.mcDDD.sp & Serializable & scala.Serializable x$14 = (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$6, x$7) -> x$6 + x$7;
        TripletFields x$15 = qual$7.aggregateMessages$default$3();
        VertexRDD t3 = qual$7.aggregateMessages(x$13, x$14, x$15, ClassTag$.MODULE$.Double());
        Graph gJoinT3 = ((Graph)g.elem).outerJoinVertices(t3, (Function3 & Serializable & scala.Serializable)(vid, vd, msg) -> SVDPlusPlus$.$anonfun$run$19(BoxesRunTime.unboxToLong((Object)vid), vd, msg), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple4.class), Predef.$eq$colon$eq$.MODULE$.tpEquals()).cache();
        this.materialize(gJoinT3);
        Graph qual$8 = (Graph)g.elem;
        boolean x$16 = qual$8.unpersist$default$1();
        qual$8.unpersist(x$16);
        g.elem = gJoinT3;
        VertexRDD newVertices = ((Graph)g.elem).vertices().mapValues((Function1 & Serializable & scala.Serializable)v -> new Tuple4(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])v._1())).toArray(ClassTag$.MODULE$.Double()), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])v._2())).toArray(ClassTag$.MODULE$.Double()), v._3(), v._4()), ClassTag$.MODULE$.apply(Tuple4.class));
        return new Tuple2(Graph$.MODULE$.apply(newVertices, ((Graph)g.elem).edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Tuple4.class), ClassTag$.MODULE$.Double()), (Object)BoxesRunTime.boxToDouble((double)u));
    }

    private void materialize(Graph<?, ?> g) {
        g.vertices().count();
        g.edges().count();
    }

    private static final Tuple4 defaultF$1(int rank) {
        double[] v1 = (double[])Array$.MODULE$.fill(rank, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Random$.MODULE$.nextDouble(), ClassTag$.MODULE$.Double());
        double[] v2 = (double[])Array$.MODULE$.fill(rank, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Random$.MODULE$.nextDouble(), ClassTag$.MODULE$.Double());
        return new Tuple4((Object)v1, (Object)v2, (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0));
    }

    public static final /* synthetic */ void $anonfun$run$7(EdgeContext ctx) {
        ctx.sendToSrc(new Tuple2.mcJD.sp(1L, BoxesRunTime.unboxToDouble(ctx.attr())));
        ctx.sendToDst(new Tuple2.mcJD.sp(1L, BoxesRunTime.unboxToDouble(ctx.attr())));
    }

    public static final /* synthetic */ Tuple4 $anonfun$run$9(double u$1, long vid, Tuple4 vd, Option msg) {
        return new Tuple4(vd._1(), vd._2(), (Object)BoxesRunTime.boxToDouble((double)(((Tuple2)msg.get())._2$mcD$sp() / (double)((Tuple2)msg.get())._1$mcJ$sp() - u$1)), (Object)BoxesRunTime.boxToDouble((double)(1.0 / package$.MODULE$.sqrt((double)((Tuple2)msg.get())._1$mcJ$sp()))));
    }

    private static final void sendMsgTrainF$1(SVDPlusPlus.Conf conf, double u, EdgeContext ctx) {
        Tuple2 tuple2 = new Tuple2(ctx.srcAttr(), ctx.dstAttr());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple4 usr = (Tuple4)tuple2._1();
        Tuple4 itm = (Tuple4)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)usr, (Object)itm);
        Tuple2 tuple23 = tuple22;
        Tuple4 usr2 = (Tuple4)tuple23._1();
        Tuple4 itm2 = (Tuple4)tuple23._2();
        Tuple2 tuple24 = new Tuple2(usr2._1(), itm2._1());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        double[] p = (double[])tuple24._1();
        double[] q = (double[])tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)p, (Object)q);
        Tuple2 tuple26 = tuple25;
        double[] p2 = (double[])tuple26._1();
        double[] q2 = (double[])tuple26._2();
        int rank = p2.length;
        double pred = u + BoxesRunTime.unboxToDouble((Object)usr2._3()) + BoxesRunTime.unboxToDouble((Object)itm2._3()) + BLAS.getInstance().ddot(rank, q2, 1, (double[])usr2._2(), 1);
        pred = package$.MODULE$.max(pred, conf.minVal());
        pred = package$.MODULE$.min(pred, conf.maxVal());
        double err = BoxesRunTime.unboxToDouble(ctx.attr()) - pred;
        double[] updateP = (double[])q2.clone();
        BLAS.getInstance().dscal(rank, err * conf.gamma2(), updateP, 1);
        BLAS.getInstance().daxpy(rank, -conf.gamma7() * conf.gamma2(), p2, 1, updateP, 1);
        double[] updateQ = (double[])((double[])usr2._2()).clone();
        BLAS.getInstance().dscal(rank, err * conf.gamma2(), updateQ, 1);
        BLAS.getInstance().daxpy(rank, -conf.gamma7() * conf.gamma2(), q2, 1, updateQ, 1);
        double[] updateY = (double[])q2.clone();
        BLAS.getInstance().dscal(rank, err * BoxesRunTime.unboxToDouble((Object)usr2._4()) * conf.gamma2(), updateY, 1);
        BLAS.getInstance().daxpy(rank, -conf.gamma7() * conf.gamma2(), (double[])itm2._2(), 1, updateY, 1);
        ctx.sendToSrc(new Tuple3((Object)updateP, (Object)updateY, (Object)BoxesRunTime.boxToDouble((double)((err - conf.gamma6() * BoxesRunTime.unboxToDouble((Object)usr2._3())) * conf.gamma1()))));
        ctx.sendToDst(new Tuple3((Object)updateQ, (Object)updateY, (Object)BoxesRunTime.boxToDouble((double)((err - conf.gamma6() * BoxesRunTime.unboxToDouble((Object)itm2._3())) * conf.gamma1()))));
    }

    public static final /* synthetic */ Tuple4 $anonfun$run$13(long vid, Tuple4 vd, Option msg) {
        Tuple4 tuple4;
        if (msg.isDefined()) {
            double[] out = (double[])((double[])vd._1()).clone();
            BLAS.getInstance().daxpy(out.length, BoxesRunTime.unboxToDouble((Object)vd._4()), (double[])msg.get(), 1, out, 1);
            tuple4 = new Tuple4(vd._1(), (Object)out, vd._3(), vd._4());
        } else {
            tuple4 = vd;
        }
        return tuple4;
    }

    public static final /* synthetic */ Tuple4 $anonfun$run$16(long vid, Tuple4 vd, Option msg) {
        double[] out1 = (double[])((double[])vd._1()).clone();
        BLAS.getInstance().daxpy(out1.length, 1.0, (double[])((Tuple3)msg.get())._1(), 1, out1, 1);
        double[] out2 = (double[])((double[])vd._2()).clone();
        BLAS.getInstance().daxpy(out2.length, 1.0, (double[])((Tuple3)msg.get())._2(), 1, out2, 1);
        return new Tuple4((Object)out1, (Object)out2, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)vd._3()) + BoxesRunTime.unboxToDouble((Object)((Tuple3)msg.get())._3()))), vd._4());
    }

    private static final void sendMsgTestF$1(SVDPlusPlus.Conf conf, double u, EdgeContext ctx) {
        Tuple2 tuple2 = new Tuple2(ctx.srcAttr(), ctx.dstAttr());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple4 usr = (Tuple4)tuple2._1();
        Tuple4 itm = (Tuple4)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)usr, (Object)itm);
        Tuple2 tuple23 = tuple22;
        Tuple4 usr2 = (Tuple4)tuple23._1();
        Tuple4 itm2 = (Tuple4)tuple23._2();
        Tuple2 tuple24 = new Tuple2(usr2._1(), itm2._1());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        double[] p = (double[])tuple24._1();
        double[] q = (double[])tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)p, (Object)q);
        Tuple2 tuple26 = tuple25;
        double[] p2 = (double[])tuple26._1();
        double[] q2 = (double[])tuple26._2();
        double pred = u + BoxesRunTime.unboxToDouble((Object)usr2._3()) + BoxesRunTime.unboxToDouble((Object)itm2._3()) + BLAS.getInstance().ddot(q2.length, q2, 1, (double[])usr2._2(), 1);
        pred = package$.MODULE$.max(pred, conf.minVal());
        pred = package$.MODULE$.min(pred, conf.maxVal());
        double err = (BoxesRunTime.unboxToDouble(ctx.attr()) - pred) * (BoxesRunTime.unboxToDouble(ctx.attr()) - pred);
        ctx.sendToDst(BoxesRunTime.boxToDouble((double)err));
    }

    public static final /* synthetic */ Tuple4 $anonfun$run$19(long vid, Tuple4 vd, Option msg) {
        return msg.isDefined() ? new Tuple4(vd._1(), vd._2(), vd._3(), msg.get()) : vd;
    }

    private SVDPlusPlus$() {
        MODULE$ = this;
    }
}

