/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.spark.SparkException;

public class DayTimeIntervalUtils {
    private static final byte DAY = 0;
    private static final byte HOUR = 1;
    private static final byte MINUTE = 2;
    private static final byte SECOND = 3;
    private static final long HOURS_PER_DAY = 24L;
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MICROS_PER_MILLIS = 1000L;
    private static final long MICROS_PER_SECOND = 1000000L;
    private static final long MICROS_PER_MINUTE = 60000000L;
    private static final long MICROS_PER_HOUR = 3600000000L;
    private static final long MICROS_PER_DAY = 86400000000L;
    private static final long MAX_HOUR = 2562047788L;
    private static final long MAX_MINUTE = 153722867280L;
    private static final long MAX_SECOND = 9223372036854L;

    public static String fieldToString(byte field) throws SparkException {
        if (field == 0) {
            return "DAY";
        }
        if (field == 1) {
            return "HOUR";
        }
        if (field == 2) {
            return "MINUTE";
        }
        if (field == 3) {
            return "SECOND";
        }
        throw new SparkException("Invalid field in day-time interval: " + field + ". Supported fields are: DAY, HOUR, MINUTE, SECOND");
    }

    public static String toDayTimeIntervalANSIString(long micros, byte startField, byte endField) throws SparkException {
        String leadZero;
        String postfix;
        String sign = "";
        long rest = micros;
        String from = DayTimeIntervalUtils.fieldToString(startField).toUpperCase();
        String to = DayTimeIntervalUtils.fieldToString(endField).toUpperCase();
        String prefix = "INTERVAL '";
        String string = postfix = startField == endField ? "' " + from : "' " + from + " TO " + to;
        if (micros < 0L) {
            if (micros == Long.MIN_VALUE) {
                int substrStart;
                String baseStr = "-106751991 04:00:54.775808000";
                long MAX_DAY = 106751991L;
                String firstStr = "-" + (startField == 0 ? Long.toString(MAX_DAY) : (startField == 1 ? Long.toString(2562047788L) : (startField == 2 ? Long.toString(153722867280L) : "9223372036854.775808")));
                if (startField == endField) {
                    return prefix + firstStr + postfix;
                }
                int n = startField == 0 ? 10 : (substrStart = startField == 1 ? 13 : 16);
                int substrEnd = endField == 1 ? 13 : (endField == 2 ? 16 : 26);
                return prefix + firstStr + baseStr.substring(substrStart, substrEnd) + postfix;
            }
            sign = "-";
            rest = -rest;
        }
        StringBuilder formatBuilder = new StringBuilder(sign);
        ArrayList<Long> formatArgs = new ArrayList<Long>();
        if (startField == 0) {
            formatBuilder.append(rest / 86400000000L);
            rest %= 86400000000L;
        } else if (startField == 1) {
            formatBuilder.append("%02d");
            formatArgs.add(rest / 3600000000L);
            rest %= 3600000000L;
        } else if (startField == 2) {
            formatBuilder.append("%02d");
            formatArgs.add(rest / 60000000L);
            rest %= 60000000L;
        } else if (startField == 3) {
            leadZero = rest < 10000000L ? "0" : "";
            formatBuilder.append(leadZero).append(BigDecimal.valueOf(rest, 6).stripTrailingZeros().toPlainString());
        }
        if (startField < 1 && 1 <= endField) {
            formatBuilder.append(" %02d");
            formatArgs.add(rest / 3600000000L);
            rest %= 3600000000L;
        }
        if (startField < 2 && 2 <= endField) {
            formatBuilder.append(":%02d");
            formatArgs.add(rest / 60000000L);
            rest %= 60000000L;
        }
        if (startField < 3 && 3 <= endField) {
            leadZero = rest < 10000000L ? "0" : "";
            formatBuilder.append(":").append(leadZero).append(BigDecimal.valueOf(rest, 6).stripTrailingZeros().toPlainString());
        }
        return prefix + String.format(formatBuilder.toString(), formatArgs.toArray()) + postfix;
    }
}

