/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.XXH64;
import org.apache.spark.sql.catalyst.expressions.XxHash64$;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a 64-bit hash value of the arguments. Hash seed is 42.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', array(123), 2);\n       5602566077635097486\n  ", since="3.0.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001B\u000f\u001f\u0001.B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u000f\"Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005Q\u0001\tE\t\u0015!\u00031\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015\t\u0006\u0001\"\u0001W\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015Y\u0007\u0001\"\u0015c\u0011\u0015a\u0007\u0001\"\u0015n\u0011\u0015)\b\u0001\"\u0015w\u0011\u001da\b!!A\u0005\u0002uD\u0011\"!\u0001\u0001#\u0003%\t!a\u0001\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005m\u0001\"CA\u0010\u0001\u0005\u0005I\u0011IA\u0011\u0011%\t\t\u0004AA\u0001\n\u0003\t\u0019\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0001\u0002>!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0013Q\t\u0005\n\u0003'\u0002\u0011\u0011!C\u0001\u0003+B\u0011\"a\u0018\u0001\u0003\u0003%\t%!\u0019\t\u0013\u0005\u0015\u0004!!A\u0005B\u0005\u001dt!CAF=\u0005\u0005\t\u0012AAG\r!ib$!A\t\u0002\u0005=\u0005BB)\u0018\t\u0003\t9\u000bC\u0005\u0002*^\t\t\u0011\"\u0012\u0002,\"I\u0011QV\f\u0002\u0002\u0013\u0005\u0015q\u0016\u0005\n\u0003k;\u0012\u0011!CA\u0003oC\u0011\"!3\u0018\u0003\u0003%I!a3\u0003\u0011aC\b*Y:imQR!a\b\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003C\t\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0005\u000112\u0014\bE\u0002.]Aj\u0011AH\u0005\u0003_y\u0011a\u0002S1tQ\u0016C\bO]3tg&|g\u000e\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0003M_:<\u0007CA\u00198\u0013\tA$GA\u0004Qe>$Wo\u0019;\u0011\u0005i\u0012eBA\u001eA\u001d\tat(D\u0001>\u0015\tq$&\u0001\u0004=e>|GOP\u0005\u0002g%\u0011\u0011IM\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019EI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Be\u0005A1\r[5mIJ,g.F\u0001H!\rQ\u0004JS\u0005\u0003\u0013\u0012\u00131aU3r!\ti3*\u0003\u0002M=\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0013\u0001B:fK\u0012,\u0012\u0001M\u0001\u0006g\u0016,G\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M#V\u000b\u0005\u0002.\u0001!)Q)\u0002a\u0001\u000f\")a*\u0002a\u0001aQ\u00111k\u0016\u0005\u00061\u001a\u0001\raR\u0001\nCJ<W/\\3oiN\f\u0001\u0002Z1uCRK\b/Z\u000b\u00027B\u0011AlX\u0007\u0002;*\u0011aLI\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,W#A2\u0011\u0005\u0011DgBA3g!\ta$'\u0003\u0002he\u00051\u0001K]3eK\u001aL!!\u001b6\u0003\rM#(/\u001b8h\u0015\t9''A\biCNDWM]\"mCN\u001ch*Y7f\u0003-\u0019w.\u001c9vi\u0016D\u0015m\u001d5\u0015\tAr7\u000f\u001e\u0005\u0006_*\u0001\r\u0001]\u0001\u0006m\u0006dW/\u001a\t\u0003cEL!A\u001d\u001a\u0003\u0007\u0005s\u0017\u0010C\u0003Z\u0015\u0001\u00071\fC\u0003O\u0015\u0001\u0007\u0001'A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u00111k\u001e\u0005\u0006q.\u0001\r!_\u0001\f]\u0016<8\t[5mIJ,g\u000eE\u0002;u*K!a\u001f#\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLHcA*\u007f\u007f\"9Q\t\u0004I\u0001\u0002\u00049\u0005b\u0002(\r!\u0003\u0005\r\u0001M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)AK\u0002H\u0003\u000fY#!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'\u0011\u0014AC1o]>$\u0018\r^5p]&!\u0011qCA\u0007\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiBK\u00021\u0003\u000f\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tA\u0001\\1oO*\u0011\u0011QF\u0001\u0005U\u00064\u0018-C\u0002j\u0003O\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u000e\u0011\u0007E\n9$C\u0002\u0002:I\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001]A \u0011%\t\t%EA\u0001\u0002\u0004\t)$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000f\u0002R!!\u0013\u0002PAl!!a\u0013\u000b\u0007\u00055#'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0015\u0002L\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9&!\u0018\u0011\u0007E\nI&C\u0002\u0002\\I\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002BM\t\t\u00111\u0001q\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r\u00121\r\u0005\n\u0003\u0003\"\u0012\u0011!a\u0001\u0003k\ta!Z9vC2\u001cH\u0003BA,\u0003SB\u0001\"!\u0011\u0016\u0003\u0003\u0005\r\u0001\u001d\u0015\u0014\u0001\u00055\u00141OA;\u0003s\nY(a \u0002\u0002\u0006\u0015\u0015q\u0011\t\u0004[\u0005=\u0014bAA9=\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA<\u0003i{f)\u0016(D?\"*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:3Y\u0001rcFL\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t\u001c5[\tLG\u000f\t5bg\"\u0004c/\u00197vK\u0002zg\r\t;iK\u0002\n'oZ;nK:$8O\f\u0011ICND\u0007e]3fI\u0002J7\u000f\t\u001b3]\u0005AQ\r_1na2,7/\t\u0002\u0002~\u0005Y&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!CJ\u0014\u0018-\u001f\u00152eMJC\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001*d\u0007\r\u001a6mY\u0002tg\u000e\u001c4kAJt\u0007\u000e\u001d7\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAB\u0003\u0015\u0019d\u0006\r\u00181\u0003\u00159'o\\;qC\t\tI)\u0001\u0006iCNDwLZ;oGN\f\u0001\u0002\u0017=ICNDg\u0007\u000e\t\u0003[]\u0019RaFAI\u0003;\u0003r!a%\u0002\u001a\u001e\u00034+\u0004\u0002\u0002\u0016*\u0019\u0011q\u0013\u001a\u0002\u000fI,h\u000e^5nK&!\u00111TAK\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*!\u00111UA\u0016\u0003\tIw.C\u0002D\u0003C#\"!!$\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\t\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bM\u000b\t,a-\t\u000b\u0015S\u0002\u0019A$\t\u000b9S\u0002\u0019\u0001\u0019\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011XAc!\u0015\t\u00141XA`\u0013\r\tiL\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bE\n\tm\u0012\u0019\n\u0007\u0005\r'G\u0001\u0004UkBdWM\r\u0005\t\u0003\u000f\\\u0012\u0011!a\u0001'\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u00055\u0007\u0003BA\u0013\u0003\u001fLA!!5\u0002(\t1qJ\u00196fGR\u0004")
public class XxHash64
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final long seed;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(XxHash64 x$0) {
        return XxHash64$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, XxHash64> tupled() {
        return XxHash64$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, XxHash64>> curried() {
        return XxHash64$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "xxhash64";
    }

    @Override
    public String hasherClassName() {
        return XXH64.class.getName();
    }

    @Override
    public long computeHash(Object value, DataType dataType, long seed) {
        return XxHash64Function$.MODULE$.hash(value, dataType, seed);
    }

    @Override
    public XxHash64 withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public XxHash64 copy(Seq<Expression> children2, long seed) {
        return new XxHash64(children2, seed);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public long copy$default$2() {
        return this.seed();
    }

    @Override
    public String productPrefix() {
        return "XxHash64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToLong((long)this.seed());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XxHash64;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
            case 1: {
                return "seed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XxHash64)) return false;
        boolean bl = true;
        if (!bl) return false;
        XxHash64 xxHash64 = (XxHash64)x$1;
        if (this.seed() != xxHash64.seed()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = xxHash64.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!xxHash64.canEqual(this)) return false;
        return true;
    }

    public XxHash64(Seq<Expression> children2, long seed) {
        this.children = children2;
        this.seed = seed;
    }

    public XxHash64(Seq<Expression> arguments) {
        this(arguments, 42L);
    }
}

