/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringDecode$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(bin, charset) - Decodes the first argument using the second argument character set.", examples="\n    Examples:\n      > SELECT _FUNC_(encode('abc', 'utf-8'), 'utf-8');\n       abc\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001B\u0010!\u00016B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0011O\u0011\u0015Y\u0006\u0001\"\u0011O\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015I\u0007\u0001\"\u0015k\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u001d\t\u0019\u0001\u0001C)\u0003\u000bAq!a\u0004\u0001\t\u0003\n\t\u0002C\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&!I\u00111\u0006\u0001\u0012\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003\u0007\u0002\u0011\u0013!C\u0001\u0003[A\u0011\"!\u0012\u0001\u0003\u0003%\t%a\u0012\t\u0013\u0005]\u0003!!A\u0005\u0002\u0005e\u0003\"CA1\u0001\u0005\u0005I\u0011AA2\u0011%\tI\u0007AA\u0001\n\u0003\nY\u0007C\u0005\u0002z\u0001\t\t\u0011\"\u0001\u0002|!I\u0011Q\u0011\u0001\u0002\u0002\u0013\u0005\u0013q\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C!\u0003\u001b;\u0011\"!-!\u0003\u0003E\t!a-\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0003kCa!V\r\u0005\u0002\u00055\u0007\"CAh3\u0005\u0005IQIAi\u0011%\t\u0019.GA\u0001\n\u0003\u000b)\u000eC\u0005\u0002\\f\t\t\u0011\"!\u0002^\"I\u0011q^\r\u0002\u0002\u0013%\u0011\u0011\u001f\u0002\r'R\u0014\u0018N\\4EK\u000e|G-\u001a\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M1\u0001A\f\u001a6y\t\u0003\"a\f\u0019\u000e\u0003\u0001J!!\r\u0011\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00184\u0013\t!\u0004E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t1\u0014H\u0004\u00020o%\u0011\u0001\bI\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4H\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005a\u0002\u0003CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0007*s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001dc\u0013A\u0002\u001fs_>$h(C\u0001@\u0013\tAd(\u0003\u0002L\u0019\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001HP\u0001\u0004E&tW#A(\u0011\u0005=\u0002\u0016BA)!\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0005E&t\u0007%A\u0004dQ\u0006\u00148/\u001a;\u0002\u0011\rD\u0017M]:fi\u0002\na\u0001P5oSRtDcA,Y3B\u0011q\u0006\u0001\u0005\u0006\u001b\u0016\u0001\ra\u0014\u0005\u0006'\u0016\u0001\raT\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0005eCR\fG+\u001f9f+\u0005q\u0006CA0c\u001b\u0005\u0001'BA1%\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0007M\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002MB\u00191i\u001a0\n\u0005!d%aA*fc\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u00191N\u001c9\u0011\u0005ub\u0017BA7?\u0005\r\te.\u001f\u0005\u0006_*\u0001\ra[\u0001\u0007S:\u0004X\u000f^\u0019\t\u000bET\u0001\u0019A6\u0002\r%t\u0007/\u001e;3\u0003%!wnR3o\u0007>$W\rF\u0002uu~\u0004\"!\u001e=\u000e\u0003YT!a\u001e\u0011\u0002\u000f\r|G-Z4f]&\u0011\u0011P\u001e\u0002\t\u000bb\u0004(oQ8eK\")1p\u0003a\u0001y\u0006\u00191\r\u001e=\u0011\u0005Ul\u0018B\u0001@w\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!!\u0001\f\u0001\u0004!\u0018AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003X\u0003\u000f\tY\u0001\u0003\u0004\u0002\n1\u0001\raT\u0001\b]\u0016<H*\u001a4u\u0011\u0019\ti\u0001\u0004a\u0001\u001f\u0006Aa.Z<SS\u001eDG/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0005\u0011\t\u0005U\u0011Q\u0004\b\u0005\u0003/\tI\u0002\u0005\u0002F}%\u0019\u00111\u0004 \u0002\rA\u0013X\rZ3g\u0013\u0011\ty\"!\t\u0003\rM#(/\u001b8h\u0015\r\tYBP\u0001\u0005G>\u0004\u0018\u0010F\u0003X\u0003O\tI\u0003C\u0004N\u001dA\u0005\t\u0019A(\t\u000fMs\u0001\u0013!a\u0001\u001f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0018U\ry\u0015\u0011G\u0016\u0003\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\b \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002B\u0005]\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001\u00027b]\u001eT!!a\u0015\u0002\t)\fg/Y\u0005\u0005\u0003?\ti%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\\A\u0019Q(!\u0018\n\u0007\u0005}cHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002l\u0003KB\u0011\"a\u001a\u0014\u0003\u0003\u0005\r!a\u0017\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0007E\u0003\u0002p\u0005U4.\u0004\u0002\u0002r)\u0019\u00111\u000f \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002x\u0005E$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!! \u0002\u0004B\u0019Q(a \n\u0007\u0005\u0005eHA\u0004C_>dW-\u00198\t\u0011\u0005\u001dT#!AA\u0002-\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011JAE\u0011%\t9GFA\u0001\u0002\u0004\tY&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003{\ny\t\u0003\u0005\u0002h]\t\t\u00111\u0001lQM\u0001\u00111SAM\u00037\u000by*!)\u0002&\u0006\u001d\u00161VAW!\ry\u0013QS\u0005\u0004\u0003/\u0003#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003;\u000b!l\u0018$V\u001d\u000e{\u0006FY5oY\u0001\u001a\u0007.\u0019:tKRL\u0003%\f\u0011EK\u000e|G-Z:!i\",\u0007EZ5sgR\u0004\u0013M]4v[\u0016tG\u000fI;tS:<\u0007\u0005\u001e5fAM,7m\u001c8eA\u0005\u0014x-^7f]R\u00043\r[1sC\u000e$XM\u001d\u0011tKRt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0016\u0001\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)K:\u001cw\u000eZ3)O\u0005\u00147m\n\u0017!OU$h-\f\u001d(S1\u0002s%\u001e;g[a:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011bE\u000eT\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003S\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!a,\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0019M#(/\u001b8h\t\u0016\u001cw\u000eZ3\u0011\u0005=J2#B\r\u00028\u0006\r\u0007cBA]\u0003\u007f{ujV\u0007\u0003\u0003wS1!!0?\u0003\u001d\u0011XO\u001c;j[\u0016LA!!1\u0002<\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fTA!!3\u0002R\u0005\u0011\u0011n\\\u0005\u0004\u0017\u0006\u001dGCAAZ\u0003!!xn\u0015;sS:<GCAA%\u0003\u0015\t\u0007\u000f\u001d7z)\u00159\u0016q[Am\u0011\u0015iE\u00041\u0001P\u0011\u0015\u0019F\u00041\u0001P\u0003\u001d)h.\u00199qYf$B!a8\u0002lB)Q(!9\u0002f&\u0019\u00111\u001d \u0003\r=\u0003H/[8o!\u0015i\u0014q](P\u0013\r\tIO\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u00055X$!AA\u0002]\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\u0019\u0010\u0005\u0003\u0002L\u0005U\u0018\u0002BA|\u0003\u001b\u0012aa\u00142kK\u000e$\b")
public class StringDecode
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression bin;
    private final Expression charset;

    public static Option<Tuple2<Expression, Expression>> unapply(StringDecode x$0) {
        return StringDecode$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, StringDecode> tupled() {
        return StringDecode$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringDecode>> curried() {
        return StringDecode$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression bin() {
        return this.bin;
    }

    public Expression charset() {
        return this.charset;
    }

    @Override
    public Expression left() {
        return this.bin();
    }

    @Override
    public Expression right() {
        return this.charset();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        String fromCharset = ((UTF8String)input2).toString();
        return UTF8String.fromString((String)new String((byte[])input1, fromCharset));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(bytes, charset) -> new StringBuilder(215).append("\n        try {\n          ").append(ev.value()).append(" = UTF8String.fromString(new String(").append((String)bytes).append(", ").append((String)charset).append(".toString()));\n        } catch (java.io.UnsupportedEncodingException e) {\n          org.apache.spark.unsafe.Platform.throwException(e);\n        }\n      ").toString());
    }

    @Override
    public StringDecode withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public String prettyName() {
        return "decode";
    }

    public StringDecode copy(Expression bin, Expression charset) {
        return new StringDecode(bin, charset);
    }

    public Expression copy$default$1() {
        return this.bin();
    }

    public Expression copy$default$2() {
        return this.charset();
    }

    @Override
    public String productPrefix() {
        return "StringDecode";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.bin();
                break;
            }
            case 1: {
                object = this.charset();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringDecode;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "bin";
                break;
            }
            case 1: {
                string = "charset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringDecode)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringDecode stringDecode = (StringDecode)x$1;
        Expression expression = this.bin();
        Expression expression2 = stringDecode.bin();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.charset();
        Expression expression4 = stringDecode.charset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringDecode.canEqual(this)) return false;
        return true;
    }

    public StringDecode(Expression bin, Expression charset) {
        this.bin = bin;
        this.charset = charset;
        ExpectsInputTypes.$init$(this);
    }
}

