/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TruncDate$;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(date, fmt) - Returns `date` with the time portion of the day truncated to the unit specified by the format model `fmt`.\n  ", arguments="\n    Arguments:\n      * date - date value or valid date string\n      * fmt - the format representing the unit to be truncated to\n          - \"YEAR\", \"YYYY\", \"YY\" - truncate to the first date of the year that the `date` falls in\n          - \"QUARTER\" - truncate to the first date of the quarter that the `date` falls in\n          - \"MONTH\", \"MM\", \"MON\" - truncate to the first date of the month that the `date` falls in\n          - \"WEEK\" - truncate to the Monday of the week that the `date` falls in\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2019-08-04', 'week');\n       2019-07-29\n      > SELECT _FUNC_('2019-08-04', 'quarter');\n       2019-07-01\n      > SELECT _FUNC_('2009-02-12', 'MM');\n       2009-02-01\n      > SELECT _FUNC_('2015-10-27', 'YEAR');\n       2015-01-01\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011K\u0011\u00159\u0006\u0001\"\u0011K\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u001d\u0011\bA1A\u0005B)Caa\u001d\u0001!\u0002\u0013Y\u0005\"\u0002;\u0001\t\u0003*\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002\u001e\u0001!\t&a\b\t\u0013\u0005%\u0002!!A\u0005\u0002\u0005-\u0002\"CA\u0019\u0001E\u0005I\u0011AA\u001a\u0011%\tI\u0005AI\u0001\n\u0003\t\u0019\u0004C\u0005\u0002L\u0001\t\t\u0011\"\u0011\u0002N!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011q\f\u0005\n\u0003O\u0002\u0011\u0011!C\u0001\u0003SB\u0011\"a\u001c\u0001\u0003\u0003%\t%!\u001d\t\u0013\u0005}\u0004!!A\u0005\u0002\u0005\u0005\u0005\"CAF\u0001\u0005\u0005I\u0011IAG\u0011%\t\t\nAA\u0001\n\u0003\n\u0019jB\u0005\u0002>\n\n\t\u0011#\u0001\u0002@\u001aA\u0011EIA\u0001\u0012\u0003\t\t\r\u0003\u0004R7\u0011\u0005\u0011\u0011\u001c\u0005\n\u00037\\\u0012\u0011!C#\u0003;D\u0011\"a8\u001c\u0003\u0003%\t)!9\t\u0013\u0005\u001d8$!A\u0005\u0002\u0006%\b\"CA~7\u0005\u0005I\u0011BA\u007f\u0005%!&/\u001e8d\t\u0006$XM\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)c%\u0001\u0005dCR\fG._:u\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0007N\u001c>!\t\t$'D\u0001#\u0013\t\u0019$E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011'N\u0005\u0003m\t\u0012A\u0002\u0016:v]\u000eLen\u001d;b]R\u0004\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002?\r:\u0011q\b\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005:\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0005\u0015K\u0014a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!R\u001d\u0002\t\u0011\fG/Z\u000b\u0002\u0017B\u0011\u0011\u0007T\u0005\u0003\u001b\n\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015!\u0017\r^3!\u0003\u00191wN]7bi\u00069am\u001c:nCR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002T)V\u0003\"!\r\u0001\t\u000b%+\u0001\u0019A&\t\u000b=+\u0001\u0019A&\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001.\u0011\u0007yZV,\u0003\u0002]\u0011\n\u00191+Z9\u0011\u0005y\u000bW\"A0\u000b\u0005\u00014\u0013!\u0002;za\u0016\u001c\u0018B\u00012`\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005)\u0007C\u00010g\u0013\t9wL\u0001\u0005ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002UB\u00111n\u001c\b\u0003Y6\u0004\"\u0001Q\u001d\n\u00059L\u0014A\u0002)sK\u0012,g-\u0003\u0002qc\n11\u000b\u001e:j]\u001eT!A\\\u001d\u0002\u000f%t7\u000f^1oi\u0006A\u0011N\\:uC:$\b%\u0001\u0003fm\u0006dGC\u0001<z!\tAt/\u0003\u0002ys\t\u0019\u0011I\\=\t\u000fil\u0001\u0013!a\u0001w\u0006)\u0011N\u001c9viB\u0011A0`\u0007\u0002I%\u0011a\u0010\n\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR1\u00111AA\b\u00033\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0011\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u001b\t9A\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\tB\u0004a\u0001\u0003'\t1a\u0019;y!\u0011\t)!!\u0006\n\t\u0005]\u0011q\u0001\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tYB\u0004a\u0001\u0003\u0007\t!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B*\u0002\"\u0005\u0015\u0002BBA\u0012\u001f\u0001\u00071*A\u0004oK^dUM\u001a;\t\r\u0005\u001dr\u00021\u0001L\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$RaUA\u0017\u0003_Aq!\u0013\t\u0011\u0002\u0003\u00071\nC\u0004P!A\u0005\t\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0007\u0016\u0004\u0017\u0006]2FAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r\u0013(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0012\u0002>\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0014\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005!A.\u00198h\u0015\t\tI&\u0001\u0003kCZ\f\u0017b\u00019\u0002T\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\r\t\u0004q\u0005\r\u0014bAA3s\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a/a\u001b\t\u0013\u00055T#!AA\u0002\u0005\u0005\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002tA)\u0011QOA>m6\u0011\u0011q\u000f\u0006\u0004\u0003sJ\u0014AC2pY2,7\r^5p]&!\u0011QPA<\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r\u0015\u0011\u0012\t\u0004q\u0005\u0015\u0015bAADs\t9!i\\8mK\u0006t\u0007\u0002CA7/\u0005\u0005\t\u0019\u0001<\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u001f\ny\tC\u0005\u0002na\t\t\u00111\u0001\u0002b\u00051Q-];bYN$B!a!\u0002\u0016\"A\u0011QN\r\u0002\u0002\u0003\u0007a\u000fK\f\u0001\u00033\u000by*!)\u0002&\u0006\u001d\u00161VAW\u0003c\u000b\u0019,a.\u0002:B\u0019\u0011'a'\n\u0007\u0005u%EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\r\u0016!!\u0004\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006Z1uK2\u0002c-\u001c;*A5\u0002#+\u001a;ve:\u001c\b\u0005\u00193bi\u0016\u0004\u0007e^5uQ\u0002\"\b.\u001a\u0011uS6,\u0007\u0005]8si&|g\u000eI8gAQDW\r\t3bs\u0002\"(/\u001e8dCR,G\r\t;pAQDW\rI;oSR\u00043\u000f]3dS\u001aLW\r\u001a\u0011cs\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0011n_\u0012,G\u000e\t1g[R\u0004gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002*\u0006\u0019iO\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!I\u0006$X\rI\u0017!I\u0006$X\r\t<bYV,\u0007e\u001c:!m\u0006d\u0017\u000e\u001a\u0011eCR,\u0007e\u001d;sS:<'\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005\u001e5fA\u0019|'/\\1uAI,\u0007O]3tK:$\u0018N\\4!i\",\u0007%\u001e8ji\u0002\"x\u000e\t2fAQ\u0014XO\\2bi\u0016$\u0007\u0005^8\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012Z\u000b\u0006\u0013&\u0005\f\u0011#3fK\u0016L\t\u0017!EeK&\u0005I\u0017!iJ,hnY1uK\u0002\"x\u000e\t;iK\u00022\u0017N]:uA\u0011\fG/\u001a\u0011pM\u0002\"\b.\u001a\u0011zK\u0006\u0014\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011aI\u0006$X\r\u0019\u0011gC2d7\u000fI5o\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011##V\u000b%\u000bV#SE\u0001j\u0003\u0005\u001e:v]\u000e\fG/\u001a\u0011u_\u0002\"\b.\u001a\u0011gSJ\u001cH\u000f\t3bi\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013/^1si\u0016\u0014\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011aI\u0006$X\r\u0019\u0011gC2d7\u000fI5o\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b>sE\u000b\u0013\u0012-A\tjUJ\t\u0017!E5{eJ\t\u0011.AQ\u0014XO\\2bi\u0016\u0004Co\u001c\u0011uQ\u0016\u0004c-\u001b:ti\u0002\"\u0017\r^3!_\u001a\u0004C\u000f[3![>tG\u000f\u001b\u0011uQ\u0006$\b\u0005\u001e5fA\u0001$\u0017\r^3aA\u0019\fG\u000e\\:!S:T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t:V)R&#A5\u0002CO];oG\u0006$X\r\t;pAQDW\rI'p]\u0012\f\u0017\u0010I8gAQDW\rI<fK.\u0004C\u000f[1uAQDW\r\t1eCR,\u0007\r\t4bY2\u001c\b%\u001b8\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003_\u000b!Q\u0004\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014'O\u00171q5\u0002Dg\n\u0017!O],Wm[\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001d.a]j#'\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014'O\u00171q5\u0002Dg\n\u0017!OE,\u0018M\u001d;fe\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cej\u0003gN\u00171c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00191s5\u0002$'L\u00193O1\u0002s%T'(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007\r\u0019:[A\u0012T\u0006M\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'M\u001b.cAj#gN\u0014-A\u001dJV)\u0011*(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00196[A\nT\u0006M\u0019\u000bA\u0001\nQa\u001a:pkB\f#!!.\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u00111X\u0001\u0006c9*d\u0006M\u0001\n)J,hn\u0019#bi\u0016\u0004\"!M\u000e\u0014\u000bm\t\u0019-a4\u0011\u000f\u0005\u0015\u00171Z&L'6\u0011\u0011q\u0019\u0006\u0004\u0003\u0013L\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u001b\f9MA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!5\u0002X6\u0011\u00111\u001b\u0006\u0005\u0003+\f9&\u0001\u0002j_&\u0019q)a5\u0015\u0005\u0005}\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005=\u0013!B1qa2LH#B*\u0002d\u0006\u0015\b\"B%\u001f\u0001\u0004Y\u0005\"B(\u001f\u0001\u0004Y\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003W\f9\u0010E\u00039\u0003[\f\t0C\u0002\u0002pf\u0012aa\u00149uS>t\u0007#\u0002\u001d\u0002t.[\u0015bAA{s\t1A+\u001e9mKJB\u0001\"!? \u0003\u0003\u0005\raU\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA\u0000!\u0011\t\tF!\u0001\n\t\t\r\u00111\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class TruncDate
extends BinaryExpression
implements TruncInstant,
Serializable {
    private final Expression date;
    private final Expression format;
    private final Expression instant;
    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(TruncDate x$0) {
        return TruncDate$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, TruncDate> tupled() {
        return TruncDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TruncDate>> curried() {
        return TruncDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return TruncInstant.nullable$(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int minLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant.evalHelper$(this, input, minLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int minLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant.codeGenHelper$(this, ctx, ev, minLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant.codeGenHelper$default$4$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncDate truncDate = this;
        synchronized (truncDate) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    public Expression date() {
        return this.date;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    @Override
    public Expression left() {
        return this.date();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_DATE_TRUNC(), (Function2<Object, Object, Object>)(Function2 & Serializable)(d, level) -> BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.truncDate(BoxesRunTime.unboxToInt((Object)d), BoxesRunTime.unboxToInt((Object)level))));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_DATE_TRUNC(), this.codeGenHelper$default$4(), (Function2<String, String, String>)(Function2 & Serializable)(date, fmt) -> new StringBuilder(14).append("truncDate(").append((String)date).append(", ").append((String)fmt).append(");").toString());
    }

    @Override
    public TruncDate withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public TruncDate copy(Expression date, Expression format) {
        return new TruncDate(date, format);
    }

    public Expression copy$default$1() {
        return this.date();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    @Override
    public String productPrefix() {
        return "TruncDate";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.date();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncDate;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "date";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncDate truncDate = (TruncDate)x$1;
        Expression expression = this.date();
        Expression expression2 = truncDate.date();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = truncDate.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!truncDate.canEqual(this)) return false;
        return true;
    }

    public TruncDate(Expression date, Expression format) {
        this.date = date;
        this.format = format;
        ExpectsInputTypes.$init$(this);
        TruncInstant.$init$(this);
        this.instant = date;
    }
}

