/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the trailing space characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u00055x!B\u0012%\u0011\u0003\td!B\u001a%\u0011\u0003!\u0004\"B\"\u0002\t\u0003!\u0005\"B#\u0002\t\u00031\u0005BB#\u0002\t\u0003\t)\r\u0003\u0005F\u0003\u0005\u0005I\u0011QAe\u0011%\ty-AI\u0001\n\u0003\t9\u0005C\u0005\u0002R\u0006\t\t\u0011\"!\u0002T\"I\u0011\u0011]\u0001\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003G\f\u0011\u0011!C\u0005\u0003K4Aa\r\u0013A\u0011\"AQL\u0003BK\u0002\u0013\u0005a\f\u0003\u0005`\u0015\tE\t\u0015!\u0003J\u0011!\u0001'B!f\u0001\n\u0003\t\u0007\u0002C3\u000b\u0005#\u0005\u000b\u0011\u00022\t\u000b\rSA\u0011\u00014\t\u000b\rSA\u0011A5\t\u000b\rSA\u0011\u00017\t\u000b9TA\u0011I8\t\u000baTA\u0011K8\t\u000beTA\u0011\t>\t\reTA\u0011IA\u0006\u0011!\t\u0019B\u0003b\u0001\n\u0003z\u0007bBA\u000b\u0015\u0001\u0006I\u0001\u001d\u0005\b\u0003/QA\u0011KA\r\u0011%\t)CCA\u0001\n\u0003\t9\u0003C\u0005\u0002.)\t\n\u0011\"\u0001\u00020!I\u0011Q\t\u0006\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003\u0017R\u0011\u0011!C!\u0003\u001bB\u0011\"!\u0017\u000b\u0003\u0003%\t!a\u0017\t\u0013\u0005\r$\"!A\u0005\u0002\u0005\u0015\u0004\"CA9\u0015\u0005\u0005I\u0011IA:\u0011%\t\tICA\u0001\n\u0003\t\u0019\tC\u0005\u0002\u000e*\t\t\u0011\"\u0011\u0002\u0010\"I\u00111\u0013\u0006\u0002\u0002\u0013\u0005\u0013QS\u0001\u0010'R\u0014\u0018N\\4Ue&l'+[4ii*\u0011QEJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(Q\u0005A1-\u0019;bYf\u001cHO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001\u0001\u0005\u00023\u00035\tAEA\bTiJLgn\u001a+sS6\u0014\u0016n\u001a5u'\r\tQg\u000f\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014AA5p\u0015\u0005\u0001\u0015\u0001\u00026bm\u0006L!AQ\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005\t\u0014!B1qa2LH#B$\u0002@\u0006\r\u0007C\u0001\u001a\u000b'\u0015Q\u0011\nT(S!\t\u0011$*\u0003\u0002LI\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005Ij\u0015B\u0001(%\u0005U\u0019FO]5oOJ\"&/[7FqB\u0014Xm]:j_:\u0004\"A\u000e)\n\u0005E;$a\u0002)s_\u0012,8\r\u001e\t\u0003'ns!\u0001V-\u000f\u0005UCV\"\u0001,\u000b\u0005]\u0003\u0014A\u0002\u001fs_>$h(C\u00019\u0013\tQv'A\u0004qC\u000e\\\u0017mZ3\n\u0005\tc&B\u0001.8\u0003\u0019\u0019(oY*ueV\t\u0011*A\u0004te\u000e\u001cFO\u001d\u0011\u0002\u000fQ\u0014\u0018.\\*ueV\t!\rE\u00027G&K!\u0001Z\u001c\u0003\r=\u0003H/[8o\u0003!!(/[7TiJ\u0004CcA$hQ\")Ql\u0004a\u0001\u0013\"9\u0001m\u0004I\u0001\u0002\u0004\u0011GcA$kW\")\u0001\r\u0005a\u0001\u0013\")Q\f\u0005a\u0001\u0013R\u0011q)\u001c\u0005\u0006;F\u0001\r!S\u0001\u000baJ,G\u000f^=OC6,W#\u00019\u0011\u0005E,hB\u0001:t!\t)v'\u0003\u0002uo\u00051\u0001K]3eK\u001aL!A^<\u0003\rM#(/\u001b8h\u0015\t!x'A\u0005eSJ,7\r^5p]\u00061Am\\#wC2$2a_A\u0004!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0006if\u0004Xm\u001d\u0006\u0004\u0003\u0003Q\u0013AB;og\u00064W-C\u0002\u0002\u0006u\u0014!\"\u0016+GqM#(/\u001b8h\u0011\u0019\tI\u0001\u0006a\u0001w\u0006I1O]2TiJLgn\u001a\u000b\u0006w\u00065\u0011q\u0002\u0005\u0007\u0003\u0013)\u0002\u0019A>\t\r\u0005EQ\u00031\u0001|\u0003)!(/[7TiJLgnZ\u0001\u000biJLW.T3uQ>$\u0017a\u0003;sS6lU\r\u001e5pI\u0002\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007\u001d\u000bY\u0002C\u0004\u0002\u001ea\u0001\r!a\b\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0005'\u0006\u0005\u0012*C\u0002\u0002$q\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u000b\u001d\u000bI#a\u000b\t\u000fuK\u0002\u0013!a\u0001\u0013\"9\u0001-\u0007I\u0001\u0002\u0004\u0011\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003cQ3!SA\u001aW\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0013Ut7\r[3dW\u0016$'bAA o\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0013\u0011\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0013R3AYA\u001a\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\n\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011QK \u0002\t1\fgnZ\u0005\u0004m\u0006M\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA/!\r1\u0014qL\u0005\u0004\u0003C:$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA4\u0003[\u00022ANA5\u0013\r\tYg\u000e\u0002\u0004\u0003:L\b\"CA8=\u0005\u0005\t\u0019AA/\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000f\t\u0007\u0003o\ni(a\u001a\u000e\u0005\u0005e$bAA>o\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0014\u0011\u0010\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0006\u0006-\u0005c\u0001\u001c\u0002\b&\u0019\u0011\u0011R\u001c\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u000e\u0011\u0002\u0002\u0003\u0007\u0011qM\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002P\u0005E\u0005\"CA8C\u0005\u0005\t\u0019AA/\u0003\u0019)\u0017/^1mgR!\u0011QQAL\u0011%\tyGIA\u0001\u0002\u0004\t9\u0007K\f\u000b\u00037\u000b\t+a)\u0002(\u0006%\u0016QVAX\u0003g\u000b),!/\u0002<B\u0019!'!(\n\u0007\u0005}EEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0015\u0016a\u0012\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:*A5\u0002#+Z7pm\u0016\u001c\b\u0005\u001e5fAQ\u0014\u0018-\u001b7j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAV\u0003\u0005u!\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t'\u0002\t\u0011!A\u0001\u0002#\u0006\t;sS6\u001cFO\u001d\u0011.AQDW\r\t;sS6\u00043\u000f\u001e:j]\u001e\u00043\r[1sC\u000e$XM]:!i>\u0004CO]5nY\u0001\"\b.\u001a\u0011eK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u0011jg\u0002\n\u0007e]5oO2,\u0007e\u001d9bG\u0016T\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011W\u0001L\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0003\u0005\t\u0011!'B\f'o[*R\u0019\u0002\u0002\u0003eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6T#2S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003o\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!!0\u0002\u0019M$(/\u001b8h?\u001a,hnY:\t\r\u0005\u00057\u00011\u0001J\u0003\r\u0019HO\u001d\u0005\u0006A\u000e\u0001\r!\u0013\u000b\u0004\u000f\u0006\u001d\u0007BBAa\t\u0001\u0007\u0011\nF\u0003H\u0003\u0017\fi\rC\u0003^\u000b\u0001\u0007\u0011\nC\u0004a\u000bA\u0005\t\u0019\u00012\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002V\u0006u\u0007\u0003\u0002\u001cd\u0003/\u0004RANAm\u0013\nL1!a78\u0005\u0019!V\u000f\u001d7fe!A\u0011q\\\u0004\u0002\u0002\u0003\u0007q)A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAt!\u0011\t\t&!;\n\t\u0005-\u00181\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class StringTrimRight
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private final String trimMethod;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimRight$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimRight x$0) {
        return StringTrimRight$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimRight$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "rtrim";
    }

    @Override
    public String direction() {
        return "TRAILING";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return srcString.trimRight();
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return srcString.trimRight(trimString);
    }

    @Override
    public String trimMethod() {
        return this.trimMethod;
    }

    @Override
    public StringTrimRight withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrimRight copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimRight(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimRight";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.srcStr();
                break;
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimRight;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "srcStr";
                break;
            }
            case 1: {
                string = "trimStr";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimRight)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimRight stringTrimRight = (StringTrimRight)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimRight.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimRight.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimRight.canEqual(this)) return false;
        return true;
    }

    public StringTrimRight(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
        this.trimMethod = "trimRight";
    }

    public StringTrimRight(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimRight(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

