/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.CallMethodViaReflection$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(class, method[, arg1[, arg2 ..]]) - Calls a method with reflection.", examples="\n    Examples:\n      > SELECT _FUNC_('java.util.UUID', 'randomUUID');\n       c33fb387-8500-4bfa-81d2-6e0e3e930df2\n      > SELECT _FUNC_('java.util.UUID', 'fromString', 'a5cf6c42-0c85-418f-af6c-3e4e5b1328f2');\n       a5cf6c42-0c85-418f-af6c-3e4e5b1328f2\n  ", since="2.0.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5d\u0001B\u0013'\u0001NB\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\t=\u0002\u0011\t\u0012)A\u00057\")q\f\u0001C\u0001A\")1\r\u0001C!I\")Q\u000e\u0001C!]\")Q\u000f\u0001C!m\"9!\u0010\u0001b\u0001\n\u0003Z\bbBA\u0003\u0001\u0001\u0006I\u0001 \u0005\b\u0003\u000f\u0001A\u0011KA\u0005\u0011\u001d\tY\u0002\u0001C)\u0003;A!\"!\r\u0001\u0011\u000b\u0007I\u0011BA\u001a\u0011)\t\u0019\u0005\u0001EC\u0002\u0013%\u0011Q\t\u0005\n\u0003/\u0002\u0001R1A\u0005\nYD!\"a\u0017\u0001\u0011\u000b\u0007I\u0011BA#\u0011)\ty\u0006\u0001EC\u0002\u0013\u0005\u0011\u0011\r\u0005\u000b\u0003c\u0002\u0001R1A\u0005\n\u0005M\u0004bBA@\u0001\u0011E\u0013\u0011\u0011\u0005\n\u0003\u001b\u0003\u0011\u0011!C\u0001\u0003\u001fC\u0011\"a%\u0001#\u0003%\t!!&\t\u0013\u0005-\u0006!!A\u0005B\u0005\u0015\u0003\"CAW\u0001\u0005\u0005I\u0011AAX\u0011%\t\t\fAA\u0001\n\u0003\t\u0019\fC\u0005\u0002:\u0002\t\t\u0011\"\u0011\u0002<\"I\u0011\u0011\u001a\u0001\u0002\u0002\u0013\u0005\u00111\u001a\u0005\n\u0003\u001f\u0004\u0011\u0011!C!\u0003#D\u0011\"!6\u0001\u0003\u0003%\t%a6\b\u000f\u0005mh\u0005#\u0001\u0002~\u001a1QE\nE\u0001\u0003\u007fDaa\u0018\u000f\u0005\u0002\tE\u0001\"\u0003B\n9\t\u0007I\u0011\u0001B\u000b\u0011!\u00119\u0004\bQ\u0001\n\t]\u0001bBA,9\u0011%!\u0011\t\u0005\b\u0005\u000bbB\u0011\u0001B$\u0011%\u0011I\u0006HA\u0001\n\u0003\u0013Y\u0006C\u0005\u0003`q\t\t\u0011\"!\u0003b!I!\u0011\u000e\u000f\u0002\u0002\u0013%!1\u000e\u0002\u0018\u0007\u0006dG.T3uQ>$g+[1SK\u001adWm\u0019;j_:T!a\n\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003S)\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003W1\n1a]9m\u0015\tic&A\u0003ta\u0006\u00148N\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\b\u0001QB4(Q$N!\t)d'D\u0001'\u0013\t9dE\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!N\u001d\n\u0005i2#\u0001\u0005(p]\u0012,G/\u001a:nS:L7\u000f^5d!\tat(D\u0001>\u0015\tqd%A\u0004d_\u0012,w-\u001a8\n\u0005\u0001k$aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005\t+U\"A\"\u000b\u0005\u0011S\u0013AB3se>\u00148/\u0003\u0002G\u0007\ny\u0011+^3ss\u0016\u0013(o\u001c:t\u0005\u0006\u001cX\r\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0004Qe>$Wo\u0019;\u0011\u000593fBA(U\u001d\t\u00016+D\u0001R\u0015\t\u0011&'\u0001\u0004=e>|GOP\u0005\u0002\u0015&\u0011Q+S\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006L\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002V\u0013\u0006A1\r[5mIJ,g.F\u0001\\!\rqE\fN\u0005\u0003;b\u00131aU3r\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003C\n\u0004\"!\u000e\u0001\t\u000be\u001b\u0001\u0019A.\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001f!\t1'N\u0004\u0002hQB\u0011\u0001+S\u0005\u0003S&\u000ba\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011.S\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002_B\u0011\u0001o]\u0007\u0002c*\u0011!\u000fK\u0001\tC:\fG._:jg&\u0011A/\u001d\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006Aa.\u001e7mC\ndW-F\u0001x!\tA\u00050\u0003\u0002z\u0013\n9!i\\8mK\u0006t\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003q\u00042!`A\u0001\u001b\u0005q(BA@+\u0003\u0015!\u0018\u0010]3t\u0013\r\t\u0019A \u0002\t\t\u0006$\u0018\rV=qK\u0006IA-\u0019;b)f\u0004X\rI\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002\f\u0005E\u0001c\u0001%\u0002\u000e%\u0019\u0011qB%\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003'I\u0001\u0019AA\u000b\u00039\u0001\u0018M\u001d;ji&|g.\u00138eKb\u00042\u0001SA\f\u0013\r\tI\"\u0013\u0002\u0004\u0013:$\u0018\u0001D3wC2Le\u000e^3s]\u0006dG\u0003BA\u0010\u0003K\u00012\u0001SA\u0011\u0013\r\t\u0019#\u0013\u0002\u0004\u0003:L\bbBA\u0014\u0015\u0001\u0007\u0011\u0011F\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003W\ti#D\u0001)\u0013\r\ty\u0003\u000b\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0005be\u001e,\u0005\u0010\u001d:t+\t\t)\u0004\u0005\u0003I\u0003o!\u0014bAA\u001d\u0013\n)\u0011I\u001d:bs\"\u001a1\"!\u0010\u0011\u0007!\u000by$C\u0002\u0002B%\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0013\rd\u0017m]:OC6,WCAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nA\u0001\\1oO*\u0011\u0011\u0011K\u0001\u0005U\u00064\u0018-C\u0002l\u0003\u0017B3\u0001DA\u001f\u0003-\u0019G.Y:t\u000bbL7\u000f^:)\u00075\ti$\u0001\u0006nKRDw\u000e\u001a(b[\u0016D3ADA\u001f\u0003\u0019iW\r\u001e5pIV\u0011\u00111\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)!\u0011\u0011NA&\u0003\u001d\u0011XM\u001a7fGRLA!!\u001c\u0002h\t1Q*\u001a;i_\u0012D3aDA\u001f\u0003\u0019\u0011WO\u001a4feV\u0011\u0011Q\u000f\t\u0006\u0011\u0006]\u0012q\u000f\t\u0005\u0003\u0013\nI(\u0003\u0003\u0002|\u0005-#AB(cU\u0016\u001cG\u000fK\u0002\u0011\u0003{\tqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007\u0005\f\u0019\tC\u0004\u0002\u0006F\u0001\r!a\"\u0002\u00179,wo\u00115jY\u0012\u0014XM\u001c\t\u0005\u001d\u0006%E'C\u0002\u0002\fb\u0013!\"\u00138eKb,GmU3r\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0005\f\t\nC\u0004Z%A\u0005\t\u0019A.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0013\u0016\u00047\u0006e5FAAN!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0016*\u0001\u0006b]:|G/\u0019;j_:LA!!+\u0002 \n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\"\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0011Q\u0017\u0005\n\u0003o3\u0012\u0011!a\u0001\u0003+\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA_!\u0019\ty,!2\u0002 5\u0011\u0011\u0011\u0019\u0006\u0004\u0003\u0007L\u0015AC2pY2,7\r^5p]&!\u0011qYAa\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007]\fi\rC\u0005\u00028b\t\t\u00111\u0001\u0002 \u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9%a5\t\u0013\u0005]\u0016$!AA\u0002\u0005U\u0011AB3rk\u0006d7\u000fF\u0002x\u00033D\u0011\"a.\u001b\u0003\u0003\u0005\r!a\b)'\u0001\ti.a9\u0002f\u0006%\u00181^Ax\u0003c\f)0a>\u0011\u0007U\ny.C\u0002\u0002b\u001a\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002h\u0006QuLR+O\u0007~C3\r\\1tg2\u0002S.\u001a;i_\u0012\\F\u0006I1sOFZF\u0006I1sOJ\u0002cFL/^S\u0001j\u0003eQ1mYN\u0004\u0013\rI7fi\"|G\rI<ji\"\u0004#/\u001a4mK\u000e$\u0018n\u001c8/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAw\u0003\u0005}(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014kCZ\fg&\u001e;jY:*V+\u0013#(Y\u0001:#/\u00198e_6,V+\u0013#(SmR\u0001\u0005\t\u0011!A\u0001\u00023mM\u001agENBt'\f\u001d6aAjCG\u00194b[a\nDMM\u00177KB*7'Z\u001d4a\u00114'G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(U\u00064\u0018ML;uS2tS+V%EO1\u0002sE\u001a:p[N#(/\u001b8hO1\u0002s%Y\u001bdMZ\u001aGGM\u00171Gb*T\u0006N\u00199M6\ngMN2.g\u0015$T-\u000e22gIBdMM\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\nWg\u001947GR\u0012T\u0006M29k5\"\u0014\u0007\u000f4.C\u001a44-L\u001afi\u0015,$-M\u001a3q\u0019\u0014$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005M\u0018!\u0002\u001a/a9\u0002\u0014!B4s_V\u0004\u0018EAA}\u0003)i\u0017n]2`MVt7m]\u0001\u0018\u0007\u0006dG.T3uQ>$g+[1SK\u001adWm\u0019;j_:\u0004\"!\u000e\u000f\u0014\u000bq\u0011\tAa\u0002\u0011\u0007!\u0013\u0019!C\u0002\u0003\u0006%\u0013a!\u00118z%\u00164\u0007\u0003\u0002B\u0005\u0005\u001fi!Aa\u0003\u000b\t\t5\u0011qJ\u0001\u0003S>L1a\u0016B\u0006)\t\ti0A\u0006usB,W*\u00199qS:<WC\u0001B\f!\u001d\u0011IBa\b}\u0005Gi!Aa\u0007\u000b\t\tu\u0011\u0011Y\u0001\nS6lW\u000f^1cY\u0016LAA!\t\u0003\u001c\t\u0019Q*\u00199\u0011\r\te!Q\u0005B\u0014\u0013\ri&1\u0004\u0019\u0005\u0005S\u0011\u0019\u0004\u0005\u0004\u0002J\t-\"qF\u0005\u0005\u0005[\tYEA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u00032\tMB\u0002\u0001\u0003\f\u0005ky\u0012\u0011!A\u0001\u0006\u0003\u0011IDA\u0002`IE\nA\u0002^=qK6\u000b\u0007\u000f]5oO\u0002\nBAa\u000f\u0002 A\u0019\u0001J!\u0010\n\u0007\t}\u0012JA\u0004O_RD\u0017N\\4\u0015\u0007]\u0014\u0019\u0005\u0003\u0004\u0002D\u0001\u0002\r!Z\u0001\u000bM&tG-T3uQ>$G\u0003\u0003B%\u0005\u001f\u0012\tFa\u0015\u0011\u000b!\u0013Y%a\u0019\n\u0007\t5\u0013J\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003\u0007\n\u0003\u0019A3\t\r\u0005m\u0013\u00051\u0001f\u0011\u001d\u0011)&\ta\u0001\u0005/\n\u0001\"\u0019:h)f\u0004Xm\u001d\t\u0004\u001drc\u0018!B1qa2LHcA1\u0003^!)\u0011L\ta\u00017\u00069QO\\1qa2LH\u0003\u0002B2\u0005K\u0002B\u0001\u0013B&7\"A!qM\u0012\u0002\u0002\u0003\u0007\u0011-A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a\u001e")
public class CallMethodViaReflection
extends Expression
implements Nondeterministic,
CodegenFallback,
QueryErrorsBase,
Serializable {
    private transient Expression[] argExprs;
    private transient String className;
    private transient boolean classExists;
    private transient String methodName;
    private transient Method method;
    private transient Object[] buffer;
    private final Seq<Expression> children;
    private final DataType dataType;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Seq<Expression>> unapply(CallMethodViaReflection x$0) {
        return CallMethodViaReflection$.MODULE$.unapply(x$0);
    }

    public static Option<Method> findMethod(String className, String methodName, Seq<DataType> argTypes) {
        return CallMethodViaReflection$.MODULE$.findMethod(className, methodName, argTypes);
    }

    public static Map<DataType, Seq<Class<?>>> typeMapping() {
        return CallMethodViaReflection$.MODULE$.typeMapping();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return !this.bitmap$0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "reflect");
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (this.children().size() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(this.toSQLId(this.prettyName()), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"> 1"}))), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Option unexpectedParameter = ((IterableOnceOps)this.children().zipWithIndex()).collectFirst((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CallMethodViaReflection $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Expression, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (0 == n) {
                        DataType dataType = e.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !e.foldable()) {
                            object = new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"class"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.$outer.toSQLExpr((Expression)this.$outer.children().head()))}))));
                            return (B1)object;
                        }
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (0 == n && e.eval(e.eval$default$1()) == null) {
                        object = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.$outer.toSQLId("class"))}))));
                        return (B1)object;
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (1 == n) {
                        DataType dataType = e.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !e.foldable()) {
                            object = new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"method"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.$outer.toSQLExpr((Expression)this.$outer.children().apply(1)))}))));
                            return (B1)object;
                        }
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (1 == n && e.eval(e.eval$default$1()) == null) {
                        object = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.$outer.toSQLId("method"))}))));
                        return (B1)object;
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int idx = A1._2$mcI$sp();
                    if (idx > 1 && !CallMethodViaReflection$.MODULE$.typeMapping().contains((Object)e.dataType())) {
                        object = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Integer.toString(idx + 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.$outer.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringType$.MODULE$})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.$outer.toSQLExpr(e)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)e.dataType()))}))));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Expression, Object> x1) {
                Tuple2<Expression, Object> tuple2 = x1;
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (0 == n) {
                        DataType dataType = e.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if (dataType == null) {
                            if (stringType$ != null) {
                                return true;
                            }
                        } else if (!dataType.equals(stringType$)) return true;
                        if (!e.foldable()) {
                            return true;
                        }
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (0 == n && e.eval(e.eval$default$1()) == null) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (1 == n) {
                        DataType dataType = e.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if (dataType == null) {
                            if (stringType$ != null) {
                                return true;
                            }
                        } else if (!dataType.equals(stringType$)) return true;
                        if (!e.foldable()) {
                            return true;
                        }
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (1 == n && e.eval(e.eval$default$1()) == null) {
                        return true;
                    }
                }
                if (tuple2 == null) return false;
                Expression e = (Expression)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (idx <= 1) return false;
                if (CallMethodViaReflection$.MODULE$.typeMapping().contains((Object)e.dataType())) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Option option = unexpectedParameter;
        if (option instanceof Some) {
            TypeCheckResult.DataTypeMismatch mismatch;
            Some some = (Some)option;
            typeCheckResult = mismatch = (TypeCheckResult.DataTypeMismatch)some.value();
        } else {
            typeCheckResult = !this.classExists() ? new TypeCheckResult.DataTypeMismatch("UNEXPECTED_CLASS_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)this.className())})))) : (this.method() == null ? new TypeCheckResult.DataTypeMismatch("UNEXPECTED_STATIC_METHOD", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"methodName"), (Object)this.methodName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)this.className())})))) : TypeCheckResult$TypeCheckSuccess$.MODULE$);
        }
        return typeCheckResult;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
    }

    @Override
    public Object evalInternal(InternalRow input) {
        for (int i = 0; i < this.argExprs().length; ++i) {
            this.buffer()[i] = this.argExprs()[i].eval(input);
            if (!(this.buffer()[i] instanceof UTF8String)) continue;
            this.buffer()[i] = this.buffer()[i].toString();
        }
        Object ret = this.method().invoke(null, this.buffer());
        return UTF8String.fromString((String)String.valueOf(ret));
    }

    private Expression[] argExprs$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.argExprs = (Expression[])((IterableOnceOps)this.children().drop(2)).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.argExprs;
    }

    private Expression[] argExprs() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.argExprs$lzycompute() : this.argExprs;
    }

    private String className$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Expression qual$1 = (Expression)this.children().apply(0);
                InternalRow x$1 = qual$1.eval$default$1();
                this.className = ((UTF8String)qual$1.eval(x$1)).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.className;
    }

    private String className() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.className$lzycompute() : this.className;
    }

    private boolean classExists$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.classExists = CallMethodViaReflection$.MODULE$.org$apache$spark$sql$catalyst$expressions$CallMethodViaReflection$$classExists(this.className());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.classExists;
    }

    private boolean classExists() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.classExists$lzycompute() : this.classExists;
    }

    private String methodName$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.methodName = ((UTF8String)((Expression)this.children().apply(1)).eval(null)).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.methodName;
    }

    private String methodName() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.methodName$lzycompute() : this.methodName;
    }

    private Method method$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.method = (Method)CallMethodViaReflection$.MODULE$.findMethod(this.className(), this.methodName(), (Seq<DataType>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.argExprs()), (Function1 & Serializable)x$1 -> x$1.dataType(), ClassTag$.MODULE$.apply(DataType.class)))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.method;
    }

    public Method method() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.method$lzycompute() : this.method;
    }

    private Object[] buffer$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                this.buffer = new Object[this.argExprs().length];
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.buffer;
    }

    private Object[] buffer() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.buffer$lzycompute() : this.buffer;
    }

    @Override
    public CallMethodViaReflection withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public CallMethodViaReflection copy(Seq<Expression> children2) {
        return new CallMethodViaReflection(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "CallMethodViaReflection";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CallMethodViaReflection;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CallMethodViaReflection)) return false;
        boolean bl = true;
        if (!bl) return false;
        CallMethodViaReflection callMethodViaReflection = (CallMethodViaReflection)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = callMethodViaReflection.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!callMethodViaReflection.canEqual(this)) return false;
        return true;
    }

    public CallMethodViaReflection(Seq<Expression> children2) {
        this.children = children2;
        Nondeterministic.$init$(this);
        CodegenFallback.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.dataType = StringType$.MODULE$;
    }
}

