/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

@DeveloperApi
public final class ColumnarBatchRow
extends InternalRow {
    public int rowId;
    private final ColumnVector[] columns;

    public ColumnarBatchRow(ColumnVector[] columns) {
        this.columns = columns;
    }

    @Override
    public int numFields() {
        return this.columns.length;
    }

    @Override
    public InternalRow copy() {
        GenericInternalRow row = new GenericInternalRow(this.columns.length);
        for (int i = 0; i < this.numFields(); ++i) {
            if (this.isNullAt(i)) {
                row.setNullAt(i);
                continue;
            }
            DataType dt = this.columns[i].dataType();
            if (dt instanceof BooleanType) {
                row.setBoolean(i, this.getBoolean(i));
                continue;
            }
            if (dt instanceof ByteType) {
                row.setByte(i, this.getByte(i));
                continue;
            }
            if (dt instanceof ShortType) {
                row.setShort(i, this.getShort(i));
                continue;
            }
            if (dt instanceof IntegerType || dt instanceof YearMonthIntervalType) {
                row.setInt(i, this.getInt(i));
                continue;
            }
            if (dt instanceof LongType || dt instanceof DayTimeIntervalType) {
                row.setLong(i, this.getLong(i));
                continue;
            }
            if (dt instanceof FloatType) {
                row.setFloat(i, this.getFloat(i));
                continue;
            }
            if (dt instanceof DoubleType) {
                row.setDouble(i, this.getDouble(i));
                continue;
            }
            if (dt instanceof StringType) {
                row.update(i, this.getUTF8String(i).copy());
                continue;
            }
            if (dt instanceof BinaryType) {
                row.update(i, this.getBinary(i));
                continue;
            }
            if (dt instanceof DecimalType) {
                DecimalType t = (DecimalType)dt;
                row.setDecimal(i, this.getDecimal(i, t.precision(), t.scale()), t.precision());
                continue;
            }
            if (dt instanceof DateType) {
                row.setInt(i, this.getInt(i));
                continue;
            }
            if (dt instanceof TimestampType) {
                row.setLong(i, this.getLong(i));
                continue;
            }
            if (dt instanceof StructType) {
                row.update(i, this.getStruct(i, ((StructType)dt).fields().length).copy());
                continue;
            }
            if (dt instanceof ArrayType) {
                row.update(i, this.getArray(i).copy());
                continue;
            }
            if (dt instanceof MapType) {
                row.update(i, this.getMap(i).copy());
                continue;
            }
            throw new RuntimeException("Not implemented. " + dt);
        }
        return row;
    }

    @Override
    public boolean anyNull() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.columns[ordinal].isNullAt(this.rowId);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return this.columns[ordinal].getBoolean(this.rowId);
    }

    @Override
    public byte getByte(int ordinal) {
        return this.columns[ordinal].getByte(this.rowId);
    }

    @Override
    public short getShort(int ordinal) {
        return this.columns[ordinal].getShort(this.rowId);
    }

    @Override
    public int getInt(int ordinal) {
        return this.columns[ordinal].getInt(this.rowId);
    }

    @Override
    public long getLong(int ordinal) {
        return this.columns[ordinal].getLong(this.rowId);
    }

    @Override
    public float getFloat(int ordinal) {
        return this.columns[ordinal].getFloat(this.rowId);
    }

    @Override
    public double getDouble(int ordinal) {
        return this.columns[ordinal].getDouble(this.rowId);
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.columns[ordinal].getDecimal(this.rowId, precision, scale);
    }

    @Override
    public UTF8String getUTF8String(int ordinal) {
        return this.columns[ordinal].getUTF8String(this.rowId);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        return this.columns[ordinal].getBinary(this.rowId);
    }

    @Override
    public CalendarInterval getInterval(int ordinal) {
        return this.columns[ordinal].getInterval(this.rowId);
    }

    @Override
    public ColumnarRow getStruct(int ordinal, int numFields) {
        return this.columns[ordinal].getStruct(this.rowId);
    }

    @Override
    public ColumnarArray getArray(int ordinal) {
        return this.columns[ordinal].getArray(this.rowId);
    }

    @Override
    public ColumnarMap getMap(int ordinal) {
        return this.columns[ordinal].getMap(this.rowId);
    }

    @Override
    public Object get(int ordinal, DataType dataType) {
        if (dataType instanceof BooleanType) {
            return this.getBoolean(ordinal);
        }
        if (dataType instanceof ByteType) {
            return this.getByte(ordinal);
        }
        if (dataType instanceof ShortType) {
            return this.getShort(ordinal);
        }
        if (dataType instanceof IntegerType || dataType instanceof YearMonthIntervalType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof LongType || dataType instanceof DayTimeIntervalType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(this.getFloat(ordinal));
        }
        if (dataType instanceof DoubleType) {
            return this.getDouble(ordinal);
        }
        if (dataType instanceof StringType) {
            return this.getUTF8String(ordinal);
        }
        if (dataType instanceof BinaryType) {
            return this.getBinary(ordinal);
        }
        if (dataType instanceof DecimalType) {
            DecimalType t = (DecimalType)dataType;
            return this.getDecimal(ordinal, t.precision(), t.scale());
        }
        if (dataType instanceof DateType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof TimestampType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof ArrayType) {
            return this.getArray(ordinal);
        }
        if (dataType instanceof StructType) {
            return this.getStruct(ordinal, ((StructType)dataType).fields().length);
        }
        if (dataType instanceof MapType) {
            return this.getMap(ordinal);
        }
        throw new UnsupportedOperationException("Datatype not supported " + dataType);
    }

    @Override
    public void update(int ordinal, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNullAt(int ordinal) {
        throw new UnsupportedOperationException();
    }
}

