/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToJson$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a JSON string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       {\"a\":1,\"b\":2}\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"26/08/2015\"}\n      > SELECT _FUNC_(array(named_struct('a', 1, 'b', 2)));\n       [{\"a\":1,\"b\":2}]\n      > SELECT _FUNC_(map('a', named_struct('b', 1)));\n       {\"a\":{\"b\":1}}\n      > SELECT _FUNC_(map(named_struct('a', 1),named_struct('b', 2)));\n       {\"[1]\":{\"b\":2}}\n      > SELECT _FUNC_(map('a', 1));\n       {\"a\":1}\n      > SELECT _FUNC_(array((map('a', 1))));\n       [{\"a\":1}]\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\t=e\u0001B\u0016-\u0001fB\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\t_\u0002\u0011\t\u0012)A\u0005I\"A\u0001\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005v\u0001\tE\t\u0015!\u0003s\u0011!1\bA!f\u0001\n\u00039\b\u0002C>\u0001\u0005#\u0005\u000b\u0011\u0002=\t\u000bq\u0004A\u0011A?\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!1A\u0010\u0001C\u0001\u0003\u001fAa\u0001 \u0001\u0005\u0002\u0005U\u0001B\u0002?\u0001\t\u0003\tI\u0002\u0003\u0006\u0002 \u0001A)\u0019!C\u0001\u0003CA!\"a\u000f\u0001\u0011\u000b\u0007I\u0011AA\u001f\u0011)\ti\u0005\u0001EC\u0002\u0013\u0005\u0011q\n\u0005\u000b\u0003?\u0002\u0001R1A\u0005\u0002\u0005\u0005\u0004bBA@\u0001\u0011\u0005\u0013q\n\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\t\t\n\u0001C!\u0003'Cq!a&\u0001\t\u0003\nI\nC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u00111\u0017\u0001\u0005R\u0005U\u0006\"CA^\u0001\u0005\u0005I\u0011AA_\u0011%\t)\rAI\u0001\n\u0003\t9\rC\u0005\u0002^\u0002\t\n\u0011\"\u0001\u0002`\"I\u00111\u001d\u0001\u0012\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003S\u0004\u0011\u0011!C!\u0003WD\u0011\"a>\u0001\u0003\u0003%\t!!?\t\u0013\t\u0005\u0001!!A\u0005\u0002\t\r\u0001\"\u0003B\u0005\u0001\u0005\u0005I\u0011\tB\u0006\u0011%\u0011I\u0002AA\u0001\n\u0003\u0011Y\u0002C\u0005\u0003 \u0001\t\t\u0011\"\u0011\u0003\"!I!Q\u0005\u0001\u0002\u0002\u0013\u0005#qE\u0004\n\u0005\u0017b\u0013\u0011!E\u0001\u0005\u001b2\u0001b\u000b\u0017\u0002\u0002#\u0005!q\n\u0005\u0007y\u000e\"\tA!\u0019\t\u0013\t\r4%!A\u0005F\t\u0015\u0004\"\u0003B4G\u0005\u0005I\u0011\u0011B5\u0011%\u0011\thII\u0001\n\u0003\t)\u000fC\u0005\u0003t\r\n\t\u0011\"!\u0003v!I!1Q\u0012\u0012\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0005\u000b\u001b\u0013\u0011!C\u0005\u0005\u000f\u0013Qb\u0015;sk\u000e$8\u000fV8Kg>t'BA\u0017/\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005=\u0002\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005E\u0012\u0014aA:rY*\u00111\u0007N\u0001\u0006gB\f'o\u001b\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0011\u0001Qd(Q$K#^\u0003\"a\u000f\u001f\u000e\u00031J!!\u0010\u0017\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"aO \n\u0005\u0001c#a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\t\u0011U)D\u0001D\u0015\t!E&A\u0004d_\u0012,w-\u001a8\n\u0005\u0019\u001b%aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005mB\u0015BA%-\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0017:s!a\u000f'\n\u00055c\u0013a\u00029bG.\fw-Z\u0005\u0003\u001fB\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002NYA\u0011!+V\u0007\u0002'*\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\n9\u0001K]8ek\u000e$\bC\u0001-`\u001d\tIfL\u0004\u0002[;6\t1L\u0003\u0002]q\u00051AH]8pizJ\u0011\u0001V\u0005\u0003\u001bNK!\u0001Y1\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00055\u001b\u0016aB8qi&|gn]\u000b\u0002IB!Q-\u001b7m\u001d\t1w\r\u0005\u0002['&\u0011\u0001nU\u0001\u0007!J,G-\u001a4\n\u0005)\\'aA'ba*\u0011\u0001n\u0015\t\u0003K6L!A\\6\u0003\rM#(/\u001b8h\u0003!y\u0007\u000f^5p]N\u0004\u0013!B2iS2$W#\u0001:\u0011\u0005m\u001a\u0018B\u0001;-\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001y!\r\u0011\u0016\u0010\\\u0005\u0003uN\u0013aa\u00149uS>t\u0017a\u0003;j[\u0016TvN\\3JI\u0002\na\u0001P5oSRtDC\u0002@\u0000\u0003\u0003\t\u0019\u0001\u0005\u0002<\u0001!)!m\u0002a\u0001I\")\u0001o\u0002a\u0001e\"9ao\u0002I\u0001\u0002\u0004A\u0018\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005%\u0001c\u0001*\u0002\f%\u0019\u0011QB*\u0003\u000f\t{w\u000e\\3b]R)a0!\u0005\u0002\u0014!)!-\u0003a\u0001I\")\u0001/\u0003a\u0001eR\u0019a0a\u0006\t\u000bAT\u0001\u0019\u0001:\u0015\u000by\fY\"!\b\t\u000bA\\\u0001\u0019\u0001:\t\u000b\t\\\u0001\u0019\u0001:\u0002\r]\u0014\u0018\u000e^3s+\t\t\u0019\u0003\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0005%|'BAA\u0017\u0003\u0011Q\u0017M^1\n\t\u0005E\u0012q\u0005\u0002\u0010\u0007\"\f'/\u0011:sCf<&/\u001b;fe\"\u001aA\"!\u000e\u0011\u0007I\u000b9$C\u0002\u0002:M\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0007\u001d,g.\u0006\u0002\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002F9\nAA[:p]&!\u0011\u0011JA\"\u0005AQ\u0015mY6t_:<UM\\3sCR|'\u000fK\u0002\u000e\u0003k\t1\"\u001b8qkR\u001c6\r[3nCV\u0011\u0011\u0011\u000b\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011q\u000b\u0019\u0002\u000bQL\b/Z:\n\t\u0005m\u0013Q\u000b\u0002\t\t\u0006$\u0018\rV=qK\"\u001aa\"!\u000e\u0002\u0013\r|gN^3si\u0016\u0014XCAA2!\u001d\u0011\u0016QMA5\u0003_J1!a\u001aT\u0005%1UO\\2uS>t\u0017\u0007E\u0002S\u0003WJ1!!\u001cT\u0005\r\te.\u001f\t\u0005\u0003c\nI(\u0004\u0002\u0002t)!\u0011qKA;\u0015\r\t9HM\u0001\u0007k:\u001c\u0018MZ3\n\t\u0005m\u00141\u000f\u0002\u000b+R3\u0005h\u0015;sS:<\u0007fA\b\u00026\u0005AA-\u0019;b)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002\u0006B!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f:\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u001f\u000bIIA\bUsB,7\t[3dWJ+7/\u001e7u\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\rq\u0014Q\u0013\u0005\u0006mJ\u0001\r\u0001\\\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0005\u0003S\nY\nC\u0004\u0002\u001eN\u0001\r!!\u001b\u0002\u000bY\fG.^3\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002$B)\u0001,!*\u0002*&\u0019\u0011qU1\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002T\u0005-\u0016\u0002BAW\u0003+\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001m\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019a0a.\t\r\u0005ef\u00031\u0001s\u0003!qWm^\"iS2$\u0017\u0001B2paf$rA`A`\u0003\u0003\f\u0019\rC\u0004c/A\u0005\t\u0019\u00013\t\u000fA<\u0002\u0013!a\u0001e\"9ao\u0006I\u0001\u0002\u0004A\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0013T3\u0001ZAfW\t\ti\r\u0005\u0003\u0002P\u0006eWBAAi\u0015\u0011\t\u0019.!6\u0002\u0013Ut7\r[3dW\u0016$'bAAl'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0017\u0011\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003CT3A]Af\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a:+\u0007a\fY-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003[\u0004B!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0005\u0003g\fY#\u0001\u0003mC:<\u0017b\u00018\u0002r\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111 \t\u0004%\u0006u\u0018bAA\u0000'\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011\u000eB\u0003\u0011%\u00119!HA\u0001\u0002\u0004\tY0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001b\u0001bAa\u0004\u0003\u0016\u0005%TB\u0001B\t\u0015\r\u0011\u0019bU\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\f\u0005#\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011\u0002B\u000f\u0011%\u00119aHA\u0001\u0002\u0004\tI'\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAw\u0005GA\u0011Ba\u0002!\u0003\u0003\u0005\r!a?\u0002\r\u0015\fX/\u00197t)\u0011\tIA!\u000b\t\u0013\t\u001d\u0011%!AA\u0002\u0005%\u0004f\u0005\u0001\u0003.\tM\"Q\u0007B\u001d\u0005w\u0011yD!\u0011\u0003F\t\u001d\u0003cA\u001e\u00030%\u0019!\u0011\u0007\u0017\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!qG\u0001J?\u001a+fjQ0)Kb\u0004(o\u0017\u0017!_B$\u0018n\u001c8t;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bA)\u001bvJ\u0014\u0011tiJLgn\u001a\u0011xSRD\u0007%\u0019\u0011hSZ,g\u000eI:ueV\u001cG\u000f\t<bYV,\u0017\u0001C3yC6\u0004H.Z:\"\u0005\tu\u0012\u0001b2\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q9\fW.\u001a3`gR\u0014Xo\u0019;)O\u0005<C\u0006I\u0019-A\u001d\u0012w\u0005\f\u00113S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012bEi\nDF\t2#uIj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b8b[\u0016$wl\u001d;sk\u000e$\bf\n;j[\u0016<C\u0006\t;p?RLW.Z:uC6\u0004\bf\n\u001a1cUj\u0003\u0007O\u00173m\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ\u0013\u0006\f\u0011nCBDs\u0005^5nKN$\u0018-\u001c9G_Jl\u0017\r^\u0014-A\u001d\"GmL'N_eL\u00180_\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u00023P\t;j[\u0016\u0014#H\t\u001a7_ABtF\r\u00192k\tj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bF\\1nK\u0012|6\u000f\u001e:vGRDs%Y\u0014-AEb\u0003e\n2(Y\u0001\u0012\u0014&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(%\u0019\u0012;c1\u0012#M\t\u001e3{vS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\\1qQ\u001d\nw\u0005\f\u0011oC6,GmX:ueV\u001cG\u000fK\u0014cO1\u0002\u0013'K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;w\n\u0012'EO\u0019~{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS.\u00199)]\u0006lW\rZ0tiJ,8\r\u001e\u0015(C\u001eb\u0003%M\u0015-]\u0006lW\rZ0tiJ,8\r\u001e\u0015(E\u001eb\u0003EM\u0015*SmR\u0001\u0005\t\u0011!A\u0001\u00023PI.2;\nR4P\t2#uIjXP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBDs%Y\u0014-AEJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|E\u0005\u0014#(M?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)Q5\f\u0007\u000fK\u0014bO1\u0002\u0013'K\u0015*SmR\u0001\u0005\t\u0011!A\u0001\u00023l\u001f\u0012bEi\nT0\u0018\u0006!A\u0005)qM]8va\u0006\u0012!1I\u0001\u000bUN|gn\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B%\u0003\u0015\u0011dF\r\u00181\u00035\u0019FO];diN$vNS:p]B\u00111hI\n\u0006G\tE#Q\f\t\t\u0005'\u0012I\u0006\u001a:y}6\u0011!Q\u000b\u0006\u0004\u0005/\u001a\u0016a\u0002:v]RLW.Z\u0005\u0005\u00057\u0012)FA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!!\n\u0003`%\u0019\u0001-a\n\u0015\u0005\t5\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0018!B1qa2LHc\u0002@\u0003l\t5$q\u000e\u0005\u0006E\u001a\u0002\r\u0001\u001a\u0005\u0006a\u001a\u0002\rA\u001d\u0005\bm\u001a\u0002\n\u00111\u0001y\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005o\u0012y\b\u0005\u0003Ss\ne\u0004C\u0002*\u0003|\u0011\u0014\b0C\u0002\u0003~M\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003BAQ\u0005\u0005\t\u0019\u0001@\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0013\u0003B!a<\u0003\f&!!QRAy\u0005\u0019y%M[3di\u0002")
public class StructsToJson
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private transient CharArrayWriter writer;
    private transient JacksonGenerator gen;
    private transient DataType inputSchema;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToJson$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToJson x$0) {
        return StructsToJson$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return StructsToJson$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToJson> tupled() {
        return StructsToJson$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToJson>>> curried() {
        return StructsToJson$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private JacksonGenerator gen$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.gen = new JacksonGenerator(this.inputSchema(), this.writer(), new JSONOptions(this.options(), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.gen;
    }

    public JacksonGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private DataType inputSchema$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputSchema = this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputSchema;
    }

    public DataType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable intersect;
                DataType dataType = this.inputSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable)row -> {
                        this.gen().write((InternalRow)row);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable)arr -> {
                        this.gen().write((ArrayData)arr);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable)map -> {
                        this.gen().write((MapData)map);
                        return this.getAndReset$1();
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        DataType dataType = this.inputSchema();
        if (dataType instanceof StructType) {
            TypeCheckResult typeCheckResult2;
            StructType structType = (StructType)dataType;
            try {
                JacksonUtils$.MODULE$.verifySchema(structType);
                typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult2 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult2;
        } else if (dataType instanceof MapType) {
            TypeCheckResult typeCheckResult3;
            MapType mapType = (MapType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), mapType);
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult3 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult3;
        } else if (dataType instanceof ArrayType) {
            TypeCheckResult typeCheckResult4;
            ArrayType arrayType = (ArrayType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), arrayType);
                typeCheckResult4 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult4 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult4;
        } else {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(22).append(new StringBuilder(50).append("Input type ").append(this.child().dataType().catalogString()).append(" must be a struct, array of structs or ").toString()).append("a map or array of map.").toString());
        }
        return typeCheckResult;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, StructType$.MODULE$}));
        return package$.MODULE$.Nil().$colon$colon((Object)typeCollection);
    }

    @Override
    public String prettyName() {
        return "to_json";
    }

    @Override
    public StructsToJson withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    public StructsToJson copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToJson(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToJson";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToJson;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "options";
                break;
            }
            case 1: {
                string = "child";
                break;
            }
            case 2: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToJson structsToJson = (StructsToJson)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToJson.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToJson.canEqual(this)) return false;
        return true;
    }

    private final UTF8String getAndReset$1() {
        this.gen().flush();
        String json = this.writer().toString();
        this.writer().reset();
        return UTF8String.fromString((String)json);
    }

    public StructsToJson(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public StructsToJson(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

