/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.PercentRank$;
import org.apache.spark.sql.catalyst.expressions.RankLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_() - Computes the percentage ranking of a value in a group of values.\n  ", arguments="\n    Arguments:\n      * children - this is to base the rank on; a change in the value of one the children will\n          trigger a change in rank. This is an internal parameter and will be assigned by the\n          Analyser.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t0.0\n       A1\t1\t0.0\n       A1\t2\t1.0\n       A2\t3\t0.0\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001B\u000e\u001d\u0001&B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u000b\")A\n\u0001C\u0001\u001b\")A\n\u0001C\u0001!\")\u0011\u000b\u0001C!%\")Q\u000b\u0001C!-\"9Q\f\u0001b\u0001\n\u0003r\u0006B\u00022\u0001A\u0003%q\fC\u0003d\u0001\u0011\u0005C\rC\u0003n\u0001\u0011Ec\u000eC\u0004u\u0001\u0005\u0005I\u0011A;\t\u000f]\u0004\u0011\u0013!C\u0001q\"I\u0011q\u0001\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0002\u0005\n\u00033\u0001\u0011\u0011!C\u0001\u00037A\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u0005E\u0002!!A\u0005B\u0005M\u0002\"CA!\u0001\u0005\u0005I\u0011AA\"\u0011%\ti\u0005AA\u0001\n\u0003\ny\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0011\u0002V\u001dI\u0011q\u0010\u000f\u0002\u0002#\u0005\u0011\u0011\u0011\u0004\t7q\t\t\u0011#\u0001\u0002\u0004\"1A*\u0006C\u0001\u00037C\u0011\"!(\u0016\u0003\u0003%)%a(\t\u0013\u0005\u0005V#!A\u0005\u0002\u0006\r\u0006\"CAT+\u0005\u0005I\u0011QAU\u0011%\t),FA\u0001\n\u0013\t9LA\u0006QKJ\u001cWM\u001c;SC:\\'BA\u000f\u001f\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005}\u0001\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001Qc&M\u001c\u0011\u0005-bS\"\u0001\u000f\n\u00055b\"\u0001\u0003*b].d\u0015n[3\u0011\u0005-z\u0013B\u0001\u0019\u001d\u0005]\u0019\u0016N_3CCN,GmV5oI><h)\u001e8di&|g\u000e\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14GA\u0004Qe>$Wo\u0019;\u0011\u0005a\u0002eBA\u001d?\u001d\tQT(D\u0001<\u0015\ta\u0004&\u0001\u0004=e>|GOP\u0005\u0002i%\u0011qhM\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002@g\u0005A1\r[5mIJ,g.F\u0001F!\rAd\tS\u0005\u0003\u000f\n\u00131aU3r!\tY\u0013*\u0003\u0002K9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002O\u001fB\u00111\u0006\u0001\u0005\u0006\u0007\u000e\u0001\r!\u0012\u000b\u0002\u001d\u0006Iq/\u001b;i\u001fJ$WM\u001d\u000b\u0003\u001dNCQ\u0001V\u0003A\u0002\u0015\u000bQa\u001c:eKJ\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002/B\u0011\u0001lW\u0007\u00023*\u0011!\fI\u0001\u0006if\u0004Xm]\u0005\u00039f\u0013\u0001\u0002R1uCRK\b/Z\u0001\u0013KZ\fG.^1uK\u0016C\bO]3tg&|g.F\u0001`!\tY\u0003-\u0003\u0002b9\t\u0011\u0011JZ\u0001\u0014KZ\fG.^1uK\u0016C\bO]3tg&|g\u000eI\u0001\u000baJ,G\u000f^=OC6,W#A3\u0011\u0005\u0019TgBA4i!\tQ4'\u0003\u0002jg\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tI7'A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0011aj\u001c\u0005\u0006a*\u0001\r!]\u0001\f]\u0016<8\t[5mIJ,g\u000eE\u00029e\"K!a\u001d\"\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLHC\u0001(w\u0011\u001d\u00195\u0002%AA\u0002\u0015\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001zU\t)%pK\u0001|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00014\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u000bi(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0003\u0011\t\u00055\u0011qC\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005!A.\u00198h\u0015\t\t)\"\u0001\u0003kCZ\f\u0017bA6\u0002\u0010\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0004\t\u0004e\u0005}\u0011bAA\u0011g\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qEA\u0017!\r\u0011\u0014\u0011F\u0005\u0004\u0003W\u0019$aA!os\"I\u0011qF\b\u0002\u0002\u0003\u0007\u0011QD\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0002CBA\u001c\u0003{\t9#\u0004\u0002\u0002:)\u0019\u00111H\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002@\u0005e\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0012\u0002LA\u0019!'a\u0012\n\u0007\u0005%3GA\u0004C_>dW-\u00198\t\u0013\u0005=\u0012#!AA\u0002\u0005\u001d\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0003\u0002R!I\u0011q\u0006\n\u0002\u0002\u0003\u0007\u0011QD\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u0013q\u000b\u0005\n\u0003_\u0019\u0012\u0011!a\u0001\u0003OAs\u0003AA.\u0003C\n\u0019'a\u001a\u0002j\u00055\u0014qNA:\u0003k\nI(a\u001f\u0011\u0007-\ni&C\u0002\u0002`q\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002f\u0005\u0019&\u0002\t\u0011!A}3UKT\"`Q%\u0002S\u0006I\"p[B,H/Z:!i\",\u0007\u0005]3sG\u0016tG/Y4fAI\fgn[5oO\u0002zg\rI1!m\u0006dW/\u001a\u0011j]\u0002\n\u0007e\u001a:pkB\u0004sN\u001a\u0011wC2,Xm\u001d\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005-\u0014!a2\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001a\u0007.\u001b7ee\u0016t\u0007%\f\u0011uQ&\u001c\b%[:!i>\u0004#-Y:fAQDW\r\t:b].\u0004sN\\\u001e!C\u0002\u001a\u0007.\u00198hK\u0002Jg\u000e\t;iK\u00022\u0018\r\\;fA=4\u0007e\u001c8fAQDW\rI2iS2$'/\u001a8!o&dGN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014\u0018nZ4fe\u0002\n\u0007e\u00195b]\u001e,\u0007%\u001b8!e\u0006t7N\f\u0011UQ&\u001c\b%[:!C:\u0004\u0013N\u001c;fe:\fG\u000e\t9be\u0006lW\r^3sA\u0005tG\rI<jY2\u0004#-\u001a\u0011bgNLwM\\3eA\tL\b\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00118bYf\u001cXM\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003c\n\u0011q\u0015\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!C2\u0002#\r\f\u0011`\rVs5i\u0018\u0015cS\u0001ze+\u0012*!QA\u000b%\u000bV%U\u0013>s\u0005EQ-!C\u0002z%\u000bR#SA\tK\u0006EY\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015(\u0003F:C\u0006\t\u001a*Y\u0001Bs%Q\u0019(Y\u0001\n\u0014\u0006\f\u0011)O\u0005\u0013t\u0005\f\u00114S1\u0002\u0003fJ!2O1\u0002\u0013'\u000b\u0011uC\nD\u0013\r\f\u0011cSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013)M\u00052\u0013Ar\u0003G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ\u0001G\f\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!'C\u0019/a)\u0001\u0003\u0005\t\u0011!A\u0001\n%'C\u001a\na9\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005]\u0014!\u0002\u001a/a9\u0002\u0014!B4s_V\u0004\u0018EAA?\u000319\u0018N\u001c3po~3WO\\2t\u0003-\u0001VM]2f]R\u0014\u0016M\\6\u0011\u0005-*2#B\u000b\u0002\u0006\u0006E\u0005CBAD\u0003\u001b+e*\u0004\u0002\u0002\n*\u0019\u00111R\u001a\u0002\u000fI,h\u000e^5nK&!\u0011qRAE\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*!\u0011qSA\n\u0003\tIw.C\u0002B\u0003+#\"!!!\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00079\u000b)\u000bC\u0003D1\u0001\u0007Q)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005-\u0016\u0011\u0017\t\u0005e\u00055V)C\u0002\u00020N\u0012aa\u00149uS>t\u0007\u0002CAZ3\u0005\u0005\t\u0019\u0001(\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002:B!\u0011QBA^\u0013\u0011\ti,a\u0004\u0003\r=\u0013'.Z2u\u0001")
public class PercentRank
extends RankLike
implements SizeBasedWindowFunction {
    private final Seq<Expression> children;
    private final If evaluateExpression;
    private AttributeReference n;

    public static Option<Seq<Expression>> unapply(PercentRank x$0) {
        return PercentRank$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<PercentRank, A> g) {
        return PercentRank$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, PercentRank> compose(Function1<A$, Seq<Expression>> g) {
        return PercentRank$.MODULE$.compose(g);
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public PercentRank withOrder(Seq<Expression> order) {
        return new PercentRank(order);
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public If evaluateExpression() {
        return this.evaluateExpression;
    }

    @Override
    public String prettyName() {
        return "percent_rank";
    }

    @Override
    public PercentRank withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public PercentRank copy(Seq<Expression> children2) {
        return new PercentRank(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "PercentRank";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PercentRank;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PercentRank)) return false;
        boolean bl = true;
        if (!bl) return false;
        PercentRank percentRank = (PercentRank)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = percentRank.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!percentRank.canEqual(this)) return false;
        return true;
    }

    public PercentRank(Seq<Expression> children2) {
        this.children = children2;
        SizeBasedWindowFunction.$init$(this);
        this.evaluateExpression = new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.n()).$greater(this.one())), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.rank()).$minus(this.one())).cast(DoubleType$.MODULE$)).$div(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$minus(this.one())).cast(DoubleType$.MODULE$)), package$expressions$.MODULE$.doubleToLiteral(0.0));
        Statics.releaseFence();
    }

    public PercentRank() {
        this((Seq<Expression>)package$.MODULE$.Nil());
    }
}

