/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.ScalaReflection;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArraySeq;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Literal$
implements Serializable {
    public static final Literal$ MODULE$ = new Literal$();
    private static final Literal TrueLiteral = new Literal(BoxesRunTime.boxToBoolean((boolean)true), BooleanType$.MODULE$);
    private static final Literal FalseLiteral = new Literal(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$);

    public Literal TrueLiteral() {
        return TrueLiteral;
    }

    public Literal FalseLiteral() {
        return FalseLiteral;
    }

    public Literal apply(Object v) {
        Literal literal;
        block31: {
            Object object;
            while (true) {
                if ((object = v) instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)object);
                    literal = new Literal(BoxesRunTime.boxToInteger((int)n), IntegerType$.MODULE$);
                    break block31;
                }
                if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    literal = new Literal(BoxesRunTime.boxToLong((long)l), LongType$.MODULE$);
                    break block31;
                }
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    literal = new Literal(BoxesRunTime.boxToDouble((double)d), DoubleType$.MODULE$);
                    break block31;
                }
                if (object instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)object);
                    literal = new Literal(BoxesRunTime.boxToFloat((float)f), FloatType$.MODULE$);
                    break block31;
                }
                if (object instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte((Object)object);
                    literal = new Literal(BoxesRunTime.boxToByte((byte)by), ByteType$.MODULE$);
                    break block31;
                }
                if (object instanceof Short) {
                    short s = BoxesRunTime.unboxToShort((Object)object);
                    literal = new Literal(BoxesRunTime.boxToShort((short)s), ShortType$.MODULE$);
                    break block31;
                }
                if (object instanceof String) {
                    String string = (String)object;
                    literal = new Literal(UTF8String.fromString((String)string), StringType$.MODULE$);
                    break block31;
                }
                if (object instanceof Character) {
                    char c = BoxesRunTime.unboxToChar((Object)object);
                    literal = new Literal(UTF8String.fromString((String)Character.toString(c)), StringType$.MODULE$);
                    break block31;
                }
                if (object instanceof char[]) {
                    char[] cArray = (char[])object;
                    literal = new Literal(UTF8String.fromString((String)String.valueOf(cArray)), StringType$.MODULE$);
                    break block31;
                }
                if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    literal = new Literal(BoxesRunTime.boxToBoolean((boolean)bl), BooleanType$.MODULE$);
                    break block31;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    Decimal decimal = Decimal$.MODULE$.apply(bigDecimal);
                    literal = new Literal(decimal, DecimalType$.MODULE$.fromDecimal(decimal));
                    break block31;
                }
                if (object instanceof java.math.BigDecimal) {
                    java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
                    Decimal decimal = Decimal$.MODULE$.apply(bigDecimal);
                    literal = new Literal(decimal, DecimalType$.MODULE$.fromDecimal(decimal));
                    break block31;
                }
                if (object instanceof Decimal) {
                    Decimal decimal = (Decimal)object;
                    literal = new Literal(decimal, new DecimalType(Math.max(decimal.precision(), decimal.scale()), decimal.scale()));
                    break block31;
                }
                if (object instanceof Instant) {
                    Instant instant = (Instant)object;
                    literal = new Literal(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(instant)), TimestampType$.MODULE$);
                    break block31;
                }
                if (object instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object;
                    literal = new Literal(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp)), TimestampType$.MODULE$);
                    break block31;
                }
                if (object instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)object;
                    if (Utils$.MODULE$.isTesting()) {
                        literal = new Literal(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime)), TimestampNTZType$.MODULE$);
                        break block31;
                    }
                }
                if (object instanceof LocalDate) {
                    LocalDate localDate = (LocalDate)object;
                    literal = new Literal(BoxesRunTime.boxToInteger((int)((int)localDate.toEpochDay())), DateType$.MODULE$);
                    break block31;
                }
                if (object instanceof Date) {
                    Date date = (Date)object;
                    literal = new Literal(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date)), DateType$.MODULE$);
                    break block31;
                }
                if (object instanceof Duration) {
                    Duration duration = (Duration)object;
                    literal = new Literal(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(duration)), DayTimeIntervalType$.MODULE$.apply());
                    break block31;
                }
                if (object instanceof Period) {
                    Period period = (Period)object;
                    literal = new Literal(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(period)), YearMonthIntervalType$.MODULE$.apply());
                    break block31;
                }
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    literal = new Literal(byArray, BinaryType$.MODULE$);
                    break block31;
                }
                if (!(object instanceof ArraySeq)) break;
                ArraySeq arraySeq = (ArraySeq)object;
                v = arraySeq.array();
            }
            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                DataType elementType = this.componentTypeToDataType(object2.getClass().getComponentType());
                ArrayType dataType = ArrayType$.MODULE$.apply(elementType);
                Function1<Object, Object> convert = CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType);
                literal = new Literal(convert.apply(object2), dataType);
            } else if (object instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)object;
                literal = new Literal(calendarInterval, CalendarIntervalType$.MODULE$);
            } else if (object == null) {
                literal = new Literal(null, NullType$.MODULE$);
            } else if (object instanceof Literal) {
                Literal literal2;
                literal = literal2 = (Literal)object;
            } else {
                throw QueryExecutionErrors$.MODULE$.literalTypeUnsupportedError(v);
            }
        }
        return literal;
    }

    private DataType componentTypeToDataType(Class<?> clz) {
        DataType dataType;
        Class<?> clazz = clz;
        Class<Short> clazz2 = Short.TYPE;
        Class<?> clazz3 = clazz;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            dataType = ShortType$.MODULE$;
        } else {
            Class<Integer> clazz4 = Integer.TYPE;
            Class<?> clazz5 = clazz;
            if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                dataType = IntegerType$.MODULE$;
            } else {
                Class<Long> clazz6 = Long.TYPE;
                Class<?> clazz7 = clazz;
                if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                    dataType = LongType$.MODULE$;
                } else {
                    Class<Double> clazz8 = Double.TYPE;
                    Class<?> clazz9 = clazz;
                    if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                        dataType = DoubleType$.MODULE$;
                    } else {
                        Class<Byte> clazz10 = Byte.TYPE;
                        Class<?> clazz11 = clazz;
                        if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                            dataType = ByteType$.MODULE$;
                        } else {
                            Class<Float> clazz12 = Float.TYPE;
                            Class<?> clazz13 = clazz;
                            if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
                                dataType = FloatType$.MODULE$;
                            } else {
                                Class<Boolean> clazz14 = Boolean.TYPE;
                                Class<?> clazz15 = clazz;
                                if (!(clazz14 != null ? !clazz14.equals(clazz15) : clazz15 != null)) {
                                    dataType = BooleanType$.MODULE$;
                                } else {
                                    Class<Character> clazz16 = Character.TYPE;
                                    Class<?> clazz17 = clazz;
                                    if (!(clazz16 != null ? !clazz16.equals(clazz17) : clazz17 != null)) {
                                        dataType = StringType$.MODULE$;
                                    } else {
                                        Class<?> clazz18 = clz;
                                        Class<LocalDate> clazz19 = LocalDate.class;
                                        if (!(clazz18 != null ? !clazz18.equals(clazz19) : clazz19 != null)) {
                                            dataType = DateType$.MODULE$;
                                        } else {
                                            Class<?> clazz20 = clz;
                                            Class<Date> clazz21 = Date.class;
                                            if (!(clazz20 != null ? !clazz20.equals(clazz21) : clazz21 != null)) {
                                                dataType = DateType$.MODULE$;
                                            } else {
                                                Class<?> clazz22 = clz;
                                                Class<Instant> clazz23 = Instant.class;
                                                if (!(clazz22 != null ? !clazz22.equals(clazz23) : clazz23 != null)) {
                                                    dataType = TimestampType$.MODULE$;
                                                } else {
                                                    Class<?> clazz24 = clz;
                                                    Class<Timestamp> clazz25 = Timestamp.class;
                                                    if (!(clazz24 != null ? !clazz24.equals(clazz25) : clazz25 != null)) {
                                                        dataType = TimestampType$.MODULE$;
                                                    } else {
                                                        Class<?> clazz26 = clz;
                                                        Class<LocalDateTime> clazz27 = LocalDateTime.class;
                                                        if (!(clazz26 != null ? !clazz26.equals(clazz27) : clazz27 != null) && Utils$.MODULE$.isTesting()) {
                                                            dataType = TimestampNTZType$.MODULE$;
                                                        } else {
                                                            Class<?> clazz28 = clz;
                                                            Class<Duration> clazz29 = Duration.class;
                                                            if (!(clazz28 != null ? !clazz28.equals(clazz29) : clazz29 != null)) {
                                                                dataType = DayTimeIntervalType$.MODULE$.apply();
                                                            } else {
                                                                Class<?> clazz30 = clz;
                                                                Class<Period> clazz31 = Period.class;
                                                                if (!(clazz30 != null ? !clazz30.equals(clazz31) : clazz31 != null)) {
                                                                    dataType = YearMonthIntervalType$.MODULE$.apply();
                                                                } else {
                                                                    Class<?> clazz32 = clz;
                                                                    Class<java.math.BigDecimal> clazz33 = java.math.BigDecimal.class;
                                                                    if (!(clazz32 != null ? !clazz32.equals(clazz33) : clazz33 != null)) {
                                                                        dataType = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                                                                    } else {
                                                                        Class<?> clazz34 = clz;
                                                                        Class<byte[]> clazz35 = byte[].class;
                                                                        if (!(clazz34 != null ? !clazz34.equals(clazz35) : clazz35 != null)) {
                                                                            dataType = BinaryType$.MODULE$;
                                                                        } else {
                                                                            Class<?> clazz36 = clz;
                                                                            Class<char[]> clazz37 = char[].class;
                                                                            if (!(clazz36 != null ? !clazz36.equals(clazz37) : clazz37 != null)) {
                                                                                dataType = StringType$.MODULE$;
                                                                            } else {
                                                                                Class<?> clazz38 = clz;
                                                                                Class<Short> clazz39 = Short.class;
                                                                                if (!(clazz38 != null ? !clazz38.equals(clazz39) : clazz39 != null)) {
                                                                                    dataType = ShortType$.MODULE$;
                                                                                } else {
                                                                                    Class<?> clazz40 = clz;
                                                                                    Class<Integer> clazz41 = Integer.class;
                                                                                    if (!(clazz40 != null ? !clazz40.equals(clazz41) : clazz41 != null)) {
                                                                                        dataType = IntegerType$.MODULE$;
                                                                                    } else {
                                                                                        Class<?> clazz42 = clz;
                                                                                        Class<Long> clazz43 = Long.class;
                                                                                        if (!(clazz42 != null ? !clazz42.equals(clazz43) : clazz43 != null)) {
                                                                                            dataType = LongType$.MODULE$;
                                                                                        } else {
                                                                                            Class<?> clazz44 = clz;
                                                                                            Class<Double> clazz45 = Double.class;
                                                                                            if (!(clazz44 != null ? !clazz44.equals(clazz45) : clazz45 != null)) {
                                                                                                dataType = DoubleType$.MODULE$;
                                                                                            } else {
                                                                                                Class<?> clazz46 = clz;
                                                                                                Class<Byte> clazz47 = Byte.class;
                                                                                                if (!(clazz46 != null ? !clazz46.equals(clazz47) : clazz47 != null)) {
                                                                                                    dataType = ByteType$.MODULE$;
                                                                                                } else {
                                                                                                    Class<?> clazz48 = clz;
                                                                                                    Class<Float> clazz49 = Float.class;
                                                                                                    if (!(clazz48 != null ? !clazz48.equals(clazz49) : clazz49 != null)) {
                                                                                                        dataType = FloatType$.MODULE$;
                                                                                                    } else {
                                                                                                        Class<?> clazz50 = clz;
                                                                                                        Class<Boolean> clazz51 = Boolean.class;
                                                                                                        if (!(clazz50 != null ? !clazz50.equals(clazz51) : clazz51 != null)) {
                                                                                                            dataType = BooleanType$.MODULE$;
                                                                                                        } else {
                                                                                                            Class<?> clazz52 = clz;
                                                                                                            Class<String> clazz53 = String.class;
                                                                                                            if (!(clazz52 != null ? !clazz52.equals(clazz53) : clazz53 != null)) {
                                                                                                                dataType = StringType$.MODULE$;
                                                                                                            } else {
                                                                                                                Class<?> clazz54 = clz;
                                                                                                                Class<BigInt> clazz55 = BigInt.class;
                                                                                                                if (!(clazz54 != null ? !clazz54.equals(clazz55) : clazz55 != null)) {
                                                                                                                    dataType = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                                                                                                                } else {
                                                                                                                    Class<?> clazz56 = clz;
                                                                                                                    Class<BigDecimal> clazz57 = BigDecimal.class;
                                                                                                                    if (!(clazz56 != null ? !clazz56.equals(clazz57) : clazz57 != null)) {
                                                                                                                        dataType = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                                                                                                                    } else {
                                                                                                                        Class<?> clazz58 = clz;
                                                                                                                        Class<CalendarInterval> clazz59 = CalendarInterval.class;
                                                                                                                        if (!(clazz58 != null ? !clazz58.equals(clazz59) : clazz59 != null)) {
                                                                                                                            dataType = CalendarIntervalType$.MODULE$;
                                                                                                                        } else if (clz.isArray()) {
                                                                                                                            dataType = ArrayType$.MODULE$.apply(this.componentTypeToDataType(clz.getComponentType()));
                                                                                                                        } else {
                                                                                                                            throw QueryCompilationErrors$.MODULE$.arrayComponentTypeUnsupportedError(clz);
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return dataType;
    }

    public Literal fromObject(Object obj, DataType objType) {
        return new Literal(obj, objType);
    }

    public Literal fromObject(Object obj) {
        return new Literal(obj, new ObjectType(obj.getClass()));
    }

    public Literal create(Object v, DataType dataType) {
        DataType dataType2 = dataType;
        Literal literal = dataType2 instanceof YearMonthIntervalType && v instanceof Period ? new Literal(CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType).apply(v), dataType) : (dataType2 instanceof DayTimeIntervalType && v instanceof Duration ? new Literal(CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType).apply(v), dataType) : (dataType2 instanceof ObjectType ? new Literal(v, dataType) : new Literal(CatalystTypeConverters$.MODULE$.convertToCatalyst(v), dataType)));
        return literal;
    }

    public <T> Literal create(T v, TypeTags.TypeTag<T> evidence$1) {
        return (Literal)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            DataType dataType;
            ScalaReflection.Schema schema = ScalaReflection$.MODULE$.schemaFor(evidence$1);
            if (schema == null) {
                throw new MatchError((Object)schema);
            }
            DataType dataType2 = dataType = schema.dataType();
            DataType dataType3 = dataType2;
            Function1<Object, Object> convert = CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType3);
            return new Literal(convert.apply(v), dataType3);
        }).getOrElse((Function0 & Serializable)() -> MODULE$.apply(v));
    }

    public Literal default(DataType dataType) {
        Literal literal;
        DataType dataType2 = dataType;
        if (NullType$.MODULE$.equals(dataType2)) {
            literal = this.create(null, NullType$.MODULE$);
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToBoolean((boolean)false));
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToByte((byte)((byte)0)));
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToShort((short)((short)0)));
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToInteger((int)0));
        } else if (LongType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToLong((long)0L));
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToFloat((float)0.0f));
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            literal = this.apply(BoxesRunTime.boxToDouble((double)0.0));
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            literal = this.apply(Decimal$.MODULE$.apply(0L, decimalType.precision(), decimalType.scale()));
        } else if (DateType$.MODULE$.equals(dataType2)) {
            literal = this.create(BoxesRunTime.boxToInteger((int)0), DateType$.MODULE$);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            literal = this.create(BoxesRunTime.boxToLong((long)0L), TimestampType$.MODULE$);
        } else if (TimestampNTZType$.MODULE$.equals(dataType2) && Utils$.MODULE$.isTesting()) {
            literal = this.create(BoxesRunTime.boxToLong((long)0L), TimestampNTZType$.MODULE$);
        } else if (dataType2 instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
            literal = this.create(BoxesRunTime.boxToLong((long)0L), dayTimeIntervalType);
        } else if (dataType2 instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
            literal = this.create(BoxesRunTime.boxToInteger((int)0), yearMonthIntervalType);
        } else if (StringType$.MODULE$.equals(dataType2)) {
            literal = this.apply("");
        } else if (BinaryType$.MODULE$.equals(dataType2)) {
            literal = this.apply("".getBytes(StandardCharsets.UTF_8));
        } else if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            literal = this.apply(new CalendarInterval(0, 0, 0L));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            literal = this.create(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing()), arrayType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            literal = this.create(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), mapType);
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            literal = this.create(InternalRow$.MODULE$.fromSeq((Seq<Object>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> MODULE$.default(f.dataType()).value(), ClassTag$.MODULE$.Any()))), structType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            literal = new Literal(this.default(userDefinedType.sqlType()).value(), userDefinedType);
        } else {
            throw QueryExecutionErrors$.MODULE$.noDefaultForDataTypeError(dataType);
        }
        return literal;
    }

    public void validateLiteralValue(Object value, DataType dataType) {
        Predef$.MODULE$.require(this.doValidate$1(value, dataType), (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(45).append("Literal must have a corresponding value to ").append(dataType.catalogString()).append(", ").toString()).append(new StringBuilder(17).append("but class ").append(Utils$.MODULE$.getSimpleName(value.getClass())).append(" found.").toString()).toString());
    }

    public Literal apply(Object value, DataType dataType) {
        return new Literal(value, dataType);
    }

    public Option<Tuple2<Object, DataType>> unapply(Literal x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.value(), (Object)x$0.dataType()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Literal$.class);
    }

    public static final /* synthetic */ boolean $anonfun$validateLiteralValue$2(Literal$ $this, InternalRow row$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DataType dt = (DataType)tuple2._1();
        int i = tuple2._2$mcI$sp();
        boolean bl = $this.doValidate$1(row$1.get(i, dt), dt);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean doValidate$1(Object v, DataType dataType) {
        while (true) {
            DataType dataType2 = dataType;
            if (v == null) {
                return true;
            }
            if (BooleanType$.MODULE$.equals(dataType2)) {
                return v instanceof Boolean;
            }
            if (ByteType$.MODULE$.equals(dataType2)) {
                return v instanceof Byte;
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return v instanceof Short;
            }
            boolean bl = IntegerType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof YearMonthIntervalType);
            if (bl) {
                return v instanceof Integer;
            }
            if (TimestampNTZType$.MODULE$.equals(dataType2) && Utils$.MODULE$.isTesting()) {
                return v instanceof Long;
            }
            boolean bl2 = LongType$.MODULE$.equals(dataType2) ? true : (TimestampType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof DayTimeIntervalType);
            if (bl2) {
                return v instanceof Long;
            }
            if (FloatType$.MODULE$.equals(dataType2)) {
                return v instanceof Float;
            }
            if (DoubleType$.MODULE$.equals(dataType2)) {
                return v instanceof Double;
            }
            if (dataType2 instanceof DecimalType) {
                return v instanceof Decimal;
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
                return v instanceof CalendarInterval;
            }
            if (BinaryType$.MODULE$.equals(dataType2)) {
                return v instanceof byte[];
            }
            if (StringType$.MODULE$.equals(dataType2)) {
                return v instanceof UTF8String;
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                if (!(v instanceof InternalRow)) return false;
                InternalRow row = (InternalRow)v;
                if (!ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)x$1 -> x$1.dataType(), ClassTag$.MODULE$.apply(DataType.class))))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Literal$.$anonfun$validateLiteralValue$2(this, row, x0$1)))) return false;
                return true;
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                if (!(v instanceof ArrayData)) return false;
                ArrayData ar = (ArrayData)v;
                if (ar.numElements() != 0) {
                    dataType = arrayType.elementType();
                    v = ar.get(0, arrayType.elementType());
                    continue;
                }
                if (!true) return false;
                return true;
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                if (!(v instanceof MapData)) return false;
                MapData map = (MapData)v;
                if (this.doValidate$1(map.keyArray(), ArrayType$.MODULE$.apply(mapType.keyType()))) {
                    dataType = ArrayType$.MODULE$.apply(mapType.valueType());
                    v = map.valueArray();
                    continue;
                }
                if (!false) return false;
                return true;
            }
            if (dataType2 instanceof ObjectType) {
                ObjectType objectType = (ObjectType)dataType2;
                Class<?> cls = objectType.cls();
                return cls.isInstance(v);
            }
            if (!(dataType2 instanceof UserDefinedType)) return false;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
    }

    private Literal$() {
    }
}

