/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.NoopFilters;
import org.apache.spark.sql.catalyst.OrderedFilters;
import org.apache.spark.sql.catalyst.StructFilters;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tUg\u0001B\u0017/\u0001mB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003S\u0011!9\u0006A!A!\u0002\u0013A\u0006\"\u00026\u0001\t\u0003Y\u0007\"\u00026\u0001\t\u0003\t\b\"\u00026\u0001\t\u0003)X\u0001B=\u0001\tiD\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005-\u0002\u0001)A\u0005\u0003+A\u0011\"!\f\u0001\u0005\u0004%I!a\f\t\u000f\u0005E\u0002\u0001)A\u0005\u0013\"I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011Q\u0007\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u00028!I\u0011q\n\u0001C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002T!I\u0011q\r\u0001C\u0002\u0013%\u0011\u0011\u000e\u0005\t\u0003c\u0002\u0001\u0015!\u0003\u0002l!Q\u00111\u000f\u0001\t\u0006\u0004%I!!\u001e\t\u0015\u0005\r\u0005\u0001#b\u0001\n\u0013\t)\b\u0003\u0006\u0002\u0006\u0002A)\u0019!C\u0005\u0003\u000fC\u0011\"a$\u0001\u0005\u0004%I!!%\t\u0011\u0005m\u0005\u0001)A\u0005\u0003'Cq!!(\u0001\t\u0013\ty\nC\u0005\u00020\u0002\u0011\r\u0011\"\u0003\u00022\"A\u0011\u0011\u0018\u0001!\u0002\u0013\t\u0019\fC\u0005\u0002<\u0002\u0011\r\u0011\"\u0003\u0002>\"A\u0011Q\u001a\u0001!\u0002\u0013\ty\fC\u0004\u0002P\u0002!\t!!5\t\u0013\u0005-\b!%A\u0005\u0002\u00055\bb\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\n\u0005/\u0001!\u0019!C\u0001\u00053A\u0001B!\u000b\u0001A\u0003%!1\u0004\u0005\n\u0005W\u0001!\u0019!C\u0005\u0005[A\u0001B!\u0010\u0001A\u0003%!q\u0006\u0005\b\u0005\u007f\u0001A\u0011\u0002B!\u000f!\u00119E\fE\u0001e\t%caB\u0017/\u0011\u0003\u0011$1\n\u0005\u0007U\u001e\"\tA!\u0014\t\u000f\t=s\u0005\"\u0001\u0003R!9!1O\u0014\u0005\u0002\tU\u0004b\u0002BFO\u0011%!Q\u0012\u0005\b\u0005\u000b<C\u0011\u0001Bd\u0005=)f.\u001b<pG&$\u0018\u0010U1sg\u0016\u0014(BA\u00181\u0003\r\u00197O\u001e\u0006\u0003cI\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003gQ\n1a]9m\u0015\t)d'A\u0003ta\u0006\u00148N\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<7\u0001A\n\u0004\u0001q\u0012\u0005CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g\r\u0005\u0002D\r6\tAI\u0003\u0002Fi\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002H\t\n9Aj\\4hS:<\u0017A\u00033bi\u0006\u001c6\r[3nCB\u0011!*T\u0007\u0002\u0017*\u0011AJM\u0001\u0006if\u0004Xm]\u0005\u0003\u001d.\u0013!b\u0015;sk\u000e$H+\u001f9f\u00039\u0011X-];je\u0016$7k\u00195f[\u0006\fqa\u001c9uS>t7/F\u0001S!\t\u0019F+D\u0001/\u0013\t)fF\u0001\u0006D'Z{\u0005\u000f^5p]N\f\u0001b\u001c9uS>t7\u000fI\u0001\bM&dG/\u001a:t!\rI\u0016\r\u001a\b\u00035~s!a\u00170\u000e\u0003qS!!\u0018\u001e\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0014B\u00011?\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\u0007M+\u0017O\u0003\u0002a}A\u0011Q\r[\u0007\u0002M*\u0011qMM\u0001\bg>,(oY3t\u0013\tIgM\u0001\u0004GS2$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b1lgn\u001c9\u0011\u0005M\u0003\u0001\"\u0002%\u0007\u0001\u0004I\u0005\"B(\u0007\u0001\u0004I\u0005\"\u0002)\u0007\u0001\u0004\u0011\u0006\"B,\u0007\u0001\u0004AF\u0003\u00027sgRDQ\u0001S\u0004A\u0002%CQaT\u0004A\u0002%CQ\u0001U\u0004A\u0002I#2\u0001\u001c<y\u0011\u00159\b\u00021\u0001J\u0003\u0019\u00198\r[3nC\")\u0001\u000b\u0003a\u0001%\nqa+\u00197vK\u000e{gN^3si\u0016\u0014\b#B\u001f|{\u0006-\u0011B\u0001??\u0005%1UO\\2uS>t\u0017\u0007E\u0002\u007f\u0003\u000bq1a`A\u0001!\tYf(C\u0002\u0002\u0004y\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u0002}A\u0019Q(!\u0004\n\u0007\u0005=aHA\u0002B]f\fQ\u0002^8lK:Le\u000eZ3y\u0003J\u0014XCAA\u000b!\u0015i\u0014qCA\u000e\u0013\r\tIB\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002 \t9\u0011J\u001c;fO\u0016\u0014\u0018A\u0004;pW\u0016t\u0017J\u001c3fq\u0006\u0013(\u000fI\u0001\ra\u0006\u00148/\u001a3TG\",W.Y\u000b\u0002\u0013\u0006i\u0001/\u0019:tK\u0012\u001c6\r[3nC\u0002\n\u0011\u0002^8lK:L'0\u001a:\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0013j!!a\u000f\u000b\u0007=\niD\u0003\u0003\u0002@\u0005\u0005\u0013a\u00029beN,'o\u001d\u0006\u0005\u0003\u0007\n)%A\u0005v]&4xnY5us*\u0011\u0011qI\u0001\u0004G>l\u0017\u0002BA&\u0003w\u0011\u0011bQ:w!\u0006\u00148/\u001a:\u0002\u0015Q|7.\u001a8ju\u0016\u0014\b%A\u0006sKF,\u0018N]3e%><XCAA*!\u0015i\u0014QKA-\u0013\r\t9F\u0010\u0002\u0005'>lW\r\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\ty\u0006M\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002d\u0005u#AE$f]\u0016\u0014\u0018nY%oi\u0016\u0014h.\u00197S_^\fAB]3rk&\u0014X\r\u001a*po\u0002\naA\\8S_^\u001cXCAA6\u001d\ri\u0014QN\u0005\u0004\u0003_r\u0014\u0001\u0002(p]\u0016\fqA\\8S_^\u001c\b%\u0001\nuS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014XCAA<!\u0011\tI(a \u000e\u0005\u0005m$bAA?a\u0005!Q\u000f^5m\u0013\u0011\t\t)a\u001f\u0003%QKW.Z:uC6\u0004hi\u001c:nCR$XM]\u0001\u0016i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3s\u00035!\u0017\r^3G_Jl\u0017\r\u001e;feV\u0011\u0011\u0011\u0012\t\u0005\u0003s\nY)\u0003\u0003\u0002\u000e\u0006m$!\u0004#bi\u00164uN]7biR,'/\u0001\u0006dgZ4\u0015\u000e\u001c;feN,\"!a%\u0011\t\u0005U\u0015qS\u0007\u0002a%\u0019\u0011\u0011\u0014\u0019\u0003\u001bM#(/^2u\r&dG/\u001a:t\u0003-\u00197O\u001e$jYR,'o\u001d\u0011\u0002\u001f\u001d,GoQ;se\u0016tG/\u00138qkR,\"!!)\u0011\t\u0005\r\u00161V\u0007\u0003\u0003KS1\u0001TAT\u0015\r\tI\u000bN\u0001\u0007k:\u001c\u0018MZ3\n\t\u00055\u0016Q\u0015\u0002\u000b+R3\u0005h\u0015;sS:<\u0017a\u0004<bYV,7i\u001c8wKJ$XM]:\u0016\u0005\u0005M\u0006#B\u001f\u0002\u0018\u0005U\u0006cAA\\\u00135\t\u0001!\u0001\twC2,XmQ8om\u0016\u0014H/\u001a:tA\u0005iA-Z2j[\u0006d\u0007+\u0019:tKJ,\"!a0\u0011\u000buZX0!1\u0011\t\u0005\r\u0017\u0011Z\u0007\u0003\u0003\u000bTA!a2\u0002$\u0005!Q.\u0019;i\u0013\u0011\tY-!2\u0003\u0015\tKw\rR3dS6\fG.\u0001\beK\u000eLW.\u00197QCJ\u001cXM\u001d\u0011\u0002\u001b5\f7.Z\"p]Z,'\u000f^3s)!\t),a5\u0002X\u0006\u0005\bBBAk=\u0001\u0007Q0\u0001\u0003oC6,\u0007bBAm=\u0001\u0007\u00111\\\u0001\tI\u0006$\u0018\rV=qKB\u0019!*!8\n\u0007\u0005}7J\u0001\u0005ECR\fG+\u001f9f\u0011%\t\u0019O\bI\u0001\u0002\u0004\t)/\u0001\u0005ok2d\u0017M\u00197f!\ri\u0014q]\u0005\u0004\u0003St$a\u0002\"p_2,\u0017M\\\u0001\u0018[\u0006\\WmQ8om\u0016\u0014H/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a<+\t\u0005\u0015\u0018\u0011_\u0016\u0003\u0003g\u0004B!!>\u0002\u00006\u0011\u0011q\u001f\u0006\u0005\u0003s\fY0A\u0005v]\u000eDWmY6fI*\u0019\u0011Q  \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0002\u0005](!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006ia.\u001e7m'\u00064W\rR1uk6$\"Ba\u0002\u0003\u000e\tE!1\u0003B\u000b)\u0011\tYA!\u0003\t\u000f\t-\u0001\u00051\u0001\u00026\u0006I1m\u001c8wKJ$XM\u001d\u0005\u0007\u0005\u001f\u0001\u0003\u0019A?\u0002\u000b\u0011\fG/^7\t\r\u0005U\u0007\u00051\u0001~\u0011\u001d\t\u0019\u000f\ta\u0001\u0003KDQ\u0001\u0015\u0011A\u0002I\u000bQ\u0001]1sg\u0016,\"Aa\u0007\u0011\u000buZXP!\b\u0011\u000bu\u0012yBa\t\n\u0007\t\u0005bH\u0001\u0004PaRLwN\u001c\t\u0005\u0003+\u0013)#C\u0002\u0003(A\u00121\"\u00138uKJt\u0017\r\u001c*po\u00061\u0001/\u0019:tK\u0002\n\u0001bZ3u)>\\WM\\\u000b\u0003\u0005_\u0001\u0002\"\u0010B\u0019\u0005k\u00119$`\u0005\u0004\u0005gq$!\u0003$v]\u000e$\u0018n\u001c83!\u0011i\u0014qC?\u0011\u0007u\u0012I$C\u0002\u0003<y\u00121!\u00138u\u0003%9W\r\u001e+pW\u0016t\u0007%A\u0004d_:4XM\u001d;\u0015\t\tu!1\t\u0005\b\u0005\u000b*\u0003\u0019\u0001B\u001b\u0003\u0019!xn[3og\u0006yQK\\5w_\u000eLG/\u001f)beN,'\u000f\u0005\u0002TOM\u0011q\u0005\u0010\u000b\u0003\u0005\u0013\na\u0002^8lK:L'0Z*ue\u0016\fW\u000e\u0006\u0006\u0003T\te#\u0011\u000eB7\u0005_\u0002R!\u0017B+\u0005kI1Aa\u0016d\u0005!IE/\u001a:bi>\u0014\bb\u0002B.S\u0001\u0007!QL\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\u0011\u0011\u0019'a\t\u0002\u0005%|\u0017\u0002\u0002B4\u0005C\u00121\"\u00138qkR\u001cFO]3b[\"9!1N\u0015A\u0002\u0005\u0015\u0018\u0001E:i_VdG\r\u0012:pa\"+\u0017\rZ3s\u0011\u001d\t\u0019$\u000ba\u0001\u0003oAaA!\u001d*\u0001\u0004i\u0018\u0001C3oG>$\u0017N\\4\u0002\u0017A\f'o]3TiJ,\u0017-\u001c\u000b\u000b\u0005o\u0012IHa\u001f\u0003\u0000\t%\u0005#B-\u0003V\t\r\u0002b\u0002B.U\u0001\u0007!Q\f\u0005\u0007\u0005{R\u0003\u0019\u00017\u0002\rA\f'o]3s\u0011\u001d\u0011\tI\u000ba\u0001\u0005\u0007\u000bQ\u0002[3bI\u0016\u00148\t[3dW\u0016\u0014\bcA*\u0003\u0006&\u0019!q\u0011\u0018\u0003!\r\u001bf\u000bS3bI\u0016\u00148\t[3dW\u0016\u0014\b\"B<+\u0001\u0004I\u0015!D2p]Z,'\u000f^*ue\u0016\fW.\u0006\u0003\u0003\u0010\n}EC\u0003BI\u0005_\u0013\tLa-\u0003DR!!1\u0013BV%\u0015\u0011)\n\u0010BM\r\u0019\u00119j\u000b\u0001\u0003\u0014\naAH]3gS:,W.\u001a8u}A)\u0011L!\u0016\u0003\u001cB!!Q\u0014BP\u0019\u0001!qA!),\u0005\u0004\u0011\u0019KA\u0001U#\u0011\u0011)+a\u0003\u0011\u0007u\u00129+C\u0002\u0003*z\u0012qAT8uQ&tw\rC\u0004\u0003@-\u0002\rA!,\u0011\ruZ(Q\u0007BN\u0011\u001d\u0011Yf\u000ba\u0001\u0005;Bq!a\r,\u0001\u0004\t9\u0004C\u0004\u00036.\u0002\rAa.\u0002\u0019!\fg\u000e\u001a7f\u0011\u0016\fG-\u001a:\u0011\u000bu\u0012IL!0\n\u0007\tmfHA\u0005Gk:\u001cG/[8oaA\u0019QHa0\n\u0007\t\u0005gH\u0001\u0003V]&$\bB\u0002B9W\u0001\u0007Q0A\u0007qCJ\u001cX-\u0013;fe\u0006$xN\u001d\u000b\u000b\u0005o\u0012IMa4\u0003R\nM\u0007b\u0002BfY\u0001\u0007!QZ\u0001\u0006Y&tWm\u001d\t\u00053\nUS\u0010\u0003\u0004\u0003~1\u0002\r\u0001\u001c\u0005\b\u0005\u0003c\u0003\u0019\u0001BB\u0011\u00159H\u00061\u0001J\u0001")
public class UnivocityParser
implements Logging {
    private TimestampFormatter timestampFormatter;
    private TimestampFormatter timestampNTZFormatter;
    private DateFormatter dateFormatter;
    private final StructType dataSchema;
    private final StructType requiredSchema;
    private final CSVOptions options;
    private final Integer[] tokenIndexArr;
    private final StructType parsedSchema;
    private final CsvParser tokenizer;
    private final Some<GenericInternalRow> requiredRow;
    private final None$ noRows;
    private final StructFilters csvFilters;
    private final Function1<String, Object>[] valueConverters;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function1<String, Option<InternalRow>> parse;
    private final Function2<String[], Object, String> getToken;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Iterator<InternalRow> parseIterator(Iterator<String> lines, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType schema) {
        return UnivocityParser$.MODULE$.parseIterator(lines, parser, headerChecker, schema);
    }

    public static Iterator<InternalRow> parseStream(InputStream inputStream, UnivocityParser parser, CSVHeaderChecker headerChecker, StructType schema) {
        return UnivocityParser$.MODULE$.parseStream(inputStream, parser, headerChecker, schema);
    }

    public static Iterator<String[]> tokenizeStream(InputStream inputStream, boolean shouldDropHeader, CsvParser tokenizer, String encoding) {
        return UnivocityParser$.MODULE$.tokenizeStream(inputStream, shouldDropHeader, tokenizer, encoding);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CSVOptions options() {
        return this.options;
    }

    private Integer[] tokenIndexArr() {
        return this.tokenIndexArr;
    }

    private StructType parsedSchema() {
        return this.parsedSchema;
    }

    public CsvParser tokenizer() {
        return this.tokenizer;
    }

    private Some<GenericInternalRow> requiredRow() {
        return this.requiredRow;
    }

    private None$ noRows() {
        return this.noRows;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.timestampFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampFormatInRead(), this.options().zoneId(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampFormatter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.timestampFormatter$lzycompute() : this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampNTZFormatInRead(), this.options().zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.timestampNTZFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.timestampNTZFormatter$lzycompute() : this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormatInRead(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dateFormatter$lzycompute() : this.dateFormatter;
    }

    private StructFilters csvFilters() {
        return this.csvFilters;
    }

    private UTF8String getCurrentInput() {
        String currentContent = this.tokenizer().getContext().currentParsedContent();
        return currentContent == null ? null : UTF8String.fromString((String)StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(currentContent)));
    }

    private Function1<String, Object>[] valueConverters() {
        return this.valueConverters;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public Function1<String, Object> makeConverter(String name, DataType dataType, boolean nullable) {
        Function1<String, Object> function1;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ByteType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(x$1))));
        } else if (dataType2 instanceof ShortType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(x$2))));
        } else if (dataType2 instanceof IntegerType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3))));
        } else if (dataType2 instanceof LongType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$4))));
        } else if (dataType2 instanceof FloatType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x0$1 -> {
                Float f;
                String string = x0$1;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    f = BoxesRunTime.boxToFloat((float)Float.NaN);
                } else {
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        f = BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
                    } else {
                        String string6 = this.options().positiveInf();
                        String string7 = string;
                        f = !(string6 != null ? !string6.equals(string7) : string7 != null) ? BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY) : BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(string)));
                    }
                }
                return f;
            });
        } else if (dataType2 instanceof DoubleType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x0$2 -> {
                Double d;
                String string = x0$2;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    d = BoxesRunTime.boxToDouble((double)Double.NaN);
                } else {
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        d = BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
                    } else {
                        String string6 = this.options().positiveInf();
                        String string7 = string;
                        d = !(string6 != null ? !string6.equals(string7) : string7 != null) ? BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY) : BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(string)));
                    }
                }
                return d;
            });
        } else if (dataType2 instanceof BooleanType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$5))));
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> Decimal$.MODULE$.apply((BigDecimal)this.decimalParser().apply(datum), decimalType.precision(), decimalType.scale()));
        } else if (dataType2 instanceof TimestampType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToLong((long)this.timestampFormatter().parse((String)datum));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                    Object object2 = DateTimeUtils$.MODULE$.stringToTimestamp(str, this.options().zoneId()).getOrElse((Function0 & Serializable)() -> {
                        throw e;
                    });
                    object = object2;
                }
                return object;
            });
        } else if (dataType2 instanceof TimestampNTZType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> BoxesRunTime.boxToLong((long)UnivocityParser.$anonfun$makeConverter$21(this, datum)));
        } else if (dataType2 instanceof DateType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToInteger((int)this.dateFormatter().parse((String)datum));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                    Object object2 = DateTimeUtils$.MODULE$.stringToDate(str).getOrElse((Function0 & Serializable)() -> {
                        throw e;
                    });
                    object = object2;
                }
                return object;
            });
        } else if (dataType2 instanceof StringType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1));
        } else if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)datum)));
        } else if (dataType2 instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> new Cast(Literal$.MODULE$.apply(datum), yearMonthIntervalType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()));
        } else if (dataType2 instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable)datum -> new Cast(Literal$.MODULE$.apply(datum), dayTimeIntervalType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()).eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow()));
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            function1 = this.makeConverter(name, userDefinedType.sqlType(), nullable);
        } else {
            throw QueryExecutionErrors$.MODULE$.unsupportedTypeError(dataType);
        }
        return function1;
    }

    public boolean makeConverter$default$3() {
        return true;
    }

    private Object nullSafeDatum(String datum, String name, boolean nullable, CSVOptions options, Function1<String, Object> converter) {
        Object object;
        String string = datum;
        String string2 = options.nullValue();
        if (!(string == null ? string2 != null : !string.equals(string2)) || datum == null) {
            if (!nullable) {
                throw QueryExecutionErrors$.MODULE$.foundNullValueForNotNullableFieldError(name);
            }
            object = null;
        } else {
            object = converter.apply((Object)datum);
        }
        return object;
    }

    public Function1<String, Option<InternalRow>> parse() {
        return this.parse;
    }

    private Function2<String[], Object, String> getToken() {
        return this.getToken;
    }

    public Option<InternalRow> org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(String[] tokens) {
        Some<GenericInternalRow> some;
        if (tokens == null) {
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable)() -> this.getCurrentInput(), (Function0<Option<InternalRow>>)(Function0 & Serializable)() -> None$.MODULE$, QueryExecutionErrors$.MODULE$.malformedCSVRecordError());
        }
        None$ badRecordException = tokens.length != this.parsedSchema().length() ? new Some((Object)QueryExecutionErrors$.MODULE$.malformedCSVRecordError()) : None$.MODULE$;
        GenericInternalRow row = (GenericInternalRow)this.requiredRow().get();
        boolean skipRow = false;
        for (int i = 0; i < this.requiredSchema.length(); ++i) {
            try {
                if (skipRow) {
                    row.setNullAt(i);
                    continue;
                }
                row.update(i, this.valueConverters()[i].apply(this.getToken().apply((Object)tokens, (Object)BoxesRunTime.boxToInteger((int)i))));
                if (!this.csvFilters().skipRow(row, i)) continue;
                skipRow = true;
                continue;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkUpgradeException) {
                    SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable2;
                    throw sparkUpgradeException;
                }
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    badRecordException = badRecordException.orElse((Function0 & Serializable)() -> new Some((Object)e));
                    row.setNullAt(i);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        if (skipRow) {
            some = this.noRows();
        } else {
            if (badRecordException.isDefined()) {
                throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable)() -> this.getCurrentInput(), (Function0<Option<InternalRow>>)(Function0 & Serializable)() -> Option$.MODULE$.option2Iterable(this.requiredRow()).headOption(), (Throwable)badRecordException.get());
            }
            some = this.requiredRow();
        }
        return some;
    }

    public static final /* synthetic */ long $anonfun$makeConverter$21(UnivocityParser $this, String datum) {
        return $this.timestampNTZFormatter().parseWithoutTimeZone(datum, false);
    }

    public static final /* synthetic */ String $anonfun$getToken$1(String[] tokens, int index) {
        return tokens[index];
    }

    public static final /* synthetic */ String $anonfun$getToken$2(UnivocityParser $this, String[] tokens, int index) {
        return tokens[Predef$.MODULE$.Integer2int($this.tokenIndexArr()[index])];
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options, Seq<Filter> filters) {
        this.dataSchema = dataSchema;
        this.requiredSchema = requiredSchema;
        this.options = options;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(requiredSchema.toSet().subsetOf(dataSchema.toSet()), (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("requiredSchema (").append($this.requiredSchema.catalogString()).append(") should be the subset of ").toString()).append(new StringBuilder(14).append("dataSchema (").append($this.dataSchema.catalogString()).append(").").toString()).toString());
        this.tokenIndexArr = (Integer[])((IterableOnceOps)requiredSchema.map((Function1 & Serializable)f -> $this.dataSchema.indexOf(f))).toArray(ClassTag$.MODULE$.apply(Integer.class));
        this.parsedSchema = options.columnPruning() ? requiredSchema : dataSchema;
        CsvParserSettings parserSetting = options.asParserSettings();
        Object object = this.parsedSchema().length() < dataSchema.length() ? parserSetting.selectIndexes(this.tokenIndexArr()) : BoxedUnit.UNIT;
        this.tokenizer = new CsvParser(parserSetting);
        this.requiredRow = new Some((Object)new GenericInternalRow(requiredSchema.length()));
        this.noRows = None$.MODULE$;
        this.csvFilters = SQLConf$.MODULE$.get().csvFilterPushDown() ? new OrderedFilters(filters, requiredSchema) : new NoopFilters();
        this.valueConverters = (Function1[])((IterableOnceOps)requiredSchema.map((Function1 & Serializable)f -> this.makeConverter(f.name(), f.dataType(), f.nullable()))).toArray(ClassTag$.MODULE$.apply(Function1.class));
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.parse = options.columnPruning() && requiredSchema.isEmpty() ? (Function1 & Serializable)x$6 -> new Some((Object)InternalRow$.MODULE$.empty()) : (Function1 & Serializable)input -> this.org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(this.tokenizer().parseLine(input));
        this.getToken = options.columnPruning() ? (Function2 & Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$1(tokens, BoxesRunTime.unboxToInt((Object)index)) : (Function2 & Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$2(this, tokens, BoxesRunTime.unboxToInt((Object)index));
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options) {
        this(dataSchema, requiredSchema, options, (Seq<Filter>)((Seq)package$.MODULE$.Seq().empty()));
    }

    public UnivocityParser(StructType schema, CSVOptions options) {
        this(schema, schema, options);
    }
}

