/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ConditionalExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NaNvl$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns `expr1` if it's not NaN, or `expr2` otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double), 123);\n       123.0\n  ", since="1.5.0", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u000f\u001f\u0001.B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u00151\b\u0001\"\u0011x\u0011\u001d\tY\u0001\u0001C)\u0003\u001bA\u0011\"a\u0006\u0001\u0003\u0003%\t!!\u0007\t\u0013\u0005}\u0001!%A\u0005\u0002\u0005\u0005\u0002\"CA\u001c\u0001E\u0005I\u0011AA\u0011\u0011%\tI\u0004AA\u0001\n\u0003\nY\u0004C\u0005\u0002N\u0001\t\t\u0011\"\u0001\u0002P!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003?\u0002\u0011\u0011!C!\u0003CB\u0011\"a\u001c\u0001\u0003\u0003%\t!!\u001d\t\u0013\u0005m\u0004!!A\u0005B\u0005ut!CAQ=\u0005\u0005\t\u0012AAR\r!ib$!A\t\u0002\u0005\u0015\u0006BB$\u0018\t\u0003\t\u0019\fC\u0005\u00026^\t\t\u0011\"\u0012\u00028\"I\u0011\u0011X\f\u0002\u0002\u0013\u0005\u00151\u0018\u0005\n\u0003\u0003<\u0012\u0011!CA\u0003\u0007D\u0011\"!6\u0018\u0003\u0003%I!a6\u0003\u000b9\u000bgJ\u001e7\u000b\u0005}\u0001\u0013aC3yaJ,7o]5p]NT!!\t\u0012\u0002\u0011\r\fG/\u00197zgRT!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u00171gYb\u0004CA\u0017/\u001b\u0005q\u0012BA\u0018\u001f\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002.c%\u0011!G\b\u0002\u0016\u0007>tG-\u001b;j_:\fG.\u0012=qe\u0016\u001c8/[8o!\tiC'\u0003\u00026=\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0004Qe>$Wo\u0019;\u0011\u0005]j\u0014B\u0001 9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u0005\u0003\"!\f\"\n\u0005\rs\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA%K\u0017B\u0011Q\u0006\u0001\u0005\u0006\u007f\u0015\u0001\r!\u0011\u0005\u0006\u000b\u0016\u0001\r!Q\u0001\tI\u0006$\u0018\rV=qKV\ta\n\u0005\u0002P%6\t\u0001K\u0003\u0002RE\u0005)A/\u001f9fg&\u00111\u000b\u0015\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003Y\u00032aV0c\u001d\tAVL\u0004\u0002Z96\t!L\u0003\u0002\\U\u00051AH]8pizJ\u0011!O\u0005\u0003=b\nq\u0001]1dW\u0006<W-\u0003\u0002aC\n\u00191+Z9\u000b\u0005yC\u0004CA(d\u0013\t!\u0007K\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006)\u0012\r\\<bsN,e/\u00197vCR,G-\u00138qkR\u001cX#A4\u0011\u0007]{\u0016)\u0001\u0007ce\u0006t7\r[$s_V\u00048/F\u0001k!\r9vlZ\u0001\u0005KZ\fG\u000e\u0006\u0002naB\u0011qG\\\u0005\u0003_b\u00121!\u00118z\u0011\u001d\t(\u0002%AA\u0002I\fQ!\u001b8qkR\u0004\"a\u001d;\u000e\u0003\u0001J!!\u001e\u0011\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$B\u0001\u001f@\u0002\bA\u0011\u0011\u0010`\u0007\u0002u*\u00111PH\u0001\bG>$WmZ3o\u0013\ti(P\u0001\u0005FqB\u00148i\u001c3f\u0011\u0019y8\u00021\u0001\u0002\u0002\u0005\u00191\r\u001e=\u0011\u0007e\f\u0019!C\u0002\u0002\u0006i\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\n-\u0001\r\u0001_\u0001\u0003KZ\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b%\u000by!a\u0005\t\r\u0005EA\u00021\u0001B\u0003\u001dqWm\u001e'fMRDa!!\u0006\r\u0001\u0004\t\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006\u0013\u0006m\u0011Q\u0004\u0005\b\u007f5\u0001\n\u00111\u0001B\u0011\u001d)U\u0002%AA\u0002\u0005\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002$)\u001a\u0011)!\n,\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\r9\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\tYCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003{\u0001B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0003mC:<'BAA$\u0003\u0011Q\u0017M^1\n\t\u0005-\u0013\u0011\t\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0003cA\u001c\u0002T%\u0019\u0011Q\u000b\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u00075\fY\u0006C\u0005\u0002^I\t\t\u00111\u0001\u0002R\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0019\u0011\u000b\u0005\u0015\u00141N7\u000e\u0005\u0005\u001d$bAA5q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0014q\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002t\u0005e\u0004cA\u001c\u0002v%\u0019\u0011q\u000f\u001d\u0003\u000f\t{w\u000e\\3b]\"A\u0011Q\f\u000b\u0002\u0002\u0003\u0007Q.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003g\ny\b\u0003\u0005\u0002^U\t\t\u00111\u0001nQM\u0001\u00111QAE\u0003\u0017\u000by)!%\u0002\u0016\u0006]\u00151TAO!\ri\u0013QQ\u0005\u0004\u0003\u000fs\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u001b\u000bQj\u0018$V\u001d\u000e{\u0006&\u001a=qeFb\u0003%\u001a=qeJJ\u0003%\f\u0011SKR,(O\\:!A\u0016D\bO]\u0019aA%4\u0007%\u001b;(g\u0002rw\u000e\u001e\u0011OC:c\u0003e\u001c:!A\u0016D\bO\u001d\u001aaA=$\b.\u001a:xSN,g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019*A)\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r\f7\u000f\u001e\u0015(\u001d\u0006tu\u0005I1tA\u0011|WO\u00197fS1\u0002\u0013GM\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$g\r\u00181\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAM\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\ty*A\td_:$\u0017\u000e^5p]\u0006dwLZ;oGN\fQAT1Om2\u0004\"!L\f\u0014\t]\t9\u000b\u0010\t\b\u0003S\u000by+Q!J\u001b\t\tYKC\u0002\u0002.b\nqA];oi&lW-\u0003\u0003\u00022\u0006-&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u00111U\u0001\ti>\u001cFO]5oOR\u0011\u0011QH\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0013\u0006u\u0016q\u0018\u0005\u0006\u007fi\u0001\r!\u0011\u0005\u0006\u000bj\u0001\r!Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)-!5\u0011\u000b]\n9-a3\n\u0007\u0005%\u0007H\u0001\u0004PaRLwN\u001c\t\u0006o\u00055\u0017)Q\u0005\u0004\u0003\u001fD$A\u0002+va2,'\u0007\u0003\u0005\u0002Tn\t\t\u00111\u0001J\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002ZB!\u0011qHAn\u0013\u0011\ti.!\u0011\u0003\r=\u0013'.Z2u\u0001")
public class NaNvl
extends BinaryExpression
implements ConditionalExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(NaNvl naNvl) {
        return NaNvl$.MODULE$.unapply(naNvl);
    }

    public static Function1<Tuple2<Expression, Expression>, NaNvl> tupled() {
        return NaNvl$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NaNvl>> curried() {
        return NaNvl$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final boolean foldable() {
        return ConditionalExpression.foldable$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<Expression> alwaysEvaluatedInputs() {
        Expression expression = this.left();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public Seq<Seq<Expression>> branchGroups() {
        return (Seq)new .colon.colon(this.children(), (List)Nil$.MODULE$);
    }

    @Override
    public Object eval(InternalRow input) {
        Object value = this.left().eval(input);
        if (value == null) {
            return null;
        }
        DataType dataType = this.left().dataType();
        if (DoubleType$.MODULE$.equals(dataType)) {
            if (!Double.isNaN(BoxesRunTime.unboxToDouble((Object)value))) {
                return value;
            }
            return this.right().eval(input);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            if (!Float.isNaN(BoxesRunTime.unboxToFloat((Object)value))) {
                return value;
            }
            return this.right().eval(input);
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        DataType dataType = this.left().dataType();
        if (DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType)) {
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = false;\n          ", " ", " = ", ";\n          if (", ") {\n            ", " = true;\n          } else {\n            if (!Double.isNaN(", ")) {\n              ", " = ", ";\n            } else {\n              ", "\n              if (", ") {\n                ", " = true;\n              } else {\n                ", " = ", ";\n              }\n            }\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), leftGen.isNull(), ev.isNull(), leftGen.value(), ev.value(), leftGen.value(), rightGen.code(), rightGen.isNull(), ev.isNull(), ev.value(), rightGen.value()})), ev.copy$default$2(), ev.copy$default$3());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public NaNvl withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public NaNvl copy(Expression left, Expression right) {
        return new NaNvl(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "NaNvl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NaNvl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NaNvl)) return false;
        boolean bl = true;
        if (!bl) return false;
        NaNvl naNvl = (NaNvl)x$1;
        Expression expression = this.left();
        Expression expression2 = naNvl.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = naNvl.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!naNvl.canEqual(this)) return false;
        return true;
    }

    public NaNvl(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ConditionalExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

