/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Abs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerExactNumeric$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongExactNumeric$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the absolute value of the numeric or interval value.", examples="\n    Examples:\n      > SELECT _FUNC_(-1);\n       1\n      > SELECT _FUNC_(INTERVAL -'1-1' YEAR TO MONTH);\n       1-1\n  ", since="1.2.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\tE\t\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\u0011\u0006\u0001\"\u0001X\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015a\u0007\u0001\"\u0011n\u0011!\t\b\u0001#b\u0001\n\u0013\u0011\b\"B=\u0001\t\u0003R\bbBA\t\u0001\u0011E\u00131\u0003\u0005\b\u00033\u0001A\u0011IA\u000e\u0011\u001d\t\u0019\u0003\u0001C)\u0003KA\u0011\"a\u000b\u0001\u0003\u0003%\t!!\f\t\u0013\u0005M\u0002!%A\u0005\u0002\u0005U\u0002\"CA&\u0001E\u0005I\u0011AA'\u0011%\t\t\u0006AA\u0001\n\u0003\n\u0019\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0001\u0002h!I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000f\u0005\n\u0003o\u0002\u0011\u0011!C!\u0003sB\u0011\"!\"\u0001\u0003\u0003%\t!a\"\t\u0013\u0005-\u0005!!A\u0005B\u00055u!CAYC\u0005\u0005\t\u0012AAZ\r!\u0001\u0013%!A\t\u0002\u0005U\u0006B\u0002*\u0019\t\u0003\t\u0019\rC\u0005\u0002Fb\t\t\u0011\"\u0012\u0002H\"I\u0011\u0011\u001a\r\u0002\u0002\u0013\u0005\u00151\u001a\u0005\n\u0003#D\u0012\u0013!C\u0001\u0003\u001bB\u0011\"a5\u0019\u0003\u0003%\t)!6\t\u0013\u0005\u001d\b$%A\u0005\u0002\u00055\u0003\"CAu1\u0005\u0005I\u0011BAv\u0005\r\t%m\u001d\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M1\u0001aL\u001a7{\r\u0003\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\r\u001b\n\u0005U\n#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005]RdB\u0001\u00199\u0013\tI\u0014%A\u0004qC\u000e\\\u0017mZ3\n\u0005mb$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003s\u0005\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002?\t&\u0011Qi\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0011B\u0011\u0001'S\u0005\u0003\u0015\u0006\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005Ya-Y5m\u001f:,%O]8s+\u0005q\u0005C\u0001 P\u0013\t\u0001vHA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\r!VK\u0016\t\u0003a\u0001AQAR\u0003A\u0002!Cq\u0001T\u0003\u0011\u0002\u0003\u0007a\n\u0006\u0002U1\")aI\u0002a\u0001\u0011\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003m\u00032\u0001X2g\u001d\ti&M\u0004\u0002_C6\tqL\u0003\u0002a[\u00051AH]8pizJ\u0011\u0001Q\u0005\u0003s}J!\u0001Z3\u0003\u0007M+\u0017O\u0003\u0002:\u007fA\u0011qM[\u0007\u0002Q*\u0011\u0011.J\u0001\u0006if\u0004Xm]\u0005\u0003W\"\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u001c\t\u0003O>L!\u0001\u001d5\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fqA\\;nKJL7-F\u0001t!\raFO^\u0005\u0003k\u0016\u0014qAT;nKJL7\r\u0005\u0002?o&\u0011\u0001p\u0010\u0002\u0004\u0003:L\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0015Y\u00181AA\u0007!\tax0D\u0001~\u0015\tq\u0018%A\u0004d_\u0012,w-\u001a8\n\u0007\u0005\u0005QP\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t)A\u0003a\u0001\u0003\u000f\t1a\u0019;y!\ra\u0018\u0011B\u0005\u0004\u0003\u0017i(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u001fQ\u0001\u0019A>\u0002\u0005\u00154\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGc\u0001<\u0002\u0016!1\u0011qC\u0006A\u0002Y\fQ!\u001b8qkR\fQB\u001a7bi\u0006\u0013x-^7f]R\u001cXCAA\u000f!\u0011a\u0016q\u0004<\n\u0007\u0005\u0005RM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019A+a\n\t\r\u0005%R\u00021\u0001I\u0003!qWm^\"iS2$\u0017\u0001B2paf$R\u0001VA\u0018\u0003cAqA\u0012\b\u0011\u0002\u0003\u0007\u0001\nC\u0004M\u001dA\u0005\t\u0019\u0001(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0007\u0016\u0004\u0011\u0006e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015s(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\n\u0016\u0004\u001d\u0006e\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013\u0001\u00027b]\u001eT!!a\u0018\u0002\t)\fg/Y\u0005\u0005\u0003G\nIF\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003S\u00022APA6\u0013\r\tig\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004m\u0006M\u0004\"CA;'\u0005\u0005\t\u0019AA5\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0010\t\u0006\u0003{\n\u0019I^\u0007\u0003\u0003\u007fR1!!!@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\ty(\u0001\u0005dC:,\u0015/^1m)\rq\u0015\u0011\u0012\u0005\t\u0003k*\u0012\u0011!a\u0001m\u00061Q-];bYN$2ATAH\u0011!\t)HFA\u0001\u0002\u00041\bf\u0005\u0001\u0002\u0014\u0006e\u00151TAP\u0003C\u000b)+a*\u0002,\u00065\u0006c\u0001\u0019\u0002\u0016&\u0019\u0011qS\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QT\u0001L?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011bEN|G.\u001e;fAY\fG.^3!_\u001a\u0004C\u000f[3!]VlWM]5dA=\u0014\b%\u001b8uKJ4\u0018\r\u001c\u0011wC2,XML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111U\u0001w\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013J\u0014+F%Z\u000bE\nI\u0017(c5\nt\u0005I-F\u0003J\u0003Ck\u0014\u0011N\u001f:#\u0006*K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c5\n$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005%\u0016!B\u0019/e9\u0002\u0014!B4s_V\u0004\u0018EAAX\u0003)i\u0017\r\u001e5`MVt7m]\u0001\u0004\u0003\n\u001c\bC\u0001\u0019\u0019'\u0011A\u0012qW\"\u0011\u000f\u0005e\u0016q\u0018%O)6\u0011\u00111\u0018\u0006\u0004\u0003{{\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u0003\fYLA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bQ\u000bi-a4\t\u000b\u0019[\u0002\u0019\u0001%\t\u000f1[\u0002\u0013!a\u0001\u001d\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005]\u00171\u001d\t\u0006}\u0005e\u0017Q\\\u0005\u0004\u00037|$AB(qi&|g\u000eE\u0003?\u0003?De*C\u0002\u0002b~\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAs;\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002nB!\u0011qKAx\u0013\u0011\t\t0!\u0017\u0003\r=\u0013'.Z2u\u0001")
public class Abs
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Abs$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Abs abs) {
        return Abs$.MODULE$.unapply(abs);
    }

    public static boolean apply$default$2() {
        return Abs$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Abs> tupled() {
        return Abs$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Abs>> curried() {
        return Abs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.NumericAndAnsiInterval(), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private Numeric<Object> numeric$lzycompute() {
        Abs abs = this;
        synchronized (abs) {
            if (!this.bitmap$0) {
                DataType dataType = this.dataType();
                this.numeric = dataType instanceof DayTimeIntervalType ? LongExactNumeric$.MODULE$ : (dataType instanceof YearMonthIntervalType ? IntegerExactNumeric$.MODULE$ : TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError()));
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        if (!this.bitmap$0) {
            return this.numeric$lzycompute();
        }
        return this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(6).append((String)c).append(".abs()").toString());
        }
        if ((ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType)) && this.failOnError()) {
            String javaBoxedType = CodeGenerator$.MODULE$.boxedType(this.dataType());
            String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
            return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n          |if (").append((String)eval).append(" == ").append(javaBoxedType).append(".MIN_VALUE) {\n          |  throw QueryExecutionErrors.unaryMinusCauseOverflowError(").append((String)eval).append(");\n          |} else if (").append((String)eval).append(" < 0) {\n          |  ").append(ev.value()).append(" = (").append(javaType).append(")-").append((String)eval).append(";\n          |} else {\n          |  ").append(ev.value()).append(" = ").append((String)eval).append(";\n          |}\n          |").toString())).stripMargin());
        }
        if ((IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)) && this.failOnError()) {
            String mathUtils = new StringOps(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName())).stripSuffix("$");
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(24).append((String)c).append(" < 0 ? ").append(mathUtils).append(".negateExact(").append((String)c).append(") : ").append((String)c).toString());
        }
        if (dataType instanceof AnsiIntervalType) {
            String mathUtils = new StringOps(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName())).stripSuffix("$");
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(24).append((String)c).append(" < 0 ? ").append(mathUtils).append(".negateExact(").append((String)c).append(") : ").append((String)c).toString());
        }
        if (dataType instanceof NumericType) {
            NumericType numericType = (NumericType)dataType;
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(24).append("(").append(CodeGenerator$.MODULE$.javaType(numericType)).append(")(java.lang.Math.abs(").append((String)c).append("))").toString());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.numeric().abs(input);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Abs withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Abs copy(Expression child, boolean failOnError) {
        return new Abs(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Abs";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Abs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Abs)) return false;
        boolean bl = true;
        if (!bl) return false;
        Abs abs = (Abs)x$1;
        Expression expression = this.child();
        Expression expression2 = abs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.failOnError() != abs.failOnError()) return false;
        if (!abs.canEqual(this)) return false;
        return true;
    }

    public Abs(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public Abs(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

