/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInTableInsert;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$StoreAssignmentPolicy$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class TableOutputResolver$ {
    public static TableOutputResolver$ MODULE$;

    static {
        new TableOutputResolver$();
    }

    public LogicalPlan resolveOutputColumns(String tableName, Seq<Attribute> expected, LogicalPlan query, boolean byName, SQLConf conf) {
        Seq resolved2;
        Seq seq;
        Seq actualExpectedCols = (Seq)expected.map((Function1 & Serializable & scala.Serializable)attr -> attr.withDataType((DataType)CharVarcharUtils$.MODULE$.getRawType(attr.metadata()).getOrElse((Function0 & Serializable & scala.Serializable)() -> attr.dataType())), Seq$.MODULE$.canBuildFrom());
        if (actualExpectedCols.size() < query.output().size()) {
            throw QueryCompilationErrors$.MODULE$.cannotWriteTooManyColumnsToTableError(tableName, (Seq<Attribute>)actualExpectedCols, query);
        }
        ArrayBuffer errors = new ArrayBuffer();
        if (byName) {
            seq = this.reorderColumnsByName(query.output(), (Seq<Attribute>)actualExpectedCols, conf, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                errors.$plus$eq((Object)x$1);
                return BoxedUnit.UNIT;
            }, this.reorderColumnsByName$default$5());
        } else {
            if (actualExpectedCols.size() > query.output().size()) {
                throw QueryCompilationErrors$.MODULE$.cannotWriteNotEnoughColumnsToTableError(tableName, (Seq<Attribute>)actualExpectedCols, query);
            }
            seq = resolved2 = (Seq)((TraversableLike)query.output().zip((GenIterable)actualExpectedCols, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Attribute queryExpr = (Attribute)tuple2._1();
                    Attribute tableAttr = (Attribute)tuple2._2();
                    return Option$.MODULE$.option2Iterable(MODULE$.checkField(tableAttr, queryExpr, byName, conf, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)err -> {
                        errors.$plus$eq((Object)err);
                        return BoxedUnit.UNIT;
                    }, (Seq<String>)((Seq)new .colon.colon((Object)tableAttr.name(), (List)Nil$.MODULE$))));
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
        }
        if (errors.nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.cannotWriteIncompatibleDataToTableError(tableName, (Seq<String>)errors.toSeq());
        }
        Seq seq2 = resolved2;
        Seq<Attribute> seq3 = query.output();
        if (!(seq2 != null ? !seq2.equals(seq3) : seq3 != null)) {
            return query;
        }
        return new Project((Seq<NamedExpression>)resolved2, query);
    }

    private Seq<NamedExpression> reorderColumnsByName(Seq<NamedExpression> inputCols, Seq<Attribute> expectedCols, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        HashSet matchedCols = HashSet$.MODULE$.empty();
        Seq reordered = (Seq)expectedCols.flatMap((Function1 & Serializable & scala.Serializable)expectedCol -> {
            NamedExpression namedExpression;
            Seq matched = (Seq)inputCols.filter((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)TableOutputResolver$.$anonfun$reorderColumnsByName$2(conf, expectedCol, col)));
            Seq newColPath = (Seq)colPath.$colon$plus((Object)expectedCol.name(), Seq$.MODULE$.canBuildFrom());
            if (matched.isEmpty()) {
                addError.apply((Object)new StringBuilder(37).append("Cannot find data for output column '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)newColPath).quoted()).append("'").toString());
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            if (matched.length() > 1) {
                addError.apply((Object)new StringBuilder(43).append("Ambiguous column name in the input data: '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)newColPath).quoted()).append("'").toString());
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            matchedCols.$plus$eq((Object)((NamedExpression)matched.head()).name());
            String expectedName = expectedCol.name();
            NamedExpression namedExpression2 = (NamedExpression)matched.head();
            if (namedExpression2 instanceof Attribute) {
                Attribute attribute = (Attribute)namedExpression2;
                namedExpression = attribute.withName(expectedName);
            } else if (namedExpression2 instanceof Alias) {
                Alias alias = (Alias)namedExpression2;
                namedExpression = alias.withName(expectedName);
            } else {
                namedExpression = namedExpression2;
            }
            NamedExpression matchedCol = namedExpression;
            Tuple2 tuple2 = new Tuple2((Object)((Expression)((Object)matchedCol)).dataType(), (Object)expectedCol.dataType());
            if (tuple2 != null) {
                DataType matchedType = (DataType)tuple2._1();
                DataType expectedType = (DataType)tuple2._2();
                if (matchedType instanceof StructType) {
                    StructType structType = (StructType)matchedType;
                    if (expectedType instanceof StructType) {
                        StructType structType2 = (StructType)expectedType;
                        MODULE$.checkNullability((Expression)((Object)matchedCol), (Attribute)expectedCol, conf, addError, (Seq<String>)newColPath);
                        return Option$.MODULE$.option2Iterable(MODULE$.resolveStructType(matchedCol, structType, structType2, expectedName, conf, addError, (Seq<String>)newColPath));
                    }
                }
            }
            if (tuple2 != null) {
                DataType matchedType = (DataType)tuple2._1();
                DataType expectedType = (DataType)tuple2._2();
                if (matchedType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)matchedType;
                    if (expectedType instanceof ArrayType) {
                        ArrayType arrayType2 = (ArrayType)expectedType;
                        MODULE$.checkNullability((Expression)((Object)matchedCol), (Attribute)expectedCol, conf, addError, (Seq<String>)newColPath);
                        return Option$.MODULE$.option2Iterable(MODULE$.resolveArrayType(matchedCol, arrayType, arrayType2, expectedName, conf, addError, (Seq<String>)newColPath));
                    }
                }
            }
            if (tuple2 != null) {
                DataType matchedType = (DataType)tuple2._1();
                DataType expectedType = (DataType)tuple2._2();
                if (matchedType instanceof MapType) {
                    MapType mapType = (MapType)matchedType;
                    if (expectedType instanceof MapType) {
                        MapType mapType2 = (MapType)expectedType;
                        MODULE$.checkNullability((Expression)((Object)matchedCol), (Attribute)expectedCol, conf, addError, (Seq<String>)newColPath);
                        return Option$.MODULE$.option2Iterable(MODULE$.resolveMapType(matchedCol, mapType, mapType2, expectedName, conf, addError, (Seq<String>)newColPath));
                    }
                }
            }
            return Option$.MODULE$.option2Iterable(MODULE$.checkField((Attribute)expectedCol, matchedCol, true, conf, addError, (Seq<String>)newColPath));
        }, Seq$.MODULE$.canBuildFrom());
        if (reordered.length() == expectedCols.length()) {
            if (matchedCols.size() < inputCols.length()) {
                String extraCols = ((TraversableOnce)((TraversableLike)inputCols.filterNot((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)matchedCols.contains((Object)col.name())))).map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(2).append("'").append(col.name()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                addError.apply((Object)new StringBuilder(40).append("Cannot write extra fields to struct '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted()).append("': ").append(extraCols).toString());
                return Nil$.MODULE$;
            }
            return reordered;
        }
        return Nil$.MODULE$;
    }

    private Seq<String> reorderColumnsByName$default$5() {
        return Nil$.MODULE$;
    }

    private void checkNullability(Expression input, Attribute expected, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        if (input.nullable() && !expected.nullable()) {
            Enumeration.Value value = conf.storeAssignmentPolicy();
            Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.LEGACY();
            if (value == null ? value2 != null : !value.equals(value2)) {
                addError.apply((Object)new StringBuilder(50).append("Cannot write nullable values to non-null column '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted()).append("'").toString());
                return;
            }
        }
    }

    private Option<NamedExpression> resolveStructType(NamedExpression input, StructType inputType, StructType expectedType, String expectedName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        Seq fields = (Seq)((TraversableLike)inputType.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                GetStructField x$1 = new GetStructField((Expression)((Object)input), i, (Option<String>)new Some((Object)f.name()));
                String x$2 = f.name();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        Seq<NamedExpression> reordered = this.reorderColumnsByName((Seq<NamedExpression>)fields, expectedType.toAttributes(), conf, addError, colPath);
        if (reordered.length() == expectedType.length()) {
            Expression res;
            CreateNamedStruct struct = CreateStruct$.MODULE$.apply(reordered);
            Expression x$7 = res = ((Expression)((Object)input)).nullable() ? new If(new IsNull((Expression)((Object)input)), new Literal(null, struct.dataType()), struct) : struct;
            String x$8 = expectedName;
            ExprId x$9 = Alias$.MODULE$.apply$default$3(x$7, x$8);
            Seq<String> x$10 = Alias$.MODULE$.apply$default$4(x$7, x$8);
            Option<Metadata> x$11 = Alias$.MODULE$.apply$default$5(x$7, x$8);
            Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
            return new Some((Object)new Alias(x$7, x$8, x$9, x$10, x$11, x$12));
        }
        return None$.MODULE$;
    }

    private Option<NamedExpression> resolveArrayType(NamedExpression input, ArrayType inputType, ArrayType expectedType, String expectedName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        Seq<String> x$6;
        ExprId x$5;
        Metadata x$4;
        boolean x$3;
        DataType x$2;
        String x$1;
        AttributeReference fakeAttr;
        if (inputType.containsNull() && !expectedType.containsNull()) {
            addError.apply((Object)new StringBuilder(56).append("Cannot write nullable elements to array of non-nulls: '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted()).append("'").toString());
            return None$.MODULE$;
        }
        NamedLambdaVariable param = new NamedLambdaVariable("x", inputType.elementType(), inputType.containsNull(), NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        Seq<NamedExpression> res = this.reorderColumnsByName((Seq<NamedExpression>)((Seq)new .colon.colon((Object)param, (List)Nil$.MODULE$)), (Seq<Attribute>)((Seq)new .colon.colon((Object)(fakeAttr = new AttributeReference(x$1 = "x", x$2 = expectedType.elementType(), x$3 = expectedType.containsNull(), x$4 = AttributeReference$.MODULE$.apply$default$4(), x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4), x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4))), (List)Nil$.MODULE$)), conf, addError, colPath);
        if (res.length() == 1) {
            LambdaFunction func = new LambdaFunction((Expression)res.head(), (Seq<NamedExpression>)((Seq)new .colon.colon((Object)param, (List)Nil$.MODULE$)), LambdaFunction$.MODULE$.apply$default$3());
            ArrayTransform x$7 = new ArrayTransform((Expression)((Object)input), func);
            String x$8 = expectedName;
            ExprId x$9 = Alias$.MODULE$.apply$default$3(x$7, x$8);
            Seq<String> x$10 = Alias$.MODULE$.apply$default$4(x$7, x$8);
            Option<Metadata> x$11 = Alias$.MODULE$.apply$default$5(x$7, x$8);
            Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
            return new Some((Object)new Alias(x$7, x$8, x$9, x$10, x$11, x$12));
        }
        return None$.MODULE$;
    }

    private Option<NamedExpression> resolveMapType(NamedExpression input, MapType inputType, MapType expectedType, String expectedName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        if (inputType.valueContainsNull() && !expectedType.valueContainsNull()) {
            addError.apply((Object)new StringBuilder(52).append("Cannot write nullable values to map of non-nulls: '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted()).append("'").toString());
            return None$.MODULE$;
        }
        NamedLambdaVariable keyParam = new NamedLambdaVariable("k", inputType.keyType(), false, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        String x$1 = "k";
        DataType x$2 = expectedType.keyType();
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        AttributeReference fakeKeyAttr = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        Seq<NamedExpression> resKey = this.reorderColumnsByName((Seq<NamedExpression>)((Seq)new .colon.colon((Object)keyParam, (List)Nil$.MODULE$)), (Seq<Attribute>)((Seq)new .colon.colon((Object)fakeKeyAttr, (List)Nil$.MODULE$)), conf, addError, (Seq<String>)((Seq)colPath.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom())));
        NamedLambdaVariable valueParam = new NamedLambdaVariable("v", inputType.valueType(), inputType.valueContainsNull(), NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        String x$7 = "v";
        DataType x$8 = expectedType.valueType();
        boolean x$9 = expectedType.valueContainsNull();
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, x$8, x$9, x$10);
        Seq<String> x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, x$8, x$9, x$10);
        AttributeReference fakeValueAttr = new AttributeReference(x$7, x$8, x$9, x$10, x$11, x$12);
        Seq<NamedExpression> resValue = this.reorderColumnsByName((Seq<NamedExpression>)((Seq)new .colon.colon((Object)valueParam, (List)Nil$.MODULE$)), (Seq<Attribute>)((Seq)new .colon.colon((Object)fakeValueAttr, (List)Nil$.MODULE$)), conf, addError, (Seq<String>)((Seq)colPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())));
        if (resKey.length() == 1 && resValue.length() == 1) {
            LambdaFunction keyFunc = new LambdaFunction((Expression)resKey.head(), (Seq<NamedExpression>)((Seq)new .colon.colon((Object)keyParam, (List)Nil$.MODULE$)), LambdaFunction$.MODULE$.apply$default$3());
            LambdaFunction valueFunc = new LambdaFunction((Expression)resValue.head(), (Seq<NamedExpression>)((Seq)new .colon.colon((Object)valueParam, (List)Nil$.MODULE$)), LambdaFunction$.MODULE$.apply$default$3());
            ArrayTransform newKeys = new ArrayTransform(new MapKeys((Expression)((Object)input)), keyFunc);
            ArrayTransform newValues = new ArrayTransform(new MapValues((Expression)((Object)input)), valueFunc);
            MapFromArrays x$13 = new MapFromArrays(newKeys, newValues);
            String x$14 = expectedName;
            ExprId x$15 = Alias$.MODULE$.apply$default$3(x$13, x$14);
            Seq<String> x$16 = Alias$.MODULE$.apply$default$4(x$13, x$14);
            Option<Metadata> x$17 = Alias$.MODULE$.apply$default$5(x$13, x$14);
            Seq<String> x$18 = Alias$.MODULE$.apply$default$6(x$13, x$14);
            return new Some((Object)new Alias(x$13, x$14, x$15, x$16, x$17, x$18));
        }
        return None$.MODULE$;
    }

    public Expression checkCastOverflowInTableInsert(Cast cast, String columnName) {
        if (this.canCauseCastOverflow(cast)) {
            return new CheckOverflowInTableInsert(cast, columnName);
        }
        return cast;
    }

    private boolean containsIntegralOrDecimalType(DataType dt) {
        DataType dataType;
        block4: {
            while (true) {
                if ((dataType = dt) instanceof IntegralType ? true : dataType instanceof DecimalType) {
                    return true;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    dt = arrayType.elementType();
                    continue;
                }
                if (!(dataType instanceof MapType)) break block4;
                MapType mapType = (MapType)dataType;
                if (this.containsIntegralOrDecimalType(mapType.keyType())) break;
                dt = mapType.valueType();
            }
            return true;
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).exists((Function1 & Serializable & scala.Serializable)sf -> BoxesRunTime.boxToBoolean((boolean)TableOutputResolver$.MODULE$.containsIntegralOrDecimalType(sf.dataType())));
        }
        return false;
    }

    private boolean canCauseCastOverflow(Cast cast) {
        return this.containsIntegralOrDecimalType(cast.dataType()) && !Cast$.MODULE$.canUpCast(cast.child().dataType(), cast.dataType());
    }

    private Option<NamedExpression> checkField(Attribute tableAttr, NamedExpression queryExpr, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        boolean bl;
        Enumeration.Value storeAssignmentPolicy;
        LazyRef outputField$lzy = new LazyRef();
        boolean attrTypeHasCharVarchar = CharVarcharUtils$.MODULE$.hasCharVarchar(tableAttr.dataType());
        DataType attrTypeWithoutCharVarchar = attrTypeHasCharVarchar ? CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(tableAttr.dataType()) : tableAttr.dataType();
        Enumeration.Value value = storeAssignmentPolicy = conf.storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return this.outputField$1(outputField$lzy, tableAttr, queryExpr, attrTypeWithoutCharVarchar, conf, colPath, attrTypeHasCharVarchar);
        }
        Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.STRICT();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            bl = true;
        } else {
            Enumeration.Value value6 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
            Enumeration.Value value7 = value;
            bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
        }
        if (bl) {
            boolean canWrite = DataType$.MODULE$.canWrite(((Expression)((Object)queryExpr)).dataType(), attrTypeWithoutCharVarchar, byName, conf.resolver(), CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted(), storeAssignmentPolicy, addError);
            if (((Expression)((Object)queryExpr)).nullable() && !tableAttr.nullable()) {
                addError.apply((Object)new StringBuilder(50).append("Cannot write nullable values to non-null column '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted()).append("'").toString());
                return None$.MODULE$;
            }
            if (!canWrite) {
                return None$.MODULE$;
            }
            return this.outputField$1(outputField$lzy, tableAttr, queryExpr, attrTypeWithoutCharVarchar, conf, colPath, attrTypeHasCharVarchar);
        }
        throw new MatchError((Object)value);
    }

    private Expression cast(Expression expr, DataType expectedType, SQLConf conf, String colName) {
        Enumeration.Value value = conf.storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Cast cast = Cast$.MODULE$.apply(expr, expectedType, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), true);
            cast.setTagValue(Cast$.MODULE$.BY_TABLE_INSERTION(), BoxedUnit.UNIT);
            return this.checkCastOverflowInTableInsert(cast, colName);
        }
        Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.LEGACY();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return Cast$.MODULE$.apply(expr, expectedType, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), false);
        }
        return new Cast(expr, expectedType, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$reorderColumnsByName$2(SQLConf conf$2, Attribute expectedCol$1, NamedExpression col) {
        return BoxesRunTime.unboxToBoolean((Object)conf$2.resolver().apply((Object)col.name(), (Object)expectedCol$1.name()));
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ Some outputField$lzycompute$1(LazyRef outputField$lzy$1, Attribute tableAttr$1, NamedExpression queryExpr$1, DataType attrTypeWithoutCharVarchar$1, SQLConf conf$3, Seq colPath$2, boolean attrTypeHasCharVarchar$1) {
        var8_8 = outputField$lzy$1;
        synchronized (var8_8) {
            block6: {
                block5: {
                    if (!outputField$lzy$1.initialized()) break block5;
                    v0 = (Some)outputField$lzy$1.value();
                    break block6;
                }
                if (!tableAttr$1.dataType().sameType(((Expression)queryExpr$1).dataType())) ** GOTO lbl-1000
                v1 = tableAttr$1.name();
                var10_9 = queryExpr$1.name();
                if (v1 != null ? v1.equals(var10_9) == false : var10_9 != null) ** GOTO lbl-1000
                v2 = tableAttr$1.metadata();
                var11_10 = queryExpr$1.metadata();
                if (!(v2 != null ? v2.equals(var11_10) == false : var11_10 != null)) {
                    v3 = new Some((Object)queryExpr$1);
                } else lbl-1000:
                // 3 sources

                {
                    casted = this.cast((Expression)queryExpr$1, attrTypeWithoutCharVarchar$1, conf$3, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)colPath$2).quoted());
                    x$1 = exprWithStrLenCheck = conf$3.charVarcharAsString() != false || attrTypeHasCharVarchar$1 == false ? casted : CharVarcharUtils$.MODULE$.stringLengthCheck(casted, tableAttr$1.dataType());
                    x$2 = tableAttr$1.name();
                    x$3 = new Some((Object)tableAttr$1.metadata());
                    x$4 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                    x$5 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                    x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                    v4 = new Some((Object)new Alias(x$1, x$2, x$4, x$5, (Option<Metadata>)x$3, x$6));
                    v3 = v4;
                }
                v0 = (Some)outputField$lzy$1.initialize((Object)v3);
            }
            var9_19 = v0;
        }
        return var9_19;
    }

    private final Some outputField$1(LazyRef outputField$lzy$1, Attribute tableAttr$1, NamedExpression queryExpr$1, DataType attrTypeWithoutCharVarchar$1, SQLConf conf$3, Seq colPath$2, boolean attrTypeHasCharVarchar$1) {
        if (outputField$lzy$1.initialized()) {
            return (Some)outputField$lzy$1.value();
        }
        return this.outputField$lzycompute$1(outputField$lzy$1, tableAttr$1, queryExpr$1, attrTypeWithoutCharVarchar$1, conf$3, colPath$2, attrTypeHasCharVarchar$1);
    }

    private TableOutputResolver$() {
        MODULE$ = this;
    }
}

