/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.read;

import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.types.StructType;

@Evolving
public interface Scan {
    public StructType readSchema();

    default public String description() {
        return this.getClass().toString();
    }

    default public Batch toBatch() {
        throw new UnsupportedOperationException(this.description() + ": Batch scan are not supported");
    }

    default public MicroBatchStream toMicroBatchStream(String checkpointLocation) {
        throw new UnsupportedOperationException(this.description() + ": Micro-batch scan are not supported");
    }

    default public ContinuousStream toContinuousStream(String checkpointLocation) {
        throw new UnsupportedOperationException(this.description() + ": Continuous scan are not supported");
    }

    default public CustomMetric[] supportedCustomMetrics() {
        return new CustomMetric[0];
    }

    default public CustomTaskMetric[] reportDriverMetrics() {
        return new CustomTaskMetric[0];
    }
}

