/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a set of unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0014)\u0001^B\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t9\u0002\u0011\t\u0012)A\u00051\"AQ\f\u0001BK\u0002\u0013\u0005a\f\u0003\u0005c\u0001\tE\t\u0015!\u0003`\u0011!\u0019\u0007A!f\u0001\n\u0003q\u0006\u0002\u00033\u0001\u0005#\u0005\u000b\u0011B0\t\u000b\u0015\u0004A\u0011\u00014\t\u000b\u0015\u0004A\u0011A6\t\u00115\u0004\u0001R1A\u0005B9DQ!\u001e\u0001\u0005BYDQ!\u001f\u0001\u0005BiDQ! \u0001\u0005ByDq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u00111\b\u0001\u0005B\u0005u\u0002bBA \u0001\u0011E\u0013\u0011\t\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013B\u0011\"!\u0015\u0001#\u0003%\t!a\u0015\t\u0013\u0005%\u0004!%A\u0005\u0002\u0005-\u0004\"CA8\u0001E\u0005I\u0011AA6\u0011%\t\t\bAA\u0001\n\u0003\n\u0019\b\u0003\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001_\u0011%\t)\tAA\u0001\n\u0003\t9\tC\u0005\u0002\u000e\u0002\t\t\u0011\"\u0011\u0002\u0010\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003K\u0003\u0011\u0011!C!\u0003O;\u0011\"!5)\u0003\u0003E\t!a5\u0007\u0011\u001dB\u0013\u0011!E\u0001\u0003+Da!Z\u000f\u0005\u0002\u0005\r\b\"CAs;\u0005\u0005IQIAt\u0011%\tI/HA\u0001\n\u0003\u000bY\u000fC\u0005\u0002tv\t\n\u0011\"\u0001\u0002l!I\u0011Q_\u000f\u0012\u0002\u0013\u0005\u00111\u000e\u0005\n\u0003ol\u0012\u0011!CA\u0003sD\u0011Ba\u0003\u001e#\u0003%\t!a\u001b\t\u0013\t5Q$%A\u0005\u0002\u0005-\u0004\"\u0003B\b;\u0005\u0005I\u0011\u0002B\t\u0005)\u0019u\u000e\u001c7fGR\u001cV\r\u001e\u0006\u0003S)\n\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005-b\u0013aC3yaJ,7o]5p]NT!!\f\u0018\u0002\u0011\r\fG/\u00197zgRT!a\f\u0019\u0002\u0007M\fHN\u0003\u00022e\u0005)1\u000f]1sW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u001dK!N\u00032!\u000f\u001e=\u001b\u0005A\u0013BA\u001e)\u0005\u001d\u0019u\u000e\u001c7fGR\u00042!\u0010#G\u001b\u0005q$BA A\u0003\u001diW\u000f^1cY\u0016T!!\u0011\"\u0002\u0015\r|G\u000e\\3di&|gNC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)eHA\u0004ICND7+\u001a;\u0011\u0005\u001dCU\"\u0001\"\n\u0005%\u0013%aA!osB\u00111JT\u0007\u0002\u0019*\u0011QJL\u0001\u0007KJ\u0014xN]:\n\u0005=c%aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005\u001d\u000b\u0016B\u0001*C\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u0012+\n\u0005U\u0013%\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u0001-\u0011\u0005eSV\"\u0001\u0016\n\u0005mS#AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u000b\u0002?B\u0011q\tY\u0005\u0003C\n\u00131!\u00138u\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003\u0019a\u0014N\\5u}Q!q\r[5k!\tI\u0004\u0001C\u0003W\u000f\u0001\u0007\u0001\fC\u0004^\u000fA\u0005\t\u0019A0\t\u000f\r<\u0001\u0013!a\u0001?R\u0011q\r\u001c\u0005\u0006-\"\u0001\r\u0001W\u0001\u0012EV4g-\u001a:FY\u0016lWM\u001c;UsB,W#A8\u0011\u0005A\u001cX\"A9\u000b\u0005It\u0013!\u0002;za\u0016\u001c\u0018B\u0001;r\u0005!!\u0015\r^1UsB,\u0017AF2p]Z,'\u000f\u001e+p\u0005V4g-\u001a:FY\u0016lWM\u001c;\u0015\u0005\u0019;\b\"\u0002=\u000b\u0001\u00041\u0015!\u0002<bYV,\u0017\u0001B3wC2$\"AR>\t\u000bq\\\u0001\u0019\u0001\u001f\u0002\r\t,hMZ3s\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015A&\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tI!a\u0001\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fQd^5uQ:+w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0005\u0003\u001f\t)\u0002E\u0002:\u0003#I1!a\u0005)\u0005MIU\u000e]3sCRLg/Z!hOJ,w-\u0019;f\u0011\u0019\t9\"\u0004a\u0001?\u0006Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR!\u0011qBA\u000f\u0011\u0019\tyB\u0004a\u0001?\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u000baJ,G\u000f^=OC6,WCAA\u0013!\u0011\t9#!\u000e\u000f\t\u0005%\u0012\u0011\u0007\t\u0004\u0003W\u0011UBAA\u0017\u0015\r\tyCN\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M\")\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\tID\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g\u0011\u0015aF2sK\u0006$X-Q4he\u0016<\u0017\r^5p]\n+hMZ3s)\u0005a\u0014\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002h\u0003\u0007Ba!!\u0012\u0012\u0001\u0004A\u0016\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\bO\u0006-\u0013QJA(\u0011\u001d1&\u0003%AA\u0002aCq!\u0018\n\u0011\u0002\u0003\u0007q\fC\u0004d%A\u0005\t\u0019A0\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u000b\u0016\u00041\u0006]3FAA-!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r$)\u0001\u0006b]:|G/\u0019;j_:LA!a\u001a\u0002^\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u000e\u0016\u0004?\u0006]\u0013AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0000\u0005!!.\u0019<b\u0013\u0011\t9$!\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a)!#\t\u0011\u0005-\u0005$!AA\u0002}\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAI!\u0015\t\u0019*!&G\u001b\u0005\u0001\u0015bAAL\u0001\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti*a)\u0011\u0007\u001d\u000by*C\u0002\u0002\"\n\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\fj\t\t\u00111\u0001G\u0003\u0019)\u0017/^1mgR!\u0011QTAU\u0011!\tYiGA\u0001\u0002\u00041\u0005f\u0006\u0001\u0002.\u0006M\u0016QWA]\u0003w\u000by,!1\u0002F\u0006\u001d\u00171ZAg!\rI\u0016qV\u0005\u0004\u0003cS#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003o\u000bQh\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006I\"pY2,7\r^:!C:$\u0007E]3ukJt7\u000fI1!g\u0016$\be\u001c4!k:L\u0017/^3!K2,W.\u001a8ug:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003{\u000b\u0001M\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0017!QIJC\u0006\t\u00152S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u000bDFM/\u000bA\u0001\nAA\\8uK\u0006\u0012\u00111Y\u0001\u0002L)\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\r\t2fG\u0006,8/\u001a\u0011uQ\u0016\u0004sN\u001d3fe\u0002zg\rI2pY2,7\r^3eAI,7/\u001e7ug\u0002\"W\r]3oINT\u0001\u0005\t\u0011!_:\u0004C\u000f[3!_J$WM\u001d\u0011pM\u0002\"\b.\u001a\u0011s_^\u001c\be\u001e5jG\"\u0004S.Y=!E\u0016\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2!C\u001a$XM\u001d\u0011bAMDWO\u001a4mK:R\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0013\f\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005=\u0017!\u0002\u001a/a9\u0002\u0014AC\"pY2,7\r^*fiB\u0011\u0011(H\n\u0005;\u0005]7\u000b\u0005\u0005\u0002Z\u0006}\u0007lX0h\u001b\t\tYNC\u0002\u0002^\n\u000bqA];oi&lW-\u0003\u0003\u0002b\u0006m'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u00111[\u0001\ti>\u001cFO]5oOR\u0011\u0011QO\u0001\u0006CB\u0004H.\u001f\u000b\bO\u00065\u0018q^Ay\u0011\u00151\u0006\u00051\u0001Y\u0011\u001di\u0006\u0005%AA\u0002}Cqa\u0019\u0011\u0011\u0002\u0003\u0007q,A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003w\u00149\u0001E\u0003H\u0003{\u0014\t!C\u0002\u0002\u0000\n\u0013aa\u00149uS>t\u0007CB$\u0003\u0004a{v,C\u0002\u0003\u0006\t\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\u0005G\u0005\u0005\t\u0019A4\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005'\u0001B!a\u001e\u0003\u0016%!!qCA=\u0005\u0019y%M[3di\u0002")
public class CollectSet
extends Collect<HashSet<Object>>
implements QueryErrorsBase,
scala.Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return CollectSet$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectSet$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(CollectSet collectSet) {
        return CollectSet$.MODULE$.unapply(collectSet);
    }

    public static int apply$default$3() {
        return CollectSet$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectSet$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, CollectSet> tupled() {
        return CollectSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, CollectSet>>> curried() {
        return CollectSet$.MODULE$.curried();
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType bufferElementType$lzycompute() {
        CollectSet collectSet = this;
        synchronized (collectSet) {
            if (!this.bitmap$0) {
                DataType dataType = this.child().dataType();
                this.bufferElementType = BinaryType$.MODULE$.equals(dataType) ? ArrayType$.MODULE$.apply(ByteType$.MODULE$) : dataType;
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        if (!this.bitmap$0) {
            return this.bufferElementType$lzycompute();
        }
        return this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        DataType dataType = this.child().dataType();
        if (BinaryType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((byte[])value);
        }
        return InternalRow$.MODULE$.copyValue(value);
    }

    @Override
    public Object eval(HashSet<Object> buffer) {
        DataType dataType = this.child().dataType();
        Object array = BinaryType$.MODULE$.equals(dataType) ? buffer.iterator().map((Function1 & Serializable & scala.Serializable)x$2 -> ((ArrayData)x$2).toByteArray()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))) : buffer.toArray(ClassTag$.MODULE$.Any());
        return new GenericArrayData(array);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.child().dataType().existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CollectSet.$anonfun$checkInputDataTypes$1(x$3)))) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("UNSUPPORTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType(MapType$.MODULE$))}))));
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public String prettyName() {
        return "collect_set";
    }

    @Override
    public HashSet<Object> createAggregationBuffer() {
        return HashSet$.MODULE$.empty();
    }

    @Override
    public CollectSet withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public CollectSet copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CollectSet(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CollectSet";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectSet collectSet = (CollectSet)x$1;
        Expression expression = this.child();
        Expression expression2 = collectSet.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.mutableAggBufferOffset() != collectSet.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectSet.inputAggBufferOffset()) return false;
        if (!collectSet.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(DataType x$3) {
        return x$3 instanceof MapType;
    }

    public CollectSet(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        QueryErrorsBase.$init$(this);
    }

    public CollectSet(Expression child) {
        this(child, 0, 0);
    }
}

