/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SQLConf$LegacyBehaviorPolicy$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\u0011\"\u00019B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005u!)q\b\u0001C\u0001\u0001\"91\t\u0001b\u0001\n\u0013!\u0005BB&\u0001A\u0003%Q\tC\u0004M\u0001\t\u0007I\u0011\u0002#\t\r5\u0003\u0001\u0015!\u0003F\u0011!q\u0005\u0001#b\u0001\n\u0013y\u0005bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u0007W\u0002\u0001\u000b\u0011B+\t\u000f1\u0004!\u0019!C\u0005[\"11\u0010\u0001Q\u0001\n9DQ\u0001 \u0001\u0005\u0002uDq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA1\u0001\u0011%\u00111\r\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!!\u001f\u0001\t\u0013\tY\bC\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u00111\u0012\u0001\u0005\n\u00055\u0005bBAI\u0001\u0011%\u00111\u0013\u0005\b\u0003/\u0003A\u0011BAM\u0011\u001d\ti\n\u0001C\u0005\u0003?Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u00024\u0002!I!!.\t\u0013\u0005}\u0006A1A\u0005\n\u0005\u0005\u0007\u0002CAe\u0001\u0001\u0006I!a1\u0003\u001d\r\u001bf+\u00138gKJ\u001c6\r[3nC*\u0011!eI\u0001\u0004GN4(B\u0001\u0013&\u0003!\u0019\u0017\r^1msN$(B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011c\u0001\u00010kA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"\u0001\r\u001c\n\u0005]\n$\u0001D*fe&\fG.\u001b>bE2,\u0017aB8qi&|gn]\u000b\u0002uA\u00111\bP\u0007\u0002C%\u0011Q(\t\u0002\u000b\u0007N3v\n\u001d;j_:\u001c\u0018\u0001C8qi&|gn\u001d\u0011\u0002\rqJg.\u001b;?)\t\t%\t\u0005\u0002<\u0001!)\u0001h\u0001a\u0001u\u0005yA/[7fgR\fW\u000e\u001d)beN,'/F\u0001F!\t1\u0015*D\u0001H\u0015\tA5%\u0001\u0003vi&d\u0017B\u0001&H\u0005I!\u0016.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0002!QLW.Z:uC6\u0004\b+\u0019:tKJ\u0004\u0013!\u0006;j[\u0016\u001cH/Y7q\u001dRSfi\u001c:nCR$XM]\u0001\u0017i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3sA\u0005iA-\u0019;f\r>\u0014X.\u0019;uKJ,\u0012\u0001\u0015\t\u0003\rFK!AU$\u0003\u001b\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u00035!WmY5nC2\u0004\u0016M]:feV\tQ\u000b\u0005\u00031-b\u001b\u0017BA,2\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002ZA:\u0011!L\u0018\t\u00037Fj\u0011\u0001\u0018\u0006\u0003;6\na\u0001\u0010:p_Rt\u0014BA02\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}\u000b\u0004C\u00013j\u001b\u0005)'B\u00014h\u0003\u0011i\u0017\r\u001e5\u000b\u0003!\fAA[1wC&\u0011!.\u001a\u0002\u000b\u0005&<G)Z2j[\u0006d\u0017A\u00043fG&l\u0017\r\u001c)beN,'\u000fI\u0001,\u0019\u0016s\u0015*\u0012(U?R\u001bvLR(S\u001b\u0006#F+\u0012*`'V\u0003\u0006k\u0014*U\u000b\u0012{F)\u0011+F?\u001a{%+T!U'V\ta\u000eE\u0002piZl\u0011\u0001\u001d\u0006\u0003cJ\f\u0011\"[7nkR\f'\r\\3\u000b\u0005M\f\u0014AC2pY2,7\r^5p]&\u0011Q\u000f\u001d\u0002\u0004'\u0016$\bCA<{\u001b\u0005A(BA=h\u0003\u0011a\u0017M\\4\n\u0005\u0005D\u0018\u0001\f'F\u001d&+e\nV0U'~3uJU'B)R+%kX*V!B{%\u000bV#E?\u0012\u000bE+R0G\u001fJk\u0015\tV*!\u0003\u0015IgNZ3s)\u0015q\u0018\u0011BA\u0010!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001&\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9!!\u0001\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002\f5\u0001\r!!\u0004\u0002\u0011Q|7.\u001a8S\t\u0012\u0003b!a\u0004\u0002\u0016\u0005eQBAA\t\u0015\r\t\u0019bJ\u0001\u0004e\u0012$\u0017\u0002BA\f\u0003#\u00111A\u0015#E!\u0011\u0001\u00141\u0004-\n\u0007\u0005u\u0011GA\u0003BeJ\f\u0017\u0010C\u0004\u0002\"5\u0001\r!!\u0007\u0002\r!,\u0017\rZ3s\u00039!xn\u0015;sk\u000e$h)[3mIN$b!a\n\u00020\u0005m\u0002#\u0002\u0019\u0002\u001c\u0005%\u0002cA@\u0002,%!\u0011QFA\u0001\u0005-\u0019FO];di\u001aKW\r\u001c3\t\u000f\u0005Eb\u00021\u0001\u00024\u0005Qa-[3mIRK\b/Z:\u0011\u000bA\nY\"!\u000e\u0011\u0007}\f9$\u0003\u0003\u0002:\u0005\u0005!\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005\u0005b\u00021\u0001\u0002\u001a\u0005a\u0011N\u001c4feJ{w\u000fV=qKR1\u00111GA!\u0003\u000bBq!a\u0011\u0010\u0001\u0004\t\u0019$\u0001\u0005s_^\u001cvNR1s\u0011\u001d\t9e\u0004a\u0001\u00033\tAA\\3yi\u0006iQ.\u001a:hKJ{w\u000fV=qKN$b!a\r\u0002N\u0005E\u0003bBA(!\u0001\u0007\u00111G\u0001\u0006M&\u00148\u000f\u001e\u0005\b\u0003'\u0002\u0002\u0019AA\u001a\u0003\u0019\u0019XmY8oI\u0006Q\u0011N\u001c4fe\u001aKW\r\u001c3\u0015\r\u0005U\u0012\u0011LA/\u0011\u001d\tY&\u0005a\u0001\u0003k\t\u0011\u0002^=qKN{g)\u0019:\t\r\u0005}\u0013\u00031\u0001Y\u0003\u00151\u0017.\u001a7e\u0003)I7/\u00138g\u001fJt\u0015M\u001c\u000b\u0005\u0003K\nY\u0007E\u00021\u0003OJ1!!\u001b2\u0005\u001d\u0011un\u001c7fC:Da!a\u0018\u0013\u0001\u0004A\u0016a\u0004;ssB\u000b'o]3J]R,w-\u001a:\u0015\t\u0005U\u0012\u0011\u000f\u0005\u0007\u0003?\u001a\u0002\u0019\u0001-\u0002\u0019Q\u0014\u0018\u0010U1sg\u0016duN\\4\u0015\t\u0005U\u0012q\u000f\u0005\u0007\u0003?\"\u0002\u0019\u0001-\u0002\u001fQ\u0014\u0018\u0010U1sg\u0016$UmY5nC2$B!!\u000e\u0002~!1\u0011qL\u000bA\u0002a\u000ba\u0002\u001e:z!\u0006\u00148/\u001a#pk\ndW\r\u0006\u0003\u00026\u0005\r\u0005BBA0-\u0001\u0007\u0001,\u0001\u0007uef\u0004\u0016M]:f\t\u0006$X\r\u0006\u0003\u00026\u0005%\u0005BBA0/\u0001\u0007\u0001,\u0001\u000buef\u0004\u0016M]:f)&lWm\u001d;b[BtEK\u0017\u000b\u0005\u0003k\ty\t\u0003\u0004\u0002`a\u0001\r\u0001W\u0001\u0012iJL\b+\u0019:tKRKW.Z:uC6\u0004H\u0003BA\u001b\u0003+Ca!a\u0018\u001a\u0001\u0004A\u0016a\u0004;ssB\u000b'o]3C_>dW-\u00198\u0015\t\u0005U\u00121\u0014\u0005\u0007\u0003?R\u0002\u0019\u0001-\u0002\u0015M$(/\u001b8h)f\u0004X\r\u0006\u0002\u00026\u0005q1m\\7qCRL'\r\\3UsB,GCBAS\u0003W\u000by\u000bE\u00031\u0003O\u000b)$C\u0002\u0002*F\u0012aa\u00149uS>t\u0007bBAW9\u0001\u0007\u0011QG\u0001\u0003iFBq!!-\u001d\u0001\u0004\t)$\u0001\u0002ue\u000592-\u00198QCJ\u001cX\rR1uK\u0006\u001bH+[7fgR\fW\u000e\u001d\u000b\u0007\u0003K\n9,a/\t\r\u0005eV\u00041\u0001Y\u0003)!\u0017\r^3G_Jl\u0017\r\u001e\u0005\b\u0003{k\u0002\u0019AA\u001b\u0003\u0019!8\u000fV=qK\u0006Ab-\u001b8e\u0007>l\u0007/\u0019;jE2,G+\u001f9f\r>\u00148i\u0015,\u0016\u0005\u0005\r\u0007#\u0003\u0019\u0002F\u0006U\u0012QGAS\u0013\r\t9-\r\u0002\n\rVt7\r^5p]J\n\u0011DZ5oI\u000e{W\u000e]1uS\ndW\rV=qK\u001a{'oQ*WA\u0001")
public class CSVInferSchema
implements scala.Serializable {
    private DateFormatter dateFormatter;
    private final CSVOptions options;
    private final TimestampFormatter timestampParser;
    private final TimestampFormatter timestampNTZFormatter;
    private final Function1<String, BigDecimal> decimalParser;
    private final Set<String> LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS;
    private final Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV;
    private volatile boolean bitmap$0;

    public CSVOptions options() {
        return this.options;
    }

    private TimestampFormatter timestampParser() {
        return this.timestampParser;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        CSVInferSchema cSVInferSchema = this;
        synchronized (cSVInferSchema) {
            if (!this.bitmap$0) {
                this.dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormatInRead(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = true;
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        if (!this.bitmap$0) {
            return this.dateFormatter$lzycompute();
        }
        return this.dateFormatter;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private Set<String> LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS() {
        return this.LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS;
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header) {
        StructField[] structFieldArray;
        if (this.options().inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2 & Serializable & scala.Serializable)(rowSoFar, next) -> this.inferRowType((DataType[])rowSoFar, (String[])next), (Function2 & Serializable & scala.Serializable)(first, second) -> this.mergeRowTypes((DataType[])first, (DataType[])second), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = this.toStructFields(rootTypes, header);
        } else {
            structFieldArray = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header)).map((Function1 & Serializable & scala.Serializable)fieldName -> new StructField((String)fieldName, StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    public StructField[] toStructFields(DataType[] fieldTypes, String[] header) {
        return (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String thisHeader = (String)tuple2._1();
                DataType rootType = (DataType)tuple2._2();
                DataType dataType = rootType;
                DataType dType = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
                return new StructField(thisHeader, dType, true, StructField$.MODULE$.apply$default$4());
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public DataType[] inferRowType(DataType[] rowSoFar, String[] next) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next[i]);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])first)).zipAll((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DataType a = (DataType)tuple2._1();
                DataType b = (DataType)tuple2._2();
                return (DataType)this.compatibleType(a, b).getOrElse((Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
    }

    public DataType inferField(DataType typeSoFar, String field) {
        DataType dataType;
        block25: {
            block24: {
                if (field == null || field.isEmpty()) break block24;
                String string = field;
                String string2 = this.options().nullValue();
                if (string != null ? !string.equals(string2) : string2 != null) break block25;
            }
            return typeSoFar;
        }
        DataType dataType2 = typeSoFar;
        if (NullType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseInteger(field);
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseInteger(field);
        } else if (LongType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseLong(field);
        } else if (dataType2 instanceof DecimalType) {
            dataType = this.tryParseDecimal(field);
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseDouble(field);
        } else if (DateType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseDate(field);
        } else if (TimestampNTZType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseTimestampNTZ(field);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseTimestamp(field);
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseBoolean(field);
        } else if (StringType$.MODULE$.equals(dataType2)) {
            dataType = StringType$.MODULE$;
        } else {
            if (dataType2 != null) {
                DataType dataType3 = dataType2;
                throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType3);
            }
            throw new MatchError((Object)dataType2);
        }
        DataType typeElemInfer = dataType;
        return (DataType)this.compatibleType(typeSoFar, typeElemInfer).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field) {
        String string = field;
        String string2 = this.options().nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = this.options().negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = this.options().positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toInt()).isDefined()) {
            return IntegerType$.MODULE$;
        }
        return this.tryParseLong(field);
    }

    private DataType tryParseLong(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toLong()).isDefined()) {
            return LongType$.MODULE$;
        }
        return this.tryParseDecimal(field);
    }

    private DataType tryParseDecimal(String field) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field);
            if (bigDecimal.scale() <= 0) {
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }
            return this.tryParseDouble(field);
        });
        return (DataType)decimalTry.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.tryParseDouble(field));
    }

    private DataType tryParseDouble(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toDouble()).isDefined() || this.isInfOrNan(field)) {
            return DoubleType$.MODULE$;
        }
        if (this.options().preferDate()) {
            return this.tryParseDate(field);
        }
        return this.tryParseTimestampNTZ(field);
    }

    private DataType tryParseDate(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.dateFormatter().parse(field)).isDefined()) {
            return DateType$.MODULE$;
        }
        return this.tryParseTimestampNTZ(field);
    }

    private DataType tryParseTimestampNTZ(String field) {
        block5: {
            AtomicType timestampType;
            block4: {
                timestampType = SQLConf$.MODULE$.get().timestampType();
                Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
                Enumeration.Value value2 = SQLConf$LegacyBehaviorPolicy$.MODULE$.LEGACY();
                if (!(value == null ? value2 != null : !value.equals(value2))) break block4;
                AtomicType atomicType = timestampType;
                TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
                if (atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null) break block5;
            }
            if (this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined()) {
                return timestampType;
            }
        }
        return this.tryParseTimestamp(field);
    }

    private DataType tryParseTimestamp(String field) {
        if (this.timestampParser().parseOptional(field).isDefined()) {
            return TimestampType$.MODULE$;
        }
        return this.tryParseBoolean(field);
    }

    private DataType tryParseBoolean(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toBoolean()).isDefined()) {
            return BooleanType$.MODULE$;
        }
        return this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private Option<DataType> compatibleType(DataType t1, DataType t2) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        var7_3 = new Tuple2((Object)t1, (Object)t2);
                        if (var7_3 == null) break block5;
                        var8_4 = (DataType)var7_3._1();
                        var9_5 = (DataType)var7_3._2();
                        if (!DateType$.MODULE$.equals(var8_4) || !TimestampType$.MODULE$.equals(var9_5)) break block5;
                        v0 = true;
                        break block6;
                    }
                    if (var7_3 == null) break block7;
                    var10_6 = (DataType)var7_3._1();
                    var11_7 = (DataType)var7_3._2();
                    if (!DateType$.MODULE$.equals(var10_6) || !TimestampNTZType$.MODULE$.equals(var11_7)) break block7;
                    v0 = true;
                    break block6;
                }
                if (var7_3 == null) break block8;
                var12_8 = (DataType)var7_3._1();
                var13_9 = (DataType)var7_3._2();
                if (!TimestampNTZType$.MODULE$.equals(var12_8) || !DateType$.MODULE$.equals(var13_9)) break block8;
                v0 = true;
                break block6;
            }
            if (var7_3 == null) ** GOTO lbl-1000
            var14_10 = (DataType)var7_3._1();
            var15_11 = (DataType)var7_3._2();
            if (TimestampType$.MODULE$.equals(var14_10) && DateType$.MODULE$.equals(var15_11)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            dateFormat = (String)this.options().dateFormatInRead().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$compatibleType$1(), ()Ljava/lang/String;)());
            var17_13 = t1;
            if (DateType$.MODULE$.equals(var17_13) && this.canParseDateAsTimestamp(dateFormat, t2)) {
                return new Some((Object)t2);
            }
            if ((TimestampType$.MODULE$.equals(var17_13) != false ? true : TimestampNTZType$.MODULE$.equals(var17_13) != false) && this.canParseDateAsTimestamp(dateFormat, t1)) {
                return new Some((Object)t1);
            }
            return new Some((Object)StringType$.MODULE$);
        }
        return ((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2)).orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$compatibleType$2(org.apache.spark.sql.catalyst.csv.CSVInferSchema org.apache.spark.sql.types.DataType org.apache.spark.sql.types.DataType ), ()Lscala/Option;)((CSVInferSchema)this, (DataType)t1, (DataType)t2));
    }

    private boolean canParseDateAsTimestamp(String dateFormat, DataType tsType) {
        if (tsType instanceof TimestampType && this.options().timestampFormatInRead().isEmpty() || tsType instanceof TimestampNTZType && this.options().timestampNTZFormatInRead().isEmpty()) {
            return this.LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS().contains((Object)dateFormat);
        }
        return false;
    }

    private Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV() {
        return this.findCompatibleTypeForCSV;
    }

    public static final /* synthetic */ String $anonfun$compatibleType$1() {
        return DateFormatter$.MODULE$.defaultPattern();
    }

    public static final /* synthetic */ Option $anonfun$compatibleType$2(CSVInferSchema $this, DataType t1$1, DataType t2$1) {
        return (Option)$this.findCompatibleTypeForCSV().apply((Object)t1$1, (Object)t2$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$findCompatibleTypeForCSV$1(CSVInferSchema $this, DataType x0$1, DataType x1$1) {
        block21: {
            block20: {
                block19: {
                    block18: {
                        var6_3 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (var6_3 != null && StringType$.MODULE$.equals(var7_4 = (DataType)var6_3._1())) {
                            return new Some((Object)StringType$.MODULE$);
                        }
                        if (var6_3 != null && StringType$.MODULE$.equals(var8_5 = (DataType)var6_3._2())) {
                            return new Some((Object)StringType$.MODULE$);
                        }
                        if (var6_3 != null) {
                            t1 = (DataType)var6_3._1();
                            t2 = (DataType)var6_3._2();
                            if (t1 instanceof IntegralType) {
                                var11_8 = (IntegralType)t1;
                                if (t2 instanceof DecimalType) {
                                    var12_9 = (DecimalType)t2;
                                    return $this.compatibleType(DecimalType$.MODULE$.forType(var11_8), var12_9);
                                }
                            }
                        }
                        if (var6_3 != null) {
                            t1 = (DataType)var6_3._1();
                            t2 = (DataType)var6_3._2();
                            if (t1 instanceof DecimalType) {
                                var15_12 = (DecimalType)t1;
                                if (t2 instanceof IntegralType) {
                                    var16_13 = (IntegralType)t2;
                                    return $this.compatibleType(var15_12, DecimalType$.MODULE$.forType(var16_13));
                                }
                            }
                        }
                        if (var6_3 == null || !DoubleType$.MODULE$.equals(var17_14 = (DataType)var6_3._1()) || !(var6_3._2() instanceof DecimalType)) break block18;
                        v0 = true;
                        break block19;
                    }
                    if (var6_3 == null) ** GOTO lbl-1000
                    var18_15 = (DataType)var6_3._2();
                    if (var6_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var18_15)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                }
                if (v0) {
                    return new Some((Object)DoubleType$.MODULE$);
                }
                if (var6_3 != null) {
                    t1 = (DataType)var6_3._1();
                    t2 = (DataType)var6_3._2();
                    if (t1 instanceof DecimalType) {
                        var21_18 = (DecimalType)t1;
                        if (t2 instanceof DecimalType) {
                            var22_19 = (DecimalType)t2;
                            scale = package$.MODULE$.max(var21_18.scale(), var22_19.scale());
                            range = package$.MODULE$.max(var21_18.precision() - var21_18.scale(), var22_19.precision() - var22_19.scale());
                            if (range + scale > 38) {
                                return new Some((Object)DoubleType$.MODULE$);
                            }
                            return new Some((Object)new DecimalType(range + scale, scale));
                        }
                    }
                }
                if (var6_3 == null) break block20;
                var25_22 = (DataType)var6_3._1();
                var26_23 = (DataType)var6_3._2();
                if (!TimestampNTZType$.MODULE$.equals(var25_22) || !TimestampType$.MODULE$.equals(var26_23)) break block20;
                v1 = true;
                break block21;
            }
            if (var6_3 == null) ** GOTO lbl-1000
            var27_24 = (DataType)var6_3._1();
            var28_25 = (DataType)var6_3._2();
            if (TimestampType$.MODULE$.equals(var27_24) && TimestampNTZType$.MODULE$.equals(var28_25)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v1) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        return None$.MODULE$;
    }

    public CSVInferSchema(CSVOptions options) {
        this.options = options;
        this.timestampParser = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        Locale locale = options.locale();
        Locale locale2 = Locale.US;
        this.decimalParser = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? s -> new BigDecimal((String)s) : ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy-MM-dd", "yyyy-M-d", "yyyy-M-dd", "yyyy-MM-d", "yyyy-MM", "yyyy-M", "yyyy"}));
        this.findCompatibleTypeForCSV = (arg_0, arg_1) -> CSVInferSchema.$anonfun$findCompatibleTypeForCSV$1(this, arg_0, arg_1);
    }
}

