/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.EulerNumber;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Logarithm$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(base, expr) - Returns the logarithm of `expr` with `base`.", examples="\n    Examples:\n      > SELECT _FUNC_(10, 100);\n       2.0\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u000e\u001d\u0001&B\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\ty\u0001\u0011\t\u0012)A\u0005s!AQ\b\u0001BK\u0002\u0013\u0005\u0001\b\u0003\u0005?\u0001\tE\t\u0015!\u0003:\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015y\u0004\u0001\"\u0001E\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015a\u0005\u0001\"\u0015N\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015!\u0007\u0001\"\u0015f\u0011\u001dQ\u0007!!A\u0005\u0002-DqA\u001c\u0001\u0012\u0002\u0013\u0005q\u000eC\u0004{\u0001E\u0005I\u0011A8\t\u000fm\u0004\u0011\u0011!C!y\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001a\u0001\u0005\u0005I\u0011IA\u001b\u000f%\tI\u0006HA\u0001\u0012\u0003\tYF\u0002\u0005\u001c9\u0005\u0005\t\u0012AA/\u0011\u0019yT\u0003\"\u0001\u0002l!I\u0011QN\u000b\u0002\u0002\u0013\u0015\u0013q\u000e\u0005\n\u0003c*\u0012\u0011!CA\u0003gB\u0011\"!\u001f\u0016\u0003\u0003%\t)a\u001f\t\u0013\u00055U#!A\u0005\n\u0005=%!\u0003'pO\u0006\u0014\u0018\u000e\u001e5n\u0015\tib$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0010!\u0003!\u0019\u0017\r^1msN$(BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u00011\u0003\u0002\u0001+]Q\u0002\"a\u000b\u0017\u000e\u0003qI!!\f\u000f\u0003)\tKg.\u0019:z\u001b\u0006$\b.\u0012=qe\u0016\u001c8/[8o!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u001d\u0001&o\u001c3vGR\u0004\"aL\u001b\n\u0005Y\u0002$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012!\u000f\t\u0003WiJ!a\u000f\u000f\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0005\u00135\t\u0005\u0002,\u0001!)q'\u0002a\u0001s!)Q(\u0002a\u0001sQ\u0011\u0011)\u0012\u0005\u0006\r\u001a\u0001\r!O\u0001\u0006G\"LG\u000eZ\u0001\t]VdG.\u00192mKV\t\u0011\n\u0005\u00020\u0015&\u00111\n\r\u0002\b\u0005>|G.Z1o\u00031qW\u000f\u001c7TC\u001a,WI^1m)\rq\u0015k\u0015\t\u0003_=K!\u0001\u0015\u0019\u0003\u0007\u0005s\u0017\u0010C\u0003S\u0011\u0001\u0007a*\u0001\u0004j]B,H/\r\u0005\u0006)\"\u0001\rAT\u0001\u0007S:\u0004X\u000f\u001e\u001a\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA,^EB\u0011\u0001lW\u0007\u00023*\u0011!\fH\u0001\bG>$WmZ3o\u0013\ta\u0016L\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015q\u0016\u00021\u0001`\u0003\r\u0019G\u000f\u001f\t\u00031\u0002L!!Y-\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")1-\u0003a\u0001/\u0006\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2!\u00114i\u0011\u00159'\u00021\u0001:\u0003\u001dqWm\u001e'fMRDQ!\u001b\u0006A\u0002e\n\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0002BY6DqaN\u0006\u0011\u0002\u0003\u0007\u0011\bC\u0004>\u0017A\u0005\t\u0019A\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0001O\u000b\u0002:c.\n!\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003oB\n!\"\u00198o_R\fG/[8o\u0013\tIHOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002{B\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!A.\u00198h\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005\u007f\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0004\u0011\u0007=\n\t\"C\u0002\u0002\u0014A\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2ATA\r\u0011%\tY\u0002EA\u0001\u0002\u0004\ty!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003C\u0001R!a\t\u0002*9k!!!\n\u000b\u0007\u0005\u001d\u0002'\u0001\u0006d_2dWm\u0019;j_:LA!a\u000b\u0002&\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rI\u0015\u0011\u0007\u0005\t\u00037\u0011\u0012\u0011!a\u0001\u001d\u00061Q-];bYN$2!SA\u001c\u0011!\tYbEA\u0001\u0002\u0004q\u0005f\u0005\u0001\u0002<\u0005\u0005\u00131IA$\u0003\u0013\ni%a\u0014\u0002T\u0005U\u0003cA\u0016\u0002>%\u0019\u0011q\b\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QI\u0001B?\u001a+fjQ0)E\u0006\u001cX\r\f\u0011fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t7pO\u0006\u0014\u0018\u000e\u001e5nA=4\u0007\u0005Y3yaJ\u0004\u0007e^5uQ\u0002\u0002'-Y:fA:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u0017\nAH\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152a1\u0002\u0013\u0007\r\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012d\u0006\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011\u0011K\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003/\n!\"\\1uQ~3WO\\2t\u0003%aunZ1sSRDW\u000e\u0005\u0002,+M!Q#a\u00185!\u001d\t\t'a\u001a:s\u0005k!!a\u0019\u000b\u0007\u0005\u0015\u0004'A\u0004sk:$\u0018.\\3\n\t\u0005%\u00141\r\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA.\u0003!!xn\u0015;sS:<G#A?\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0005\u000b)(a\u001e\t\u000b]B\u0002\u0019A\u001d\t\u000buB\u0002\u0019A\u001d\u0002\u000fUt\u0017\r\u001d9msR!\u0011QPAE!\u0015y\u0013qPAB\u0013\r\t\t\t\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b=\n))O\u001d\n\u0007\u0005\u001d\u0005G\u0001\u0004UkBdWM\r\u0005\t\u0003\u0017K\u0012\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u00032A`AJ\u0013\r\t)j \u0002\u0007\u001f\nTWm\u0019;")
public class Logarithm
extends BinaryMathExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Logarithm logarithm) {
        return Logarithm$.MODULE$.unapply(logarithm);
    }

    public static Function1<Tuple2<Expression, Expression>, Logarithm> tupled() {
        return Logarithm$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Logarithm>> curried() {
        return Logarithm$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        double dLeft = BoxesRunTime.unboxToDouble((Object)input1);
        double dRight = BoxesRunTime.unboxToDouble((Object)input2);
        return dLeft <= 0.0 || dRight <= 0.0 ? null : BoxesRunTime.boxToDouble((double)(StrictMath.log(dRight) / StrictMath.log(dLeft)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.left() instanceof EulerNumber ? this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(c1, c2) -> new StringBuilder(129).append("\n          if (").append((String)c2).append(" <= 0.0) {\n            ").append(ev.isNull()).append(" = true;\n          } else {\n            ").append(ev.value()).append(" = java.lang.StrictMath.log(").append((String)c2).append(");\n          }\n        ").toString()) : this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(c1, c2) -> new StringBuilder(169).append("\n          if (").append((String)c1).append(" <= 0.0 || ").append((String)c2).append(" <= 0.0) {\n            ").append(ev.isNull()).append(" = true;\n          } else {\n            ").append(ev.value()).append(" = java.lang.StrictMath.log(").append((String)c2).append(") / java.lang.StrictMath.log(").append((String)c1).append(");\n          }\n        ").toString());
    }

    @Override
    public Logarithm withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public Logarithm copy(Expression left, Expression right) {
        return new Logarithm(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Logarithm";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Logarithm;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Logarithm)) return false;
        boolean bl = true;
        if (!bl) return false;
        Logarithm logarithm = (Logarithm)x$1;
        Expression expression = this.left();
        Expression expression2 = logarithm.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = logarithm.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!logarithm.canEqual(this)) return false;
        return true;
    }

    public Logarithm(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super((Function2<Object, Object, Object>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double c1, double c2) {
                return this.apply$mcDDD$sp(c1, c2);
            }

            public double apply$mcDDD$sp(double c1, double c2) {
                return StrictMath.log(c2) / StrictMath.log(c1);
            }
        }, "LOG");
    }

    public Logarithm(Expression child) {
        this(new EulerNumber(), child);
    }
}

