/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Extract$;
import org.apache.spark.sql.catalyst.expressions.InheritAnalysisRules;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(field FROM source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted\n          - Supported string values of `field` for dates and timestamps are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the year field\n              - \"YEAROFWEEK\" - the ISO 8601 week-numbering year that the datetime falls in. For example, 2005-01-02 is part of the 53rd week of year 2004, so the result is 2004\n              - \"QUARTER\", (\"QTR\") - the quarter (1 - 4) of the year that the datetime falls in\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the month field (1 - 12)\n              - \"WEEK\", (\"W\", \"WEEKS\") - the number of the ISO 8601 week-of-week-based-year. A week is considered to start on a Monday and week 1 is the first week with >3 days. In the ISO week-numbering system, it is possible for early-January dates to be part of the 52nd or 53rd week of the previous year, and for late-December dates to be part of the first week of the next year. For example, 2005-01-02 is part of the 53rd week of year 2004, while 2012-12-31 is part of the first week of 2013\n              - \"DAY\", (\"D\", \"DAYS\") - the day of the month field (1 - 31)\n              - \"DAYOFWEEK\",(\"DOW\") - the day of the week for datetime as Sunday(1) to Saturday(7)\n              - \"DAYOFWEEK_ISO\",(\"DOW_ISO\") - ISO 8601 based day of the week for datetime as Monday(1) to Sunday(7)\n              - \"DOY\" - the day of the year (1 - 365/366)\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - The hour field (0 - 23)\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - the minutes field (0 - 59)\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - the seconds field, including fractional parts\n          - Supported string values of `field` for interval(which consists of `months`, `days`, `microseconds`) are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the total `months` / 12\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the total `months` % 12\n              - \"DAY\", (\"D\", \"DAYS\") - the `days` part of interval\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - how many hours the `microseconds` contains\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - how many minutes left after taking hours from `microseconds`\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - how many second with fractions left after taking hours and minutes from `microseconds`\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(YEAR FROM TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_(week FROM timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_(doy FROM DATE'2019-08-12');\n       224\n      > SELECT _FUNC_(SECONDS FROM timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_(days FROM interval 5 days 3 hours 7 minutes);\n       5\n      > SELECT _FUNC_(seconds FROM interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n      > SELECT _FUNC_(MONTH FROM INTERVAL '2021-11' YEAR TO MONTH);\n       11\n      > SELECT _FUNC_(MINUTE FROM INTERVAL '123 23:55:59.002001' DAY TO SECOND);\n       55\n  ", note="\n    The _FUNC_ function is equivalent to `date_part(field, source)`.\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u000f\u001f\u0001.B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005Y!A!\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005D\u0001\tE\t\u0015!\u0003-\u0011!!\u0005A!f\u0001\n\u0003\u0001\u0005\u0002C#\u0001\u0005#\u0005\u000b\u0011\u0002\u0017\t\u000b\u0019\u0003A\u0011A$\t\u000b\u0019\u0003A\u0011\u0001'\t\u000b=\u0003A\u0011\t)\t\u000bu\u0003A\u0011\t0\t\u000b)\u0004A\u0011K6\t\u000f9\u0004\u0011\u0011!C\u0001_\"91\u000fAI\u0001\n\u0003!\bbB@\u0001#\u0003%\t\u0001\u001e\u0005\t\u0003\u0003\u0001\u0011\u0013!C\u0001i\"I\u00111\u0001\u0001\u0002\u0002\u0013\u0005\u0013Q\u0001\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"a\b\u0001\u0003\u0003%\t!!\t\t\u0013\u00055\u0002!!A\u0005B\u0005=\u0002\"CA\u001f\u0001\u0005\u0005I\u0011AA \u0011%\tI\u0005AA\u0001\n\u0003\nYeB\u0004\u0002|yA\t!! \u0007\ruq\u0002\u0012AA@\u0011\u00191u\u0003\"\u0001\u0002\b\"9\u0011\u0011R\f\u0005\u0002\u0005-\u0005\"CAK/\u0005\u0005I\u0011QAL\u0011%\tyjFA\u0001\n\u0003\u000b\t\u000bC\u0005\u00024^\t\t\u0011\"\u0003\u00026\n9Q\t\u001f;sC\u000e$(BA\u0010!\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001a\u0003g\r\u001c=!\tic&D\u0001\u001f\u0013\tycD\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!L\u0019\n\u0005Ir\"A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"!\f\u001b\n\u0005Ur\"\u0001F%oQ\u0016\u0014\u0018\u000e^!oC2L8/[:Sk2,7\u000f\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0004Qe>$Wo\u0019;\u0011\u0005]j\u0014B\u0001 9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u00151\u0017.\u001a7e+\u0005a\u0013A\u00024jK2$\u0007%\u0001\u0004t_V\u00148-Z\u0001\bg>,(oY3!\u0003-\u0011X\r\u001d7bG\u0016lWM\u001c;\u0002\u0019I,\u0007\u000f\\1dK6,g\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\u0011A\u0015JS&\u0011\u00055\u0002\u0001\"B \b\u0001\u0004a\u0003\"\u0002\"\b\u0001\u0004a\u0003\"\u0002#\b\u0001\u0004aCc\u0001%N\u001d\")q\b\u0003a\u0001Y!)!\t\u0003a\u0001Y\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0016\u0003E\u00032A\u0015.-\u001d\t\u0019\u0006L\u0004\u0002U/6\tQK\u0003\u0002WU\u00051AH]8pizJ\u0011!O\u0005\u00033b\nq\u0001]1dW\u0006<W-\u0003\u0002\\9\n\u00191+Z9\u000b\u0005eC\u0014!D7bW\u0016\u001c\u0016\u000bT*ue&tw\r\u0006\u0002`OB\u0011\u0001\r\u001a\b\u0003C\n\u0004\"\u0001\u0016\u001d\n\u0005\rD\u0014A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!a\u0019\u001d\t\u000b!T\u0001\u0019A5\u0002\u0017\rD\u0017\u000e\u001c3sK:\u001c\u0016\u000b\u0014\t\u0004%j{\u0016\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000e\u0006\u0002-Y\")Qn\u0003a\u0001Y\u0005Aa.Z<DQ&dG-\u0001\u0003d_BLH\u0003\u0002%qcJDqa\u0010\u0007\u0011\u0002\u0003\u0007A\u0006C\u0004C\u0019A\u0005\t\u0019\u0001\u0017\t\u000f\u0011c\u0001\u0013!a\u0001Y\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A;+\u0005128&A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018!C;oG\",7m[3e\u0015\ta\b(\u0001\u0006b]:|G/\u0019;j_:L!A`=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005!A.\u00198h\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017bA3\u0002\f\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0004\t\u0004o\u0005m\u0011bAA\u000fq\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111EA\u0015!\r9\u0014QE\u0005\u0004\u0003OA$aA!os\"I\u00111\u0006\n\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0002CBA\u001a\u0003s\t\u0019#\u0004\u0002\u00026)\u0019\u0011q\u0007\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0005U\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0011\u0002HA\u0019q'a\u0011\n\u0007\u0005\u0015\u0003HA\u0004C_>dW-\u00198\t\u0013\u0005-B#!AA\u0002\u0005\r\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002B\u00055\u0003\"CA\u0016+\u0005\u0005\t\u0019AA\u0012Qm\u0001\u0011\u0011KA,\u00033\ni&a\u0018\u0002d\u0005\u0015\u0014\u0011NA6\u0003_\n\t(!\u001e\u0002xA\u0019Q&a\u0015\n\u0007\u0005UcDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005m\u0013!V0G+:\u001bu\f\u000b4jK2$\u0007E\u0012*P\u001b\u0002\u001ax.\u001e:dK&\u0002S\u0006I#yiJ\f7\r^:!C\u0002\u0002\u0018M\u001d;!_\u001a\u0004C\u000f[3!I\u0006$Xm\f;j[\u0016\u001cH/Y7qA=\u0014\b%\u001b8uKJ4\u0018\r\u001c\u0011t_V\u00148-\u001a\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA1\u0003M-'\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011gS\u0016dG\rI\u0017!g\u0016dWm\u0019;tA]D\u0017n\u00195!a\u0006\u0014H\u000fI8gAQDW\rI:pkJ\u001cW\rI:i_VdG\r\t2fA\u0015DHO]1di\u0016$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u001aV\u000f\u001d9peR,G\rI:ue&tw\r\t<bYV,7\u000fI8gA\u00014\u0017.\u001a7eA\u00022wN\u001d\u0011eCR,7\u000fI1oI\u0002\"\u0018.\\3ti\u0006l\u0007o\u001d\u0011be\u0016D3-Y:fA%t7/\u001a8tSRLg/Z\u0015;\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%W#B%\nb\u0003\u0005\u000b\u0012ZE1\u0002#%W#B%N\u0013C\u0006\t\u0012Z%\nb\u0003EI-S'\nJ\u0003%\f\u0011uQ\u0016\u0004\u00130Z1sA\u0019LW\r\u001c3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012\u0013,R!S\u001f\u001a;V)R&#A5\u0002C\u000f[3!\u0013N{\u0005\u0005\u000f\u001c1c\u0001:X-Z6.]Vl'-\u001a:j]\u001e\u0004\u00130Z1sAQD\u0017\r\u001e\u0011uQ\u0016\u0004C-\u0019;fi&lW\r\t4bY2\u001c\b%\u001b8/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!eA\u0002T'\f\u00192[A\u0012\u0004%[:!a\u0006\u0014H\u000fI8gAQDW\rI\u001b4e\u0012\u0004s/Z3lA=4\u0007%_3be\u0002\u0012\u0004\u0007\r\u001b-AM|\u0007\u0005\u001e5fAI,7/\u001e7uA%\u001c\bE\r\u00191i)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI)V\u0003J#VI\u0015\u0012-A!\u0012\u0013\u000b\u0016*#S\u0001j\u0003\u0005\u001e5fAE,\u0018M\u001d;fe\u0002B\u0013\u0007I\u0017!i%\u0002sN\u001a\u0011uQ\u0016\u0004\u00130Z1sAQD\u0017\r\u001e\u0011uQ\u0016\u0004C-\u0019;fi&lW\r\t4bY2\u001c\b%\u001b8\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012Sj\u0014(U\u0011\nb\u0003\u0005\u000b\u0012N\u001f:\u0013C\u0006\t\u0012N\u001f:\u001b&\u0005\f\u0011#\u001b>sE\u000bS*#S\u0001j\u0003\u0005\u001e5fA5|g\u000e\u001e5!M&,G\u000e\u001a\u0011)c\u0001j\u0003%\r\u001a*\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#eV#F\u0017\nb\u0003\u0005\u000b\u0012XE1\u0002#eV#F\u0017N\u0013\u0013\u0006I\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!i\",\u0007%S*PAa2\u0004'\r\u0011xK\u0016\\Wf\u001c4.o\u0016,7.\f2bg\u0016$W&_3be:\u0002\u0013\tI<fK.\u0004\u0013n\u001d\u0011d_:\u001c\u0018\u000eZ3sK\u0012\u0004Co\u001c\u0011ti\u0006\u0014H\u000fI8oA\u0005\u0004Sj\u001c8eCf\u0004\u0013M\u001c3!o\u0016,7\u000eI\u0019!SN\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011xK\u0016\\\u0007e^5uQ\u0002r4\u0007\t3bsNt\u0003%\u00138!i\",\u0007%S*PA],Wm[\u0017ok6\u0014WM]5oO\u0002\u001a\u0018p\u001d;f[2\u0002\u0013\u000e\u001e\u0011jg\u0002\u0002xn]:jE2,\u0007EZ8sA\u0015\f'\u000f\\=.\u0015\u0006tW/\u0019:zA\u0011\fG/Z:!i>\u0004#-\u001a\u0011qCJ$\be\u001c4!i\",\u0007%\u000e\u001aoI\u0002z'\u000fI\u001b4e\u0012\u0004s/Z3lA=4\u0007\u0005\u001e5fAA\u0014XM^5pkN\u0004\u00130Z1sY\u0001\ng\u000e\u001a\u0011g_J\u0004C.\u0019;f[\u0011+7-Z7cKJ\u0004C-\u0019;fg\u0002\"x\u000e\t2fAA\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI<fK.\u0004sN\u001a\u0011uQ\u0016\u0004c.\u001a=uAe,\u0017M\u001d\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u00113aA*T\u0006M\u0019.aI\u0002\u0013n\u001d\u0011qCJ$\be\u001c4!i\",\u0007%N\u001asI\u0002:X-Z6!_\u001a\u0004\u00130Z1sAI\u0002\u0004\u0007\u000e\u0017!o\"LG.\u001a\u00113aE\u0012T&\r\u001a.gE\u0002\u0013n\u001d\u0011qCJ$\be\u001c4!i\",\u0007EZ5sgR\u0004s/Z3lA=4\u0007E\r\u00192g)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#B3\nb\u0003\u0005\u000b\u0012EE1\u0002#\u0005R!Z'\nJ\u0003%\f\u0011uQ\u0016\u0004C-Y=!_\u001a\u0004C\u000f[3![>tG\u000f\u001b\u0011gS\u0016dG\r\t\u00152A5\u00023'M\u0015\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012C)Q-P\r^+Ui\u0013\u0012-Q\t\"uj\u0016\u0012*A5\u0002C\u000f[3!I\u0006L\be\u001c4!i\",\u0007e^3fW\u00022wN\u001d\u0011eCR,G/[7fA\u0005\u001c\beU;oI\u0006L\b&M\u0015!i>\u00043+\u0019;ve\u0012\f\u0017\u0010K\u001c*\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#\u0005R!Z\u001f\u001a;V)R&`\u0013N{%\u0005\f\u0015#\t>;v,S*PE%\u0002S\u0006I%T\u001f\u0002Bd\u0007M\u0019!E\u0006\u001cX\r\u001a\u0011eCf\u0004sN\u001a\u0011uQ\u0016\u0004s/Z3lA\u0019|'\u000f\t3bi\u0016$\u0018.\\3!CN\u0004Sj\u001c8eCfD\u0013'\u000b\u0011u_\u0002\u001aVO\u001c3bs\":\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E\u0011{\u0015L\t\u0011.AQDW\r\t3bs\u0002zg\r\t;iK\u0002JX-\u0019:!QE\u0002S\u0006I\u001a7k=\u001adGN\u0015\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012\u0003jT+SE1\u0002\u0003F\t%#Y\u0001\u0012\u0003jT+S'\nb\u0003E\t%SE1\u0002#\u0005\u0013*TE%\u0002S\u0006\t+iK\u0002Bw.\u001e:!M&,G\u000e\u001a\u0011)a\u0001j\u0003EM\u001a*\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T%O+R+%\u0005\f\u0011)E5\u0013C\u0006\t\u0012N\u0013:\u0013C\u0006\t\u0012N\u0013:\u001b&\u0005\f\u0011#\u001b&sU\u000bV#TE%\u0002S\u0006\t;iK\u0002j\u0017N\\;uKN\u0004c-[3mI\u0002B\u0003\u0007I\u0017!keJ#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#'\u0016\u001buJ\u0014##Y\u0001B#e\u0015\u0012-A\t\u001aVi\u0011\u0012-A\t\u001aViQ(O\tN\u0013C\u0006\t\u0012T\u000b\u000e\u001b&%\u000b\u0011.AQDW\rI:fG>tGm\u001d\u0011gS\u0016dG\r\f\u0011j]\u000edW\u000fZ5oO\u00022'/Y2uS>t\u0017\r\u001c\u0011qCJ$8O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u00023+\u001e9q_J$X\r\u001a\u0011tiJLgn\u001a\u0011wC2,Xm\u001d\u0011pM\u0002\u0002g-[3mI\u0002\u0004cm\u001c:!S:$XM\u001d<bY\":\b.[2iA\r|gn]5tiN\u0004sN\u001a\u0011a[>tG\u000f[:aY\u0001\u0002G-Y=tA2\u0002\u0003-\\5de>\u001cXmY8oIN\u0004\u0017\u0006I1sK\"\u001a\u0017m]3!S:\u001cXM\\:ji&4X-\u000b\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012\u0013,R!SE1\u0002\u0003FI-#Y\u0001\u0012\u0013,R!S'\nb\u0003EI-SE1\u0002#%\u0017*TE%\u0002S\u0006\t;iK\u0002\"x\u000e^1mA\u0001lwN\u001c;ig\u0002\u0004s\u0006I\u00193\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T(O)\"\u0013C\u0006\t\u0015#\u001b>s%\u0005\f\u0011#\u001b>s5K\t\u0017!E5{e\n\u0016%TE%\u0002S\u0006\t;iK\u0002\"x\u000e^1mA\u0001lwN\u001c;ig\u0002\u0004S\u0005I\u00193\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#\u0005R!ZE1\u0002\u0003F\t##Y\u0001\u0012C)Q-TE%\u0002S\u0006\t;iK\u0002\u0002G-Y=tA\u0002\u0002\u0018M\u001d;!_\u001a\u0004\u0013N\u001c;feZ\fGN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E!{UK\u0015\u0012-A!\u0012\u0003J\t\u0017!E!{UKU*#Y\u0001\u0012\u0003J\u0015\u0012-A\tB%k\u0015\u0012*A5\u0002\u0003n\\<![\u0006t\u0017\u0010\t5pkJ\u001c\b\u0005\u001e5fA\u0001l\u0017n\u0019:pg\u0016\u001cwN\u001c3tA\u0002\u001awN\u001c;bS:\u001c(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b&sU\u000bV##Y\u0001B#%\u0014\u0012-A\tj\u0015J\u0014\u0012-A\tj\u0015JT*#Y\u0001\u0012S*\u0013(V)\u0016\u001b&%\u000b\u0011.A!|w\u000fI7b]f\u0004S.\u001b8vi\u0016\u001c\b\u0005\\3gi\u0002\ng\r^3sAQ\f7.\u001b8hA!|WO]:!MJ|W\u000e\t1nS\u000e\u0014xn]3d_:$7\u000f\u0019\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\u001aViQ(O\t\nb\u0003\u0005\u000b\u0012TE1\u0002#eU#DE1\u0002#eU#D\u001f:#5K\t\u0017!EM+5i\u0015\u0012*A5\u0002\u0003n\\<![\u0006t\u0017\u0010I:fG>tG\rI<ji\"\u0004cM]1di&|gn\u001d\u0011mK\u001a$\b%\u00194uKJ\u0004C/Y6j]\u001e\u0004\u0003n\\;sg\u0002\ng\u000e\u001a\u0011nS:,H/Z:!MJ|W\u000e\t1nS\u000e\u0014xn]3d_:$7\u000f\u0019\u0006!A\u0001\u0002\u0003\u0005\t\u0016!g>,(oY3![\u0001\n\u0007\u0005Z1uK>\"\u0018.\\3ti\u0006l\u0007\u000fI8sA%tG/\u001a:wC2\u00043m\u001c7v[:\u0004cM]8nA]DWM]3!A\u001aLW\r\u001c3aAMDw.\u001e7eA\t,\u0007%\u001a=ue\u0006\u001cG/\u001a3\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003O\nQQ\u000e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)3\u0016\u000b%\u000b\t$S\u001f6\u0003C+S'F'R\u000bU\n\u0015\u0011(eA\n\u0014(\f\u00199[E\u0012\u0004\u0005M\u0019;aAR\u0004\u0007\r\u00182eM\"TGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001d\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q],Wm\u001b\u0011G%>k\u0005\u0005^5nKN$\u0018-\u001c9(eA\n\u0014(\f\u00199[E\u0012\u0004\u0005M\u0019;aAR\u0004\u0007\r\u00182eM\"TGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a4G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015e_f\u0004cIU(NA\u0011\u000bE+R\u00143aEJT\u0006\r\u001d.cI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113eQR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fU#D\u001f:#5\u000b\t$S\u001f6\u0003C/[7fgR\fW\u000e]\u00143aEJT&\r\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0014G\f\u00191aA\u0002\u0014gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEr\u0003\u0007\r\u00191aER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006Z1zg\u00022%kT'!S:$XM\u001d<bY\u0002*\u0004\u0005Z1zg\u0002\u001a\u0004\u0005[8veN\u0004s\u0007I7j]V$Xm]\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AUR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f]3d_:$7\u000f\t$S\u001f6\u0003\u0013N\u001c;feZ\fG\u000eI\u001b!Q>,(o\u001d\u00114a\u0001\u001aXmY8oIN\u0004\u0013\u0007I7jY2L7/Z2p]\u0012\u001c\b%\r\u0011nS\u000e\u0014xn]3d_:$7/K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!gAr\u0003\u0007M\u00191aER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&T(O)\"\u0003cIU(NA%sE+\u0012*W\u00032\u0003sE\r\u00193c5\n\u0014g\n\u0011Z\u000b\u0006\u0013\u0006\u0005V(!\u001b>sE\u000bS\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK'J\u001dV#V\t\t$S\u001f6\u0003\u0013J\u0014+F%Z\u000bE\nI\u00142eM\u0002#g\r\u001e6ki*\u0014H\f\u00191eA\u0002\u0014g\n\u0011E\u0003f\u0003Ck\u0014\u0011T\u000b\u000e{e\nR\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AU*$\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003[\n\u0001J\u0003\u0011!A\u0001\"\u0006.\u001a\u0011`\rVs5i\u0018\u0011gk:\u001cG/[8oA%\u001c\b%Z9vSZ\fG.\u001a8uAQ|\u0007\u0005\u00193bi\u0016|\u0006/\u0019:uQ\u0019LW\r\u001c3-AM|WO]2fS\u0001t#\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005M\u0014A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003s\nQa\r\u00181]A\nq!\u0012=ue\u0006\u001cG\u000f\u0005\u0002./M!q#!!=!\r9\u00141Q\u0005\u0004\u0003\u000bC$AB!osJ+g\r\u0006\u0002\u0002~\u0005Q1M]3bi\u0016,\u0005\u0010\u001d:\u0015\u000f1\ni)!%\u0002\u0014\"1\u0011qR\rA\u0002}\u000b\u0001BZ;oG:\u000bW.\u001a\u0005\u0006\u007fe\u0001\r\u0001\f\u0005\u0006\u0005f\u0001\r\u0001L\u0001\u0006CB\u0004H.\u001f\u000b\b\u0011\u0006e\u00151TAO\u0011\u0015y$\u00041\u0001-\u0011\u0015\u0011%\u00041\u0001-\u0011\u0015!%\u00041\u0001-\u0003\u001d)h.\u00199qYf$B!a)\u00020B)q'!*\u0002*&\u0019\u0011q\u0015\u001d\u0003\r=\u0003H/[8o!\u00199\u00141\u0016\u0017-Y%\u0019\u0011Q\u0016\u001d\u0003\rQ+\b\u000f\\34\u0011!\t\tlGA\u0001\u0002\u0004A\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\f\u0005\u0003\u0002\n\u0005e\u0016\u0002BA^\u0003\u0017\u0011aa\u00142kK\u000e$\b")
public class Extract
extends Expression
implements RuntimeReplaceable,
InheritAnalysisRules,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression replacement;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Extract extract2) {
        return Extract$.MODULE$.unapply(extract2);
    }

    public static Expression createExpr(String string, Expression expression, Expression expression2) {
        return Extract$.MODULE$.createExpr(string, expression, expression2);
    }

    @Override
    public Expression child() {
        return InheritAnalysisRules.child$(this);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return InheritAnalysisRules.flatArguments$(this);
    }

    @Override
    public final String sql() {
        return InheritAnalysisRules.sql$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        Extract extract2 = this;
        synchronized (extract2) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        Extract extract2 = this;
        synchronized (extract2) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression replacement() {
        return this.replacement;
    }

    @Override
    public Seq<Expression> parameters() {
        return (Seq)new .colon.colon((Object)this.field(), (List)new .colon.colon((Object)this.source(), (List)Nil$.MODULE$));
    }

    @Override
    public String makeSQLString(Seq<String> childrenSQL) {
        Some some;
        String string;
        Option<String> option = this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS());
        String string2 = option instanceof Some && "date_part".equals(string = (String)(some = (Some)option).value()) ? new StringBuilder(2).append(this.prettyName()).append("(").append(childrenSQL.mkString(", ")).append(")").toString() : new StringBuilder(2).append(this.prettyName()).append("(").append(childrenSQL.mkString(" FROM ")).append(")").toString();
        return string2;
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public Extract copy(Expression field, Expression source, Expression replacement) {
        return new Extract(field, source, replacement);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.replacement();
    }

    @Override
    public String productPrefix() {
        return "Extract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.field();
                break;
            }
            case 1: {
                expression = this.source();
                break;
            }
            case 2: {
                expression = this.replacement();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Extract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Extract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Extract extract2 = (Extract)x$1;
        Expression expression = this.field();
        Expression expression2 = extract2.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = extract2.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replacement();
        Expression expression6 = extract2.replacement();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!extract2.canEqual(this)) return false;
        return true;
    }

    public Extract(Expression field, Expression source, Expression replacement) {
        this.field = field;
        this.source = source;
        this.replacement = replacement;
        RuntimeReplaceable.$init$(this);
        UnaryLike.$init$(this);
        InheritAnalysisRules.$init$(this);
    }

    public Extract(Expression field, Expression source) {
        this(field, source, Extract$.MODULE$.createExpr("extract", field, source));
    }
}

