/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.DeserializerBuildHelper$;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.SerializerBuildHelper$;
import org.apache.spark.sql.catalyst.WalkedTypePath;
import org.apache.spark.sql.catalyst.WalkedTypePath$;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.objects.CreateExternalRow;
import org.apache.spark.sql.catalyst.expressions.objects.GetExternalRowField;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.expressions.objects.MapObjects;
import org.apache.spark.sql.catalyst.expressions.objects.MapObjects$;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.objects.ValidateExternalType;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UDTRegistration$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RowEncoder$ {
    public static RowEncoder$ MODULE$;

    static {
        new RowEncoder$();
    }

    public ExpressionEncoder<Row> apply(StructType schema, boolean lenient) {
        Class<Row> cls = Row.class;
        BoundReference inputObject = new BoundReference(0, new ObjectType(cls), true);
        Expression serializer = this.serializerFor(inputObject, schema, lenient);
        Expression deserializer = this.deserializerFor((Expression)new GetColumnByOrdinal(0, serializer.dataType()), schema);
        return new ExpressionEncoder<Row>(serializer, deserializer, ClassTag$.MODULE$.apply(cls));
    }

    public ExpressionEncoder<Row> apply(StructType schema) {
        return this.apply(schema, false);
    }

    private Expression serializerFor(Expression inputObject, DataType inputType, boolean lenient) {
        Expression expression;
        block26: {
            DataType dataType;
            while (true) {
                if (ScalaReflection$.MODULE$.isNativeType(dataType = inputType)) {
                    expression = inputObject;
                    break block26;
                }
                if (!(dataType instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType;
                inputType = pythonUserDefinedType.sqlType();
            }
            if (dataType instanceof UserDefinedType) {
                NewInstance obj;
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                SQLUserDefinedType annotation = userDefinedType.userClass().getAnnotation(SQLUserDefinedType.class);
                Class udtClass = annotation != null ? annotation.udt() : (Class)UDTRegistration$.MODULE$.getUDTFor(userDefinedType.userClass().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw QueryExecutionErrors$.MODULE$.userDefinedTypeNotAnnotatedAndRegisteredError(userDefinedType);
                });
                NewInstance x$1 = obj = NewInstance$.MODULE$.apply(udtClass, (Seq<Expression>)Nil$.MODULE$, new ObjectType(udtClass), false);
                String x$2 = "serialize";
                UserDefinedType x$3 = userDefinedType;
                Expression expression2 = inputObject;
                List x$4 = Nil$.MODULE$.$colon$colon((Object)expression2);
                boolean x$5 = false;
                Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
                boolean x$7 = Invoke$.MODULE$.apply$default$6();
                boolean x$8 = Invoke$.MODULE$.apply$default$8();
                expression = new Invoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                expression = lenient ? SerializerBuildHelper$.MODULE$.createSerializerForAnyTimestamp(inputObject) : (SQLConf$.MODULE$.get().datetimeJava8ApiEnabled() ? SerializerBuildHelper$.MODULE$.createSerializerForJavaInstant(inputObject) : SerializerBuildHelper$.MODULE$.createSerializerForSqlTimestamp(inputObject));
            } else if (TimestampNTZType$.MODULE$.equals(dataType) && Utils$.MODULE$.isTesting()) {
                expression = SerializerBuildHelper$.MODULE$.createSerializerForLocalDateTime(inputObject);
            } else if (DateType$.MODULE$.equals(dataType)) {
                expression = lenient ? SerializerBuildHelper$.MODULE$.createSerializerForAnyDate(inputObject) : (SQLConf$.MODULE$.get().datetimeJava8ApiEnabled() ? SerializerBuildHelper$.MODULE$.createSerializerForJavaLocalDate(inputObject) : SerializerBuildHelper$.MODULE$.createSerializerForSqlDate(inputObject));
            } else if (dataType instanceof DayTimeIntervalType) {
                expression = SerializerBuildHelper$.MODULE$.createSerializerForJavaDuration(inputObject);
            } else if (dataType instanceof YearMonthIntervalType) {
                expression = SerializerBuildHelper$.MODULE$.createSerializerForJavaPeriod(inputObject);
            } else if (dataType instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType;
                Class<?> x$9 = Decimal$.MODULE$.getClass();
                DecimalType x$10 = decimalType;
                String x$11 = "fromDecimal";
                Expression expression3 = inputObject;
                List x$12 = Nil$.MODULE$.$colon$colon((Object)expression3);
                boolean x$13 = false;
                Seq<AbstractDataType> x$14 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$15 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$16 = StaticInvoke$.MODULE$.apply$default$8();
                expression = new CheckOverflow(new StaticInvoke(x$9, x$10, x$11, (Seq<Expression>)x$12, x$14, x$15, x$13, x$16), decimalType, !SQLConf$.MODULE$.get().ansiEnabled());
            } else if (StringType$.MODULE$.equals(dataType)) {
                expression = SerializerBuildHelper$.MODULE$.createSerializerForString(inputObject);
            } else if (dataType instanceof ArrayType) {
                Expression expression4;
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                DataType dataType2 = et;
                boolean bl = BooleanType$.MODULE$.equals(dataType2) ? true : (ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2))))));
                if (bl) {
                    Class<ArrayData> x$17 = ArrayData.class;
                    ArrayType x$18 = arrayType;
                    String x$19 = "toArrayData";
                    Expression expression5 = inputObject;
                    List x$20 = Nil$.MODULE$.$colon$colon((Object)expression5);
                    boolean x$21 = false;
                    Seq<AbstractDataType> x$22 = StaticInvoke$.MODULE$.apply$default$5();
                    boolean x$23 = StaticInvoke$.MODULE$.apply$default$6();
                    boolean x$24 = StaticInvoke$.MODULE$.apply$default$8();
                    expression4 = new StaticInvoke(x$17, x$18, x$19, (Seq<Expression>)x$20, x$22, x$23, x$21, x$24);
                } else {
                    expression4 = SerializerBuildHelper$.MODULE$.createSerializerForMapObjects(inputObject, new ObjectType(Object.class), (Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)element -> {
                        Expression value = MODULE$.serializerFor(new ValidateExternalType((Expression)element, et, lenient), et, lenient);
                        return DeserializerBuildHelper$.MODULE$.expressionWithNullSafety(value, containsNull, new WalkedTypePath(WalkedTypePath$.MODULE$.apply$default$1()));
                    });
                }
                expression = expression4;
            } else if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueNullable = mapType.valueContainsNull();
                Expression x$25 = inputObject;
                String x$26 = "keysIterator";
                ObjectType x$27 = new ObjectType(Iterator.class);
                boolean x$28 = false;
                Seq<Expression> x$29 = Invoke$.MODULE$.apply$default$4();
                Seq<AbstractDataType> x$30 = Invoke$.MODULE$.apply$default$5();
                boolean x$31 = Invoke$.MODULE$.apply$default$6();
                boolean x$32 = Invoke$.MODULE$.apply$default$8();
                Invoke x$33 = new Invoke(x$25, x$26, x$27, x$29, x$30, x$31, x$28, x$32);
                String x$34 = "toSeq";
                ObjectType x$35 = new ObjectType(Seq.class);
                boolean x$36 = false;
                Seq<Expression> x$37 = Invoke$.MODULE$.apply$default$4();
                Seq<AbstractDataType> x$38 = Invoke$.MODULE$.apply$default$5();
                boolean x$39 = Invoke$.MODULE$.apply$default$6();
                boolean x$40 = Invoke$.MODULE$.apply$default$8();
                Invoke keys = new Invoke(x$33, x$34, x$35, x$37, x$38, x$39, x$36, x$40);
                Expression convertedKeys = this.serializerFor(keys, new ArrayType(kt, false), lenient);
                Expression x$41 = inputObject;
                String x$42 = "valuesIterator";
                ObjectType x$43 = new ObjectType(Iterator.class);
                boolean x$44 = false;
                Seq<Expression> x$45 = Invoke$.MODULE$.apply$default$4();
                Seq<AbstractDataType> x$46 = Invoke$.MODULE$.apply$default$5();
                boolean x$47 = Invoke$.MODULE$.apply$default$6();
                boolean x$48 = Invoke$.MODULE$.apply$default$8();
                Invoke x$49 = new Invoke(x$41, x$42, x$43, x$45, x$46, x$47, x$44, x$48);
                String x$50 = "toSeq";
                ObjectType x$51 = new ObjectType(Seq.class);
                boolean x$52 = false;
                Seq<Expression> x$53 = Invoke$.MODULE$.apply$default$4();
                Seq<AbstractDataType> x$54 = Invoke$.MODULE$.apply$default$5();
                boolean x$55 = Invoke$.MODULE$.apply$default$6();
                boolean x$56 = Invoke$.MODULE$.apply$default$8();
                Invoke values = new Invoke(x$49, x$50, x$51, x$53, x$54, x$55, x$52, x$56);
                Expression convertedValues = this.serializerFor(values, new ArrayType(vt, valueNullable), lenient);
                Expression expression6 = convertedKeys;
                Expression expression7 = convertedValues;
                NewInstance nonNullOutput = NewInstance$.MODULE$.apply(ArrayBasedMapData.class, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression7).$colon$colon((Object)expression6), mapType, false);
                expression = inputObject.nullable() ? this.expressionForNullableExpr(inputObject, nonNullOutput) : nonNullOutput;
            } else if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                CreateNamedStruct nonNullOutput = new CreateNamedStruct((Seq<Expression>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Expression expression;
                    StructField field;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        field = (StructField)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Expression fieldValue = MODULE$.serializerFor(new ValidateExternalType(new GetExternalRowField(inputObject, index, field.name()), field.dataType(), lenient), field.dataType(), lenient);
                        if (field.nullable()) {
                            Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)index));
                            If if_ = new If(new Invoke(inputObject, "isNullAt", BooleanType$.MODULE$, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)literal), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()), Literal$.MODULE$.create(null, fieldValue.dataType()), fieldValue);
                            expression = if_;
                        } else {
                            expression = fieldValue;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Expression convertedField = expression;
                    Literal literal = Literal$.MODULE$.apply(field.name());
                    Expression expression2 = convertedField;
                    List list = Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)literal);
                    return list;
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                expression = inputObject.nullable() ? this.expressionForNullableExpr(inputObject, nonNullOutput) : nonNullOutput;
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return expression;
    }

    public DataType externalDataTypeForInput(DataType dt, boolean lenient) {
        boolean bl;
        DataType dataType = dt;
        DataType dataType2 = dataType instanceof DecimalType ? new ObjectType(Object.class) : (dataType instanceof ArrayType ? new ObjectType(Object.class) : ((bl = dataType instanceof DateType ? true : dataType instanceof TimestampType) && lenient ? new ObjectType(Object.class) : this.externalDataTypeFor(dt)));
        return dataType2;
    }

    public DataType externalDataTypeFor(DataType dt) {
        DataType dataType;
        block14: {
            DataType dataType2;
            while (true) {
                dataType2 = dt;
                if (ScalaReflection$.MODULE$.isNativeType(dt)) {
                    dataType = dt;
                    break block14;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    dataType = SQLConf$.MODULE$.get().datetimeJava8ApiEnabled() ? new ObjectType(Instant.class) : new ObjectType(Timestamp.class);
                    break block14;
                }
                if (TimestampNTZType$.MODULE$.equals(dataType2) && Utils$.MODULE$.isTesting()) {
                    dataType = new ObjectType(LocalDateTime.class);
                    break block14;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    dataType = SQLConf$.MODULE$.get().datetimeJava8ApiEnabled() ? new ObjectType(LocalDate.class) : new ObjectType(Date.class);
                    break block14;
                }
                if (dataType2 instanceof DayTimeIntervalType) {
                    dataType = new ObjectType(Duration.class);
                    break block14;
                }
                if (dataType2 instanceof YearMonthIntervalType) {
                    dataType = new ObjectType(Period.class);
                    break block14;
                }
                if (dataType2 instanceof DecimalType) {
                    dataType = new ObjectType(BigDecimal.class);
                    break block14;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    dataType = new ObjectType(String.class);
                    break block14;
                }
                if (dataType2 instanceof ArrayType) {
                    dataType = new ObjectType(Seq.class);
                    break block14;
                }
                if (dataType2 instanceof MapType) {
                    dataType = new ObjectType(Map.class);
                    break block14;
                }
                if (dataType2 instanceof StructType) {
                    dataType = new ObjectType(Row.class);
                    break block14;
                }
                if (!(dataType2 instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                dt = pythonUserDefinedType.sqlType();
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = new ObjectType(userDefinedType.userClass());
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return dataType;
    }

    private Expression deserializerFor(Expression input, StructType schema) {
        Seq fields = (Seq)((TraversableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int i = tuple2._2$mcI$sp();
            Expression expression = MODULE$.deserializerFor(new GetStructField(input, i, GetStructField$.MODULE$.apply$default$3()));
            return expression;
        }, Seq$.MODULE$.canBuildFrom());
        return new CreateExternalRow((Seq<Expression>)fields, schema);
    }

    private Expression deserializerFor(Expression input) {
        return this.deserializerFor(input, input.dataType());
    }

    private Expression deserializerFor(Expression input, DataType dataType) {
        Expression expression;
        block24: {
            DataType dataType2;
            while (true) {
                if (ScalaReflection$.MODULE$.isNativeType(dataType2 = dataType)) {
                    expression = input;
                    break block24;
                }
                if (!(dataType2 instanceof PythonUserDefinedType)) break;
                PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType2;
                dataType = pythonUserDefinedType.sqlType();
            }
            if (dataType2 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                SQLUserDefinedType annotation = userDefinedType.userClass().getAnnotation(SQLUserDefinedType.class);
                Class udtClass = annotation != null ? annotation.udt() : (Class)UDTRegistration$.MODULE$.getUDTFor(userDefinedType.userClass().getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw QueryExecutionErrors$.MODULE$.userDefinedTypeNotAnnotatedAndRegisteredError(userDefinedType);
                });
                NewInstance obj = NewInstance$.MODULE$.apply(udtClass, (Seq<Expression>)Nil$.MODULE$, new ObjectType(udtClass), NewInstance$.MODULE$.apply$default$4());
                Expression expression2 = input;
                expression = new Invoke(obj, "deserialize", new ObjectType(userDefinedType.userClass()), (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression2), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
            } else if (TimestampType$.MODULE$.equals(dataType2)) {
                expression = SQLConf$.MODULE$.get().datetimeJava8ApiEnabled() ? DeserializerBuildHelper$.MODULE$.createDeserializerForInstant(input) : DeserializerBuildHelper$.MODULE$.createDeserializerForSqlTimestamp(input);
            } else if (TimestampNTZType$.MODULE$.equals(dataType2) && Utils$.MODULE$.isTesting()) {
                expression = DeserializerBuildHelper$.MODULE$.createDeserializerForLocalDateTime(input);
            } else if (DateType$.MODULE$.equals(dataType2)) {
                expression = SQLConf$.MODULE$.get().datetimeJava8ApiEnabled() ? DeserializerBuildHelper$.MODULE$.createDeserializerForLocalDate(input) : DeserializerBuildHelper$.MODULE$.createDeserializerForSqlDate(input);
            } else if (dataType2 instanceof DayTimeIntervalType) {
                expression = DeserializerBuildHelper$.MODULE$.createDeserializerForDuration(input);
            } else if (dataType2 instanceof YearMonthIntervalType) {
                expression = DeserializerBuildHelper$.MODULE$.createDeserializerForPeriod(input);
            } else if (dataType2 instanceof DecimalType) {
                expression = DeserializerBuildHelper$.MODULE$.createDeserializerForJavaBigDecimal(input, false);
            } else if (StringType$.MODULE$.equals(dataType2)) {
                expression = DeserializerBuildHelper$.MODULE$.createDeserializerForString(input, false);
            } else if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                DataType et = arrayType.elementType();
                MapObjects x$1 = MapObjects$.MODULE$.apply((Function1<Expression, Expression>)(Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.deserializerFor((Expression)x$10), input, et, MapObjects$.MODULE$.apply$default$4(), MapObjects$.MODULE$.apply$default$5());
                String x$2 = "array";
                ObjectType x$3 = new ObjectType(Object.class);
                boolean x$4 = false;
                Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
                Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
                boolean x$7 = Invoke$.MODULE$.apply$default$6();
                boolean x$8 = Invoke$.MODULE$.apply$default$8();
                Invoke arrayData = new Invoke(x$1, x$2, x$3, x$5, x$6, x$7, x$4, x$8);
                Class x$9 = WrappedArray$.MODULE$.getClass();
                ObjectType x$102 = new ObjectType(Seq.class);
                String x$11 = "make";
                Invoke invoke = arrayData;
                List x$12 = Nil$.MODULE$.$colon$colon((Object)invoke);
                boolean x$13 = false;
                Seq<AbstractDataType> x$14 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$15 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$16 = StaticInvoke$.MODULE$.apply$default$8();
                expression = new StaticInvoke(x$9, x$102, x$11, (Seq<Expression>)x$12, x$14, x$15, x$13, x$16);
            } else if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueNullable = mapType.valueContainsNull();
                ArrayType keyArrayType = new ArrayType(kt, false);
                Expression keyData = this.deserializerFor(new Invoke(input, "keyArray", keyArrayType, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()));
                ArrayType valueArrayType = new ArrayType(vt, valueNullable);
                Expression valueData = this.deserializerFor(new Invoke(input, "valueArray", valueArrayType, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()));
                Class<?> x$17 = ArrayBasedMapData$.MODULE$.getClass();
                ObjectType x$18 = new ObjectType(Map.class);
                String x$19 = "toScalaMap";
                Expression expression3 = keyData;
                Expression expression4 = valueData;
                List x$20 = Nil$.MODULE$.$colon$colon((Object)expression4).$colon$colon((Object)expression3);
                boolean x$21 = false;
                Seq<AbstractDataType> x$22 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$23 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$24 = StaticInvoke$.MODULE$.apply$default$8();
                expression = new StaticInvoke(x$17, x$18, x$19, (Seq<Expression>)x$20, x$22, x$23, x$21, x$24);
            } else if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                StructField[] fields = structType.fields();
                If[] convertedFields = (If[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StructField f = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)i));
                    If if_ = new If(new Invoke(input, "isNullAt", BooleanType$.MODULE$, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)literal), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()), Literal$.MODULE$.create(null, MODULE$.externalDataTypeFor(f.dataType())), MODULE$.deserializerFor(new GetStructField(input, i, GetStructField$.MODULE$.apply$default$3())));
                    return if_;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(If.class)));
                expression = new If(new IsNull(input), Literal$.MODULE$.create(null, this.externalDataTypeFor(input.dataType())), new CreateExternalRow((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])convertedFields), structType));
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return expression;
    }

    private Expression expressionForNullableExpr(Expression expr, Expression newExprWhenNotNull) {
        return new If(new IsNull(expr), Literal$.MODULE$.create(null, newExprWhenNotNull.dataType()), newExprWhenNotNull);
    }

    private RowEncoder$() {
        MODULE$ = this;
    }
}

