/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Factorial$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the factorial of `expr`. `expr` is [0..20]. Otherwise, null.", examples="\n    Examples:\n      > SELECT _FUNC_(5);\n       120\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015w!B\u000e\u001d\u0011\u0003Ic!B\u0016\u001d\u0011\u0003a\u0003\"\u0002\u001c\u0002\t\u00039\u0004\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\"\u0002\u0005\u0004%Ia\u0011\u0005\u0007\u000f\u0006\u0001\u000b\u0011\u0002#\t\u000f!\u000b\u0011\u0011!CA\u0013\"I\u0011QV\u0001\u0002\u0002\u0013\u0005\u0015q\u0016\u0005\n\u0003w\u000b\u0011\u0011!C\u0005\u0003{3Aa\u000b\u000fA\u0017\"AA,\u0003BK\u0002\u0013\u0005Q\f\u0003\u0005b\u0013\tE\t\u0015!\u0003_\u0011\u00151\u0014\u0002\"\u0001c\u0011\u0015!\u0017\u0002\"\u0011f\u0011\u00159\u0018\u0002\"\u0011y\u0011\u0015I\u0018\u0002\"\u0011{\u0011\u0015q\u0018\u0002\"\u0015\u0000\u0011\u001d\tY!\u0003C!\u0003\u001bAq!!\u000b\n\t#\nY\u0003C\u0005\u00022%\t\t\u0011\"\u0001\u00024!I\u0011qG\u0005\u0012\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u001fJ\u0011\u0011!C!\u0003#B\u0011\"a\u0019\n\u0003\u0003%\t!!\u001a\t\u0013\u0005\u001d\u0014\"!A\u0005\u0002\u0005%\u0004\"CA8\u0013\u0005\u0005I\u0011IA9\u0011%\ty(CA\u0001\n\u0003\t\t\tC\u0005\u0002\u0006&\t\t\u0011\"\u0011\u0002\b\u0006Ia)Y2u_JL\u0017\r\u001c\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001A\u0011!&A\u0007\u00029\tIa)Y2u_JL\u0017\r\\\n\u0004\u00035\u001a\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0005\u0002/i%\u0011Qg\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\n\u0011BZ1di>\u0014\u0018.\u00197\u0015\u0005ij\u0004C\u0001\u0018<\u0013\tatF\u0001\u0003M_:<\u0007\"\u0002 \u0004\u0001\u0004y\u0014!\u00018\u0011\u00059\u0002\u0015BA!0\u0005\rIe\u000e^\u0001\u000bM\u0006\u001cGo\u001c:jC2\u001cX#\u0001#\u0011\u00079*%(\u0003\u0002G_\t)\u0011I\u001d:bs\u0006Ya-Y2u_JL\u0017\r\\:!\u0003\u0015\t\u0007\u000f\u001d7z)\rQ\u00151\u0016\t\u0003U%\u0019b!\u0003'P%f\u001b\u0004C\u0001\u0016N\u0013\tqEDA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tQ\u0003+\u0003\u0002R9\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002T-:\u0011!\u0006V\u0005\u0003+r\tq\u0001]1dW\u0006<W-\u0003\u0002X1\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA+\u001d!\tq#,\u0003\u0002\\_\t9\u0001K]8ek\u000e$\u0018!B2iS2$W#\u00010\u0011\u0005)z\u0016B\u00011\u001d\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0015\u0005)\u001b\u0007\"\u0002/\r\u0001\u0004q\u0016AC5oaV$H+\u001f9fgV\ta\rE\u0002h]Ft!\u0001[7\u000f\u0005%dW\"\u00016\u000b\u0005-D\u0013A\u0002\u001fs_>$h(C\u00011\u0013\t)v&\u0003\u0002pa\n\u00191+Z9\u000b\u0005U{\u0003C\u0001:v\u001b\u0005\u0019(B\u0001;!\u0003\u0015!\u0018\u0010]3t\u0013\t18O\u0001\u0005ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A9\u0002\u00119,H\u000e\\1cY\u0016,\u0012a\u001f\t\u0003]qL!!`\u0018\u0003\u000f\t{w\u000e\\3b]\u0006aa.\u001e7m'\u00064W-\u0012<bYR!\u0011\u0011AA\u0004!\rq\u00131A\u0005\u0004\u0003\u000by#aA!os\"9\u0011\u0011\u0002\tA\u0002\u0005\u0005\u0011!B5oaV$\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ty!a\u0007\u0002&A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016q\tqaY8eK\u001e,g.\u0003\u0003\u0002\u001a\u0005M!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005u\u0011\u00031\u0001\u0002 \u0005\u00191\r\u001e=\u0011\t\u0005E\u0011\u0011E\u0005\u0005\u0003G\t\u0019B\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\u001d\u0012\u00031\u0001\u0002\u0010\u0005\u0011QM^\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007)\u000bi\u0003\u0003\u0004\u00020I\u0001\rAX\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\rQ\u0015Q\u0007\u0005\b9N\u0001\n\u00111\u0001_\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u000f+\u0007y\u000bid\u000b\u0002\u0002@A!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013!C;oG\",7m[3e\u0015\r\tIeL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA'\u0003\u0007\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0013\u0001\u00026bm\u0006LA!!\u0019\u0002X\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012aP\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t!a\u001b\t\u0011\u00055t#!AA\u0002}\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA:!\u0019\t)(a\u001f\u0002\u00025\u0011\u0011q\u000f\u0006\u0004\u0003sz\u0013AC2pY2,7\r^5p]&!\u0011QPA<\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007m\f\u0019\tC\u0005\u0002ne\t\t\u00111\u0001\u0002\u0002\u00051Q-];bYN$2a_AE\u0011%\tiGGA\u0001\u0002\u0004\t\t\u0001K\n\n\u0003\u001b\u000b\u0019*!&\u0002\u001a\u0006m\u0015qTAQ\u0003K\u000b9\u000bE\u0002+\u0003\u001fK1!!%\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a&\u0002'~3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!M\u0006\u001cGo\u001c:jC2\u0004sN\u001a\u0011aKb\u0004(\u000f\u0019\u0018!A\u0016D\bO\u001d1!SN\u00043\f\r\u0018/eAjf\u0006I(uQ\u0016\u0014x/[:fY\u0001rW\u000f\u001c7/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAO\u0003YR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0012\u0004G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019+A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0002*\u0006QQ.\u0019;i?\u001a,hnY:\t\u000bq3\u0001\u0019\u00010\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011WA\\!\u0011q\u00131\u00170\n\u0007\u0005UvF\u0001\u0004PaRLwN\u001c\u0005\t\u0003s;\u0011\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u007f\u0003B!!\u0016\u0002B&!\u00111YA,\u0005\u0019y%M[3di\u0002")
public class Factorial
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Factorial factorial) {
        return Factorial$.MODULE$.unapply(factorial);
    }

    public static long factorial(int n) {
        return Factorial$.MODULE$.factorial(n);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Integer value = (Integer)input;
        return Predef$.MODULE$.Integer2int(value) > 20 || Predef$.MODULE$.Integer2int(value) < 0 ? null : BoxesRunTime.boxToLong((long)Factorial$.MODULE$.factorial(Predef$.MODULE$.Integer2int(value)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)eval -> new StringBuilder(172).append("\n        if (").append((String)eval).append(" > 20 || ").append((String)eval).append(" < 0) {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" =\n            org.apache.spark.sql.catalyst.expressions.Factorial.factorial(").append((String)eval).append(");\n        }\n      ").toString());
    }

    @Override
    public Factorial withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Factorial copy(Expression child) {
        return new Factorial(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Factorial";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Factorial;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Factorial)) return false;
        boolean bl = true;
        if (!bl) return false;
        Factorial factorial = (Factorial)x$1;
        Expression expression = this.child();
        Expression expression2 = factorial.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!factorial.canEqual(this)) return false;
        return true;
    }

    public Factorial(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

