/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.TimeWindow$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(time_column, window_duration[, slide_duration[, start_time]]) - Bucketize rows into one or more time windows given a timestamp specifying column.\n      Window starts are inclusive but the window ends are exclusive, e.g. 12:05 will be in the window [12:05,12:10) but not in [12:00,12:05).\n      Windows can support microsecond precision. Windows in the order of months are not supported.\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#window-operations-on-event-time\">'Window Operations on Event Time'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * time_column - The column or the expression to use as the timestamp for windowing by time. The time column must be of TimestampType.\n      * window_duration - A string specifying the width of the window represented as \"interval value\".\n        (See <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#interval-literal\">Interval Literal</a> for more details.)\n        Note that the duration is a fixed length of time, and does not vary over time according to a calendar.\n      * slide_duration - A string specifying the sliding interval of the window represented as \"interval value\".\n        A new window will be generated every `slide_duration`. Must be less than or equal to the `window_duration`.\n        This duration is likewise absolute, and does not vary according to a calendar.\n      * start_time - The offset with respect to 1970-01-01 00:00:00 UTC with which to start window intervals.\n        For example, in order to have hourly tumbling windows that start 15 minutes past the hour,\n        e.g. 12:15-13:15, 13:15-14:15... provide `start_time` as `15 minutes`.\n  ", examples="\n    Examples:\n      > SELECT a, window.start, window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:06:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '5 minutes') ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t2\n        A1\t2021-01-01 00:05:00\t2021-01-01 00:10:00\t1\n        A2\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t1\n      > SELECT a, window.start, window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:06:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '10 minutes', '5 minutes') ORDER BY a, start;\n        A1\t2020-12-31 23:55:00\t2021-01-01 00:05:00\t2\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:10:00\t3\n        A1\t2021-01-01 00:05:00\t2021-01-01 00:15:00\t1\n        A2\t2020-12-31 23:55:00\t2021-01-01 00:05:00\t1\n        A2\t2021-01-01 00:00:00\t2021-01-01 00:10:00\t1\n  ", group="datetime_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\t5d\u0001\u0002\u0016,\u0001bB\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005#\"AQ\u000b\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003X\u0011!Y\u0006A!f\u0001\n\u00031\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B,\t\u0011u\u0003!Q3A\u0005\u0002YC\u0001B\u0018\u0001\u0003\u0012\u0003\u0006Ia\u0016\u0005\u0006?\u0002!\t\u0001\u0019\u0005\u0006?\u0002!\tA\u001a\u0005\u0006?\u0002!\ta\u001b\u0005\u0006?\u0002!\ta\u001c\u0005\u0006e\u0002!\t\u0005\u0015\u0005\u0006g\u0002!\t\u0005\u001e\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\tI\u0002\u0001C!\u00037A\u0011\"!\f\u0001\u0005\u0004%)%a\f\t\u0011\u0005u\u0003\u0001)A\u0007\u0003cA!\"a\u0018\u0001\u0011\u000b\u0007I\u0011IA1\u0011\u001d\tI\u0007\u0001C!\u0003WBq!!\u001f\u0001\t#\nY\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0001\u0002\u0004\"I\u0011Q\u0012\u0001\u0012\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003K\u0003\u0011\u0013!C\u0001\u0003OC\u0011\"a+\u0001#\u0003%\t!a*\t\u0013\u00055\u0006!%A\u0005\u0002\u0005\u001d\u0006\"CAX\u0001\u0005\u0005I\u0011IAY\u0011%\t\t\rAA\u0001\n\u0003\t\u0019\rC\u0005\u0002L\u0002\t\t\u0011\"\u0001\u0002N\"I\u0011\u0011\u001c\u0001\u0002\u0002\u0013\u0005\u00131\u001c\u0005\n\u0003S\u0004\u0011\u0011!C\u0001\u0003WD\u0011\"a<\u0001\u0003\u0003%\t%!=\b\u000f\tm1\u0006#\u0001\u0003\u001e\u00191!f\u000bE\u0001\u0005?Aaa\u0018\u0012\u0005\u0002\t\u001d\u0002b\u0002B\u0015E\u0011\u0005!1\u0006\u0005\b\u0005c\u0011C\u0011\u0001B\u001a\u0011\u001d\u0011ID\tC\u0001\u0005wA\u0011B!\u000f#\u0003\u0003%\tI!\u0012\t\u0013\t=#%!A\u0005\u0002\nE\u0003\"\u0003B2E\u0005\u0005I\u0011\u0002B3\u0005)!\u0016.\\3XS:$wn\u001e\u0006\u0003Y5\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011afL\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001'M\u0001\u0004gFd'B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M9\u0001!O\u001fA\u0007\u001ac\u0005C\u0001\u001e<\u001b\u0005Y\u0013B\u0001\u001f,\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001e?\u0013\ty4F\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tQ\u0014)\u0003\u0002CW\tYQK\\3wC2,\u0018M\u00197f!\tQD)\u0003\u0002FW\t\u0001bj\u001c8T#2+\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\b!J|G-^2u!\t9U*\u0003\u0002O\u0011\na1+\u001a:jC2L'0\u00192mK\u0006QA/[7f\u0007>dW/\u001c8\u0016\u0003E\u0003\"A\u000f*\n\u0005M[#AC#yaJ,7o]5p]\u0006YA/[7f\u0007>dW/\u001c8!\u000399\u0018N\u001c3po\u0012+(/\u0019;j_:,\u0012a\u0016\t\u0003\u000fbK!!\u0017%\u0003\t1{gnZ\u0001\u0010o&tGm\\<EkJ\fG/[8oA\u0005i1\u000f\\5eK\u0012+(/\u0019;j_:\fab\u001d7jI\u0016$UO]1uS>t\u0007%A\u0005ti\u0006\u0014H\u000fV5nK\u0006Q1\u000f^1siRKW.\u001a\u0011\u0002\rqJg.\u001b;?)\u0015\t'm\u00193f!\tQ\u0004\u0001C\u0003P\u0013\u0001\u0007\u0011\u000bC\u0003V\u0013\u0001\u0007q\u000bC\u0003\\\u0013\u0001\u0007q\u000bC\u0003^\u0013\u0001\u0007q\u000bF\u0003bO\"L'\u000eC\u0003P\u0015\u0001\u0007\u0011\u000bC\u0003V\u0015\u0001\u0007\u0011\u000bC\u0003\\\u0015\u0001\u0007\u0011\u000bC\u0003^\u0015\u0001\u0007\u0011\u000b\u0006\u0003bY6t\u0007\"B(\f\u0001\u0004\t\u0006\"B+\f\u0001\u0004\t\u0006\"B.\f\u0001\u0004\tFcA1qc\")q\n\u0004a\u0001#\")Q\u000b\u0004a\u0001#\u0006)1\r[5mI\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003U\u0004BA\u001e@\u0002\u00049\u0011q\u000f \b\u0003qnl\u0011!\u001f\u0006\u0003u^\na\u0001\u0010:p_Rt\u0014\"A%\n\u0005uD\u0015a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006\u0005!aA*fc*\u0011Q\u0010\u0013\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u0018\u0002\u000bQL\b/Z:\n\t\u00055\u0011q\u0001\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003'\u0001B!!\u0002\u0002\u0016%!\u0011qCA\u0004\u0005!!\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011Q\u0004\t\u0005\u0003?\t9C\u0004\u0003\u0002\"\u0005\r\u0002C\u0001=I\u0013\r\t)\u0003S\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00121\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0002*\u0001\u0007o_\u0012,\u0007+\u0019;uKJt7/\u0006\u0002\u00022A!aO`A\u001a!\u0011\t)$a\u0016\u000f\t\u0005]\u0012\u0011\u000b\b\u0005\u0003s\tiE\u0004\u0003\u0002<\u0005-c\u0002BA\u001f\u0003\u0013rA!a\u0010\u0002H9!\u0011\u0011IA#\u001d\rA\u00181I\u0005\u0002m%\u0011A'N\u0005\u0003eMJ!\u0001M\u0019\n\u00059z\u0013bAA([\u0005)AO]3fg&!\u00111KA+\u0003-!&/Z3QCR$XM\u001d8\u000b\u0007\u0005=S&\u0003\u0003\u0002Z\u0005m#a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:TA!a\u0015\u0002V\u0005ian\u001c3f!\u0006$H/\u001a:og\u0002\n\u0001B]3t_24X\rZ\u000b\u0003\u0003G\u00022aRA3\u0013\r\t9\u0007\u0013\u0002\b\u0005>|G.Z1o\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\ti\u0007\u0005\u0003\u0002p\u0005UTBAA9\u0015\r\t\u0019(L\u0001\tC:\fG._:jg&!\u0011qOA9\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002b\u0003{Ba!a \u0016\u0001\u0004\t\u0016\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\nC\u0006\u0015\u0015qQAE\u0003\u0017Cqa\u0014\f\u0011\u0002\u0003\u0007\u0011\u000bC\u0004V-A\u0005\t\u0019A,\t\u000fm3\u0002\u0013!a\u0001/\"9QL\u0006I\u0001\u0002\u00049\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#S3!UAJW\t\t)\n\u0005\u0003\u0002\u0018\u0006\u0005VBAAM\u0015\u0011\tY*!(\u0002\u0013Ut7\r[3dW\u0016$'bAAP\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0016\u0011\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003SS3aVAJ\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003g\u0003B!!.\u0002@6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000bY,\u0001\u0003mC:<'BAA_\u0003\u0011Q\u0017M^1\n\t\u0005%\u0012qW\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000b\u00042aRAd\u0013\r\tI\r\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001f\f)\u000eE\u0002H\u0003#L1!a5I\u0005\r\te.\u001f\u0005\n\u0003/l\u0012\u0011!a\u0001\u0003\u000b\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAo!\u0019\ty.!:\u0002P6\u0011\u0011\u0011\u001d\u0006\u0004\u0003GD\u0015AC2pY2,7\r^5p]&!\u0011q]Aq\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r\u0014Q\u001e\u0005\n\u0003/|\u0012\u0011!a\u0001\u0003\u001f\fa!Z9vC2\u001cH\u0003BA2\u0003gD\u0011\"a6!\u0003\u0003\u0005\r!a4)/\u0001\t90!@\u0002\u0000\n\r!Q\u0001B\u0005\u0005\u0017\u0011yA!\u0005\u0003\u0016\t]\u0001c\u0001\u001e\u0002z&\u0019\u00111`\u0016\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011A\u0001\u0006\f)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015uS6,wlY8mk6tG\u0006I<j]\u0012|wo\u00183ve\u0006$\u0018n\u001c8\\Y\u0001\u001aH.\u001b3f?\u0012,(/\u0019;j_:\\F\u0006I:uCJ$x\f^5nKvk\u0016\u0006I\u0017!\u0005V\u001c7.\u001a;ju\u0016\u0004#o\\<tA%tGo\u001c\u0011p]\u0016\u0004sN\u001d\u0011n_J,\u0007\u0005^5nK\u0002:\u0018N\u001c3poN\u0004s-\u001b<f]\u0002\n\u0007\u0005^5nKN$\u0018-\u001c9!gB,7-\u001b4zS:<\u0007eY8mk6tgF\u0003\u0011!A\u0001\u0002\u0003eV5oI><\be\u001d;beR\u001c\b%\u0019:fA%t7\r\\;tSZ,\u0007EY;uAQDW\rI<j]\u0012|w\u000fI3oIN\u0004\u0013M]3!Kb\u001cG.^:jm\u0016d\u0003%\u001a\u0018h]\u0001\n$G\u000f\u00196A]LG\u000e\u001c\u0011cK\u0002Jg\u000e\t;iK\u0002:\u0018N\u001c3po\u0002Z\u0016G\r\u001e1k1\n$GO\u00191S\u0001\u0012W\u000f\u001e\u0011o_R\u0004\u0013N\u001c\u0011\\cIR\u0004\u0007\r\u00172ei\u0002T'\u000b\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011XS:$wn^:!G\u0006t\u0007e];qa>\u0014H\u000fI7jGJ|7/Z2p]\u0012\u0004\u0003O]3dSNLwN\u001c\u0018!/&tGm\\<tA%t\u0007\u0005\u001e5fA=\u0014H-\u001a:!_\u001a\u0004Sn\u001c8uQN\u0004\u0013M]3!]>$\be];qa>\u0014H/\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011!'\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M$(/^2ukJ,G-L:ue\u0016\fW.\u001b8h[A\u0014xn\u001a:b[6LgnZ\u0017hk&$WM\f5u[2\u001cs/\u001b8e_^ls\u000e]3sCRLwN\\:._:lSM^3oi6\"\u0018.\\3#}\u001d:\u0016N\u001c3po\u0002z\u0005/\u001a:bi&|gn\u001d\u0011p]\u0002*e/\u001a8uAQKW.Z\u0014=_\u0005t\u0004%\u001b8!'R\u0014Xo\u0019;ve\u0016$\u0007e\u0015;sK\u0006l\u0017N\\4!OVLG-\u001a\u0011e_\u000e\u0004cm\u001c:!I\u0016$\u0018-\u001b7fI\u0002*\u0007\u0010\u001d7b]\u0006$\u0018n\u001c8!C:$\u0007%\u001a=b[BdWm\u001d\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\t\u001d\u0011\u0001c.\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3`G>dW/\u001c8![\u0001\"\u0006.\u001a\u0011d_2,XN\u001c\u0011pe\u0002\"\b.\u001a\u0011fqB\u0014Xm]:j_:\u0004Co\u001c\u0011vg\u0016\u0004\u0013m\u001d\u0011uQ\u0016\u0004C/[7fgR\fW\u000e\u001d\u0011g_J\u0004s/\u001b8e_^Lgn\u001a\u0011cs\u0002\"\u0018.\\3/AQCW\r\t;j[\u0016\u00043m\u001c7v[:\u0004S.^:uA\t,\u0007e\u001c4!)&lWm\u001d;b[B$\u0016\u0010]3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001:\u0018N\u001c3po~#WO]1uS>t\u0007%\f\u0011BAM$(/\u001b8hAM\u0004XmY5gs&tw\r\t;iK\u0002:\u0018\u000e\u001a;iA=4\u0007\u0005\u001e5fA]Lg\u000eZ8xAI,\u0007O]3tK:$X\r\u001a\u0011bg\u0002\u0012\u0013N\u001c;feZ\fG\u000e\t<bYV,'E\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!QM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001a\u0018\u000f\\\u0017sK\u001alC.\u001b;fe\u0006d7O\f5u[2\u001c\u0013N\u001c;feZ\fG.\f7ji\u0016\u0014\u0018\r\u001c\u0012?\u0013:$XM\u001d<bY\u0002b\u0015\u000e^3sC2dt&\u0019 !M>\u0014\b%\\8sK\u0002\"W\r^1jYNt\u0013F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011O_R,\u0007\u0005\u001e5bi\u0002\"\b.\u001a\u0011ekJ\fG/[8oA%\u001c\b%\u0019\u0011gSb,G\r\t7f]\u001e$\b\u000eI8gAQLW.\u001a\u0017!C:$\u0007\u0005Z8fg\u0002rw\u000e\u001e\u0011wCJL\be\u001c<fe\u0002\"\u0018.\\3!C\u000e\u001cwN\u001d3j]\u001e\u0004Co\u001c\u0011bA\r\fG.\u001a8eCJt#\u0002\t\u0011!A\u0001\u0002#\u0006I:mS\u0012,w\fZ;sCRLwN\u001c\u0011.A\u0005\u00033\u000f\u001e:j]\u001e\u00043\u000f]3dS\u001aL\u0018N\\4!i\",\u0007e\u001d7jI&tw\rI5oi\u0016\u0014h/\u00197!_\u001a\u0004C\u000f[3!o&tGm\\<!e\u0016\u0004(/Z:f]R,G\rI1tA\tJg\u000e^3sm\u0006d\u0007E^1mk\u0016\u0014cF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011BA9,w\u000fI<j]\u0012|w\u000fI<jY2\u0004#-\u001a\u0011hK:,'/\u0019;fI\u0002*g/\u001a:zA\u0001\u001cH.\u001b3f?\u0012,(/\u0019;j_:\u0004g\u0006I'vgR\u0004#-\u001a\u0011mKN\u001c\b\u0005\u001e5b]\u0002z'\u000fI3rk\u0006d\u0007\u0005^8!i\",\u0007\u0005Y<j]\u0012|wo\u00183ve\u0006$\u0018n\u001c8a])\u0001\u0003\u0005\t\u0011!A\u0001\u0002C\u000b[5tA\u0011,(/\u0019;j_:\u0004\u0013n\u001d\u0011mS.,w/[:fA\u0005\u00147o\u001c7vi\u0016d\u0003%\u00198eA\u0011|Wm\u001d\u0011o_R\u0004c/\u0019:zA\u0005\u001c7m\u001c:eS:<\u0007\u0005^8!C\u0002\u001a\u0017\r\\3oI\u0006\u0014hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ti\u0006\u0014Ho\u0018;j[\u0016\u0004S\u0006\t+iK\u0002zgMZ:fi\u0002:\u0018\u000e\u001e5!e\u0016\u001c\b/Z2uAQ|\u0007%M\u001d8a5\u0002\u0014'\f\u00192AA\u0002$\b\r\u0019;aA\u0002S\u000bV\"!o&$\b\u000eI<iS\u000eD\u0007\u0005^8!gR\f'\u000f\u001e\u0011xS:$wn\u001e\u0011j]R,'O^1mg:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002\u0013N\u001c\u0011pe\u0012,'\u000f\t;pA!\fg/\u001a\u0011i_V\u0014H.\u001f\u0011uk6\u0014G.\u001b8hA]Lg\u000eZ8xg\u0002\"\b.\u0019;!gR\f'\u000f\u001e\u00112k\u0001j\u0017N\\;uKN\u0004\u0003/Y:uAQDW\r\t5pkJd#\u0002\t\u0011!A\u0001\u0002\u0003\u0005I3/O:\u0002\u0013G\r\u001e2k5\n4GO\u00196Y\u0001\n4GO\u00196[E\"$(M\u001b/]9\u0002\u0003O]8wS\u0012,\u0007\u0005Y:uCJ$x\f^5nK\u0002\u0004\u0013m\u001d\u0011acU\u0002S.\u001b8vi\u0016\u001c\bM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003\u000e\u000599K\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011bY\u0001:\u0018N\u001c3po:\u001aH/\u0019:uY\u0001:\u0018N\u001c3po:*g\u000e\u001a\u0017!G>,h\u000e\u001e\u0015+S\u0001\n7\u000fI2oi\u00022%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001b;gA:\u0013\u0006\f\u0011)O\u0005\u000bt\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aYR\u0004\u0007M\u0014*Y\u0001Bs%\u0011\u001a(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a\u001dJ\u0003%Q*!i\u0006\u0014\u0007&\u0019\u0017!E&\u0002sIU(V!\u0002\u0012\u0017\u0010I1-A}3UKT\"`Q\td\u0003eJ\u001b![&tW\u000f^3tO%\u0002sJ\u0015#F%\u0002\u0012\u0015\fI1-AM$\u0018M\u001d;<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n\u0015'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u001b;aAJ!G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002TG\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uE\u0002$\b\r\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013IM\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00196uA\u0002\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!C2\u0002s/\u001b8e_^t3\u000f^1si2\u0002s/\u001b8e_^tSM\u001c3-A\r|WO\u001c;)U%\u0002\u0013m\u001d\u0011d]R\u0004cIU(NAY\u000bE*V#TA!:\u0013)M\u0014-A\u001d\u0012\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191O%b\u0003\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00195uM\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA2$\b\r\u0019(S1\u0002\u0003fJ!3O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u0019;aA:\u0013\u0006I!TAQ\f'\rK1-A\tL\u0003e\u0012*P+B\u0003#-\u001f\u0011bY\u0001zf)\u0016(D?\"\u0012G\u0006I\u00142a\u0001j\u0017N\\;uKN<C\u0006I\u00146A5Lg.\u001e;fg\u001eJ\u0003e\u0014*E\u000bJ\u0003#)\u0017\u0011bY\u0001\u001aH/\u0019:uw)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\u0002T&\r\u001a.gE\u0002#g\r\u001e6ki\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00196uA\u0002\u0014B\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004\u0007\r\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\n\u0004G\u000f\u00191\u0013MR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%Q\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aUR\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e2ki\u0002\u0004'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u0013\u0014B\r\u00193a5\n$'L\u001a2AI\u001a$(N\u001b;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\u000e\u001e1a%\t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!3\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;cAR\u0004\u0007M\u00052\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B\n\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#A!\u0007\u0002\u000bIr\u0003G\f\u0019\u0002\u0015QKW.Z,j]\u0012|w\u000f\u0005\u0002;EM!!E!\tM!\r9%1E\u0005\u0004\u0005KA%AB!osJ+g\r\u0006\u0002\u0003\u001e\u0005Ir-\u001a;J]R,'O^1m\u0013:l\u0015n\u0019:p'\u0016\u001cwN\u001c3t)\r9&Q\u0006\u0005\b\u0005_!\u0003\u0019AA\u000f\u0003!Ig\u000e^3sm\u0006d\u0017a\u00049beN,W\t\u001f9sKN\u001c\u0018n\u001c8\u0015\u0007]\u0013)\u0004\u0003\u0004\u00038\u0015\u0002\r!U\u0001\u0005Kb\u0004(/A\u0003baBd\u0017\u0010F\u0005b\u0005{\u0011yD!\u0011\u0003D!)qJ\na\u0001#\"1QK\na\u0001\u0003;Aaa\u0017\u0014A\u0002\u0005u\u0001BB/'\u0001\u0004\ti\u0002F\u0005b\u0005\u000f\u0012IEa\u0013\u0003N!)qj\na\u0001#\")Qk\na\u0001/\")1l\na\u0001/\")Ql\na\u0001/\u00069QO\\1qa2LH\u0003\u0002B*\u0005?\u0002Ra\u0012B+\u00053J1Aa\u0016I\u0005\u0019y\u0005\u000f^5p]B9qIa\u0017R/^;\u0016b\u0001B/\u0011\n1A+\u001e9mKRB\u0001B!\u0019)\u0003\u0003\u0005\r!Y\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u001a\u0011\t\u0005U&\u0011N\u0005\u0005\u0005W\n9L\u0001\u0004PE*,7\r\u001e")
public class TimeWindow
extends UnaryExpression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression timeColumn;
    private final long windowDuration;
    private final long slideDuration;
    private final long startTime;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<Expression, Object, Object, Object>> unapply(TimeWindow timeWindow) {
        return TimeWindow$.MODULE$.unapply(timeWindow);
    }

    public static long parseExpression(Expression expression) {
        return TimeWindow$.MODULE$.parseExpression(expression);
    }

    public static long getIntervalInMicroSeconds(String string) {
        return TimeWindow$.MODULE$.getIntervalInMicroSeconds(string);
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    public Expression timeColumn() {
        return this.timeColumn;
    }

    public long windowDuration() {
        return this.windowDuration;
    }

    public long slideDuration() {
        return this.slideDuration;
    }

    public long startTime() {
        return this.startTime;
    }

    @Override
    public Expression child() {
        return this.timeColumn();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)AnyTimestampType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return new StructType().add(new StructField("start", this.child().dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", this.child().dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    @Override
    public String prettyName() {
        return "window";
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean resolved$lzycompute() {
        TimeWindow timeWindow = this;
        synchronized (timeWindow) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_1;
        TypeCheckResult dataTypeCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (dataTypeCheck.isSuccess()) {
            if (this.windowDuration() <= 0L) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("The window duration (").append(this.windowDuration()).append(") must be greater than 0.").toString());
            }
            if (this.slideDuration() <= 0L) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append("The slide duration (").append(this.slideDuration()).append(") must be greater than 0.").toString());
            }
            if (this.slideDuration() > this.windowDuration()) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(74).append("The slide duration (").append(this.slideDuration()).append(") must be less than or equal").append(" to the windowDuration (").append(this.windowDuration()).append(").").toString());
            }
            if (RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(this.startTime())) >= this.slideDuration()) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The absolute value of start time (").append(this.startTime()).append(") must be less ").append("than the slideDuration (").append(this.slideDuration()).append(").").toString());
            }
        }
        return var1_1;
    }

    @Override
    public TimeWindow withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public TimeWindow copy(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        return new TimeWindow(timeColumn, windowDuration, slideDuration, startTime);
    }

    public Expression copy$default$1() {
        return this.timeColumn();
    }

    public long copy$default$2() {
        return this.windowDuration();
    }

    public long copy$default$3() {
        return this.slideDuration();
    }

    public long copy$default$4() {
        return this.startTime();
    }

    @Override
    public String productPrefix() {
        return "TimeWindow";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeColumn();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.windowDuration());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToLong((long)this.slideDuration());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToLong((long)this.startTime());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimeWindow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimeWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimeWindow timeWindow = (TimeWindow)x$1;
        Expression expression = this.timeColumn();
        Expression expression2 = timeWindow.timeColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.windowDuration() != timeWindow.windowDuration()) return false;
        if (this.slideDuration() != timeWindow.slideDuration()) return false;
        if (this.startTime() != timeWindow.startTime()) return false;
        if (!timeWindow.canEqual(this)) return false;
        return true;
    }

    public TimeWindow(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        this.timeColumn = timeColumn;
        this.windowDuration = windowDuration;
        this.slideDuration = slideDuration;
        this.startTime = startTime;
        ExpectsInputTypes.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.TIME_WINDOW(), (List)Nil$.MODULE$);
    }

    public TimeWindow(Expression timeColumn, Expression windowDuration, Expression slideDuration, Expression startTime) {
        this(timeColumn, TimeWindow$.MODULE$.parseExpression(windowDuration), TimeWindow$.MODULE$.parseExpression(slideDuration), TimeWindow$.MODULE$.parseExpression(startTime));
    }

    public TimeWindow(Expression timeColumn, Expression windowDuration, Expression slideDuration) {
        this(timeColumn, TimeWindow$.MODULE$.parseExpression(windowDuration), TimeWindow$.MODULE$.parseExpression(slideDuration), 0L);
    }

    public TimeWindow(Expression timeColumn, Expression windowDuration) {
        this(timeColumn, windowDuration, windowDuration);
    }
}

