/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(unix_time[, fmt]) - Returns `unix_time` in the specified `fmt`.", arguments="\n    Arguments:\n      * unix_time - UNIX Timestamp to be converted to the provided format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>\n              for valid date and time format patterns. The 'yyyy-MM-dd HH:mm:ss' pattern is used if omitted.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss');\n       1969-12-31 16:00:00\n\n      > SELECT _FUNC_(0);\n       1969-12-31 16:00:00\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0015+\u0001^B\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003Y\u0006\u0002\u00036\u0001\u0005#\u0005\u000b\u0011\u0002/\t\u000b-\u0004A\u0011\u00017\t\u000b-\u0004A\u0011A9\t\u000bQ\u0004A\u0011I*\t\u000bU\u0004A\u0011I*\t\u000bY\u0004A\u0011I<\t\u000b-\u0004A\u0011\u0001=\t\u000bm\u0004A\u0011\t?\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Ba!!\u001a\u0001\t#\u001a\u0006bBA4\u0001\u0011E\u0013\u0011\u0002\u0005\b\u0003S\u0002A\u0011KA6\u0011%\t)\bAA\u0001\n\u0003\t9\bC\u0005\u0002\u0000\u0001\t\n\u0011\"\u0001\u0002\u0002\"I\u0011q\u0013\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u00033\u0003\u0011\u0013!C\u0001\u00037C\u0011\"a(\u0001\u0003\u0003%\t%!)\t\u0013\u0005E\u0006!!A\u0005\u0002\u0005M\u0006\"CA^\u0001\u0005\u0005I\u0011AA_\u0011%\t\u0019\rAA\u0001\n\u0003\n)\rC\u0005\u0002T\u0002\t\t\u0011\"\u0001\u0002V\"I\u0011\u0011\u001c\u0001\u0002\u0002\u0013\u0005\u00131\\\u0004\n\u0005\u000bQ\u0013\u0011!E\u0001\u0005\u000f1\u0001\"\u000b\u0016\u0002\u0002#\u0005!\u0011\u0002\u0005\u0007W\u0006\"\tAa\u0006\t\u0013\te\u0011%!A\u0005F\tm\u0001\"\u0003B\u000fC\u0005\u0005I\u0011\u0011B\u0010\u0011%\u00119#II\u0001\n\u0003\tY\nC\u0005\u0003*\u0005\n\t\u0011\"!\u0003,!I!\u0011H\u0011\u0012\u0002\u0013\u0005\u00111\u0014\u0005\n\u0005w\t\u0013\u0011!C\u0005\u0005{\u0011AB\u0012:p[Vs\u0017\u000e\u001f+j[\u0016T!a\u000b\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003[9\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003_A\n1a]9m\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7\u0001A\n\b\u0001abtHQ%P!\tI$(D\u0001+\u0013\tY$F\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011(P\u0005\u0003})\u0012\u0001\u0004V5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;fe\"+G\u000e]3s!\tI\u0004)\u0003\u0002BU\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002D\r:\u0011\u0011\bR\u0005\u0003\u000b*\nq\u0001]1dW\u0006<W-\u0003\u0002H\u0011\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA#+!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0013)\n\u0005E[%\u0001D*fe&\fG.\u001b>bE2,\u0017aA:fGV\tA\u000b\u0005\u0002:+&\u0011aK\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001B:fG\u0002\naAZ8s[\u0006$\u0018a\u00024pe6\fG\u000fI\u0001\u000bi&lWMW8oK&#W#\u0001/\u0011\u0007)kv,\u0003\u0002_\u0017\n1q\n\u001d;j_:\u0004\"\u0001Y4\u000f\u0005\u0005,\u0007C\u00012L\u001b\u0005\u0019'B\u000137\u0003\u0019a$o\\8u}%\u0011amS\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002g\u0017\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}Q!QN\\8q!\tI\u0004\u0001C\u0003S\u000f\u0001\u0007A\u000bC\u0003Y\u000f\u0001\u0007A\u000bC\u0004[\u000fA\u0005\t\u0019\u0001/\u0015\u00075\u00148\u000fC\u0003S\u0011\u0001\u0007A\u000bC\u0003Y\u0011\u0001\u0007A+\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018A\u00039sKR$\u0018PT1nKV\tq\f\u0006\u0002ns\")!\u0010\u0004a\u0001)\u0006!QO\\5y\u0003!!\u0017\r^1UsB,W#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\tAL\u0001\u0006if\u0004Xm]\u0005\u0004\u0003\u000by(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\"!a\u0003\u0011\u0007)\u000bi!C\u0002\u0002\u0010-\u0013qAQ8pY\u0016\fg.\u0001\u0006j]B,H\u000fV=qKN,\"!!\u0006\u0011\r\u0005]\u0011qDA\u0013\u001d\u0011\tI\"!\b\u000f\u0007\t\fY\"C\u0001M\u0013\t)5*\u0003\u0003\u0002\"\u0005\r\"aA*fc*\u0011Qi\u0013\t\u0004}\u0006\u001d\u0012bAA\u0015\u007f\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0005\u0003_\t)\u0004E\u0002:\u0003cI1!a\r+\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000eC\u0003[!\u0001\u0007q,\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002<\u0005\u0005\u0013Q\t\t\u0004\u0015\u0006u\u0012bAA \u0017\n\u0019\u0011I\\=\t\u000f\u0005\r\u0013\u00031\u0001\u0002<\u000591/Z2p]\u0012\u001c\bB\u0002-\u0012\u0001\u0004\tY$A\u0005e_\u001e+gnQ8eKR1\u00111JA,\u0003C\u0002B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#R\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003+\nyE\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tIF\u0005a\u0001\u00037\n1a\u0019;y!\u0011\ti%!\u0018\n\t\u0005}\u0013q\n\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\u0019G\u0005a\u0001\u0003\u0017\n!!\u001a<\u0002\u0019\u0019|'/\\1u'R\u0014\u0018N\\4\u0002\u0013%\u001c\b+\u0019:tS:<\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015i\u0017QNA9\u0011\u0019\ty'\u0006a\u0001)\u00069a.Z<MK\u001a$\bBBA:+\u0001\u0007A+\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000f5\fI(a\u001f\u0002~!9!K\u0006I\u0001\u0002\u0004!\u0006b\u0002-\u0017!\u0003\u0005\r\u0001\u0016\u0005\b5Z\u0001\n\u00111\u0001]\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a!+\u0007Q\u000b)i\u000b\u0002\u0002\bB!\u0011\u0011RAJ\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015!C;oG\",7m[3e\u0015\r\t\tjS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAK\u0003\u0017\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u001e*\u001aA,!\"\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u000b\u0005\u0003\u0002&\u0006=VBAAT\u0015\u0011\tI+a+\u0002\t1\fgn\u001a\u0006\u0003\u0003[\u000bAA[1wC&\u0019\u0001.a*\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0006c\u0001&\u00028&\u0019\u0011\u0011X&\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0012q\u0018\u0005\n\u0003\u0003d\u0012\u0011!a\u0001\u0003k\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAd!\u0019\tI-a4\u0002<5\u0011\u00111\u001a\u0006\u0004\u0003\u001b\\\u0015AC2pY2,7\r^5p]&!\u0011\u0011[Af\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-\u0011q\u001b\u0005\n\u0003\u0003t\u0012\u0011!a\u0001\u0003w\ta!Z9vC2\u001cH\u0003BA\u0006\u0003;D\u0011\"!1 \u0003\u0003\u0005\r!a\u000f)/\u0001\t\t/a:\u0002j\u00065\u0018q^Az\u0003k\fI0a?\u0002\u0000\n\u0005\u0001cA\u001d\u0002d&\u0019\u0011Q\u001d\u0016\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111^\u0001G?\u001a+fjQ0)k:L\u0007p\u0018;j[\u0016\\F\u0006\t4nivK\u0003%\f\u0011SKR,(O\\:!AVt\u0017\u000e_0uS6,\u0007\rI5oAQDW\rI:qK\u000eLg-[3eA\u00014W\u000e\u001e1/\u0003%\t'oZ;nK:$8/\t\u0002\u0002r\u0006\u00119M\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!k:L\u0007p\u0018;j[\u0016\u0004S\u0006I+O\u0013b\u0003C+[7fgR\fW\u000e\u001d\u0011u_\u0002\u0012W\rI2p]Z,'\u000f^3eAQ|\u0007\u0005\u001e5fAA\u0014xN^5eK\u0012\u0004cm\u001c:nCRt#\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005R1uK>\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.I\u0006$X\r^5nK6\u0002\u0018\r\u001e;fe:t\u0003\u000e^7mEy\"\u0015\r^3uS6,\u0007\u0005U1ui\u0016\u0014hn\u001d\u001f0CzR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002cm\u001c:!m\u0006d\u0017\u000e\u001a\u0011eCR,\u0007%\u00198eAQLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8t]\u0001\"\u0006.\u001a\u0011(sfL\u00180L'N[\u0011$\u0007\u0005\u0013%;[6T4o]\u0014!a\u0006$H/\u001a:oA%\u001c\b%^:fI\u0002Jg\rI8nSR$X\r\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003o\f\u0011q\u0005\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a1\u0002s%_=zs6jU*\f3eA!C%(\\7;gN<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112sYJT&\r\u001a.gE\u0002\u0013G\u000e\u001e1ai\u0002\u0004G\u0003\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a%Z$\u0002\t\u0011!A\u0001\u0002\u0003%M\u001d7s5\n$'L\u001a2AE2$\b\r\u0019;aAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003{\fa\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0003\u0004\u0005)\u0011GL\u001b/a\u0005aaI]8n+:L\u0007\u0010V5nKB\u0011\u0011(I\n\u0005C\t-q\n\u0005\u0005\u0003\u000e\tMA\u000b\u0016/n\u001b\t\u0011yAC\u0002\u0003\u0012-\u000bqA];oi&lW-\u0003\u0003\u0003\u0016\t=!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!qA\u0001\ti>\u001cFO]5oOR\u0011\u00111U\u0001\u0006CB\u0004H.\u001f\u000b\b[\n\u0005\"1\u0005B\u0013\u0011\u0015\u0011F\u00051\u0001U\u0011\u0015AF\u00051\u0001U\u0011\u001dQF\u0005%AA\u0002q\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iC!\u000e\u0011\t)k&q\u0006\t\u0007\u0015\nEB\u000b\u0016/\n\u0007\tM2J\u0001\u0004UkBdWm\r\u0005\t\u0005o1\u0013\u0011!a\u0001[\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t}\u0002\u0003BAS\u0005\u0003JAAa\u0011\u0002(\n1qJ\u00196fGR\u0004")
public class FromUnixTime
extends BinaryExpression
implements TimestampFormatterHelper,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression sec;
    private final Expression format;
    private final Option<String> timeZoneId;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return FromUnixTime$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(FromUnixTime fromUnixTime) {
        return FromUnixTime$.MODULE$.unapply(fromUnixTime);
    }

    public static Option<String> apply$default$3() {
        return FromUnixTime$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, FromUnixTime> tupled() {
        return FromUnixTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, FromUnixTime>>> curried() {
        return FromUnixTime$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean forTimestampNTZ() {
        return TimestampFormatterHelper.forTimestampNTZ$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatterOption$lzycompute() : this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression sec() {
        return this.sec;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.sec();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public String prettyName() {
        return "from_unixtime";
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object seconds, Object format) {
        TimestampFormatter fmt = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getFormatter(format.toString()));
        return UTF8String.fromString((String)fmt.format(BoxesRunTime.unboxToLong((Object)seconds) * 1000000L));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatterOption().map((Function1 & Serializable & scala.Serializable)f -> {
            String formatterName = ctx.addReferenceObj("formatter", f, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(seconds, x$6) -> new StringBuilder(43).append("UTF8String.fromString(").append(formatterName).append(".format(").append((String)seconds).append(" * 1000000L))").toString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String tf = new StringOps(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName())).stripSuffix("$");
            String ldf = new StringOps(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName())).stripSuffix("$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(seconds, format) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n           |UTF8String.fromString(\n           |  ").append(tf).append("$.MODULE$.apply(").append((String)format).append(".toString(),\n           |  ").append(zid).append(",\n           |  ").append(ldf).append("$.MODULE$.SIMPLE_DATE_FORMAT(),\n           |  false).format(").append((String)seconds).append(" * 1000000L))\n           |").toString())).stripMargin());
        });
    }

    @Override
    public Expression formatString() {
        return this.format();
    }

    @Override
    public boolean isParsing() {
        return false;
    }

    @Override
    public FromUnixTime withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public FromUnixTime copy(Expression sec, Expression format, Option<String> timeZoneId) {
        return new FromUnixTime(sec, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.sec();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "FromUnixTime";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.sec();
                break;
            }
            case 1: {
                option = this.format();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUnixTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUnixTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUnixTime fromUnixTime = (FromUnixTime)x$1;
        Expression expression = this.sec();
        Expression expression2 = fromUnixTime.sec();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = fromUnixTime.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = fromUnixTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!fromUnixTime.canEqual(this)) return false;
        return true;
    }

    public FromUnixTime(Expression sec, Expression format, Option<String> timeZoneId) {
        this.sec = sec;
        this.format = format;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public FromUnixTime(Expression sec, Expression format) {
        this(sec, format, (Option<String>)None$.MODULE$);
    }

    public FromUnixTime(Expression unix) {
        this(unix, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }
}

