/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ", since="1.0.1", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0001\t]c\u0001B\u0013'\u0001NB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t+\u0002\u0011\t\u0012)A\u0005\r\"Aa\u000b\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003Y\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u001d!\u0007A1A\u0005F\u0015Da\u0001 \u0001!\u0002\u001b1\u0007\"B?\u0001\t#r\bBCA\u0005\u0001!\u0015\r\u0011\"\u0011\u0002\f!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t\u0019\u0006\u0001C!\u0003+Baa\u000b\u0001\u0005B\u0005\u001d\u0004bBA5\u0001\u0011%\u00111\u000e\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011%\ty\tAA\u0001\n\u0003\t\t\nC\u0005\u0002\u0018\u0002\t\n\u0011\"\u0001\u0002\u001a\"I\u0011q\u0016\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003k\u0003\u0011\u0011!C!\u0003oC\u0011\"a2\u0001\u0003\u0003%\t!!3\t\u0013\u0005E\u0007!!A\u0005\u0002\u0005M\u0007\"CAm\u0001\u0005\u0005I\u0011IAn\u0011%\tI\u000fAA\u0001\n\u0003\tY\u000fC\u0005\u0002p\u0002\t\t\u0011\"\u0011\u0002r\u001e9!1\u0004\u0014\t\u0002\tuaAB\u0013'\u0011\u0003\u0011y\u0002\u0003\u0004]9\u0011\u0005!q\u0005\u0005\b\u0005SaB\u0011\u0001B\u0016\u0011\u001d\u0011\t\u0004\bC\u0001\u0005gA\u0011B!\u000b\u001d\u0003\u0003%\tIa\u000e\t\u0013\tuB$%A\u0005\u0002\u0005E\u0006\"\u0003B 9\u0005\u0005I\u0011\u0011B!\u0011%\u0011Y\u0005HI\u0001\n\u0003\t\t\fC\u0005\u0003Nq\t\t\u0011\"\u0003\u0003P\tA1)Y:f/\",gN\u0003\u0002(Q\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tI#&\u0001\u0005dCR\fG._:u\u0015\tYC&A\u0002tc2T!!\f\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0002\u0014AB1qC\u000eDWMC\u00012\u0003\ry'oZ\u0002\u0001'\u0015\u0001A\u0007O\u001eB!\t)d'D\u0001'\u0013\t9dE\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!N\u001d\n\u0005i2#\u0001H\"p[BdW\r\u001f+za\u0016lUM]4j]\u001e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003y\tK!aQ\u001f\u0003\u000fA\u0013x\u000eZ;di\u0006A!M]1oG\",7/F\u0001G!\r9uJ\u0015\b\u0003\u00116s!!\u0013'\u000e\u0003)S!a\u0013\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0014B\u0001(>\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u0003\u0007M+\u0017O\u0003\u0002O{A!Ah\u0015\u001b5\u0013\t!VH\u0001\u0004UkBdWMM\u0001\nEJ\fgn\u00195fg\u0002\n\u0011\"\u001a7tKZ\u000bG.^3\u0016\u0003a\u00032\u0001P-5\u0013\tQVH\u0001\u0004PaRLwN\\\u0001\u000bK2\u001cXMV1mk\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0002_?\u0002\u0004\"!\u000e\u0001\t\u000b\u0011+\u0001\u0019\u0001$\t\u000fY+\u0001\u0013!a\u00011\u0006A1\r[5mIJ,g.F\u0001d!\r9u\nN\u0001\r]>$W\rU1ui\u0016\u0014hn]\u000b\u0002MB\u0019qiT4\u0011\u0005!LhBA5w\u001d\tQGO\u0004\u0002lg:\u0011AN\u001d\b\u0003[Ft!A\u001c9\u000f\u0005%{\u0017\"A\u0019\n\u0005=\u0002\u0014BA\u0017/\u0013\tYC&\u0003\u0002*U%\u0011Q\u000fK\u0001\u0006iJ,Wm]\u0005\u0003ob\f1\u0002\u0016:fKB\u000bG\u000f^3s]*\u0011Q\u000fK\u0005\u0003un\u00141\u0002\u0016:fKB\u000bG\u000f^3s]*\u0011q\u000f_\u0001\u000e]>$W\rU1ui\u0016\u0014hn\u001d\u0011\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGC\u0001\u001b\u0000\u0011\u001d\t\t!\u0003a\u0001\u0003\u0007\t1B\\3x\u0007\"LG\u000e\u001a:f]B!q)!\u00025\u0013\r\t9!\u0015\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001F5oaV$H+\u001f9fg\u001a{'/T3sO&tw-\u0006\u0002\u0002\u000eA!qiTA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000bU\u0005)A/\u001f9fg&!\u0011\u0011DA\n\u0005!!\u0015\r^1UsB,\u0007f\u0001\u0006\u0002\u001eA\u0019A(a\b\n\u0007\u0005\u0005RHA\u0005ue\u0006t7/[3oi\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002(A\u0019A(!\u000b\n\u0007\u0005-RHA\u0004C_>dW-\u00198\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]\u0002&\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tY$!\u000e\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fA!\u001a<bYR!\u0011\u0011IA$!\ra\u00141I\u0005\u0004\u0003\u000bj$aA!os\"I\u0011\u0011J\u0007\u0011\u0002\u0003\u0007\u00111J\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u001b\ny%D\u0001)\u0013\r\t\t\u0006\u000b\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0005u_N#(/\u001b8h)\t\t9\u0006\u0005\u0003\u0002Z\u0005\u0005d\u0002BA.\u0003;\u0002\"!S\u001f\n\u0007\u0005}S(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\n)G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?jTCAA,\u0003QiW\u000f\u001c;j\u0005J\fgn\u00195fg\u000e{G-Z4f]R1\u0011QNA=\u0003\u0007\u0003B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003g2\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003o\n\tH\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tY\b\u0005a\u0001\u0003{\n1a\u0019;y!\u0011\ty'a \n\t\u0005\u0005\u0015\u0011\u000f\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t)\t\u0005a\u0001\u0003[\n!!\u001a<\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA7\u0003\u0017\u000bi\tC\u0004\u0002|E\u0001\r!! \t\u000f\u0005\u0015\u0015\u00031\u0001\u0002n\u0005!1m\u001c9z)\u0015q\u00161SAK\u0011\u001d!%\u0003%AA\u0002\u0019CqA\u0016\n\u0011\u0002\u0003\u0007\u0001,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005m%f\u0001$\u0002\u001e.\u0012\u0011q\u0014\t\u0005\u0003C\u000bY+\u0004\u0002\u0002$*!\u0011QUAT\u0003%)hn\u00195fG.,GMC\u0002\u0002*v\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti+a)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M&f\u0001-\u0002\u001e\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!/\u0011\t\u0005m\u0016QY\u0007\u0003\u0003{SA!a0\u0002B\u0006!A.\u00198h\u0015\t\t\u0019-\u0001\u0003kCZ\f\u0017\u0002BA2\u0003{\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a3\u0011\u0007q\ni-C\u0002\u0002Pv\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0011\u0002V\"I\u0011q[\f\u0002\u0002\u0003\u0007\u00111Z\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0007CBAp\u0003K\f\t%\u0004\u0002\u0002b*\u0019\u00111]\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002h\u0006\u0005(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\n\u0002n\"I\u0011q[\r\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\u00121\u001f\u0005\n\u0003/T\u0012\u0011!a\u0001\u0003\u0003Bs\u0003AA|\u0003{\fyPa\u0001\u0003\u0006\t%!1\u0002B\b\u0005#\u0011)Ba\u0006\u0011\u0007U\nI0C\u0002\u0002|\u001a\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u0002\u0005\tYfQ!T\u000b\u0002:\u0006*\u0012(!Kb\u0004(/\r\u0011U\u0011\u0016s\u0005%\u001a=qeJ\u00023l\u0016%F\u001d\u0002*\u0007\u0010\u001d:4AQCUI\u0014\u0011fqB\u0014H'\u0018\u0016!7\u0016c5+\u0012\u0011fqB\u0014X'\u0018\u0011F\u001d\u0012\u0003S\u0006I,iK:\u0004\u0003-\u001a=qeF\u0002\u0007%\u0010\u0011ueV,G\u0006\t:fiV\u0014hn\u001d\u0011aKb\u0004(O\r1<A\u0015d7/\u001a\u0011xQ\u0016t\u0007\u0005Y3yaJ\u001c\u0004\rI\u001f!iJ,X\r\f\u0011sKR,(O\\:!A\u0016D\bO\u001d\u001baw\u0001*Gn]3!e\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:6A:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\t\u001d\u0011!!?\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:4A5\u0002C\u000f[3!EJ\fgn\u00195!G>tG-\u001b;j_:\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tAMDw.\u001e7eA\u0005dG\u000e\t2fA\t|w\u000e\\3b]\u0002\"\u0018\u0010]3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\u0007\u0010\u001d:3Y\u0001*\u0007\u0010\u001d:5Y\u0001*\u0007\u0010\u001d:6A5\u0002C\u000f[3!EJ\fgn\u00195!m\u0006dW/\u001a\u0011fqB\u0014Xm]:j_:\u001c\b%\u00198eA\u0015d7/\u001a\u0011wC2,X\rI3yaJ,7o]5p]\u0002\u001a\bn\\;mI\u0002\nG\u000e\u001c\u0011cK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I:b[\u0016\u0004C/\u001f9fA=\u0014\beY8fe\u000eL'\r\\3!i>\u0004\u0013\rI2p[6|g\u000e\t;za\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!\u0004\u0002\u0005\u000bQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eQ!T\u000b\u0002:\u0006*\u0012(!c\u0001r\u0004\u0005\r\u0011U\u0011\u0016s\u0005%\r\u0011X\u0011\u0016s\u0005E\r\u0011?AA\u0002C\u000bS#OAIr\u0003\u0007I#M'\u0016\u0003\u0013G\f\u001a!\u000b:#5H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019/a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033)Q*FA]CUI\u0014\u00112Aq\u0002\u0003\u0007\t+I\u000b:\u0003\u0013\u0007I,I\u000b:\u0003#\u0007\t !a\u0001\"\u0006*\u0012(!e9\u0002\u0004%\u0012'T\u000b\u0002\ndF\r\u0011F\u001d\u0012[$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00181\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u001a\u0015iU#!/\"+e\nI\u0019!y\u0001\u0002\u0004\u0005\u0016%F\u001d\u0002\n\u0004e\u0016%F\u001d\u0002\u0012\u0004\u0005\u0010\u00111AQCUI\u0014\u00113]A\u0002SI\u0014#<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)1/\u001b8dK\u0006\u0012!1C\u0001\u0006c9\u0002d&M\u0001\u0006OJ|W\u000f]\u0011\u0003\u00053\t\u0011cY8oI&$\u0018n\u001c8bY~3WO\\2t\u0003!\u0019\u0015m]3XQ\u0016t\u0007CA\u001b\u001d'\u0011a\"\u0011E\u001e\u0011\u0007q\u0012\u0019#C\u0002\u0003&u\u0012a!\u00118z%\u00164GC\u0001B\u000f\u0003\u0015\t\u0007\u000f\u001d7z)\u0015q&Q\u0006B\u0018\u0011\u0015!e\u00041\u0001G\u0011\u00151f\u00041\u00015\u0003A\u0019'/Z1uK\u001a\u0013x.\u001c)beN,'\u000fF\u0002_\u0005kAQ\u0001R\u0010A\u0002\r$RA\u0018B\u001d\u0005wAQ\u0001\u0012\u0011A\u0002\u0019CqA\u0016\u0011\u0011\u0002\u0003\u0007\u0001,A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$BAa\u0011\u0003HA!A(\u0017B#!\u0011a4K\u0012-\t\u0011\t%#%!AA\u0002y\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0006\u0005\u0003\u0002<\nM\u0013\u0002\u0002B+\u0003{\u0013aa\u00142kK\u000e$\b")
public class CaseWhen
extends Expression
implements ComplexTypeMergingExpression,
scala.Serializable {
    private transient Seq<DataType> inputTypesForMerging;
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;
    private final Seq<Enumeration.Value> nodePatterns;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen caseWhen) {
        return CaseWhen$.MODULE$.unapply(caseWhen);
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static CaseWhen createFromParser(Seq<Expression> seq) {
        return CaseWhen$.MODULE$.createFromParser(seq);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression.dataType$(this);
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)this.branches().flatMap((Function1 & Serializable & scala.Serializable)b -> {
            Expression expression = (Expression)b._1();
            Expression expression2 = (Expression)b._2();
            return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return super.legacyWithNewChildren(newChildren);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$trans$0) {
                this.inputTypesForMerging = (Seq)((TraversableLike)this.branches().map((Function1 & Serializable & scala.Serializable)x$3 -> ((Expression)x$3._2()).dataType(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dataType())), Seq$.MODULE$.canBuildFrom());
                this.bitmap$trans$0 = true;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return !this.bitmap$trans$0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    @Override
    public boolean nullable() {
        return this.branches().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$1(x$5))) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.nullable())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (TypeCoercion$.MODULE$.haveSameType(this.inputTypesForMerging())) {
            if (this.branches().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$1(x$7)))) {
                typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else {
                int index = this.branches().indexWhere((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$2(x$8)));
                typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(94).append("WHEN expressions in CaseWhen should all be boolean type, ").append("but the ").append(index + 1).append("th when expression's type is ").append(((Tuple2)this.branches().apply(index))._1()).toString());
            }
        } else {
            String branchesStr = ((TraversableOnce)((TraversableLike)this.branches().map((Function1 & Serializable & scala.Serializable)x$9 -> ((Expression)x$9._2()).dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dt -> new StringBuilder(14).append("WHEN ... THEN ").append(dt.catalogString()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(" ");
            String elseStr = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)expr -> new StringBuilder(6).append(" ELSE ").append(expr.dataType().catalogString()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(94).append("THEN and ELSE expressions should all be same type or coercible to a common type,").append(" got CASE ").append(branchesStr).append(elseStr).append(" END").toString());
        }
        return typeCheckResult;
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        if (this.elseValue().isDefined()) {
            return ((Expression)this.elseValue().get()).eval(input);
        }
        return null;
    }

    @Override
    public String toString() {
        String cases = ((TraversableOnce)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c).append(" THEN ").append(v).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$10 -> new StringBuilder(6).append(" ELSE ").append(x$10).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    @Override
    public String sql() {
        String cases = ((TraversableOnce)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c.sql()).append(" THEN ").append(v.sql()).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$11 -> new StringBuilder(6).append(" ELSE ").append(x$11.sql()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    private ExprCode multiBranchesCodegen(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(JavaCode$.MODULE$.global(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ExprValue$.MODULE$.exprValueToString(ev.value()), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()), this.dataType()));
        Seq cases = (Seq)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression condExpr = (Expression)tuple2._1();
            Expression valueExpr = (Expression)tuple2._2();
            ExprCode cond = condExpr.genCode(ctx);
            ExprCode res = valueExpr.genCode(ctx);
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n         |").append(cond.code()).append("\n         |if (!").append(cond.isNull()).append(" && ").append(cond.value()).append(") {\n         |  ").append(res.code()).append("\n         |  ").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |  ").append(ev.value()).append(" = ").append(res.value()).append(";\n         |  continue;\n         |}\n       ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom());
        Option elseCode = this.elseValue().map((Function1 & Serializable & scala.Serializable)elseExpr -> {
            ExprCode res = elseExpr.genCode(ctx);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n         |").append(res.code()).append("\n         |").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |").append(ev.value()).append(" = ").append(res.value()).append(";\n       ").toString())).stripMargin();
        });
        Seq x$1 = allConditions = (Seq)cases.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(elseCode), Seq$.MODULE$.canBuildFrom());
        String x$2 = "caseWhen";
        String x$3 = "byte";
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)func -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n           |").append("byte").append(" ").append(resultState).append(" = ").append(NOT_MATCHED).append(";\n           |do {\n           |  ").append((String)func).append("\n           |} while (false);\n           |return ").append(resultState).append(";\n         ").toString())).stripMargin();
        Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)x$12 -> ((TraversableOnce)x$12.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n           |").append(resultState).append(" = ").append((String)funcCall).append(";\n           |if (").append(resultState).append(" != ").append(NOT_MATCHED).append(") {\n           |  continue;\n           |}\n         ").toString())).stripMargin(), Seq$.MODULE$.canBuildFrom())).mkString();
        Seq<Tuple2<String, String>> x$6 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$1, x$2, x$6, x$3, (Function1<String, String>)x$4, (Function1<Seq<String>, String>)x$5);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.branches().length() == 1 ? new If((Expression)((Tuple2)this.branches().apply(0))._1(), (Expression)((Tuple2)this.branches().apply(0))._2(), (Expression)this.elseValue().getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.create(null, ((Expression)((Tuple2)this.branches().apply(0))._2()).dataType()))).doGenCode(ctx, ev) : this.multiBranchesCodegen(ctx, ev);
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<Tuple2<Expression, Expression>> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.branches();
                break;
            }
            case 1: {
                seq = this.elseValue();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return seq;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$nullable$1(Tuple2 x$5) {
        return ((Expression)x$5._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(Tuple2 x$7) {
        DataType dataType = ((Expression)x$7._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(Tuple2 x$8) {
        DataType dataType = ((Expression)x$8._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return dataType == null ? booleanType$ != null : !dataType.equals(booleanType$);
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
        ComplexTypeMergingExpression.$init$(this);
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.CASE_WHEN(), (List)Nil$.MODULE$);
    }
}

