/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple10;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create timestamp from year, month, day, hour, min, sec and timezone fields. The result data type is consistent with the value of configuration `spark.sql.timestampType`", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from 0 to 60.\n              The value can be either an integer like 13 , or a fraction like 13.123.\n              If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 1);\n       2019-06-30 23:59:01\n      > SELECT _FUNC_(2019, 13, 1, 10, 11, 12, 'PST');\n       NULL\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\r\u0005b\u0001B!C\u0001>C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005Y\"A\u0001\u000f\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005r\u0001\tE\t\u0015!\u0003m\u0011!\u0011\bA!f\u0001\n\u0003Y\u0007\u0002C:\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011Q\u0004!Q3A\u0005\u0002-D\u0001\"\u001e\u0001\u0003\u0012\u0003\u0006I\u0001\u001c\u0005\tm\u0002\u0011)\u001a!C\u0001W\"Aq\u000f\u0001B\tB\u0003%A\u000e\u0003\u0005y\u0001\tU\r\u0011\"\u0001l\u0011!I\bA!E!\u0002\u0013a\u0007\u0002\u0003>\u0001\u0005+\u0007I\u0011A>\t\u0011}\u0004!\u0011#Q\u0001\nqD!\"!\u0001\u0001\u0005+\u0007I\u0011AA\u0002\u0011)\ti\u0002\u0001B\tB\u0003%\u0011Q\u0001\u0005\u000b\u0003?\u0001!Q3A\u0005\u0002\u0005\u0005\u0002BCA\u0015\u0001\tE\t\u0015!\u0003\u0002$!Q\u00111\u0006\u0001\u0003\u0016\u0004%\t%!\f\t\u0015\u0005m\u0002A!E!\u0002\u0013\ty\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005u\u0002\u0001\"\u0001\u0002X!9\u0011Q\b\u0001\u0005\u0002\u0005\u0015\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\t)\n\u0001C!\u0003CAq!a&\u0001\t\u0003\nI\nC\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\"9\u0011\u0011\u001e\u0001\u0005B\u0005-\bb\u0002B\u0004\u0001\u0011\u0005#\u0011\u0002\u0005\b\u0005\u0017\u0001A\u0011\u000bB\u0007\u0011%\u0011I\u0002AA\u0001\n\u0003\u0011Y\u0002C\u0005\u00032\u0001\t\n\u0011\"\u0001\u00034!I!\u0011\n\u0001\u0012\u0002\u0013\u0005!1\u0007\u0005\n\u0005\u0017\u0002\u0011\u0013!C\u0001\u0005gA\u0011B!\u0014\u0001#\u0003%\tAa\r\t\u0013\t=\u0003!%A\u0005\u0002\tM\u0002\"\u0003B)\u0001E\u0005I\u0011\u0001B\u001a\u0011%\u0011\u0019\u0006AI\u0001\n\u0003\u0011)\u0006C\u0005\u0003Z\u0001\t\n\u0011\"\u0001\u0003\\!I!q\f\u0001\u0012\u0002\u0013\u0005!\u0011\r\u0005\n\u0005K\u0002\u0011\u0013!C\u0001\u0005OB\u0011Ba\u001b\u0001\u0003\u0003%\tE!\u001c\t\u0013\te\u0004!!A\u0005\u0002\tm\u0004\"\u0003B?\u0001\u0005\u0005I\u0011\u0001B@\u0011%\u0011)\tAA\u0001\n\u0003\u00129\tC\u0005\u0003\u0016\u0002\t\t\u0011\"\u0001\u0003\u0018\"I!1\u0014\u0001\u0002\u0002\u0013\u0005#QT\u0004\n\u0005\u000f\u0014\u0015\u0011!E\u0001\u0005\u00134\u0001\"\u0011\"\u0002\u0002#\u0005!1\u001a\u0005\b\u0003{\u0019D\u0011\u0001Bm\u0011%\u0011YnMA\u0001\n\u000b\u0012i\u000eC\u0005\u0003`N\n\t\u0011\"!\u0003b\"I!q_\u001a\u0012\u0002\u0013\u0005!Q\u000b\u0005\n\u0005s\u001c\u0014\u0013!C\u0001\u00057B\u0011Ba?4#\u0003%\tA!\u0019\t\u0013\tu8'%A\u0005\u0002\t\u001d\u0004\"\u0003B\u0000g\u0005\u0005I\u0011QB\u0001\u0011%\u0019yaMI\u0001\n\u0003\u0011)\u0006C\u0005\u0004\u0012M\n\n\u0011\"\u0001\u0003\\!I11C\u001a\u0012\u0002\u0013\u0005!\u0011\r\u0005\n\u0007+\u0019\u0014\u0013!C\u0001\u0005OB\u0011ba\u00064\u0003\u0003%Ia!\u0007\u0003\u001b5\u000b7.\u001a+j[\u0016\u001cH/Y7q\u0015\t\u0019E)A\u0006fqB\u0014Xm]:j_:\u001c(BA#G\u0003!\u0019\u0017\r^1msN$(BA$I\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013*\u000bQa\u001d9be.T!a\u0013'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0015aA8sO\u000e\u00011c\u0002\u0001Q)^S\u0016m\u001a\t\u0003#Jk\u0011AQ\u0005\u0003'\n\u00131cU3qi\u0016t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!U+\n\u0005Y\u0013%a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\t\t\u0006,\u0003\u0002Z\u0005\n1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\\=:\u0011\u0011\u000bX\u0005\u0003;\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002`A\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA/C!\t\u0011W-D\u0001d\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u00195\n\u0005%\u001c'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001B=fCJ,\u0012\u0001\u001c\t\u0003#6L!A\u001c\"\u0003\u0015\u0015C\bO]3tg&|g.A\u0003zK\u0006\u0014\b%A\u0003n_:$\b.\u0001\u0004n_:$\b\u000eI\u0001\u0004I\u0006L\u0018\u0001\u00023bs\u0002\nA\u0001[8ve\u0006)\u0001n\\;sA\u0005\u0019Q.\u001b8\u0002\t5Lg\u000eI\u0001\u0004g\u0016\u001c\u0017\u0001B:fG\u0002\n\u0001\u0002^5nKj|g.Z\u000b\u0002yB\u0019!- 7\n\u0005y\u001c'AB(qi&|g.A\u0005uS6,'p\u001c8fA\u0005QA/[7f5>tW-\u00133\u0016\u0005\u0005\u0015\u0001\u0003\u00022~\u0003\u000f\u0001B!!\u0003\u0002\u00189!\u00111BA\n!\r\tiaY\u0007\u0003\u0003\u001fQ1!!\u0005O\u0003\u0019a$o\\8u}%\u0019\u0011QC2\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)bY\u0001\fi&lWMW8oK&#\u0007%A\u0006gC&dwJ\\#se>\u0014XCAA\u0012!\r\u0011\u0017QE\u0005\u0004\u0003O\u0019'a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007$\u0002\u000bQL\b/Z:\n\t\u0005e\u00121\u0007\u0002\t\t\u0006$\u0018\rV=qK\u0006IA-\u0019;b)f\u0004X\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0013\u0011KA*\u0003+\u0002\"!\u0015\u0001\t\u000b),\u0002\u0019\u00017\t\u000bA,\u0002\u0019\u00017\t\u000bI,\u0002\u0019\u00017\t\u000bQ,\u0002\u0019\u00017\t\u000bY,\u0002\u0019\u00017\t\u000ba,\u0002\u0019\u00017\t\u000fi,\u0002\u0013!a\u0001y\"I\u0011\u0011A\u000b\u0011\u0002\u0003\u0007\u0011Q\u0001\u0005\n\u0003?)\u0002\u0013!a\u0001\u0003GA\u0011\"a\u000b\u0016!\u0003\u0005\r!a\f\u0015\u001d\u0005\u0005\u0013\u0011LA.\u0003;\ny&!\u0019\u0002d!)!N\u0006a\u0001Y\")\u0001O\u0006a\u0001Y\")!O\u0006a\u0001Y\")AO\u0006a\u0001Y\")aO\u0006a\u0001Y\")\u0001P\u0006a\u0001YR\u0001\u0012\u0011IA4\u0003S\nY'!\u001c\u0002p\u0005E\u00141\u000f\u0005\u0006U^\u0001\r\u0001\u001c\u0005\u0006a^\u0001\r\u0001\u001c\u0005\u0006e^\u0001\r\u0001\u001c\u0005\u0006i^\u0001\r\u0001\u001c\u0005\u0006m^\u0001\r\u0001\u001c\u0005\u0006q^\u0001\r\u0001\u001c\u0005\u0006u^\u0001\r\u0001\\\u0001\tG\"LG\u000e\u001a:f]V\u0011\u0011\u0011\u0010\t\u0006\u0003w\n\u0019\t\u001c\b\u0005\u0003{\n\tI\u0004\u0003\u0002\u000e\u0005}\u0014\"\u00013\n\u0005u\u001b\u0017\u0002BAC\u0003\u000f\u00131aU3r\u0015\ti6-\u0001\u0006j]B,H\u000fV=qKN,\"!!$\u0011\r\u0005m\u00141QAH!\u0011\t\t$!%\n\t\u0005M\u00151\u0007\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004)\u0006m\u0005bBA\u00017\u0001\u0007\u0011qA\u0001\ti>l\u0015n\u0019:pgR\u0001\u0012\u0011UAT\u0003_\u000b\t,a-\u00026\u0006]\u0016\u0011\u0019\t\u0004E\u0006\r\u0016bAASG\n\u0019\u0011I\\=\t\r)d\u0002\u0019AAU!\r\u0011\u00171V\u0005\u0004\u0003[\u001b'aA%oi\"1\u0001\u000f\ba\u0001\u0003SCaA\u001d\u000fA\u0002\u0005%\u0006B\u0002;\u001d\u0001\u0004\tI\u000b\u0003\u0004w9\u0001\u0007\u0011\u0011\u0016\u0005\b\u0003sc\u0002\u0019AA^\u00031\u0019XmY!oI6K7M]8t!\u0011\t\t$!0\n\t\u0005}\u00161\u0007\u0002\b\t\u0016\u001c\u0017.\\1m\u0011\u001d\t\u0019\r\ba\u0001\u0003\u000b\faA_8oK&#\u0007\u0003BAd\u0003#l!!!3\u000b\t\u0005-\u0017QZ\u0001\u0005i&lWM\u0003\u0002\u0002P\u0006!!.\u0019<b\u0013\u0011\t\u0019.!3\u0003\ri{g.Z%e\u00031qW\u000f\u001c7TC\u001a,WI^1m)A\t\t+!7\u0002\\\u0006u\u0017q\\Aq\u0003G\f)\u000f\u0003\u0004k;\u0001\u0007\u0011\u0011\u0015\u0005\u0007av\u0001\r!!)\t\rIl\u0002\u0019AAQ\u0011\u0019!X\u00041\u0001\u0002\"\"1a/\ba\u0001\u0003CCa\u0001_\u000fA\u0002\u0005\u0005\u0006B\u0002>\u001e\u0001\u0004\t9\u000f\u0005\u0003c{\u0006\u0005\u0016!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ti/!?\u0003\u0004A!\u0011q^A{\u001b\t\t\tPC\u0002\u0002t\n\u000bqaY8eK\u001e,g.\u0003\u0003\u0002x\u0006E(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005mh\u00041\u0001\u0002~\u0006\u00191\r\u001e=\u0011\t\u0005=\u0018q`\u0005\u0005\u0005\u0003\t\tP\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\t\u0015a\u00041\u0001\u0002n\u0006\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA\u0004\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002B\t=\u0001b\u0002B\tA\u0001\u0007!1C\u0001\f]\u0016<8\t[5mIJ,g\u000eE\u0003\u0002|\tUA.\u0003\u0003\u0003\u0018\u0005\u001d%AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)Y\t\tE!\b\u0003 \t\u0005\"1\u0005B\u0013\u0005O\u0011ICa\u000b\u0003.\t=\u0002b\u00026\"!\u0003\u0005\r\u0001\u001c\u0005\ba\u0006\u0002\n\u00111\u0001m\u0011\u001d\u0011\u0018\u0005%AA\u00021Dq\u0001^\u0011\u0011\u0002\u0003\u0007A\u000eC\u0004wCA\u0005\t\u0019\u00017\t\u000fa\f\u0003\u0013!a\u0001Y\"9!0\tI\u0001\u0002\u0004a\b\"CA\u0001CA\u0005\t\u0019AA\u0003\u0011%\ty\"\tI\u0001\u0002\u0004\t\u0019\u0003C\u0005\u0002,\u0005\u0002\n\u00111\u0001\u00020\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u001bU\ra'qG\u0016\u0003\u0005s\u0001BAa\u000f\u0003F5\u0011!Q\b\u0006\u0005\u0005\u007f\u0011\t%A\u0005v]\u000eDWmY6fI*\u0019!1I2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003H\tu\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t]#f\u0001?\u00038\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012BTC\u0001B/U\u0011\t)Aa\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!1\r\u0016\u0005\u0003G\u00119$A\bd_BLH\u0005Z3gCVdG\u000fJ\u00191+\t\u0011IG\u000b\u0003\u00020\t]\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003pA!!\u0011\u000fB<\u001b\t\u0011\u0019H\u0003\u0003\u0003v\u00055\u0017\u0001\u00027b]\u001eLA!!\u0007\u0003t\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011V\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\tK!!\t\u0013\t\re&!AA\u0002\u0005%\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\nB1!1\u0012BI\u0003Ck!A!$\u000b\u0007\t=5-\u0001\u0006d_2dWm\u0019;j_:LAAa%\u0003\u000e\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019C!'\t\u0013\t\r\u0005'!AA\u0002\u0005\u0005\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002$\t}\u0005\"\u0003BBc\u0005\u0005\t\u0019AAQQ]\u0001!1\u0015BU\u0005W\u0013yK!-\u00036\n]&1\u0018B_\u0005\u0003\u0014\u0019\rE\u0002R\u0005KK1Aa*C\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!,\u0002\u0003\u007f{f)\u0016(D?\"JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u0017\u0010\f\u0011i_V\u0014H\u0006I7j]2\u00023/Z2\\Y\u0001\"\u0018.\\3{_:,W,\u000b\u0011.A\r\u0013X-\u0019;fAQLW.Z:uC6\u0004\bE\u001a:p[\u0002JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u0017\u0010\f\u0011i_V\u0014H\u0006I7j]2\u00023/Z2!C:$\u0007\u0005^5nKj|g.\u001a\u0011gS\u0016dGm\u001d\u0018!)\",\u0007E]3tk2$\b\u0005Z1uC\u0002\"\u0018\u0010]3!SN\u00043m\u001c8tSN$XM\u001c;!o&$\b\u000e\t;iK\u00022\u0018\r\\;fA=4\u0007eY8oM&<WO]1uS>t\u0007\u0005Y:qCJ\\gf]9m]QLW.Z:uC6\u0004H+\u001f9fA\u0006I\u0011M]4v[\u0016tGo]\u0011\u0003\u0005g\u000bQq\u0013\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+Ae,\u0017M\u001d\u0011.AQDW\rI=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002Co\u001c\u0011:seJ$\u0002\t\u0011!A\u0001\u0002#\u0006I7p]RD\u0007%\f\u0011uQ\u0016\u0004Sn\u001c8uQ6zg-L=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002\u0003FS1ok\u0006\u0014\u00180\u000b\u0011u_\u0002\n$\u0007\t\u0015EK\u000e,WNY3sS)\u0001\u0003\u0005\t\u0011!A)\u0002C-Y=![\u0001\"\b.\u001a\u0011eCflsNZ\u0017n_:$\b\u000e\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAM\n$\u0002\t\u0011!A\u0001\u0002#\u0006\t5pkJ\u0004S\u0006\t;iK\u0002Bw.\u001e:._\u001alC-Y=!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000e\t\u0019!i>\u0004#g\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016![&t\u0007%\f\u0011uQ\u0016\u0004S.\u001b8vi\u0016lsNZ\u0017i_V\u0014\b\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\u0002\u0004\u0005^8!keR\u0001\u0005\t\u0011!A\u0001R\u0003e]3dA5\u0002C\u000f[3!g\u0016\u001cwN\u001c3._\u001alS.\u001b8vi\u0016\u0004\u0013M\u001c3!SR\u001c\b%\\5de>lcM]1di&|g\u000e\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0003\u0007\t;pAY\u0002dF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t+iK\u00022\u0018\r\\;fA\r\fg\u000e\t2fA\u0015LG\u000f[3sA\u0005t\u0007%\u001b8uK\u001e,'\u000f\t7jW\u0016\u0004\u0013g\r\u0011-A=\u0014\b%\u0019\u0011ge\u0006\u001cG/[8oA1L7.\u001a\u00112g9\n$g\r\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004C\u000f[3!g\u0016\u001c\u0007%\u0019:hk6,g\u000e\u001e\u0011fcV\fGn\u001d\u0011u_\u00022\u0004\u0007\f\u0011uQ\u0016\u00043/Z2p]\u0012\u001c\bEZ5fY\u0012\u0004\u0013n\u001d\u0011tKRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002Co\u001c\u00111A\u0005tG\rI\u0019![&tW\u000f^3!SN\u0004\u0013\r\u001a3fI\u0002\"x\u000e\t;iK\u00022\u0017N\\1mAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011uS6,'p\u001c8fA5\u0002C\u000f[3!i&lW\r\t>p]\u0016\u0004\u0013\u000eZ3oi&4\u0017.\u001a:/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!\u0007\u0016#F\u0006I+U\u0007\u0002\ng\u000e\u001a\u0011fi\u000et#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!/\u0002\u0007GS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192i1\u0002\u0013G\r\u0017!eab\u0003E\u000e\u0017!gAb\u0003\u0005N\u001b/qa:\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\"T&\r\u001a.ea\u0002\u0003G\u000e\u001e4ai\"TG\f\u001d9o)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00195Y\u0001\n$\u0007\f\u00113q1\u0002c\u0007\f\u00114a1\u0002C'\u000e\u00189q]b\u0003eJ\"F)\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cQj\u0013GM\u00173o\u0001\u0012\u0014GO\u001a1uQ*d\u0006\u000f\u001d8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'M\u001d-AYb\u0003e\r\u0019-AI\u001aD\u0006I\u001b:Y\u00012\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\n\u0014(\f\u00198[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eA\n\u0014\b\f\u00117Y\u0001\u001a\u0004\u0007\f\u00113g1\u0002S'\u000f\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192s5\u0002d'L\u001a1AI\u001a$(N\u001d;aER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002\u0013g\r\u0017!c1\u0002\u0013\u0007\r\u0017!cEb\u0003%\r\u001a-A\u001d\u00026\u000bV\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q9,H\u000e\u001c\u0017!o1\u0002#G\r\u0017!cUb\u0003e\r\u0019-AAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005\u007f\u000ba\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0003F\u0006)1G\f\u0019/a\u0005iQ*Y6f)&lWm\u001d;b[B\u0004\"!U\u001a\u0014\tM\u0012im\u001a\t\u0014\u0005\u001f\u0014)\u000e\u001c7mY2dG0!\u0002\u0002$\u0005=\u0012\u0011I\u0007\u0003\u0005#T1Aa5d\u0003\u001d\u0011XO\u001c;j[\u0016LAAa6\u0003R\n\u0011\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u00191)\t\u0011I-\u0001\u0005u_N#(/\u001b8h)\t\u0011y'A\u0003baBd\u0017\u0010\u0006\f\u0002B\t\r(Q\u001dBt\u0005S\u0014YO!<\u0003p\nE(1\u001fB{\u0011\u0015Qg\u00071\u0001m\u0011\u0015\u0001h\u00071\u0001m\u0011\u0015\u0011h\u00071\u0001m\u0011\u0015!h\u00071\u0001m\u0011\u00151h\u00071\u0001m\u0011\u0015Ah\u00071\u0001m\u0011\u001dQh\u0007%AA\u0002qD\u0011\"!\u00017!\u0003\u0005\r!!\u0002\t\u0013\u0005}a\u0007%AA\u0002\u0005\r\u0002\"CA\u0016mA\u0005\t\u0019AA\u0018\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012:\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001d\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIe\n\u0001#\u00199qYf$C-\u001a4bk2$H%\r\u0019\u0002\u000fUt\u0017\r\u001d9msR!11AB\u0006!\u0011\u0011Wp!\u0002\u0011!\t\u001c9\u0001\u001c7mY2dG0!\u0002\u0002$\u0005=\u0012bAB\u0005G\n9A+\u001e9mKF\u0002\u0004\"CB\u0007w\u0005\u0005\t\u0019AA!\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%s\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa\u0007\u0011\t\tE4QD\u0005\u0005\u0007?\u0011\u0019H\u0001\u0004PE*,7\r\u001e")
public class MakeTimestamp
extends SeptenaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final Option<String> timeZoneId;
    private final boolean failOnError;
    private final DataType dataType;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static DataType $lessinit$greater$default$10() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean $lessinit$greater$default$9() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> $lessinit$greater$default$8() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Expression> $lessinit$greater$default$7() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>> unapply(MakeTimestamp makeTimestamp) {
        return MakeTimestamp$.MODULE$.unapply(makeTimestamp);
    }

    public static DataType apply$default$10() {
        return MakeTimestamp$.MODULE$.apply$default$10();
    }

    public static boolean apply$default$9() {
        return MakeTimestamp$.MODULE$.apply$default$9();
    }

    public static Option<String> apply$default$8() {
        return MakeTimestamp$.MODULE$.apply$default$8();
    }

    public static Option<Expression> apply$default$7() {
        return MakeTimestamp$.MODULE$.apply$default$7();
    }

    public static Function1<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>, MakeTimestamp> tupled() {
        return MakeTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, Function1<DataType, MakeTimestamp>>>>>>>>>> curried() {
        return MakeTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)new .colon.colon((Object)this.year(), (List)new .colon.colon((Object)this.month(), (List)new .colon.colon((Object)this.day(), (List)new .colon.colon((Object)this.hour(), (List)new .colon.colon((Object)this.min(), (List)new .colon.colon((Object)this.sec(), (List)Nil$.MODULE$))))))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)((TraversableLike)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)new DecimalType(16, 6), (List)Nil$.MODULE$))))))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.timezone().map((Function1 & Serializable & scala.Serializable)x$12 -> StringType$.MODULE$)), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.nullable())) : true;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$9();
        DataType x$10 = this.copy$default$10();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<String>)x$1, x$9, x$10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toMicros(int year, int month, int day, int hour, int min, Decimal secAndMicros, ZoneId zoneId) {
        try {
            Long l;
            LocalDateTime localDateTime;
            Predef$.MODULE$.assert(secAndMicros.scale() == 6, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Seconds fraction must have 6 digits for microseconds but got ").append(secAndMicros.scale()).toString());
            long unscaledSecFrac = secAndMicros.toUnscaledLong();
            int totalMicros = (int)unscaledSecFrac;
            int seconds = Math.floorDiv(totalMicros, (int)1000000L);
            int nanos = Math.floorMod(totalMicros, (int)1000000L) * (int)1000L;
            if (seconds == 60) {
                if (nanos != 0) throw QueryExecutionErrors$.MODULE$.invalidFractionOfSecondError();
                localDateTime = LocalDateTime.of(year, month, day, hour, min, 0, 0).plusMinutes(1L);
            } else {
                localDateTime = LocalDateTime.of(year, month, day, hour, min, seconds, nanos);
            }
            LocalDateTime ldt = localDateTime;
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            if (!(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null)) {
                l = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(ldt.atZone(zoneId).toInstant()));
                return l;
            }
            l = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt));
            return l;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof DateTimeException)) throw throwable;
            if (this.failOnError()) throw throwable;
            return null;
        }
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day, Object hour, Object min, Object sec, Option<Object> timezone) {
        ZoneId zid = (ZoneId)timezone.map((Function1 & Serializable & scala.Serializable)tz -> DateTimeUtils$.MODULE$.getZoneId(((UTF8String)tz).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.zoneId());
        return this.toMicros(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec, zid);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String d = new StringOps(Predef$.MODULE$.augmentString(Decimal$.MODULE$.getClass().getName())).stripSuffix("$");
        String failOnErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable & scala.Serializable)(year, month, day, hour, min, secAndNanos, timezone) -> {
            String zoneId = (String)timezone.map((Function1 & Serializable & scala.Serializable)tz -> new StringBuilder(23).append(dtu).append(".getZoneId(").append((String)tz).append(".toString())").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> zid);
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            String toMicrosCode = !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null) ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("\n           |java.time.Instant instant = ldt.atZone(").append(zoneId).append(").toInstant();\n           |").append(ev.value()).append(" = ").append(dtu).append(".instantToMicros(instant);\n           |").toString())).stripMargin() : new StringBuilder(31).append(ev.value()).append(" = ").append(dtu).append(".localDateTimeToMicros(ldt);").toString();
            return new StringBuilder(740).append("\n      try {\n        org.apache.spark.sql.types.Decimal secFloor = ").append((String)secAndNanos).append(".floor();\n        org.apache.spark.sql.types.Decimal nanosPerSec = ").append(d).append("$.MODULE$.apply(1000000000L, 10, 0);\n        int nanos = ((").append((String)secAndNanos).append(".$minus(secFloor)).$times(nanosPerSec)).toInt();\n        int seconds = secFloor.toInt();\n        java.time.LocalDateTime ldt;\n        if (seconds == 60) {\n          if (nanos == 0) {\n            ldt = java.time.LocalDateTime.of(\n              ").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", 0, 0).plusMinutes(1);\n          } else {\n            throw QueryExecutionErrors.invalidFractionOfSecondError();\n          }\n        } else {\n          ldt = java.time.LocalDateTime.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", seconds, nanos);\n        }\n        ").append(toMicrosCode).append("\n      } catch (java.time.DateTimeException e) {\n        ").append(failOnErrorBranch).append("\n      }").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_timestamp";
    }

    @Override
    public MakeTimestamp withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        None$ timezoneOpt = this.timezone().isDefined() ? new Some(newChildren.apply(6)) : None$.MODULE$;
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5), (Option<Expression>)timezoneOpt, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public MakeTimestamp copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        return new MakeTimestamp(year, month, day, hour, min, sec, timezone, timeZoneId, failOnError, dataType);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public DataType copy$default$10() {
        return this.dataType();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public Option<String> copy$default$8() {
        return this.timeZoneId();
    }

    public boolean copy$default$9() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestamp";
    }

    public int productArity() {
        return 10;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = this.hour();
                break;
            }
            case 4: {
                object = this.min();
                break;
            }
            case 5: {
                object = this.sec();
                break;
            }
            case 6: {
                object = this.timezone();
                break;
            }
            case 7: {
                object = this.timeZoneId();
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            case 9: {
                object = this.dataType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestamp makeTimestamp = (MakeTimestamp)x$1;
        Expression expression = this.year();
        Expression expression2 = makeTimestamp.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestamp.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestamp.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestamp.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestamp.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestamp.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestamp.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = makeTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (this.failOnError() != makeTimestamp.failOnError()) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = makeTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        if (!makeTimestamp.canEqual(this)) return false;
        return true;
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
        this.dataType = dataType;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), SQLConf$.MODULE$.get().timestampType());
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), SQLConf$.MODULE$.get().timestampType());
    }
}

