/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH FROM str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(LEADING FROM str) - Removes the leading space characters from `str`.\n\n    _FUNC_(TRAILING FROM str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`.\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(BOTH FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(LEADING FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(TRAILING FROM '    SparkSQL   ');\n           SparkSQL\n      > SELECT _FUNC_('SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}v!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002\u001f\u0002\t\u0003i\u0004B\u0002\u001f\u0002\t\u0003\t9\n\u0003\u0005=\u0003\u0005\u0005I\u0011QAN\u0011%\t\t+AI\u0001\n\u0003\t9\u0003C\u0005\u0002$\u0006\t\t\u0011\"!\u0002&\"I\u00111W\u0001\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003k\u000b\u0011\u0011!C\u0005\u0003o3Aa\f\u0011A\u007f!A\u0011J\u0003BK\u0002\u0013\u0005!\n\u0003\u0005L\u0015\tE\t\u0015!\u0003A\u0011!a%B!f\u0001\n\u0003i\u0005\u0002C)\u000b\u0005#\u0005\u000b\u0011\u0002(\t\u000biRA\u0011\u0001*\t\u000biRA\u0011A+\t\u000biRA\u0011\u0001-\t\u000biSA\u0011I.\t\u000b\u001dTA\u0011K.\t\u000b!TA\u0011I5\t\u000bMTA\u0011\t;\t\u0013\u0005\u0015!\"!A\u0005\u0002\u0005\u001d\u0001\"CA\u0007\u0015E\u0005I\u0011AA\b\u0011%\t)CCI\u0001\n\u0003\t9\u0003C\u0005\u0002,)\t\t\u0011\"\u0011\u0002.!I\u0011Q\b\u0006\u0002\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u000fR\u0011\u0011!C\u0001\u0003\u0013B\u0011\"a\u0014\u000b\u0003\u0003%\t%!\u0015\t\u0013\u0005}#\"!A\u0005\u0002\u0005\u0005\u0004\"CA6\u0015\u0005\u0005I\u0011IA7\u0003)\u0019FO]5oOR\u0013\u0018.\u001c\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001A\u0011a&A\u0007\u0002A\tQ1\u000b\u001e:j]\u001e$&/[7\u0014\u0007\u0005\tt\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003eaJ!!O\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005i\u0013!B1qa2LH#\u0002 \u0002\u0012\u0006U\u0005C\u0001\u0018\u000b'\u0015Q\u0001i\u0011$8!\tq\u0013)\u0003\u0002CA\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00059\"\u0015BA#!\u0005U\u0019FO]5oOJ\"&/[7FqB\u0014Xm]:j_:\u0004\"AM$\n\u0005!\u001b$a\u0002)s_\u0012,8\r^\u0001\u0007gJ\u001c7\u000b\u001e:\u0016\u0003\u0001\u000bqa\u001d:d'R\u0014\b%A\u0004ue&l7\u000b\u001e:\u0016\u00039\u00032AM(A\u0013\t\u00016G\u0001\u0004PaRLwN\\\u0001\tiJLWn\u0015;sAQ\u0019ah\u0015+\t\u000b%{\u0001\u0019\u0001!\t\u000f1{\u0001\u0013!a\u0001\u001dR\u0019aHV,\t\u000b1\u0003\u0002\u0019\u0001!\t\u000b%\u0003\u0002\u0019\u0001!\u0015\u0005yJ\u0006\"B%\u0012\u0001\u0004\u0001\u0015A\u00039sKR$\u0018PT1nKV\tA\f\u0005\u0002^I:\u0011aL\u0019\t\u0003?Nj\u0011\u0001\u0019\u0006\u0003C2\na\u0001\u0010:p_Rt\u0014BA24\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r\u001c\u0014!\u00033je\u0016\u001cG/[8o\u0003\u0011)g/\u00197\u0015\u0005)l\u0007C\u0001\u001al\u0013\ta7GA\u0002B]fDqA\u001c\u000b\u0011\u0002\u0003\u0007q.A\u0003j]B,H\u000f\u0005\u0002qc6\t!%\u0003\u0002sE\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0003vw\u0006\u0005\u0001C\u0001<z\u001b\u00059(B\u0001=!\u0003\u001d\u0019w\u000eZ3hK:L!A_<\u0003\u0011\u0015C\bO]\"pI\u0016DQ\u0001`\u000bA\u0002u\f1a\u0019;y!\t1h0\u0003\u0002\u0000o\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bBBA\u0002+\u0001\u0007Q/\u0001\u0002fm\u0006!1m\u001c9z)\u0015q\u0014\u0011BA\u0006\u0011\u001dIe\u0003%AA\u0002\u0001Cq\u0001\u0014\f\u0011\u0002\u0003\u0007a*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E!f\u0001!\u0002\u0014-\u0012\u0011Q\u0003\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003%)hn\u00195fG.,GMC\u0002\u0002 M\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019#!\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%\"f\u0001(\u0002\u0014\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005!A.\u00198h\u0015\t\tI$\u0001\u0003kCZ\f\u0017bA3\u00024\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\t\t\u0004e\u0005\r\u0013bAA#g\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!.a\u0013\t\u0013\u000553$!AA\u0002\u0005\u0005\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002TA)\u0011QKA.U6\u0011\u0011q\u000b\u0006\u0004\u00033\u001a\u0014AC2pY2,7\r^5p]&!\u0011QLA,\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r\u0014\u0011\u000e\t\u0004e\u0005\u0015\u0014bAA4g\t9!i\\8mK\u0006t\u0007\u0002CA';\u0005\u0005\t\u0019\u00016\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019'a\u001c\t\u0011\u00055c$!AA\u0002)D3CCA:\u0003s\nY(a \u0002\u0002\u0006\u0015\u0015qQAF\u0003\u001b\u00032ALA;\u0013\r\t9\b\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti(ACT\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004C.Z1eS:<\u0007%\u00198eAQ\u0014\u0018-\u001b7j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"\u0012u\n\u0016%!\rJ{U\nI:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004C.Z1eS:<\u0007%\u00198eAQ\u0014\u0018-\u001b7j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"bU)\u0011#J\u001d\u001e\u0003cIU(NAM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!gB\f7-\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1/\u0015)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015U%\u0006KE*\u0013(HA\u0019\u0013v*\u0014\u0011tiJL\u0003%\f\u0011SK6|g/Z:!i\",\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b;sS6\u001cFO\u001d\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,\u0007\u0005\u001e5fA1,\u0017\rZ5oO\u0002\ng\u000e\u001a\u0011ue\u0006LG.\u001b8hA\u0001$(/[7TiJ\u0004\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006FQ(U\u0011\u0002\"(/[7TiJ\u0004cIU(NAM$(/\u000b\u0011.AI+Wn\u001c<fAQDW\r\t7fC\u0012Lgn\u001a\u0011b]\u0012\u0004CO]1jY&tw\r\t1ue&l7\u000b\u001e:aA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`Q1+\u0015\tR%O\u000f\u0002\"(/[7TiJ\u0004cIU(NAM$(/\u000b\u0011.AI+Wn\u001c<fAQDW\r\t7fC\u0012Lgn\u001a\u0011aiJLWn\u0015;sA\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"\"&+Q%M\u0013:;\u0005\u0005\u001e:j[N#(\u000f\t$S\u001f6\u00033\u000f\u001e:*A5\u0002#+Z7pm\u0016\u0004C\u000f[3!iJ\f\u0017\u000e\\5oO\u0002\u0002GO]5n'R\u0014\b\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005\r\u0015aa>\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQ\u0014\u0018.\\*ue\u0002j\u0003\u0005\u001e5fAQ\u0014\u0018.\u001c\u0011tiJLgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004Co\u001c\u0011ue&lG\u0006\t;iK\u0002\"WMZ1vYR\u0004c/\u00197vK\u0002J7\u000fI1!g&tw\r\\3!gB\f7-\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0016!\u0005>#\u0006\n\f\u0011G%>k\u0005%\f\u0011uQ\u0016\u001cX\rI1sK\u0002ZW-_<pe\u0012\u001c\b\u0005^8!gB,7-\u001b4zAQ\u0014\u0018.\\7j]\u001e\u00043\u000f\u001e:j]\u001e\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t2pi\"\u0004SM\u001c3tA=4'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i\",\u0007e\u001d;sS:<'\u0002\t\u0011!A\u0001\u0002#\u0006\t'F\u0003\u0012Kej\u0012\u0017!\rJ{U\nI\u0017!i\",7/\u001a\u0011be\u0016\u00043.Z=x_J$7\u000f\t;pAM\u0004XmY5gs\u0002\"(/[7nS:<\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004C.\u001a4u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a8eA=4\u0007\u0005\u001e5fAM$(/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"&+Q%M\u0013:;E\u0006\t$S\u001f6\u0003S\u0006\t;iKN,\u0007%\u0019:fA-,\u0017p^8sIN\u0004Co\u001c\u0011ta\u0016\u001c\u0017NZ=!iJLW.\\5oO\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005\u001e5fAILw\r\u001b;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002SM\u001c3!_\u001a\u0004C\u000f[3!gR\u0014\u0018N\\4\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u0013\u000bA\u0011\r\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'!A\u0001:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012u\n\u0016%!\rJ{U\nI\u0014!A\u0001\u00023\u000b]1sWN\u000bF\n\t\u0011!O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\u0019\u0016\u000bE)\u0013(HA\u0019\u0013v*\u0014\u0011(A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0011!A\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QQ\u0013\u0016)\u0013'J\u001d\u001e\u0003cIU(NA\u001d\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)MA\u0001\u0002s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OMcu\u0005\t$S\u001f6\u0003seU*qCJ\\7+\u0015'TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005]1sWN\u000b&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\"P)\"\u0003se\u0015'(A\u0019\u0013v*\u0014\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q1+\u0015\tR%O\u000f\u0002:3\u000bT\u0014!\rJ{U\nI\u0014T'B\f'o[*R\u0019N;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011qCJ\\7+\u0015'T\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\"&+Q%M\u0013:;\u0005eJ*MO\u00012%kT'!OM\u001b\u0006/\u0019:l'Fc5kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u001b\u0006/\u0019:l'FS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u001f\u000bQ!\r\u00186]ABa!a%\u0004\u0001\u0004\u0001\u0015aA:ue\")Aj\u0001a\u0001\u0001R\u0019a(!'\t\r\u0005ME\u00011\u0001A)\u0015q\u0014QTAP\u0011\u0015IU\u00011\u0001A\u0011\u001daU\u0001%AA\u00029\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9+a,\u0011\tIz\u0015\u0011\u0016\t\u0006e\u0005-\u0006IT\u0005\u0004\u0003[\u001b$A\u0002+va2,'\u0007\u0003\u0005\u00022\u001e\t\t\u00111\u0001?\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003s\u0003B!!\r\u0002<&!\u0011QXA\u001a\u0005\u0019y%M[3di\u0002")
public class StringTrim
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim stringTrim) {
        return StringTrim$.MODULE$.unapply(stringTrim);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public String direction() {
        return "BOTH";
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trim((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trim());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$42 -> x$42.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$43 -> x$43.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trim();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimFunction = new StringBuilder(84).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trim(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$44 -> x$44.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

