/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Sequence$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.Mirrors;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(start, stop, step) - Generates an array of elements from start to stop (inclusive),\n      incrementing by step. The type of the returned elements is the same as the type of argument\n      expressions.\n\n      Supported types are: byte, short, integer, long, date, timestamp.\n\n      The start and stop expressions must resolve to the same type.\n      If start and stop expressions resolve to the 'date' or 'timestamp' type\n      then the step expression must resolve to the 'interval' type, otherwise to the same type\n      as the start and stop expressions.\n  ", arguments="\n    Arguments:\n      * start - an expression. The start of the range.\n      * stop - an expression. The end the range (inclusive).\n      * step - an optional expression. The step of the range.\n          By default step is 1 if start is less than or equal to stop, otherwise -1.\n          For the temporal sequences it's 1 day and -1 day respectively.\n          If start is greater than stop then the step must be negative, and vice versa.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(5, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(to_date('2018-01-01'), to_date('2018-03-01'), interval 1 month);\n       [2018-01-01,2018-02-01,2018-03-01]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\rmh\u0001B+W\u0001\u000eD\u0001\u0002\u001e\u0001\u0003\u0016\u0004%\t!\u001e\u0005\tm\u0002\u0011\t\u0012)A\u0005I\"Aq\u000f\u0001BK\u0002\u0013\u0005Q\u000f\u0003\u0005y\u0001\tE\t\u0015!\u0003e\u0011!I\bA!f\u0001\n\u0003Q\b\u0002\u0003@\u0001\u0005#\u0005\u000b\u0011B>\t\u0013}\u0004!Q3A\u0005\u0002\u0005\u0005\u0001BCA\u000e\u0001\tE\t\u0015!\u0003\u0002\u0004!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u000f\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003;\u0001A\u0011AA\u0019\u0011\u001d\tY\u0004\u0001C!\u0003{Aq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002Z!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003\u0007\u0003A\u0011AA\"\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fC!\"a%\u0001\u0011\u000b\u0007I\u0011BAK\u0011\u001d\u0011\u0019\u0001\u0001C!\u0007cBqaa \u0001\t#\u001a\t\tC\u0005\u0004\n\u0002\t\t\u0011\"\u0001\u0004\f\"I1Q\u0013\u0001\u0012\u0002\u0013\u00051q\u0013\u0005\n\u00077\u0003\u0011\u0013!C\u0001\u0007/C\u0011b!(\u0001#\u0003%\taa(\t\u0013\r\r\u0006!%A\u0005\u0002\rE\u0002\"CBS\u0001\u0005\u0005I\u0011IBT\u0011%\u0019i\u000bAA\u0001\n\u0003\u0019y\u000bC\u0005\u00042\u0002\t\t\u0011\"\u0001\u00044\"I1\u0011\u0018\u0001\u0002\u0002\u0013\u000531\u0018\u0005\n\u0007\u0013\u0004\u0011\u0011!C\u0001\u0007\u0017D\u0011ba4\u0001\u0003\u0003%\te!5\b\u000f\u0005me\u000b#\u0001\u0002\u001e\u001a1QK\u0016E\u0001\u0003?Cq!!\b$\t\u0003\t9+\u0002\u0004\u0002*\u000e\"\u00111\u0016\u0004\u0007\u0003o\u001bC!!/\t\u0015\u0005mfE!A!\u0002\u0013\ti\f\u0003\u0006\u0002B\u001a\u0012\t\u0011)A\u0005\u0003\u001bC!\"a1'\u0005\u0003\u0005\u000b\u0011BAY\u0011\u001d\tiB\nC\u0001\u0003\u000bD\u0011\"a4'\u0005\u0004%I!!5\t\u0011\u0005Mg\u0005)A\u0005\u0003cCq!!6'\t\u0003\t9\u000eC\u0004\u0002^\u001a\"\t!a8\u0007\u0013\u0005}8\u0005%A\u0012\n\t\u0005\u0001b\u0002B\u0002_\u0019\u0005!Q\u0001\u0005\b\u0003;|c\u0011\u0001B\u0007\u0011%\u0011yb\fb\u0001\u000e\u0003\u0011\tC\u0002\u0004\u0003$\r\"!Q\u0005\u0005\u000b\u0005;\u0019$\u0011!Q\u0001\n\t-\u0002B\u0003B\u0019g\t\r\t\u0015a\u0003\u00034!Q!qJ\u001a\u0003\u0002\u0003\u0006YA!\u0015\t\u000f\u0005u1\u0007\"\u0001\u0003X!I!qD\u001aC\u0002\u0013\u0005#\u0011\u0005\u0005\t\u0005G\u001a\u0004\u0015!\u0003\u0002H\"9!1A\u001a\u0005B\t\u0015\u0004bBAog\u0011\u0005#\u0011\u0010\u0004\u0007\u0005\u000f\u001bCA!#\t\u0015\t5EH!A!\u0002\u0013\u0011Y\u0003\u0003\u0006\u0003\u0010r\u0012\t\u0011)A\u0005\u0005#C!Ba&=\u0005\u0003\u0005\u000b\u0011\u0002BM\u0011)\u0011\u0019\u000b\u0010B\u0001B\u0003%!Q\u0015\u0005\u000b\u0005kc$1!Q\u0001\f\t]\u0006B\u0003B(y\t\u0005\t\u0015a\u0003\u0003:\"9\u0011Q\u0004\u001f\u0005\u0002\tm\u0006\"\u0003B\u0010y\t\u0007I\u0011\tB\u0011\u0011!\u0011\u0019\u0007\u0010Q\u0001\n\u0005\u001d\u0007\"\u0003Bgy\t\u0007I\u0011\u0002Bh\u0011!\u0011\u0019\u000e\u0010Q\u0001\n\tE\u0007\"\u0003Bky\t\u0007I\u0011\u0002Bl\u0011!\u0011I\u000e\u0010Q\u0001\n\tE\u0005\"\u0003Bny\t\u0007I\u0011\u0002Bl\u0011!\u0011i\u000e\u0010Q\u0001\n\tE\u0005b\u0002B\u0002y\u0011\u0005#q\u001c\u0005\b\u0003;dD\u0011\tBu\u0011\u001d\u00119p\tC\u0005\u0005sDqa!\u0006$\t\u0013\u00199\u0002C\u0005\u0002V\u000e\n\t\u0011\"!\u0004&!I1qF\u0012\u0012\u0002\u0013\u00051\u0011\u0007\u0005\n\u0007\u000f\u001a\u0013\u0011!CA\u0007\u0013B\u0011ba\u0016$#\u0003%\ta!\r\t\u0013\re3%!A\u0005\n\rm#\u0001C*fcV,gnY3\u000b\u0005]C\u0016aC3yaJ,7o]5p]NT!!\u0017.\u0002\u0011\r\fG/\u00197zgRT!a\u0017/\u0002\u0007M\fHN\u0003\u0002^=\u0006)1\u000f]1sW*\u0011q\fY\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\f1a\u001c:h\u0007\u0001\u0019R\u0001\u00013iWF\u0004\"!\u001a4\u000e\u0003YK!a\u001a,\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002fS&\u0011!N\u0016\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"\u0001\\8\u000e\u00035T\u0011A\\\u0001\u0006g\u000e\fG.Y\u0005\u0003a6\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002me&\u00111/\u001c\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006gR\f'\u000f^\u000b\u0002I\u000611\u000f^1si\u0002\nAa\u001d;pa\u0006)1\u000f^8qA\u000591\u000f^3q\u001fB$X#A>\u0011\u00071dH-\u0003\u0002~[\n1q\n\u001d;j_:\f\u0001b\u001d;fa>\u0003H\u000fI\u0001\u000bi&lWMW8oK&#WCAA\u0002!\u0011aG0!\u0002\u0011\t\u0005\u001d\u0011Q\u0003\b\u0005\u0003\u0013\t\t\u0002E\u0002\u0002\f5l!!!\u0004\u000b\u0007\u0005=!-\u0001\u0004=e>|GOP\u0005\u0004\u0003'i\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\u0005e!AB*ue&twMC\u0002\u0002\u00145\f1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"\"\"!\t\u0002$\u0005\u0015\u0012qEA\u0015!\t)\u0007\u0001C\u0003u\u0013\u0001\u0007A\rC\u0003x\u0013\u0001\u0007A\rC\u0003z\u0013\u0001\u00071\u0010\u0003\u0005\u0000\u0013A\u0005\t\u0019AA\u0002)\u0019\t\t#!\f\u00020!)AO\u0003a\u0001I\")qO\u0003a\u0001IRA\u0011\u0011EA\u001a\u0003k\t9\u0004C\u0003u\u0017\u0001\u0007A\rC\u0003x\u0017\u0001\u0007A\r\u0003\u0004\u0002:-\u0001\r\u0001Z\u0001\u0005gR,\u0007/\u0001\u0007xSRDG+[7f5>tW\rF\u0002i\u0003\u007fAaa \u0007A\u0002\u0005\u0015\u0011\u0001C2iS2$'/\u001a8\u0016\u0005\u0005\u0015\u0003#BA$\u0003#\"g\u0002BA%\u0003\u001brA!a\u0003\u0002L%\ta.C\u0002\u0002P5\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002T\u0005U#aA*fc*\u0019\u0011qJ7\u0002\u0011\u0019|G\u000eZ1cY\u0016,\"!a\u0017\u0011\u00071\fi&C\u0002\u0002`5\u0014qAQ8pY\u0016\fg.\u0001\u0005ok2d\u0017M\u00197f\u0003!!\u0017\r^1UsB,WCAA4!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA75\u0006)A/\u001f9fg&!\u0011\u0011OA6\u0005%\t%O]1z)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002xA!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~a\u000b\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u0003\u000bYHA\bUsB,7\t[3dWJ+7/\u001e7u\u0003E\u0019w.\u001a:dS\ndWm\u00115jY\u0012\u0014XM\\\u0001\u000fG\u0006\u001cHo\u00115jY\u0012\u0014XM\u001c+p)\r!\u0017\u0011\u0012\u0005\b\u0003\u0017\u001b\u0002\u0019AAG\u0003%9\u0018\u000eZ3s)f\u0004X\r\u0005\u0003\u0002j\u0005=\u0015\u0002BAI\u0003W\u0012\u0001\u0002R1uCRK\b/Z\u0001\u0005S6\u0004H.\u0006\u0002\u0002\u0018B\u0019\u0011\u0011T\u0018\u000f\u0005\u0015\u0014\u0013\u0001C*fcV,gnY3\u0011\u0005\u0015\u001c3\u0003B\u0012\u0002\"F\u00042\u0001\\AR\u0013\r\t)+\u001c\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005u%!\u0005'fgN$\u0006.\u00198Pe\u0016\u000bX/\u00197G]BIA.!,\u00022\u0006E\u00161L\u0005\u0004\u0003_k'!\u0003$v]\u000e$\u0018n\u001c83!\ra\u00171W\u0005\u0004\u0003kk'aA!os\nYA)\u001a4bk2$8\u000b^3q'\r1\u0013\u0011U\u0001\u0005YR,\u0017\u000fE\u0002\u0002@\u0016j\u0011aI\u0001\tgR,\u0007\u000fV=qK\u0006\u0019qN\\3\u0015\u0011\u0005\u001d\u0017\u0011ZAf\u0003\u001b\u00042!a0'\u0011\u001d\tYL\u000ba\u0001\u0003{Cq!!1+\u0001\u0004\ti\tC\u0004\u0002D*\u0002\r!!-\u0002\u00179,w-\u0019;jm\u0016|e.Z\u000b\u0003\u0003c\u000bAB\\3hCRLg/Z(oK\u0002\nQ!\u00199qYf$b!!-\u0002Z\u0006m\u0007B\u0002;.\u0001\u0004\t\t\f\u0003\u0004x[\u0001\u0007\u0011\u0011W\u0001\bO\u0016t7i\u001c3f)!\t\t/!<\u0002x\u0006m\b\u0003BAr\u0003Sl!!!:\u000b\u0007\u0005\u001dh+A\u0004d_\u0012,w-\u001a8\n\t\u0005-\u0018Q\u001d\u0002\t\u000bb\u0004(oQ8eK\"9\u0011q\u001e\u0018A\u0002\u0005E\u0018aA2uqB!\u00111]Az\u0013\u0011\t)0!:\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011\u0011 \u0018A\u0002\u0005\u0005\u0018\u0001C:uCJ$x)\u001a8\t\u000f\u0005uh\u00061\u0001\u0002b\u000691\u000f^8q\u000f\u0016t'\u0001D*fcV,gnY3J[Bd7cA\u0018\u0002\"\u0006!QM^1m)!\t\tLa\u0002\u0003\n\t-\u0001B\u0002;1\u0001\u0004\t\t\f\u0003\u0004xa\u0001\u0007\u0011\u0011\u0017\u0005\b\u0003s\u0001\u0004\u0019AAY)9\t)Aa\u0004\u0003\u0012\tM!Q\u0003B\f\u00057Aq!a<2\u0001\u0004\t\t\u0010\u0003\u0004uc\u0001\u0007\u0011Q\u0001\u0005\u0007oF\u0002\r!!\u0002\t\u000f\u0005e\u0012\u00071\u0001\u0002\u0006!9!\u0011D\u0019A\u0002\u0005\u0015\u0011aA1se\"9!QD\u0019A\u0002\u0005\u0015\u0011\u0001C3mK6$\u0016\u0010]3\u0002\u0017\u0011,g-Y;miN#X\r]\u000b\u0003\u0003\u000f\u0014A#\u00138uK\u001e\u0014\u0018\r\\*fcV,gnY3J[BdW\u0003\u0002B\u0014\u0005\u0007\u001aRaMAQ\u0005S\u00012!a00!\u0011\tIG!\f\n\t\t=\u00121\u000e\u0002\r\u0013:$Xm\u001a:bYRK\b/Z\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004C\u0002B\u001b\u0005w\u0011y$\u0004\u0002\u00038)\u0019!\u0011H7\u0002\u000fI,g\r\\3di&!!Q\bB\u001c\u0005!\u0019E.Y:t)\u0006<\u0007\u0003\u0002B!\u0005\u0007b\u0001\u0001B\u0004\u0003FM\u0012\rAa\u0012\u0003\u0003Q\u000bBA!\u0013\u00022B\u0019ANa\u0013\n\u0007\t5SNA\u0004O_RD\u0017N\\4\u0002\u00079,X\u000e\u0005\u0004\u0002H\tM#qH\u0005\u0005\u0005+\n)F\u0001\u0005J]R,wM]1m)\u0011\u0011IF!\u0019\u0015\r\tm#Q\fB0!\u0015\tyl\rB \u0011\u001d\u0011\td\u000ea\u0002\u0005gAqAa\u00148\u0001\b\u0011\t\u0006C\u0004\u0003\u001e]\u0002\rAa\u000b\u0002\u0019\u0011,g-Y;miN#X\r\u001d\u0011\u0015\u0011\t\u001d$Q\u000eB9\u0005k\u0002R\u0001\u001cB5\u0005\u007fI1Aa\u001bn\u0005\u0015\t%O]1z\u0011\u001d\u0011yG\u000fa\u0001\u0003c\u000ba!\u001b8qkR\f\u0004b\u0002B:u\u0001\u0007\u0011\u0011W\u0001\u0007S:\u0004X\u000f\u001e\u001a\t\u000f\t]$\b1\u0001\u00022\u00061\u0011N\u001c9viN\"b\"!\u0002\u0003|\tu$q\u0010BA\u0005\u0007\u0013)\tC\u0004\u0002pn\u0002\r!!=\t\rQ\\\u0004\u0019AA\u0003\u0011\u001998\b1\u0001\u0002\u0006!9\u0011\u0011H\u001eA\u0002\u0005\u0015\u0001b\u0002B\rw\u0001\u0007\u0011Q\u0001\u0005\b\u0005;Y\u0004\u0019AA\u0003\u0005Q!V-\u001c9pe\u0006d7+Z9vK:\u001cW-S7qYV!!1\u0012BQ'\u0015a\u0014\u0011\u0015B\u0015\u0003\t!G/A\u0003tG\u0006dW\rE\u0002m\u0005'K1A!&n\u0005\u0011auN\\4\u0002\u0011\u0019\u0014x.\u001c'p]\u001e\u0004r\u0001\u001cBN\u0005#\u0013y*C\u0002\u0003\u001e6\u0014\u0011BR;oGRLwN\\\u0019\u0011\t\t\u0005#\u0011\u0015\u0003\b\u0005\u000bb$\u0019\u0001B$\u0003\u0019QxN\\3JIB!!q\u0015BY\u001b\t\u0011IK\u0003\u0003\u0003,\n5\u0016\u0001\u0002;j[\u0016T!Aa,\u0002\t)\fg/Y\u0005\u0005\u0005g\u0013IK\u0001\u0004[_:,\u0017\nZ\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004C\u0002B\u001b\u0005w\u0011y\n\u0005\u0004\u0002H\tM#q\u0014\u000b\u000b\u0005{\u0013)Ma2\u0003J\n-GC\u0002B`\u0005\u0003\u0014\u0019\rE\u0003\u0002@r\u0012y\nC\u0004\u00036\u000e\u0003\u001dAa.\t\u000f\t=3\tq\u0001\u0003:\"9!QR\"A\u0002\t-\u0002b\u0002BH\u0007\u0002\u0007!\u0011\u0013\u0005\b\u0005/\u001b\u0005\u0019\u0001BM\u0011\u001d\u0011\u0019k\u0011a\u0001\u0005K\u000b!CY1dW\u0016$7+Z9vK:\u001cW-S7qYV\u0011!\u0011\u001b\t\u0006\u0003\u007f\u001b$qT\u0001\u0014E\u0006\u001c7.\u001a3TKF,XM\\2f\u00136\u0004H\u000eI\u0001\r[&\u001c'o\\:QKJ$\u0015-_\u000b\u0003\u0005#\u000bQ\"\\5de>\u001c\b+\u001a:ECf\u0004\u0013AD7jGJ|7\u000fU3s\u001b>tG\u000f[\u0001\u0010[&\u001c'o\\:QKJluN\u001c;iAQA!\u0011\u001dBr\u0005K\u00149\u000fE\u0003m\u0005S\u0012y\nC\u0004\u0003p1\u0003\r!!-\t\u000f\tMD\n1\u0001\u00022\"9!q\u000f'A\u0002\u0005EFCDA\u0003\u0005W\u0014iOa<\u0003r\nM(Q\u001f\u0005\b\u0003_l\u0005\u0019AAy\u0011\u0019!X\n1\u0001\u0002\u0006!1q/\u0014a\u0001\u0003\u000bAq!!\u000fN\u0001\u0004\t)\u0001C\u0004\u0003\u001a5\u0003\r!!\u0002\t\u000f\tuQ\n1\u0001\u0002\u0006\u0005\tr-\u001a;TKF,XM\\2f\u0019\u0016tw\r\u001e5\u0016\t\tm81\u0002\u000b\t\u0005{\u001cya!\u0005\u0004\u0014Q!!q`B\u0003!\ra7\u0011A\u0005\u0004\u0007\u0007i'aA%oi\"9!q\n(A\u0004\r\u001d\u0001CBA$\u0005'\u001aI\u0001\u0005\u0003\u0003B\r-AaBB\u0007\u001d\n\u0007!q\t\u0002\u0002+\"1AO\u0014a\u0001\u0007\u0013Aaa\u001e(A\u0002\r%\u0001bBA\u001d\u001d\u0002\u00071\u0011B\u0001\u0016O\u0016t7+Z9vK:\u001cW\rT3oORD7i\u001c3f)1\t)a!\u0007\u0004\u001c\ru1qDB\u0011\u0011\u001d\tyo\u0014a\u0001\u0003cDa\u0001^(A\u0002\u0005\u0015\u0001BB<P\u0001\u0004\t)\u0001C\u0004\u0002:=\u0003\r!!\u0002\t\u000f\r\rr\n1\u0001\u0002\u0006\u0005\u0019A.\u001a8\u0015\u0015\u0005\u00052qEB\u0015\u0007W\u0019i\u0003C\u0003u!\u0002\u0007A\rC\u0003x!\u0002\u0007A\rC\u0003z!\u0002\u00071\u0010\u0003\u0005\u0000!B\u0005\t\u0019AA\u0002\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"TCAB\u001aU\u0011\t\u0019a!\u000e,\u0005\r]\u0002\u0003BB\u001d\u0007\u0007j!aa\u000f\u000b\t\ru2qH\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0011n\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u000b\u001aYDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004L\rM\u0003\u0003\u00027}\u0007\u001b\u0002\u0002\u0002\\B(I\u0012\\\u00181A\u0005\u0004\u0007#j'A\u0002+va2,G\u0007C\u0005\u0004VI\u000b\t\u00111\u0001\u0002\"\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\ru\u0003\u0003BB0\u0007Kj!a!\u0019\u000b\t\r\r$QV\u0001\u0005Y\u0006tw-\u0003\u0003\u0004h\r\u0005$AB(cU\u0016\u001cG\u000fK\u0002\u0015\u0007W\u00022\u0001\\B7\u0013\r\u0019y'\u001c\u0002\niJ\fgn]5f]R$B!!-\u0004t!I1QO\u000b\u0011\u0002\u0003\u00071qO\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0007s\u001aY(D\u0001Y\u0013\r\u0019i\b\u0017\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR1\u0011\u0011]BB\u0007\u000bCq!a<\u0017\u0001\u0004\t\t\u0010C\u0004\u0004\bZ\u0001\r!!9\u0002\u0005\u00154\u0018\u0001B2paf$\"\"!\t\u0004\u000e\u000e=5\u0011SBJ\u0011\u001d!x\u0003%AA\u0002\u0011Dqa^\f\u0011\u0002\u0003\u0007A\rC\u0004z/A\u0005\t\u0019A>\t\u0011}<\u0002\u0013!a\u0001\u0003\u0007\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u001a*\u001aAm!\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCABQU\rY8QG\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111\u0011\u0016\t\u0005\u0007?\u001aY+\u0003\u0003\u0002\u0018\r\u0005\u0014\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0000\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!-\u00046\"I1q\u0017\u0010\u0002\u0002\u0003\u0007!q`\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\ru\u0006CBB`\u0007\u000b\f\t,\u0004\u0002\u0004B*\u001911Y7\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004H\u000e\u0005'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0017\u0004N\"I1q\u0017\u0011\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m31\u001b\u0005\n\u0007o\u000b\u0013\u0011!a\u0001\u0003cCs\u0003ABl\u0007;\u001cyna9\u0004f\u000e%81^Bx\u0007c\u001c)pa>\u0011\u0007\u0015\u001cI.C\u0002\u0004\\Z\u0013Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0004b\u0006!9H\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aH/\u0019:uY\u0001\u001aHo\u001c9-AM$X\r]\u0015![\u0001:UM\\3sCR,7\u000fI1oA\u0005\u0014(/Y=!_\u001a\u0004S\r\\3nK:$8\u000f\t4s_6\u00043\u000f^1si\u0002\"x\u000eI:u_B\u0004\u0003&\u001b8dYV\u001c\u0018N^3*Y)\u0001\u0003\u0005\t\u0011!A%t7M]3nK:$\u0018N\\4!Ef\u00043\u000f^3q]\u0001\"\u0006.\u001a\u0011usB,\u0007e\u001c4!i\",\u0007E]3ukJtW\r\u001a\u0011fY\u0016lWM\u001c;tA%\u001c\b\u0005\u001e5fAM\fW.\u001a\u0011bg\u0002\"\b.\u001a\u0011usB,\u0007e\u001c4!CJ<W/\\3oi*\u0001\u0003\u0005\t\u0011!A\u0015D\bO]3tg&|gn\u001d\u0018\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!'V\u0004\bo\u001c:uK\u0012\u0004C/\u001f9fg\u0002\n'/\u001a\u001e!Ef$X\r\f\u0011tQ>\u0014H\u000f\f\u0011j]R,w-\u001a:-A1|gn\u001a\u0017!I\u0006$X\r\f\u0011uS6,7\u000f^1na:R!\u0002\t\u0011!A\u0001\u0002C\u000b[3!gR\f'\u000f\u001e\u0011b]\u0012\u00043\u000f^8qA\u0015D\bO]3tg&|gn\u001d\u0011nkN$\bE]3t_24X\r\t;pAQDW\rI:b[\u0016\u0004C/\u001f9f])\u0001\u0003\u0005\t\u0011!A%3\u0007e\u001d;beR\u0004\u0013M\u001c3!gR|\u0007\u000fI3yaJ,7o]5p]N\u0004#/Z:pYZ,\u0007\u0005^8!i\",\u0007e\n3bi\u0016<\u0003e\u001c:!OQLW.Z:uC6\u0004x\u0005\t;za\u0016T\u0001\u0005\t\u0011!A\u0001\"\b.\u001a8!i\",\u0007e\u001d;fa\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011nkN$\bE]3t_24X\r\t;pAQDW\rI\u0014j]R,'O^1mO\u0001\"\u0018\u0010]3-A=$\b.\u001a:xSN,\u0007\u0005^8!i\",\u0007e]1nK\u0002\"\u0018\u0010]3\u000bA\u0001\u0002\u0003\u0005\t\u0011bg\u0002\"\b.\u001a\u0011ti\u0006\u0014H\u000fI1oI\u0002\u001aHo\u001c9!Kb\u0004(/Z:tS>t7O\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0007O\f1Q\u000f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$\u0018M\u001d;![\u0001\ng\u000eI3yaJ,7o]5p]:\u0002C\u000b[3!gR\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011sC:<WM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR|\u0007\u000fI\u0017!C:\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\rI3oI\u0002\"\b.\u001a\u0011sC:<W\r\t\u0015j]\u000edWo]5wK&r#\u0002\t\u0011!A\u0001\u0002#\u0006I:uKB\u0004S\u0006I1oA=\u0004H/[8oC2\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\rI:uKB\u0004sN\u001a\u0011uQ\u0016\u0004#/\u00198hK:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011Cs\u0002\"WMZ1vYR\u00043\u000f^3qA%\u001c\b%\r\u0011jM\u0002\u001aH/\u0019:uA%\u001c\b\u0005\\3tg\u0002\"\b.\u00198!_J\u0004S-];bY\u0002\"x\u000eI:u_Bd\u0003e\u001c;iKJ<\u0018n]3![Er#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\r>\u0014\b\u0005\u001e5fAQ,W\u000e]8sC2\u00043/Z9vK:\u001cWm\u001d\u0011ji\u001e\u001a\b%\r\u0011eCf\u0004\u0013M\u001c3![E\u0002C-Y=!e\u0016\u001c\b/Z2uSZ,G.\u001f\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013J\u001a\u0011ti\u0006\u0014H\u000fI5tA\u001d\u0014X-\u0019;fe\u0002\"\b.\u00198!gR|\u0007\u000f\t;iK:\u0004C\u000f[3!gR,\u0007\u000fI7vgR\u0004#-\u001a\u0011oK\u001e\fG/\u001b<fY\u0001\ng\u000e\u001a\u0011wS\u000e,\u0007E^3sg\u0006t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#a!<\u0002\u0003KT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0017!k%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-e1\u001aD\u0006\u000e\u00176;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS\u0007\f\u00112SmR\u0001\u0005\t\u0011!A\u0001\u00023,\u000e\u00175YMb#\u0007L\u0019^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\"xn\u00183bi\u0016DsE\r\u00192q5\u0002\u0014'\f\u00192O%b\u0003\u0005^8`I\u0006$X\rK\u00143aEBT\u0006M\u001a.aE:\u0013\u0006\f\u0011j]R,'O^1mAE\u0002Sn\u001c8uQ&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u001a1caj\u0003'M\u00171c1\u0012\u0004'\r\u001d.aIj\u0003'\r\u00173aEBT\u0006M\u001a.aEj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\rM\u0018aC1se\u0006LxLZ;oGN\fQa]5oG\u0016\f#a!?\u0002\u000bIrCG\f\u0019")
public class Sequence
extends Expression
implements TimeZoneAwareExpression,
scala.Serializable {
    private transient SequenceImpl impl;
    private final Expression start;
    private final Expression stop;
    private final Option<Expression> stepOpt;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return Sequence$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Option<Expression>, Option<String>>> unapply(Sequence sequence) {
        return Sequence$.MODULE$.unapply(sequence);
    }

    public static Option<String> apply$default$4() {
        return Sequence$.MODULE$.apply$default$4();
    }

    private boolean resolved$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression start() {
        return this.start;
    }

    public Expression stop() {
        return this.stop;
    }

    public Option<Expression> stepOpt() {
        return this.stepOpt;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Option<Expression> x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.start(), this.stop()}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.stepOpt()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToBoolean((boolean)x$62.foldable()));
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)x$63.nullable()));
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.start().dataType(), false);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType;
        boolean bl;
        boolean bl2;
        DataType startType = this.start().dataType();
        boolean typesCorrect = startType.sameType(this.stop().dataType()) && (bl2 = (bl = TimestampType$.MODULE$.equals(dataType = startType) ? true : DateType$.MODULE$.equals(dataType)) ? this.stepOpt().isEmpty() || CalendarIntervalType$.MODULE$.acceptsType(this.stepType$1()) : (dataType instanceof IntegralType ? this.stepOpt().isEmpty() || this.stepType$1().sameType(startType) : false));
        return typesCorrect ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(48).append(this.prettyName()).append(" only supports integral, timestamp or date types").toString());
    }

    public Seq<Expression> coercibleChildren() {
        return (Seq)this.children().filter((Function1 & Serializable & scala.Serializable)x$64 -> BoxesRunTime.boxToBoolean((boolean)Sequence.$anonfun$coercibleChildren$1(x$64)));
    }

    public Expression castChildrenTo(DataType widerType) {
        return new Sequence(new Cast(this.start(), widerType, Cast$.MODULE$.apply$default$3()), new Cast(this.stop(), widerType, Cast$.MODULE$.apply$default$3()), (Option<Expression>)this.stepOpt().map((Function1 & Serializable & scala.Serializable)step -> {
            DataType dataType = step.dataType();
            CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
            return (dataType == null ? calendarIntervalType$ != null : !dataType.equals(calendarIntervalType$)) ? new Cast((Expression)step, widerType, Cast$.MODULE$.apply$default$3()) : step;
        }), this.timeZoneId());
    }

    private SequenceImpl impl$lzycompute() {
        Sequence sequence = this;
        synchronized (sequence) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                SequenceImpl sequenceImpl;
                DataType dataType = this.dataType().elementType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    ClassTag ct = ClassTag$.MODULE$.apply((Class)((Mirrors.RuntimeMirror)integralType.tag().mirror()).runtimeClass(integralType.tag().tpe()));
                    sequenceImpl = new IntegralSequenceImpl<Object>(integralType, ct, integralType.integral());
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    sequenceImpl = new TemporalSequenceImpl(LongType$.MODULE$, 1L, (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x))), this.zoneId(), ClassTag$.MODULE$.Long(), Numeric.LongIsIntegral$.MODULE$);
                } else if (DateType$.MODULE$.equals(dataType)) {
                    sequenceImpl = new TemporalSequenceImpl(IntegerType$.MODULE$, 86400000000L, (JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$65 -> (int)x$65, this.zoneId(), ClassTag$.MODULE$.Int(), Numeric.IntIsIntegral$.MODULE$);
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.impl = sequenceImpl;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.impl;
    }

    private SequenceImpl impl() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.impl$lzycompute() : this.impl;
    }

    @Override
    public Object eval(InternalRow input) {
        Object startVal = this.start().eval(input);
        if (startVal == null) {
            return null;
        }
        Object stopVal = this.stop().eval(input);
        if (stopVal == null) {
            return null;
        }
        Object stepVal = this.stepOpt().map((Function1 & Serializable & scala.Serializable)x$66 -> x$66.eval(input)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.impl().defaultStep().apply(startVal, stopVal));
        if (stepVal == null) {
            return null;
        }
        return ArrayData$.MODULE$.toArrayData(this.impl().eval(startVal, stopVal, stepVal));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        ExprCode startGen = this.start().genCode(ctx);
        ExprCode stopGen = this.stop().genCode(ctx);
        ExprCode stepGen = (ExprCode)this.stepOpt().map((Function1 & Serializable & scala.Serializable)x$67 -> x$67.genCode(ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.impl().defaultStep().genCode(ctx, startGen, stopGen));
        String resultType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String arr = ctx.freshName("arr");
        String arrElemType = CodeGenerator$.MODULE$.javaType(this.dataType().elementType());
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n         |final ").append(arrElemType).append("[] ").append(arr).append(" = null;\n         |").append(this.impl().genCode(ctx, ExprValue$.MODULE$.exprValueToString(startGen.value()), ExprValue$.MODULE$.exprValueToString(stopGen.value()), ExprValue$.MODULE$.exprValueToString(stepGen.value()), arr, arrElemType)).append("\n         |").append(ev.value()).append(" = UnsafeArrayData.fromPrimitiveArray(").append(arr).append(");\n       ").toString())).stripMargin();
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)startGen.code()), ctx.nullSafeExec(this.start().nullable(), ExprValue$.MODULE$.exprValueToString(startGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stopGen.code()), ctx.nullSafeExec(this.stop().nullable(), ExprValue$.MODULE$.exprValueToString(stopGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)stepGen.code()), ctx.nullSafeExec(this.stepOpt().exists((Function1 & Serializable & scala.Serializable)x$68 -> BoxesRunTime.boxToBoolean((boolean)x$68.nullable())), ExprValue$.MODULE$.exprValueToString(stepGen.isNull()), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n                 |").append(ev.isNull()).append(" = false;\n                 |").append(resultCode).append("\n               ").toString())).stripMargin()))))));
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), resultType, ev.value(), nullSafeEval})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
        } else {
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", "\n           |", "\n           |", " ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startGen.code(), stopGen.code(), stepGen.code(), resultType, ev.value(), resultCode})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        return exprCode;
    }

    public Sequence copy(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        return new Sequence(start, stop, stepOpt, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.start();
    }

    public Expression copy$default$2() {
        return this.stop();
    }

    public Option<Expression> copy$default$3() {
        return this.stepOpt();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Sequence";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.start();
                break;
            }
            case 1: {
                object = this.stop();
                break;
            }
            case 2: {
                object = this.stepOpt();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sequence)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sequence sequence = (Sequence)x$1;
        Expression expression = this.start();
        Expression expression2 = sequence.start();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.stop();
        Expression expression4 = sequence.stop();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.stepOpt();
        Option<Expression> option2 = sequence.stepOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = sequence.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!sequence.canEqual(this)) return false;
        return true;
    }

    private final DataType stepType$1() {
        return ((Expression)this.stepOpt().get()).dataType();
    }

    public static final /* synthetic */ boolean $anonfun$coercibleChildren$1(Expression x$64) {
        DataType dataType = x$64.dataType();
        CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
        return dataType == null ? calendarIntervalType$ != null : !dataType.equals(calendarIntervalType$);
    }

    public Sequence(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        this.start = start;
        this.stop = stop;
        this.stepOpt = stepOpt;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
    }

    public Sequence(Expression start, Expression stop) {
        this(start, stop, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Sequence(Expression start, Expression stop, Expression step) {
        this(start, stop, (Option<Expression>)new Some((Object)step), (Option<String>)None$.MODULE$);
    }

    public static class DefaultStep {
        private final Function2<Object, Object, Object> lteq;
        private final DataType stepType;
        private final Object one;
        private final Object negativeOne;

        private Object negativeOne() {
            return this.negativeOne;
        }

        public Object apply(Object start, Object stop) {
            return BoxesRunTime.unboxToBoolean((Object)this.lteq.apply(start, stop)) ? this.one : this.negativeOne();
        }

        public ExprCode genCode(CodegenContext ctx, ExprCode startGen, ExprCode stopGen) {
            Seq seq = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.one, this.negativeOne()}))).map((Function1 & Serializable & scala.Serializable)x$69 -> Literal$.MODULE$.apply(x$69).genCode(ctx).value(), Seq$.MODULE$.canBuildFrom());
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            ExprValue oneVal = (ExprValue)((SeqLike)some.get()).apply(0);
            ExprValue negativeOneVal = (ExprValue)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)oneVal, (Object)negativeOneVal);
            Tuple2 tuple22 = tuple2;
            ExprValue oneVal2 = (ExprValue)tuple22._1();
            ExprValue negativeOneVal2 = (ExprValue)tuple22._2();
            return ExprCode$.MODULE$.forNonNullValue(JavaCode$.MODULE$.expression(new StringBuilder(10).append(startGen.value()).append(" <= ").append(stopGen.value()).append(" ? ").append(oneVal2).append(" : ").append(negativeOneVal2).toString(), this.stepType));
        }

        public DefaultStep(Function2<Object, Object, Object> lteq, DataType stepType, Object one) {
            this.lteq = lteq;
            this.stepType = stepType;
            this.one = one;
            UnaryMinus qual$1 = new UnaryMinus(Literal$.MODULE$.apply(one), UnaryMinus$.MODULE$.apply$default$2());
            InternalRow x$1 = qual$1.eval$default$1();
            this.negativeOne = qual$1.eval(x$1);
        }
    }

    public static class IntegralSequenceImpl<T>
    implements SequenceImpl {
        private final IntegralType elemType;
        private final ClassTag<T> evidence$1;
        private final Integral<T> num;
        private final DefaultStep defaultStep;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object start = input1;
            Object stop = input2;
            Object step = input3;
            int i = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(start, stop, step, this.num);
            Object arr = this.evidence$1.newArray(i);
            while (i > 0) {
                ScalaRunTime$.MODULE$.array_update(arr, --i, this.num.mkNumericOps(start).$plus(this.num.mkNumericOps(step).$times(this.num.fromInt(i))));
            }
            return arr;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String i = ctx.freshName("i");
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n         |").append(Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, start, stop, step, i)).append("\n         |").append(arr).append(" = new ").append(elemType).append("[").append(i).append("];\n         |while (").append(i).append(" > 0) {\n         |  ").append(i).append("--;\n         |  ").append(arr).append("[").append(i).append("] = (").append(elemType).append(") (").append(start).append(" + ").append(step).append(" * ").append(i).append(");\n         |}\n         ").toString())).stripMargin();
        }

        public static final /* synthetic */ boolean $anonfun$defaultStep$1(IntegralSequenceImpl $this, Object x, Object y) {
            return $this.elemType.ordering().lteq(x, y);
        }

        public IntegralSequenceImpl(IntegralType elemType, ClassTag<T> evidence$1, Integral<T> num) {
            this.elemType = elemType;
            this.evidence$1 = evidence$1;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)IntegralSequenceImpl.$anonfun$defaultStep$1(this, x, y)), elemType, num.one());
        }
    }

    public static interface SequenceImpl {
        public Object eval(Object var1, Object var2, Object var3);

        public String genCode(CodegenContext var1, String var2, String var3, String var4, String var5, String var6);

        public DefaultStep defaultStep();
    }

    public static class TemporalSequenceImpl<T>
    implements SequenceImpl {
        private final IntegralType dt;
        private final long scale;
        private final Function1<Object, T> fromLong;
        private final ZoneId zoneId;
        private final ClassTag<T> evidence$2;
        private final Integral<T> num;
        private final DefaultStep defaultStep;
        private final IntegralSequenceImpl<T> backedSequenceImpl;
        private final long microsPerDay;
        private final long microsPerMonth;

        @Override
        public DefaultStep defaultStep() {
            return this.defaultStep;
        }

        private IntegralSequenceImpl<T> backedSequenceImpl() {
            return this.backedSequenceImpl;
        }

        private long microsPerDay() {
            return this.microsPerDay;
        }

        private long microsPerMonth() {
            return this.microsPerMonth;
        }

        @Override
        public Object eval(Object input1, Object input2, Object input3) {
            Object object;
            Object start = input1;
            Object stop = input2;
            CalendarInterval step = (CalendarInterval)input3;
            int stepMonths = step.months;
            int stepDays = step.days;
            long stepMicros = step.microseconds;
            if (this.scale == 86400000000L && stepMonths == 0 && stepDays == 0) {
                throw new IllegalArgumentException("sequence step must be a day interval if start and end values are dates");
            }
            if (stepMonths == 0 && stepMicros == 0L && this.scale == 86400000000L) {
                object = this.backedSequenceImpl().eval(start, stop, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)stepDays)));
            } else if (stepMonths == 0 && stepDays == 0 && this.scale == 1L) {
                object = this.backedSequenceImpl().eval(start, stop, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)stepMicros)));
            } else {
                long intervalStepInMicros = stepMicros + (long)stepMonths * this.microsPerMonth() + (long)stepDays * this.microsPerDay();
                long startMicros = this.num.toLong(start) * this.scale;
                long stopMicros = this.num.toLong(stop) * this.scale;
                int maxEstimatedArrayLength = Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(BoxesRunTime.boxToLong((long)startMicros), BoxesRunTime.boxToLong((long)stopMicros), BoxesRunTime.boxToLong((long)intervalStepInMicros), Numeric.LongIsIntegral$.MODULE$);
                int stepSign = stopMicros >= startMicros ? 1 : -1;
                long exclusiveItem = stopMicros + (long)stepSign;
                Object arr = this.evidence$2.newArray(maxEstimatedArrayLength);
                long t = startMicros;
                int i = 0;
                while (t < exclusiveItem ^ stepSign < 0) {
                    ScalaRunTime$.MODULE$.array_update(arr, i, this.fromLong.apply((Object)BoxesRunTime.boxToLong((long)(t / this.scale))));
                    t = DateTimeUtils$.MODULE$.timestampAddInterval(startMicros, ++i * stepMonths, i * stepDays, (long)i * stepMicros, this.zoneId);
                }
                object = ScalaRunTime$.MODULE$.array_length(arr) == i ? arr : Predef$.MODULE$.genericArrayOps(arr).slice(0, i);
            }
            return object;
        }

        @Override
        public String genCode(CodegenContext ctx, String start, String stop, String step, String arr, String elemType) {
            String stepMonths = ctx.freshName("stepMonths");
            String stepDays = ctx.freshName("stepDays");
            String stepMicros = ctx.freshName("stepMicros");
            String stepScaled = ctx.freshName("stepScaled");
            String intervalInMicros = ctx.freshName("intervalInMicros");
            String startMicros = ctx.freshName("startMicros");
            String stopMicros = ctx.freshName("stopMicros");
            String arrLength = ctx.freshName("arrLength");
            String stepSign = ctx.freshName("stepSign");
            String exclusiveItem = ctx.freshName("exclusiveItem");
            String t = ctx.freshName("t");
            String i = ctx.freshName("i");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId, ZoneId.class.getName());
            String sequenceLengthCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n           |final long ").append(intervalInMicros).append(" =\n           |  ").append(stepMicros).append(" + ").append(stepMonths).append(" * ").append(this.microsPerMonth()).append("L + ").append(stepDays).append(" * ").append(this.microsPerDay()).append("L;\n           |").append(Sequence$.MODULE$.org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(ctx, startMicros, stopMicros, intervalInMicros, arrLength)).append("\n          ").toString())).stripMargin();
            String check = this.scale == 86400000000L ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(200).append("\n           |if (").append(stepMonths).append(" == 0 && ").append(stepDays).append(" == 0) {\n           |  throw new IllegalArgumentException(\n           |    \"sequence step must be a day interval if start and end values are dates\");\n           |}\n          ").toString())).stripMargin() : "";
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(889).append("\n         |final int ").append(stepMonths).append(" = ").append(step).append(".months;\n         |final int ").append(stepDays).append(" = ").append(step).append(".days;\n         |final long ").append(stepMicros).append(" = ").append(step).append(".microseconds;\n         |\n         |").append(check).append("\n         |\n         |if (").append(stepMonths).append(" == 0 && ").append(stepMicros).append(" == 0 && ").append(this.scale).append("L == ").append(86400000000L).append("L) {\n         |  ").append(this.backedSequenceImpl().genCode(ctx, start, stop, stepDays, arr, elemType)).append(";\n         |\n         |} else if (").append(stepMonths).append(" == 0 && ").append(stepDays).append(" == 0 && ").append(this.scale).append("L == 1) {\n         |  ").append(this.backedSequenceImpl().genCode(ctx, start, stop, stepMicros, arr, elemType)).append(";\n         |} else {\n         |  final long ").append(startMicros).append(" = ").append(start).append(" * ").append(this.scale).append("L;\n         |  final long ").append(stopMicros).append(" = ").append(stop).append(" * ").append(this.scale).append("L;\n         |\n         |  ").append(sequenceLengthCode).append("\n         |\n         |  final int ").append(stepSign).append(" = ").append(stopMicros).append(" >= ").append(startMicros).append(" ? +1 : -1;\n         |  final long ").append(exclusiveItem).append(" = ").append(stopMicros).append(" + ").append(stepSign).append(";\n         |\n         |  ").append(arr).append(" = new ").append(elemType).append("[").append(arrLength).append("];\n         |  long ").append(t).append(" = ").append(startMicros).append(";\n         |  int ").append(i).append(" = 0;\n         |\n         |  while (").append(t).append(" < ").append(exclusiveItem).append(" ^ ").append(stepSign).append(" < 0) {\n         |    ").append(arr).append("[").append(i).append("] = (").append(elemType).append(") (").append(t).append(" / ").append(this.scale).append("L);\n         |    ").append(i).append(" += 1;\n         |    ").append(t).append(" = org.apache.spark.sql.catalyst.util.DateTimeUtils.timestampAddInterval(\n         |       ").append(startMicros).append(", ").append(i).append(" * ").append(stepMonths).append(", ").append(i).append(" * ").append(stepDays).append(", ").append(i).append(" * ").append(stepMicros).append(", ").append(zid).append(");\n         |  }\n         |\n         |  if (").append(arr).append(".length > ").append(i).append(") {\n         |    ").append(arr).append(" = java.util.Arrays.copyOf(").append(arr).append(", ").append(i).append(");\n         |  }\n         |}\n         ").toString())).stripMargin();
        }

        public static final /* synthetic */ boolean $anonfun$defaultStep$2(TemporalSequenceImpl $this, Object x, Object y) {
            return $this.dt.ordering().lteq(x, y);
        }

        public TemporalSequenceImpl(IntegralType dt, long scale, Function1<Object, T> fromLong, ZoneId zoneId, ClassTag<T> evidence$2, Integral<T> num) {
            this.dt = dt;
            this.scale = scale;
            this.fromLong = fromLong;
            this.zoneId = zoneId;
            this.evidence$2 = evidence$2;
            this.num = num;
            this.defaultStep = new DefaultStep((Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)TemporalSequenceImpl.$anonfun$defaultStep$2(this, x, y)), CalendarIntervalType$.MODULE$, new CalendarInterval(0, 1, 0L));
            this.backedSequenceImpl = new IntegralSequenceImpl<T>(dt, evidence$2, num);
            this.microsPerDay = 86400000000L;
            this.microsPerMonth = 28L * this.microsPerDay();
        }
    }
}

