/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp, rep[, position]) - Replaces all substrings of `str` that match `regexp` with `rep`.", arguments="\n    Arguments:\n      * str - a string expression to search for a regular expression pattern match.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.\n\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".\n\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * rep - a string expression to replace matched substrings.\n      * position - a positive integer literal that indicates the position within `str` to begin searching.\n          The default is 1. If position is greater than the number of characters in `str`, the result is `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)', 'num');\n       num-num\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u00193\u0001~B\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0012)A\u00053\"AQ\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005_\u0001\tE\t\u0015!\u0003Z\u0011!y\u0006A!f\u0001\n\u0003A\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B-\t\u0011\u0005\u0004!Q3A\u0005\u0002aC\u0001B\u0019\u0001\u0003\u0012\u0003\u0006I!\u0017\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006G\u0002!\tA\u001b\u0005\u0006]\u0002!\te\u001c\u0005\nm\u0002\u0001\r\u00111A\u0005\n]D1\"!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0004!Q\u0011q\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u0002=\t\u0017\u0005e\u0001\u00011AA\u0002\u0013%\u00111\u0004\u0005\f\u0003c\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0004C\u0006\u00028\u0001\u0001\r\u0011!Q!\n\u0005u\u0001bCA\u001e\u0001\u0001\u0007\t\u0019!C\u0005\u0003{A1\"!\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002X!Y\u00111\f\u0001A\u0002\u0003\u0005\u000b\u0015BA \u0011)\ty\u0006\u0001a\u0001\u0002\u0004%Ia\u001e\u0005\f\u0003C\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0007\u0003\u0006\u0002h\u0001\u0001\r\u0011!Q!\naD!\"a\u001b\u0001\u0011\u000b\u0007I\u0011BA7\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!a&\u0001\t\u0003\nI\nC\u0004\u0002&\u0002!\t%a*\t\u000f\u0005}\u0006\u0001\"\u0011\u0002B\"9\u0011Q\u0019\u0001\u0005B\u0005u\u0002bBAd\u0001\u0011E\u0013\u0011\u001a\u0005\n\u0003K\u0004\u0011\u0011!C\u0001\u0003OD\u0011\"!=\u0001#\u0003%\t!a=\t\u0013\t%\u0001!%A\u0005\u0002\u0005M\b\"\u0003B\u0006\u0001E\u0005I\u0011AAz\u0011%\u0011i\u0001AI\u0001\n\u0003\t\u0019\u0010C\u0005\u0003\u0010\u0001\t\t\u0011\"\u0011\u0003\u0012!I!q\u0003\u0001\u0002\u0002\u0013\u0005!\u0011\u0004\u0005\n\u0005C\u0001\u0011\u0011!C\u0001\u0005GA\u0011Ba\n\u0001\u0003\u0003%\tE!\u000b\t\u0013\t]\u0002!!A\u0005\u0002\te\u0002\"\u0003B\"\u0001\u0005\u0005I\u0011\tB#\u000f\u001d\u0011IG\rE\u0001\u0005W2a!\r\u001a\t\u0002\t5\u0004BB2,\t\u0003\u0011)\bC\u0004\u0003x-\"\tA!\u001f\t\u0013\t]4&!A\u0005\u0002\n\u0005\u0005\"\u0003BFW\u0005\u0005I\u0011\u0011BG\u0011%\u0011yjKA\u0001\n\u0013\u0011\tKA\u0007SK\u001e,\u0005\u0010\u001d*fa2\f7-\u001a\u0006\u0003gQ\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QGN\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0007O\u0001\u0004gFd'BA\u001d;\u0003\u0015\u0019\b/\u0019:l\u0015\tYD(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\u0011#H\u001dR\u0003\"!\u0011\"\u000e\u0003IJ!a\u0011\u001a\u0003)E+\u0018\r^3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tU)\u0003\u0002Ge\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002I\u0017:\u0011\u0011)S\u0005\u0003\u0015J\nq\u0001]1dW\u0006<W-\u0003\u0002M\u001b\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001&3!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u001d\u0001&o\u001c3vGR\u0004\"aT+\n\u0005Y\u0003&\u0001D*fe&\fG.\u001b>bE2,\u0017aB:vE*,7\r^\u000b\u00023B\u0011\u0011IW\u0005\u00037J\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003!\u0019XO\u00196fGR\u0004\u0013A\u0002:fO\u0016D\b/A\u0004sK\u001e,\u0007\u0010\u001d\u0011\u0002\u0007I,\u0007/\u0001\u0003sKB\u0004\u0013a\u00019pg\u0006!\u0001o\\:!\u0003\u0019a\u0014N\\5u}Q)QMZ4iSB\u0011\u0011\t\u0001\u0005\u0006/&\u0001\r!\u0017\u0005\u0006;&\u0001\r!\u0017\u0005\u0006?&\u0001\r!\u0017\u0005\u0006C&\u0001\r!\u0017\u000b\u0005K.dW\u000eC\u0003X\u0015\u0001\u0007\u0011\fC\u0003^\u0015\u0001\u0007\u0011\fC\u0003`\u0015\u0001\u0007\u0011,A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001q!\t\tH/D\u0001s\u0015\t\u0019H'\u0001\u0005b]\u0006d\u0017p]5t\u0013\t)(OA\bUsB,7\t[3dWJ+7/\u001e7u\u0003%a\u0017m\u001d;SK\u001e,\u00070F\u0001y!\tIh0D\u0001{\u0015\tYH0A\u0003usB,7O\u0003\u0002~q\u00051QO\\:bM\u0016L!a >\u0003\u0015U#f\tO*ue&tw-A\u0007mCN$(+Z4fq~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u0002P\u0003\u000fI1!!\u0003Q\u0005\u0011)f.\u001b;\t\u0011\u00055Q\"!AA\u0002a\f1\u0001\u001f\u00132\u0003)a\u0017m\u001d;SK\u001e,\u0007\u0010\t\u0015\u0004\u001d\u0005M\u0001cA(\u0002\u0016%\u0019\u0011q\u0003)\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00029biR,'O\\\u000b\u0003\u0003;\u0001B!a\b\u0002.5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0003sK\u001e,\u0007P\u0003\u0003\u0002(\u0005%\u0012\u0001B;uS2T!!a\u000b\u0002\t)\fg/Y\u0005\u0005\u0003_\t\tCA\u0004QCR$XM\u001d8\u0002\u0017A\fG\u000f^3s]~#S-\u001d\u000b\u0005\u0003\u000b\t)\u0004C\u0005\u0002\u000eA\t\t\u00111\u0001\u0002\u001e\u0005A\u0001/\u0019;uKJt\u0007\u0005K\u0002\u0012\u0003'\tq\u0002\\1tiJ+\u0007\u000f\\1dK6,g\u000e^\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002P9!\u00111IA&!\r\t)\u0005U\u0007\u0003\u0003\u000fR1!!\u0013?\u0003\u0019a$o\\8u}%\u0019\u0011Q\n)\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t&a\u0015\u0003\rM#(/\u001b8h\u0015\r\ti\u0005U\u0001\u0014Y\u0006\u001cHOU3qY\u0006\u001cW-\\3oi~#S-\u001d\u000b\u0005\u0003\u000b\tI\u0006C\u0005\u0002\u000eM\t\t\u00111\u0001\u0002@\u0005\u0001B.Y:u%\u0016\u0004H.Y2f[\u0016tG\u000f\t\u0015\u0004)\u0005M\u0011!\u00067bgR\u0014V\r\u001d7bG\u0016lWM\u001c;J]V#f\tO\u0001\u001aY\u0006\u001cHOU3qY\u0006\u001cW-\\3oi&sW\u000b\u0016$9?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005\u0015\u0004\u0002CA\u0007-\u0005\u0005\t\u0019\u0001=\u0002-1\f7\u000f\u001e*fa2\f7-Z7f]RLe.\u0016+Gq\u0001B3aFA\n\u0003\u0019\u0011Xm];miV\u0011\u0011q\u000e\t\u0005\u0003c\n9(\u0004\u0002\u0002t)!\u0011QOA\u0015\u0003\u0011a\u0017M\\4\n\t\u0005e\u00141\u000f\u0002\r'R\u0014\u0018N\\4Ck\u001a4WM\u001d\u0015\u00041\u0005M\u0011\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCCAA\u0003\u000f\u000bY)a$\u0002\u0014B\u0019q*a!\n\u0007\u0005\u0015\u0005KA\u0002B]fDq!!#\u001a\u0001\u0004\t\t)A\u0001t\u0011\u001d\ti)\u0007a\u0001\u0003\u0003\u000b\u0011\u0001\u001d\u0005\b\u0003#K\u0002\u0019AAA\u0003\u0005\u0011\bbBAK3\u0001\u0007\u0011\u0011Q\u0001\u0002S\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u001cB!\u0011QTAQ\u001b\t\tyJ\u0003\u0002|m%!\u00111UAP\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\u0011\u0011\u0011\u0016\t\u0007\u0003W\u000b\u0019,!/\u000f\t\u00055\u0016\u0011\u0017\b\u0005\u0003\u000b\ny+C\u0001R\u0013\tQ\u0005+\u0003\u0003\u00026\u0006]&aA*fc*\u0011!\n\u0015\t\u0005\u0003;\u000bY,\u0003\u0003\u0002>\u0006}%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!\u0019\u0007.\u001b7ee\u0016tWCAAb!\u0015\tY+a-Z\u0003)\u0001(/\u001a;us:\u000bW.Z\u0001\nI><UM\\\"pI\u0016$b!a3\u0002X\u0006\u0005\b\u0003BAg\u0003'l!!a4\u000b\u0007\u0005E''A\u0004d_\u0012,w-\u001a8\n\t\u0005U\u0017q\u001a\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011\u001c\u0010A\u0002\u0005m\u0017aA2uqB!\u0011QZAo\u0013\u0011\ty.a4\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111\u001d\u0010A\u0002\u0005-\u0017AA3w\u0003\u0011\u0019w\u000e]=\u0015\u0013\u0015\fI/a;\u0002n\u0006=\bbB, !\u0003\u0005\r!\u0017\u0005\b;~\u0001\n\u00111\u0001Z\u0011\u001dyv\u0004%AA\u0002eCq!Y\u0010\u0011\u0002\u0003\u0007\u0011,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U(fA-\u0002x.\u0012\u0011\u0011 \t\u0005\u0003w\u0014)!\u0004\u0002\u0002~*!\u0011q B\u0001\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0004A\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119!!@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0014A!\u0011\u0011\u000fB\u000b\u0013\u0011\t\t&a\u001d\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tm\u0001cA(\u0003\u001e%\u0019!q\u0004)\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005%Q\u0005\u0005\n\u0003\u001b1\u0013\u0011!a\u0001\u00057\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005W\u0001bA!\f\u00034\u0005\u0005UB\u0001B\u0018\u0015\r\u0011\t\u0004U\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u001b\u0005_\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\bB!!\ry%QH\u0005\u0004\u0005\u007f\u0001&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u001bA\u0013\u0011!a\u0001\u0003\u0003\u000ba!Z9vC2\u001cH\u0003\u0002B\u001e\u0005\u000fB\u0011\"!\u0004*\u0003\u0003\u0005\r!!!)'\u0001\u0011YE!\u0015\u0003T\t]#\u0011\fB/\u0005?\u0012\u0019G!\u001a\u0011\u0007\u0005\u0013i%C\u0002\u0003PI\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003V\u00059wLR+O\u0007~C3\u000f\u001e:-AI,w-\u001a=qY\u0001\u0012X\r].-AA|7/\u001b;j_:l\u0016\u0006I\u0017!%\u0016\u0004H.Y2fg\u0002\nG\u000e\u001c\u0011tk\n\u001cHO]5oON\u0004sN\u001a\u0011agR\u0014\b\r\t;iCR\u0004S.\u0019;dQ\u0002\u0002'/Z4fqB\u0004\u0007e^5uQ\u0002\u0002'/\u001a9a]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u00057\nqq\u0017\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011u_\u0002\u001aX-\u0019:dQ\u00022wN\u001d\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011qCR$XM\u001d8![\u0006$8\r\u001b\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AI,w-\u001a=qA5\u0002\u0013\rI:ue&tw\r\t:faJ,7/\u001a8uS:<\u0007%\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>tg\u0006\t+iK\u0002\u0012XmZ3yAM$(/\u001b8hAMDw.\u001e7eA\t,\u0007%\u0019\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001R\u0015M^1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gN\f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023+\u001b8dK\u0002\u001a\u0006/\u0019:lAIr\u0003\u0007\f\u0011tiJLgn\u001a\u0011mSR,'/\u00197tA!Jgn\u00197vI&tw\r\t:fO\u0016D\b\u0005]1ui\u0016\u0014hn]\u0015!CJ,\u0007%\u001e8fg\u000e\f\u0007/\u001a3!S:\u0004s.\u001e:!'Fc%\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148/\u001a:/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!i>\u0004S.\u0019;dQ\u0002\u0012C,\u00192dE1\u0002\u0013\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:\u0004cm\u001c:!AJ,w-\u001a=qA\u0002\u001a\u0017M\u001c\u0011cK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0012_9r\u000b'm\u0019\u0013#])Q\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0014X\rI5tA\u0005\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011uQ\u0006$\beY1oA\t,\u0007%^:fI\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fG\u000e\u001c2bG.\u0004Co\u001c\u0011uQ\u0016\u00043\u000b]1sW\u0002\ndF\u000e\u0011cK\"\fg/[8sAI,w-\u0019:eS:<\u0007e\u001d;sS:<\u0007\u0005\\5uKJ\fG\u000e\t9beNLgn\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001Jg\r\t;iK\u0002\u001awN\u001c4jO\u0002J7\u000fI3oC\ndW\r\u001a\u0017!i\",\u0007\u0005\u0019:fO\u0016D\b\u000f\u0019\u0011uQ\u0006$\beY1oA5\fGo\u00195!Eq\u000b'm\u0019\u0012!SN\u0004#E\u0018/bE\u000e$#E\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!e\u0016\u0004\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|g\u000e\t;pAI,\u0007\u000f\\1dK\u0002j\u0017\r^2iK\u0012\u00043/\u001e2tiJLgnZ:/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u0002xn]5uS>t\u0007%\f\u0011bAA|7/\u001b;jm\u0016\u0004\u0013N\u001c;fO\u0016\u0014\b\u0005\\5uKJ\fG\u000e\t;iCR\u0004\u0013N\u001c3jG\u0006$Xm\u001d\u0011uQ\u0016\u0004\u0003o\\:ji&|g\u000eI<ji\"Lg\u000e\t1tiJ\u0004\u0007\u0005^8!E\u0016<\u0017N\u001c\u0011tK\u0006\u00148\r[5oO:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004C-\u001a4bk2$\b%[:!c9\u0002\u0013J\u001a\u0011q_NLG/[8oA%\u001c\be\u001a:fCR,'\u000f\t;iC:\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u00043\r[1sC\u000e$XM]:!S:\u0004\u0003m\u001d;sA2\u0002C\u000f[3!e\u0016\u001cX\u000f\u001c;!SN\u0004\u0003m\u001d;sA:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!\u0011M\u0001T\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013\u0007\r\u0019.eA\u0002t\u0005\f\u0011(QqcFmK\u0015(Y\u0001:c.^7(SmR\u0001\u0005\t\u0011!A\u0001\u0002c.^7.]Vl'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t\u001d\u0014!B\u0019/k9\u0002\u0014!\u0004*fO\u0016C\bOU3qY\u0006\u001cW\r\u0005\u0002BWM!1Fa\u001cU!\ry%\u0011O\u0005\u0004\u0005g\u0002&AB!osJ+g\r\u0006\u0002\u0003l\u0005)\u0011\r\u001d9msR9QMa\u001f\u0003~\t}\u0004\"B,.\u0001\u0004I\u0006\"B/.\u0001\u0004I\u0006\"B0.\u0001\u0004IF#C3\u0003\u0004\n\u0015%q\u0011BE\u0011\u00159f\u00061\u0001Z\u0011\u0015if\u00061\u0001Z\u0011\u0015yf\u00061\u0001Z\u0011\u0015\tg\u00061\u0001Z\u0003\u001d)h.\u00199qYf$BAa$\u0003\u001cB)qJ!%\u0003\u0016&\u0019!1\u0013)\u0003\r=\u0003H/[8o!\u001dy%qS-Z3fK1A!'Q\u0005\u0019!V\u000f\u001d7fi!A!QT\u0018\u0002\u0002\u0003\u0007Q-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u0015\t\u0005\u0003c\u0012)+\u0003\u0003\u0003(\u0006M$AB(cU\u0016\u001cG\u000f")
public class RegExpReplace
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient StringBuffer result;
    private final Expression subject;
    private final Expression regexp;
    private final Expression rep;
    private final Expression pos;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;
    private transient String lastReplacement;
    private transient UTF8String lastReplacementInUTF8;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(RegExpReplace regExpReplace) {
        return RegExpReplace$.MODULE$.unapply(regExpReplace);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression rep() {
        return this.rep;
    }

    public Expression pos() {
        return this.pos;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.pos().foldable()) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("Position expression must be foldable, but got ").append(this.pos()).toString());
        }
        Object posEval = this.pos().eval(this.pos().eval$default$1());
        return posEval == null || BoxesRunTime.unboxToInt((Object)posEval) > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(47).append("Position expression must be positive, but got: ").append(posEval).toString());
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    private String lastReplacement() {
        return this.lastReplacement;
    }

    private void lastReplacement_$eq(String x$1) {
        this.lastReplacement = x$1;
    }

    private UTF8String lastReplacementInUTF8() {
        return this.lastReplacementInUTF8;
    }

    private void lastReplacementInUTF8_$eq(UTF8String x$1) {
        this.lastReplacementInUTF8 = x$1;
    }

    private StringBuffer result$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$trans$0) {
                this.result = new StringBuffer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.result;
    }

    private StringBuffer result() {
        return !this.bitmap$trans$0 ? this.result$lzycompute() : this.result;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r, Object i) {
        Object object;
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        if (!r.equals(this.lastReplacementInUTF8())) {
            this.lastReplacementInUTF8_$eq(((UTF8String)r).clone());
            this.lastReplacement_$eq(this.lastReplacementInUTF8().toString());
        }
        String source = s.toString();
        int position = BoxesRunTime.unboxToInt((Object)i) - 1;
        if (position < source.length()) {
            Matcher m = this.pattern().matcher(source);
            m.region(position, source.length());
            this.result().delete(0, this.result().length());
            while (m.find()) {
                m.appendReplacement(this.result(), this.lastReplacement());
            }
            m.appendTail(this.result());
            object = UTF8String.fromString((String)this.result().toString());
        } else {
            object = s;
        }
        return object;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.subject();
        Expression expression2 = this.regexp();
        Expression expression3 = this.rep();
        Expression expression4 = this.pos();
        return Nil$.MODULE$.$colon$colon((Object)expression4).$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "regexp_replace";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termResult = ctx.freshName("termResult");
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameStringBuffer = StringBuffer.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String source = ctx.freshName("source");
        String position = ctx.freshName("position");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacement = ctx.addMutableState("String", "lastReplacement", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacementInUTF8 = ctx.addMutableState("UTF8String", "lastReplacementInUTF8", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable & scala.Serializable)(subject, regexp, rep, pos) -> new StringBuilder(610).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      if (!").append((String)rep).append(".equals(").append(termLastReplacementInUTF8).append(")) {\n        // replacement string changed\n        ").append(termLastReplacementInUTF8).append(" = ").append((String)rep).append(".clone();\n        ").append(termLastReplacement).append(" = ").append(termLastReplacementInUTF8).append(".toString();\n      }\n      String ").append(source).append(" = ").append((String)subject).append(".toString();\n      int ").append(position).append(" = ").append((String)pos).append(" - 1;\n      if (").append(position).append(" < ").append(source).append(".length()) {\n        ").append(classNameStringBuffer).append(" ").append(termResult).append(" = new ").append(classNameStringBuffer).append("();\n        java.util.regex.Matcher ").append(matcher).append(" = ").append(termPattern).append(".matcher(").append(source).append(");\n        ").append(matcher).append(".region(").append(position).append(", ").append(source).append(".length());\n\n        while (").append(matcher).append(".find()) {\n          ").append(matcher).append(".appendReplacement(").append(termResult).append(", ").append(termLastReplacement).append(");\n        }\n        ").append(matcher).append(".appendTail(").append(termResult).append(");\n        ").append(ev.value()).append(" = UTF8String.fromString(").append(termResult).append(".toString());\n        ").append(termResult).append(" = null;\n      } else {\n        ").append(ev.value()).append(" = ").append((String)subject).append(";\n      }\n      ").append(setEvNotNull).append("\n    ").toString());
    }

    public RegExpReplace copy(Expression subject, Expression regexp, Expression rep, Expression pos) {
        return new RegExpReplace(subject, regexp, rep, pos);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.rep();
    }

    public Expression copy$default$4() {
        return this.pos();
    }

    @Override
    public String productPrefix() {
        return "RegExpReplace";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.rep();
                break;
            }
            case 3: {
                expression = this.pos();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpReplace regExpReplace = (RegExpReplace)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpReplace.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpReplace.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.rep();
        Expression expression6 = regExpReplace.rep();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.pos();
        Expression expression8 = regExpReplace.pos();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!regExpReplace.canEqual(this)) return false;
        return true;
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep, Expression pos) {
        this.subject = subject;
        this.regexp = regexp;
        this.rep = rep;
        this.pos = pos;
        ExpectsInputTypes.$init$(this);
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep) {
        this(subject, regexp, rep, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

