/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.IsNaN$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns true if `expr` is NaN, or false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double));\n       true\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\f\u0019\u0001\u0016B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t}\u0001\u0011\t\u0012)A\u0005w!)q\b\u0001C\u0001\u0001\")1\t\u0001C!\t\")q\u000b\u0001C!1\")A\f\u0001C!;\")q\r\u0001C!Q\"9a\u000fAA\u0001\n\u00039\bbB=\u0001#\u0003%\tA\u001f\u0005\n\u0003\u0017\u0001\u0011\u0011!C!\u0003\u001bA\u0011\"a\b\u0001\u0003\u0003%\t!!\t\t\u0013\u0005%\u0002!!A\u0005\u0002\u0005-\u0002\"CA\u0019\u0001\u0005\u0005I\u0011IA\u001a\u0011%\t\t\u0005AA\u0001\n\u0003\t\u0019\u0005C\u0005\u0002H\u0001\t\t\u0011\"\u0011\u0002J\u001dI\u0011q\r\r\u0002\u0002#\u0005\u0011\u0011\u000e\u0004\t/a\t\t\u0011#\u0001\u0002l!1q(\u0005C\u0001\u0003sB\u0011\"a\u001f\u0012\u0003\u0003%)%! \t\u0013\u0005}\u0014#!A\u0005\u0002\u0006\u0005\u0005\"CAC#\u0005\u0005I\u0011QAD\u0011%\t\u0019*EA\u0001\n\u0013\t)JA\u0003Jg:\u000bgJ\u0003\u0002\u001a5\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tYB$\u0001\u0005dCR\fG._:u\u0015\tib$A\u0002tc2T!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005\u0012\u0013AB1qC\u000eDWMC\u0001$\u0003\ry'oZ\u0002\u0001'\u0019\u0001aEK\u00171mA\u0011q\u0005K\u0007\u00021%\u0011\u0011\u0006\u0007\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011qeK\u0005\u0003Ya\u0011\u0011\u0002\u0015:fI&\u001c\u0017\r^3\u0011\u0005\u001dr\u0013BA\u0018\u0019\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$a\u0002)s_\u0012,8\r\u001e\t\u0003c]J!\u0001\u000f\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003m\u0002\"a\n\u001f\n\u0005uB\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDCA!C!\t9\u0003\u0001C\u0003:\u0007\u0001\u00071(\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0012\t\u0004\r:\u000bfBA$M\u001d\tA5*D\u0001J\u0015\tQE%\u0001\u0004=e>|GOP\u0005\u0002g%\u0011QJM\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005KA\u0002TKFT!!\u0014\u001a\u0011\u0005I+V\"A*\u000b\u0005Qc\u0012!\u0002;za\u0016\u001c\u0018B\u0001,T\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\u0005I\u0006CA\u0019[\u0013\tY&GA\u0004C_>dW-\u00198\u0002\t\u00154\u0018\r\u001c\u000b\u0003=\u0006\u0004\"!M0\n\u0005\u0001\u0014$aA!os\"9!M\u0002I\u0001\u0002\u0004\u0019\u0017!B5oaV$\bC\u00013f\u001b\u0005Q\u0012B\u00014\u001b\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA5piB\u0011!.\\\u0007\u0002W*\u0011A\u000eG\u0001\bG>$WmZ3o\u0013\tq7N\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015\u0001x\u00011\u0001r\u0003\r\u0019G\u000f\u001f\t\u0003UJL!a]6\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")Qo\u0002a\u0001S\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002Bq\"9\u0011\b\u0003I\u0001\u0002\u0004Y\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002w*\u00121\b`\u0016\u0002{B\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000b\u0011\u0014AC1o]>$\u0018\r^5p]&\u0019\u0011\u0011B@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003mC:<'BAA\r\u0003\u0011Q\u0017M^1\n\t\u0005u\u00111\u0003\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\r\u0002cA\u0019\u0002&%\u0019\u0011q\u0005\u001a\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007y\u000bi\u0003C\u0005\u000201\t\t\u00111\u0001\u0002$\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u000e\u0011\u000b\u0005]\u0012Q\b0\u000e\u0005\u0005e\"bAA\u001ee\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0012\u0011\b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002Z\u0003\u000bB\u0001\"a\f\u000f\u0003\u0003\u0005\rAX\u0001\u0007KF,\u0018\r\\:\u0015\u0007e\u000bY\u0005\u0003\u0005\u00020=\t\t\u00111\u0001_Q=\u0001\u0011qJA+\u0003/\nY&!\u0018\u0002b\u0005\r\u0004cA\u0014\u0002R%\u0019\u00111\u000b\r\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011L\u0001B?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"(/^3!S\u001a\u0004\u0003-\u001a=qe\u0002\u0004\u0013n\u001d\u0011OC:c\u0003e\u001c:!M\u0006d7/\u001a\u0011pi\",'o^5tK:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003?\n1J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015dCN$\bf\n(b\u001d\u001e\u0002\u0013m\u001d\u0011e_V\u0014G.Z\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\nQa]5oG\u0016\f#!!\u001a\u0002\u000bErSG\f\u0019\u0002\u000b%\u001bh*\u0019(\u0011\u0005\u001d\n2\u0003B\t\u0002nY\u0002b!a\u001c\u0002vm\nUBAA9\u0015\r\t\u0019HM\u0001\beVtG/[7f\u0013\u0011\t9(!\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002j\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0010\u0005)\u0011\r\u001d9msR\u0019\u0011)a!\t\u000be\"\u0002\u0019A\u001e\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011RAH!\u0011\t\u00141R\u001e\n\u0007\u00055%G\u0001\u0004PaRLwN\u001c\u0005\t\u0003#+\u0012\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003/\u0003B!!\u0005\u0002\u001a&!\u00111TA\n\u0005\u0019y%M[3di\u0002")
public class IsNaN
extends UnaryExpression
implements Predicate,
ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(IsNaN isNaN) {
        return IsNaN$.MODULE$.unapply(isNaN);
    }

    public static <A> Function1<Expression, A> andThen(Function1<IsNaN, A> function1) {
        return IsNaN$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, IsNaN> compose(Function1<A, Expression> function1) {
        return IsNaN$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$}))}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Boolean bl;
        Object value = this.child().eval(input);
        if (value == null) {
            bl = BoxesRunTime.boxToBoolean((boolean)false);
        } else {
            Boolean bl2;
            DataType dataType = this.child().dataType();
            if (DoubleType$.MODULE$.equals(dataType)) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)value)).isNaN());
            } else if (FloatType$.MODULE$.equals(dataType)) {
                bl2 = BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)value)).isNaN());
            } else {
                throw new MatchError((Object)dataType);
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval = this.child().genCode(ctx);
        DataType dataType = this.child().dataType();
        boolean bl = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
        if (!bl) {
            throw new MatchError((Object)dataType);
        }
        ExprCode exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          ", " ", " = ", ";\n          ", " = !", " && Double.isNaN(", ");"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.value(), eval.isNull(), eval.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        return exprCode;
    }

    public IsNaN copy(Expression child) {
        return new IsNaN(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "IsNaN";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IsNaN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IsNaN)) return false;
        boolean bl = true;
        if (!bl) return false;
        IsNaN isNaN = (IsNaN)x$1;
        Expression expression = this.child();
        Expression expression2 = isNaN.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!isNaN.canEqual(this)) return false;
        return true;
    }

    public IsNaN(Expression child) {
        this.child = child;
        Predicate.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

