/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.DatePart$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Extract$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(field FROM source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted\n          - Supported string values of `field` for dates and timestamps are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the year field\n              - \"YEAROFWEEK\" - the ISO 8601 week-numbering year that the datetime falls in. For example, 2005-01-02 is part of the 53rd week of year 2004, so the result is 2004\n              - \"QUARTER\", (\"QTR\") - the quarter (1 - 4) of the year that the datetime falls in\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the month field (1 - 12)\n              - \"WEEK\", (\"W\", \"WEEKS\") - the number of the ISO 8601 week-of-week-based-year. A week is considered to start on a Monday and week 1 is the first week with >3 days. In the ISO week-numbering system, it is possible for early-January dates to be part of the 52nd or 53rd week of the previous year, and for late-December dates to be part of the first week of the next year. For example, 2005-01-02 is part of the 53rd week of year 2004, while 2012-12-31 is part of the first week of 2013\n              - \"DAY\", (\"D\", \"DAYS\") - the day of the month field (1 - 31)\n              - \"DAYOFWEEK\",(\"DOW\") - the day of the week for datetime as Sunday(1) to Saturday(7)\n              - \"DAYOFWEEK_ISO\",(\"DOW_ISO\") - ISO 8601 based day of the week for datetime as Monday(1) to Sunday(7)\n              - \"DOY\" - the day of the year (1 - 365/366)\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - The hour field (0 - 23)\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - the minutes field (0 - 59)\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - the seconds field, including fractional parts\n          - Supported string values of `field` for interval(which consists of `months`, `days`, `microseconds`) are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the total `months` / 12\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the total `months` % 12\n              - \"DAY\", (\"D\", \"DAYS\") - the `days` part of interval\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - how many hours the `microseconds` contains\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - how many minutes left after taking hours from `microseconds`\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - how many second with fractions left after taking hours and minutes from `microseconds`\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(YEAR FROM TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_(week FROM timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_(doy FROM DATE'2019-08-12');\n       224\n      > SELECT _FUNC_(SECONDS FROM timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_(days FROM interval 1 year 10 months 5 days);\n       5\n      > SELECT _FUNC_(seconds FROM interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n  ", note="\n    The _FUNC_ function is equivalent to `date_part(field, source)`.\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011!!\u0005A!f\u0001\n\u0003i\u0004\u0002C#\u0001\u0005#\u0005\u000b\u0011\u0002 \t\u000b\u0019\u0003A\u0011A$\t\u000b\u0019\u0003A\u0011\u0001'\t\u000b=\u0003A\u0011\t)\t\u000b\u0001\u0004A\u0011I1\t\u000b\u0015\u0004A\u0011\t4\t\u000fI\u0004\u0011\u0011!C\u0001g\"9q\u000fAI\u0001\n\u0003A\b\u0002CA\u0004\u0001E\u0005I\u0011\u0001=\t\u0011\u0005%\u0001!%A\u0005\u0002aD\u0011\"a\u0003\u0001\u0003\u0003%\t%!\u0004\t\u0013\u0005u\u0001!!A\u0005\u0002\u0005}\u0001\"CA\u0014\u0001\u0005\u0005I\u0011AA\u0015\u0011%\ty\u0003AA\u0001\n\u0003\n\t\u0004C\u0005\u0002>\u0001\t\t\u0011\"\u0001\u0002@!I\u0011\u0011\n\u0001\u0002\u0002\u0013\u0005\u00131J\u0004\n\u0003kr\u0012\u0011!E\u0001\u0003o2\u0001\"\b\u0010\u0002\u0002#\u0005\u0011\u0011\u0010\u0005\u0007\r^!\t!a\"\t\u0013\u0005%u#!A\u0005F\u0005-\u0005\"CAG/\u0005\u0005I\u0011QAH\u0011%\t9jFA\u0001\n\u0003\u000bI\nC\u0005\u0002,^\t\t\u0011\"\u0003\u0002.\n9Q\t\u001f;sC\u000e$(BA\u0010!\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001a\u0003gM\u001d\u0011\u00055rS\"\u0001\u0010\n\u0005=r\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00055\n\u0014B\u0001\u001a\u001f\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000fA\u0013x\u000eZ;diB\u0011AGO\u0005\u0003wU\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQAZ5fY\u0012,\u0012A\u0010\t\u0003[}J!\u0001\u0011\u0010\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004gS\u0016dG\rI\u0001\u0007g>,(oY3\u0002\u000fM|WO]2fA\u0005)1\r[5mI\u000611\r[5mI\u0002\na\u0001P5oSRtD\u0003\u0002%J\u0015.\u0003\"!\f\u0001\t\u000bq:\u0001\u0019\u0001 \t\u000b\t;\u0001\u0019\u0001 \t\u000b\u0011;\u0001\u0019\u0001 \u0015\u0007!ke\nC\u0003=\u0011\u0001\u0007a\bC\u0003C\u0011\u0001\u0007a(A\u0007gY\u0006$\u0018I]4v[\u0016tGo]\u000b\u0002#B\u0019!KW/\u000f\u0005MCfB\u0001+X\u001b\u0005)&B\u0001,+\u0003\u0019a$o\\8u}%\ta'\u0003\u0002Zk\u00059\u0001/Y2lC\u001e,\u0017BA.]\u0005!IE/\u001a:bi>\u0014(BA-6!\t!d,\u0003\u0002`k\t\u0019\u0011I\\=\u0002\u001b\u0015D\bO]:SKBd\u0017mY3e+\u0005\u0011\u0007c\u0001*d}%\u0011A\r\u0018\u0002\u0004'\u0016\f\u0018\u0001C7l'R\u0014\u0018N\\4\u0015\u0005\u001d|\u0007C\u00015m\u001d\tI'\u000e\u0005\u0002Uk%\u00111.N\u0001\u0007!J,G-\u001a4\n\u00055t'AB*ue&twM\u0003\u0002lk!)\u0001o\u0003a\u0001c\u0006q1\r[5mIJ,gn\u0015;sS:<\u0007c\u0001*dO\u0006!1m\u001c9z)\u0011AE/\u001e<\t\u000fqb\u0001\u0013!a\u0001}!9!\t\u0004I\u0001\u0002\u0004q\u0004b\u0002#\r!\u0003\u0005\rAP\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005I(F\u0001 {W\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003)\u0014AC1o]>$\u0018\r^5p]&\u0019\u0011QA?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0004\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005!A.\u00198h\u0015\t\tI\"\u0001\u0003kCZ\f\u0017bA7\u0002\u0014\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0005\t\u0004i\u0005\r\u0012bAA\u0013k\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q,a\u000b\t\u0013\u00055\"#!AA\u0002\u0005\u0005\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00024A)\u0011QGA\u001e;6\u0011\u0011q\u0007\u0006\u0004\u0003s)\u0014AC2pY2,7\r^5p]&\u00191,a\u000e\u0002\u0011\r\fg.R9vC2$B!!\u0011\u0002HA\u0019A'a\u0011\n\u0007\u0005\u0015SGA\u0004C_>dW-\u00198\t\u0011\u00055B#!AA\u0002u\u000ba!Z9vC2\u001cH\u0003BA!\u0003\u001bB\u0001\"!\f\u0016\u0003\u0003\u0005\r!\u0018\u0015\u0018\u0001\u0005E\u0013qKA-\u0003;\ny&a\u0019\u0002f\u0005%\u00141NA8\u0003c\u00022!LA*\u0013\r\t)F\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tY&A+`\rVs5i\u0018\u0015gS\u0016dG\r\t$S\u001f6\u00033o\\;sG\u0016L\u0003%\f\u0011FqR\u0014\u0018m\u0019;tA\u0005\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fA\u0011\fG/Z\u0018uS6,7\u000f^1na\u0002z'\u000fI5oi\u0016\u0014h/\u00197!g>,(oY3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002b\u0005\u0019ZM\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!M&,G\u000e\u001a\u0011.AM,G.Z2ug\u0002:\b.[2iAA\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u0011t_V\u00148-\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002*\u0007\u0010\u001e:bGR,GM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u00023+\u001e9q_J$X\r\u001a\u0011tiJLgn\u001a\u0011wC2,Xm\u001d\u0011pM\u0002\u0002g-[3mI\u0002\u0004cm\u001c:!I\u0006$Xm\u001d\u0011b]\u0012\u0004C/[7fgR\fW\u000e]:!CJ,\u0007fY1tK\u0002Jgn]3og&$\u0018N^3*u)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI-F\u0003J\u0013C\u0006\t\u0015#3\nb\u0003EI-F\u0003J\u001b&\u0005\f\u0011#3J\u0013C\u0006\t\u0012Z%N\u0013\u0013\u0006I\u0017!i\",\u0007%_3be\u00022\u0017.\u001a7e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%W#B%>3u+R#LE\u0001j\u0003\u0005\u001e5fA%\u001bv\n\t\u001d7aE\u0002s/Z3l[9,XNY3sS:<\u0007%_3be\u0002\"\b.\u0019;!i\",\u0007\u0005Z1uKRLW.\u001a\u0011gC2d7\u000fI5o]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-AI\u0002\u0004'N\u00171c5\u0002$\u0007I5tAA\f'\u000f\u001e\u0011pM\u0002\"\b.\u001a\u00116gI$\u0007e^3fW\u0002zg\rI=fCJ\u0004#\u0007\r\u00195Y\u0001\u001ax\u000e\t;iK\u0002\u0012Xm];mi\u0002J7\u000f\t\u001a1aQR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012R+\u0006\u0013F+\u0012*#Y\u0001B#%\u0015+SE%\u0002S\u0006\t;iK\u0002\nX/\u0019:uKJ\u0004\u0003&\r\u0011.AQJ\u0003e\u001c4!i\",\u0007%_3be\u0002\"\b.\u0019;!i\",\u0007\u0005Z1uKRLW.\u001a\u0011gC2d7\u000fI5o\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T(O)\"\u0013C\u0006\t\u0015#\u001b>s%\u0005\f\u0011#\u001b>s5K\t\u0017!E5{e\n\u0016%TE%\u0002S\u0006\t;iK\u0002jwN\u001c;iA\u0019LW\r\u001c3!QE\u0002S\u0006I\u00193S)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI,F\u000b.\u0013C\u0006\t\u0015#/\nb\u0003EI,F\u000b.\u001b&%\u000b\u0011.AQDW\r\t8v[\n,'\u000fI8gAQDW\rI%T\u001f\u0002Bd\u0007M\u0019!o\u0016,7.L8g[],Wm[\u0017cCN,G-L=fCJt\u0003%\u0011\u0011xK\u0016\\\u0007%[:!G>t7/\u001b3fe\u0016$\u0007\u0005^8!gR\f'\u000f\u001e\u0011p]\u0002\n\u0007%T8oI\u0006L\b%\u00198eA],Wm\u001b\u00112A%\u001c\b\u0005\u001e5fA\u0019L'o\u001d;!o\u0016,7\u000eI<ji\"\u0004ch\r\u0011eCf\u001ch\u0006I%oAQDW\rI%T\u001f\u0002:X-Z6.]Vl'-\u001a:j]\u001e\u00043/_:uK6d\u0003%\u001b;!SN\u0004\u0003o\\:tS\ndW\r\t4pe\u0002*\u0017M\u001d7z[)\u000bg.^1ss\u0002\"\u0017\r^3tAQ|\u0007EY3!a\u0006\u0014H\u000fI8gAQDW\rI\u001b3]\u0012\u0004sN\u001d\u00116gI$\u0007e^3fW\u0002zg\r\t;iK\u0002\u0002(/\u001a<j_V\u001c\b%_3be2\u0002\u0013M\u001c3!M>\u0014\b\u0005\\1uK6\"UmY3nE\u0016\u0014\b\u0005Z1uKN\u0004Co\u001c\u0011cK\u0002\u0002\u0018M\u001d;!_\u001a\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011xK\u0016\\\u0007e\u001c4!i\",\u0007E\\3yi\u0002JX-\u0019:/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!eA\u0002T'\f\u00192[A\u0012\u0004%[:!a\u0006\u0014H\u000fI8gAQDW\rI\u001b4e\u0012\u0004s/Z3lA=4\u0007%_3be\u0002\u0012\u0004\u0007\r\u001b-A]D\u0017\u000e\\3!eA\n$'L\u00193[M\n\u0004%[:!a\u0006\u0014H\u000fI8gAQDW\r\t4jeN$\be^3fW\u0002zg\r\t\u001a1cMR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012E\u0003f\u0013C\u0006\t\u0015#\t\nb\u0003E\t#B3N\u0013\u0013\u0006I\u0017!i\",\u0007\u0005Z1zA=4\u0007\u0005\u001e5fA5|g\u000e\u001e5!M&,G\u000e\u001a\u0011)c\u0001j\u0003eM\u0019*\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#\u0005R!Z\u001f\u001a;V)R&#Y!\u0012CiT,#S\u0001j\u0003\u0005\u001e5fA\u0011\f\u0017\u0010I8gAQDW\rI<fK.\u0004cm\u001c:!I\u0006$X\r^5nK\u0002\n7\u000fI*v]\u0012\f\u0017\u0010K\u0019*AQ|\u0007eU1ukJ$\u0017-\u001f\u00158S)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#B3>3u+R#L?&\u001bvJ\t\u0017)E\u0011{ukX%T\u001f\nJ\u0003%\f\u0011J'>\u0003\u0003H\u000e\u00192A\t\f7/\u001a3!I\u0006L\be\u001c4!i\",\u0007e^3fW\u00022wN\u001d\u0011eCR,G/[7fA\u0005\u001c\b%T8oI\u0006L\b&M\u0015!i>\u00043+\u001e8eCfDs'\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\"u*\u0017\u0012![\u0001\"\b.\u001a\u0011eCf\u0004sN\u001a\u0011uQ\u0016\u0004\u00130Z1sA!\n\u0004%\f\u00114mUz3G\u000e\u001c*\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#\u0005S(V%\nb\u0003\u0005\u000b\u0012IE1\u0002#\u0005S(V%N\u0013C\u0006\t\u0012I%\nb\u0003E\t%S'\nJ\u0003%\f\u0011UQ\u0016\u0004\u0003n\\;sA\u0019LW\r\u001c3!QA\u0002S\u0006\t\u001a4S)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI'J\u001dV#VI\t\u0017!Q\tj%\u0005\f\u0011#\u001b&s%\u0005\f\u0011#\u001b&s5K\t\u0017!E5Ke*\u0016+F'\nJ\u0003%\f\u0011uQ\u0016\u0004S.\u001b8vi\u0016\u001c\bEZ5fY\u0012\u0004\u0003\u0006\r\u0011.AUJ\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!EM+5i\u0014(EE1\u0002\u0003FI*#Y\u0001\u00123+R\"#Y\u0001\u00123+R\"P\u001d\u0012\u001b&\u0005\f\u0011#'\u0016\u001b5KI\u0015![\u0001\"\b.\u001a\u0011tK\u000e|g\u000eZ:!M&,G\u000e\u001a\u0017!S:\u001cG.\u001e3j]\u001e\u0004cM]1di&|g.\u00197!a\u0006\u0014Ho\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003eU;qa>\u0014H/\u001a3!gR\u0014\u0018N\\4!m\u0006dW/Z:!_\u001a\u0004\u0003MZ5fY\u0012\u0004\u0007EZ8sA%tG/\u001a:wC2Ds\u000f[5dQ\u0002\u001awN\\:jgR\u001c\be\u001c4!A6|g\u000e\u001e5tA2\u0002\u0003\rZ1zg\u0002d\u0003\u0005Y7jGJ|7/Z2p]\u0012\u001c\b-\u000b\u0011be\u0016D3-Y:fA%t7/\u001a8tSRLg/Z\u0015;\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%W#B%\nb\u0003\u0005\u000b\u0012ZE1\u0002#%W#B%N\u0013C\u0006\t\u0012Z%\nb\u0003EI-S'\nJ\u0003%\f\u0011uQ\u0016\u0004Co\u001c;bY\u0002\u0002Wn\u001c8uQN\u0004\u0007e\f\u00112e)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI'P\u001dRC%\u0005\f\u0011)E5{eJ\t\u0017!E5{ej\u0015\u0012-A\tjuJ\u0014+I'\nJ\u0003%\f\u0011uQ\u0016\u0004Co\u001c;bY\u0002\u0002Wn\u001c8uQN\u0004\u0007%\n\u00112e)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#B3\nb\u0003\u0005\u000b\u0012EE1\u0002#\u0005R!Z'\nJ\u0003%\f\u0011uQ\u0016\u0004\u0003\rZ1zg\u0002\u0004\u0003/\u0019:uA=4\u0007%\u001b8uKJ4\u0018\r\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tBu*\u0016*#Y\u0001B#\u0005\u0013\u0012-A\tBu*\u0016*TE1\u0002#\u0005\u0013*#Y\u0001\u0012\u0003JU*#S\u0001j\u0003\u0005[8xA5\fg.\u001f\u0011i_V\u00148\u000f\t;iK\u0002\u0002W.[2s_N,7m\u001c8eg\u0002\u00043m\u001c8uC&t7O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5Ke*\u0016+FE1\u0002\u0003FI'#Y\u0001\u0012S*\u0013(#Y\u0001\u0012S*\u0013(TE1\u0002#%T%O+R+5KI\u0015![\u0001Bwn\u001e\u0011nC:L\b%\\5okR,7\u000f\t7fMR\u0004\u0013M\u001a;fe\u0002\"\u0018m[5oO\u0002Bw.\u001e:tA\u0019\u0014x.\u001c\u0011a[&\u001c'o\\:fG>tGm\u001d1\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u00123+R\"P\u001d\u0012\u0013C\u0006\t\u0015#'\nb\u0003EI*F\u0007\nb\u0003EI*F\u0007>sEi\u0015\u0012-A\t\u001aViQ*#S\u0001j\u0003\u0005[8xA5\fg.\u001f\u0011tK\u000e|g\u000e\u001a\u0011xSRD\u0007E\u001a:bGRLwN\\:!Y\u00164G\u000fI1gi\u0016\u0014\b\u0005^1lS:<\u0007\u0005[8veN\u0004\u0013M\u001c3![&tW\u000f^3tA\u0019\u0014x.\u001c\u0011a[&\u001c'o\\:fG>tGm\u001d1\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM|WO]2fA5\u0002\u0013\r\t3bi\u0016|C/[7fgR\fW\u000e\u001d\u0011pe\u0002Jg\u000e^3sm\u0006d\u0007eY8mk6t\u0007E\u001a:p[\u0002:\b.\u001a:fA\u00014\u0017.\u001a7eA\u0002\u001a\bn\\;mI\u0002\u0012W\rI3yiJ\f7\r^3e\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0014\u0001\"\u0007\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Qe+\u0015I\u0015\u0011G%>k\u0005\u0005V%N\u000bN#\u0016)\u0014)!OI\u0002\u0014'O\u00171q5\n$\u0007\t\u00192uA\u0002$\b\r\u0019/cI\u001aD'\u000e\u001c(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u0019:\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":X-Z6!\rJ{U\n\t;j[\u0016\u001cH/Y7qOI\u0002\u0014'O\u00171q5\n$\u0007\t\u00192uA\u0002$\b\r\u0019/cI\u001aD'\u000e\u001c(SmR\u0001\u0005\t\u0011!A\u0001\u00023g\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)I>L\bE\u0012*P\u001b\u0002\"\u0015\tV#(eA\n\u0014(\f\u00199[E\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eI\"$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK*F\u0007>sEi\u0015\u0011G%>k\u0005\u0005^5nKN$\u0018-\u001c9(eA\n\u0014(L\u00191[A\n\u0004\u0005\r\u0019;aAR\u0004'\r\u00181aA\u0002\u0004'M\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\nd\u0006\r\u00191aA\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b3bsN\u0004cIU(NA%tG/\u001a:wC2\u0004\u0013\u0007I=fCJ\u0004\u0013\u0007\r\u0011n_:$\bn\u001d\u00116A\u0011\f\u0017p]\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AUR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f]3d_:$7\u000f\t$S\u001f6\u0003\u0013N\u001c;feZ\fG\u000eI\u001b!Q>,(o\u001d\u00114a\u0001\u001aXmY8oIN\u0004\u0013\u0007I7jY2L7/Z2p]\u0012\u001c\b%\r\u0011nS\u000e\u0014xn]3d_:$7/K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!gAr\u0003\u0007M\u00191aER\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002n\u0005A%\u0002\t\u0011!AQCW\rI0G+:\u001bu\f\t4v]\u000e$\u0018n\u001c8!SN\u0004S-];jm\u0006dWM\u001c;!i>\u0004\u0003\rZ1uK~\u0003\u0018M\u001d;)M&,G\u000e\u001a\u0017!g>,(oY3*A:R\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003g\nQa\r\u00181]A\nq!\u0012=ue\u0006\u001cG\u000f\u0005\u0002./M!q#a\u001f:!!\ti(a!?}yBUBAA@\u0015\r\t\t)N\u0001\beVtG/[7f\u0013\u0011\t))a \u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002x\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0010\u0005)\u0011\r\u001d9msR9\u0001*!%\u0002\u0014\u0006U\u0005\"\u0002\u001f\u001b\u0001\u0004q\u0004\"\u0002\"\u001b\u0001\u0004q\u0004\"\u0002#\u001b\u0001\u0004q\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u00037\u000b9\u000bE\u00035\u0003;\u000b\t+C\u0002\u0002 V\u0012aa\u00149uS>t\u0007C\u0002\u001b\u0002$zrd(C\u0002\u0002&V\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAU7\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAX!\u0011\t\t\"!-\n\t\u0005M\u00161\u0003\u0002\u0007\u001f\nTWm\u0019;")
public class Extract
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Extract extract2) {
        return Extract$.MODULE$.unapply(extract2);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Extract> tupled() {
        return Extract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Extract>>> curried() {
        return Extract$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        Extract extract2 = this;
        synchronized (extract2) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return new StringBuilder(0).append(this.prettyName()).append(childrenString.mkString("(", " FROM ", ")")).toString();
    }

    public Extract copy(Expression field, Expression source, Expression child) {
        return new Extract(field, source, child);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Extract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.field();
                break;
            }
            case 1: {
                expression = this.source();
                break;
            }
            case 2: {
                expression = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Extract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Extract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Extract extract2 = (Extract)x$1;
        Expression expression = this.field();
        Expression expression2 = extract2.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = extract2.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.child();
        Expression expression6 = extract2.child();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!extract2.canEqual(this)) return false;
        return true;
    }

    public Extract(Expression field, Expression source, Expression child) {
        this.field = field;
        this.source = source;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public Extract(Expression field, Expression source) {
        this(field, source, DatePart$.MODULE$.toEquivalentExpr(field, source));
    }
}

