/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayBasedSimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.SimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NullType$;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr, func) - Sorts the input array. If func is omitted, sort\n    in ascending order. The elements of the input array must be orderable. Null elements\n    will be placed at the end of the returned array. Since 3.0.0 this function also sorts\n    and returns the array based on the given comparator function. The comparator will\n    take two arguments representing two elements of the array.\n    It returns -1, 0, or 1 as the first element is less than, equal to, or greater\n    than the second element. If the comparator function returns other\n    values (including null), the function will fail and raise an error.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array(5, 6, 1), (left, right) -> case when left < right then -1 when left > right then 1 else 0 end);\n       [1,5,6]\n      > SELECT _FUNC_(array('bc', 'ab', 'dc'), (left, right) -> case when left is null and right is null then 0 when left is null then -1 when right is null then 1 when left < right then 1 when left > right then -1 else 0 end);\n       [\"dc\",\"bc\",\"ab\"]\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0012%\u0001FB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005e!A1\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005M\u0001\tE\t\u0015!\u00033\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015i\u0005\u0001\"\u0001S\u0011!!\u0006\u0001#b\u0001\n\u0003)\u0006\"\u00021\u0001\t\u0003\n\u0007\"B3\u0001\t\u00032\u0007\"B7\u0001\t\u0003r\u0007\u0002DA\n\u0001A\u0005\tr1Q\u0005\n\u0005U\u0001BCA\u0010\u0001!\u0015\r\u0011\"\u0001\u0002\"!Q\u0011Q\u0005\u0001\t\u0006\u0004%\t!!\t\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u0011q\n\u0001\u0005B\u0005E\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\n\u0003[\u0002\u0011\u0011!C\u0001\u0003_B\u0011\"!\u001e\u0001#\u0003%\t!a\u001e\t\u0013\u00055\u0005!%A\u0005\u0002\u0005]\u0004\"CAH\u0001\u0005\u0005I\u0011IAI\u0011%\ti\nAA\u0001\n\u0003\ty\nC\u0005\u0002(\u0002\t\t\u0011\"\u0001\u0002*\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0017\u0005\n\u0003\u007f\u0003\u0011\u0011!C\u0001\u0003\u0003D\u0011\"!2\u0001\u0003\u0003%\t%a2\b\u000f\u0005\u0015H\u0005#\u0001\u0002h\u001a11\u0005\nE\u0001\u0003SDa!T\u000e\u0005\u0002\u0005E\bbBA\u00157\u0011\u0005\u00111\u001f\u0005\n\u0003{\\\"\u0019!C\u0001\u0003\u007fD\u0001B!\u0001\u001cA\u0003%\u0011Q\u0002\u0005\n\u0005\u0007Y\u0012\u0011!CA\u0005\u000bA\u0011Ba\u0003\u001c\u0003\u0003%\tI!\u0004\t\u0013\tm1$!A\u0005\n\tu!!C!se\u0006L8k\u001c:u\u0015\t)c%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0014)\u0003!\u0019\u0017\r^1msN$(BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u00011C\u0002\u00013mezT\t\u0005\u00024i5\tA%\u0003\u00026I\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005M:\u0014B\u0001\u001d%\u0005\r\n%O]1z\u0005\u0006\u001cX\rZ*j[BdW\rS5hQ\u0016\u0014xJ\u001d3fe\u001a+hn\u0019;j_:\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0013\u0002\u000f\r|G-Z4f]&\u0011ah\u000f\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n9\u0001K]8ek\u000e$\bC\u0001!G\u0013\t9\u0015I\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005be\u001e,X.\u001a8u+\u0005\u0011\u0014!C1sOVlWM\u001c;!\u0003!1WO\\2uS>t\u0017!\u00034v]\u000e$\u0018n\u001c8!\u0003\u0019a\u0014N\\5u}Q\u0019q\nU)\u0011\u0005M\u0002\u0001\"\u0002%\u0006\u0001\u0004\u0011\u0004\"B&\u0006\u0001\u0004\u0011DCA(T\u0011\u0015Ae\u00011\u00013\u0003-)G.Z7f]R$\u0016\u0010]3\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!\u0017\u0015\u0002\u000bQL\b/Z:\n\u0005mC&\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0005\u001di\u0006C\u0001!_\u0013\ty\u0016IA\u0005ue\u0006t7/[3oi\u0006AA-\u0019;b)f\u0004X-F\u0001c!\t96-\u0003\u0002e1\nI\u0011I\u001d:bsRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!NJ\u0001\tC:\fG._:jg&\u0011A.\u001b\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006!!-\u001b8e)\tyu\u000eC\u0003q\u0015\u0001\u0007\u0011/A\u0001g!\u0019\u0001%O\r;\u0002\u000e%\u00111/\u0011\u0002\n\rVt7\r^5p]J\u0002B!^?\u0002\u00029\u0011ao\u001f\b\u0003ojl\u0011\u0001\u001f\u0006\u0003sB\na\u0001\u0010:p_Rt\u0014\"\u0001\"\n\u0005q\f\u0015a\u00029bG.\fw-Z\u0005\u0003}~\u00141aU3r\u0015\ta\u0018\t\u0005\u0004A\u0003\u00071\u0016qA\u0005\u0004\u0003\u000b\t%A\u0002+va2,'\u0007E\u0002A\u0003\u0013I1!a\u0003B\u0005\u001d\u0011un\u001c7fC:\u00042aMA\b\u0013\r\t\t\u0002\n\u0002\u000f\u0019\u0006l'\rZ1Gk:\u001cG/[8o\u0003\u0011AH%\r\u001d\u0016\u0005\u0005]\u0001c\u0002!\u0002\u0004\u0005e\u0011\u0011\u0004\t\u0004g\u0005m\u0011bAA\u000fI\t\u0019b*Y7fI2\u000bWN\u00193b-\u0006\u0014\u0018.\u00192mK\u0006aa-\u001b:ti\u0016cW-\u001c,beV\u0011\u0011\u0011\u0004\u0015\u0003\u0019u\u000bQb]3d_:$W\t\\3n-\u0006\u0014\bFA\u0007^\u0003)\u0019w.\u001c9be\u0006$xN\u001d\u000b\u0005\u0003[\t\u0019\u0005\u0005\u0004\u00020\u0005e\u0012QH\u0007\u0003\u0003cQA!a\r\u00026\u0005!Q\u000f^5m\u0015\t\t9$\u0001\u0003kCZ\f\u0017\u0002BA\u001e\u0003c\u0011!bQ8na\u0006\u0014\u0018\r^8s!\r\u0001\u0015qH\u0005\u0004\u0003\u0003\n%aA!os\"9\u0011Q\t\bA\u0002\u0005\u001d\u0013\u0001C5oaV$(k\\<\u0011\t\u0005%\u00131J\u0007\u0002M%\u0019\u0011Q\n\u0014\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003{\t\u0019&!\u0016\t\u000f\u0005\u0015s\u00021\u0001\u0002H!9\u0011qK\bA\u0002\u0005u\u0012!D1sOVlWM\u001c;WC2,X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0018\u0011\t\u0005}\u0013q\r\b\u0005\u0003C\n\u0019\u0007\u0005\u0002x\u0003&\u0019\u0011QM!\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)'Q\u0001\u0005G>\u0004\u0018\u0010F\u0003P\u0003c\n\u0019\bC\u0004I#A\u0005\t\u0019\u0001\u001a\t\u000f-\u000b\u0002\u0013!a\u0001e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA=U\r\u0011\u00141P\u0016\u0003\u0003{\u0002B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))A\u0005v]\u000eDWmY6fI*\u0019\u0011qQ!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0006\u0005%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0014B!\u0011QSAN\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006U\u0012\u0001\u00027b]\u001eLA!!\u001b\u0002\u0018\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0015\t\u0004\u0001\u0006\r\u0016bAAS\u0003\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QHAV\u0011%\tiKFA\u0001\u0002\u0004\t\t+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003g\u0003b!!.\u0002<\u0006uRBAA\\\u0015\r\tI,Q\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA_\u0003o\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qAAb\u0011%\ti\u000bGA\u0001\u0002\u0004\ti$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\tI\rC\u0005\u0002.f\t\t\u00111\u0001\u0002>!z\u0001!!4\u0002T\u0006U\u0017\u0011\\An\u0003?\f\t\u000fE\u00024\u0003\u001fL1!!5%\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a6\u0002\tK|f)\u0016(D?\"*\u0007\u0010\u001d:-A\u0019,hnY\u0015![\u0001\u001avN\u001d;tAQDW\rI5oaV$\b%\u0019:sCft\u0003%\u00134!MVt7\rI5tA=l\u0017\u000e\u001e;fI2\u00023o\u001c:u\u0015\u0001\u0002\u0003\u0005I5oA\u0005\u001c8-\u001a8eS:<\u0007e\u001c:eKJt\u0003\u0005\u00165fA\u0015dW-\\3oiN\u0004sN\u001a\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\n'O]1zA5,8\u000f\u001e\u0011cK\u0002z'\u000fZ3sC\ndWM\f\u0011Ok2d\u0007%\u001a7f[\u0016tGo\u001d\u0006!A\u0001\u0002s/\u001b7mA\t,\u0007\u0005\u001d7bG\u0016$\u0007%\u0019;!i\",\u0007%\u001a8eA=4\u0007\u0005\u001e5fAI,G/\u001e:oK\u0012\u0004\u0013M\u001d:bs:\u00023+\u001b8dK\u0002\u001ad\u0006\r\u00181AQD\u0017n\u001d\u0011gk:\u001cG/[8oA\u0005d7o\u001c\u0011t_J$8O\u0003\u0011!A\u0001\ng\u000e\u001a\u0011sKR,(O\\:!i\",\u0007%\u0019:sCf\u0004#-Y:fI\u0002zg\u000e\t;iK\u0002:\u0017N^3oA\r|W\u000e]1sCR|'\u000f\t4v]\u000e$\u0018n\u001c8/AQCW\rI2p[B\f'/\u0019;pe\u0002:\u0018\u000e\u001c7\u000bA\u0001\u0002\u0003\u0005^1lK\u0002\"xo\u001c\u0011be\u001e,X.\u001a8ug\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hAQ<x\u000eI3mK6,g\u000e^:!_\u001a\u0004C\u000f[3!CJ\u0014\u0018-\u001f\u0018\u000bA\u0001\u0002\u0003%\u0013;!e\u0016$XO\u001d8tA5\nD\u0006\t\u0019-A=\u0014\b%\r\u0011bg\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI3mK6,g\u000e\u001e\u0011jg\u0002bWm]:!i\"\fg\u000e\f\u0011fcV\fG\u000e\t;pY\u0001z'\u000fI4sK\u0006$XM\u001d\u0006!A\u0001\u0002C\u000f[1oAQDW\rI:fG>tG\rI3mK6,g\u000e\u001e\u0018!\u0013\u001a\u0004C\u000f[3!G>l\u0007/\u0019:bi>\u0014\bEZ;oGRLwN\u001c\u0011sKR,(O\\:!_RDWM\u001d\u0006!A\u0001\u0002c/\u00197vKN\u0004\u0003&\u001b8dYV$\u0017N\\4!]VdG.\u000b\u0017!i\",\u0007EZ;oGRLwN\u001c\u0011xS2d\u0007EZ1jY\u0002\ng\u000e\u001a\u0011sC&\u001cX\rI1oA\u0015\u0014(o\u001c:/\u0015\u0001\u0002\u0003\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011Q\\\u0001\u0004^*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"*D\u0006\t\u001c-AEJC\u0006\t\u0015mK\u001a$H\u0006\t:jO\"$\u0018\u0006I\u0017?A\r\f7/\u001a\u0011xQ\u0016t\u0007\u0005\\3gi\u0002b\u0004E]5hQR\u0004C\u000f[3oA5\n\u0004e\u001e5f]\u0002bWM\u001a;!}\u0001\u0012\u0018n\u001a5uAQDWM\u001c\u00112A\u0015d7/\u001a\u00111A\u0015tG-K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7FbS\u0007\f\u001c^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ\u001d\u00127m\n\u0017!O\u0005\u0014w\u0005\f\u0011(I\u000e<\u0013\u0006\f\u0011)Y\u00164G\u000f\f\u0011sS\u001eDG/\u000b\u0011.}\u0001\u001a\u0017m]3!o\",g\u000e\t7fMR\u0004\u0013n\u001d\u0011ok2d\u0007%\u00198eAILw\r\u001b;!SN\u0004c.\u001e7mAQDWM\u001c\u00111A]DWM\u001c\u0011mK\u001a$\b%[:!]VdG\u000e\t;iK:\u0004S&\r\u0011xQ\u0016t\u0007E]5hQR\u0004\u0013n\u001d\u0011ok2d\u0007\u0005\u001e5f]\u0002\n\u0004e\u001e5f]\u0002bWM\u001a;!y\u0001\u0012\u0018n\u001a5uAQDWM\u001c\u00112A]DWM\u001c\u0011mK\u001a$\bE\u0010\u0011sS\u001eDG\u000f\t;iK:\u0004S&\r\u0011fYN,\u0007\u0005\r\u0011f]\u0012L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.#I\u000e\u0014CF\t2dE1\u0012\u0013M\u0019\u0012^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ\u001d\u0012w\u0005\f\u0011(I\u001eb\u0003E\\;mY2\u0002seY\u0014-A\u001d\nw%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0013\u0013M\t\u0017#E\nb#e\u0019\u0012-E\u0011\u0014CF\\;mYvS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003G\fQA\r\u00185]A\n\u0011\"\u0011:sCf\u001cvN\u001d;\u0011\u0005MZ2\u0003B\u000e\u0002l\u0016\u00032\u0001QAw\u0013\r\ty/\u0011\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u001dH#\u0002\u001a\u0002v\u0006e\bBBA|;\u0001\u0007!'\u0001\u0003mK\u001a$\bBBA~;\u0001\u0007!'A\u0003sS\u001eDG/A\teK\u001a\fW\u000f\u001c;D_6\u0004\u0018M]1u_J,\"!!\u0004\u0002%\u0011,g-Y;mi\u000e{W\u000e]1sCR|'\u000fI\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u001f\n\u001d!\u0011\u0002\u0005\u0006\u0011\u0002\u0002\rA\r\u0005\u0006\u0017\u0002\u0002\rAM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yAa\u0006\u0011\u000b\u0001\u0013\tB!\u0006\n\u0007\tM\u0011I\u0001\u0004PaRLwN\u001c\t\u0006\u0001\u0006\r!G\r\u0005\t\u00053\t\u0013\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005?\u0001B!!&\u0003\"%!!1EAL\u0005\u0019y%M[3di\u0002")
public class ArraySort
extends Expression
implements ArrayBasedSimpleHigherOrderFunction,
CodegenFallback,
Serializable {
    private transient DataType elementType;
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$18;
    private transient NamedLambdaVariable firstElemVar;
    private transient NamedLambdaVariable secondElemVar;
    private final Expression argument;
    private final Expression function;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraySort arraySort) {
        return ArraySort$.MODULE$.unapply(arraySort);
    }

    public static LambdaFunction defaultComparator() {
        return ArraySort$.MODULE$.defaultComparator();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public AbstractDataType argumentType() {
        return ArrayBasedSimpleHigherOrderFunction.argumentType$(this);
    }

    @Override
    public Seq<Expression> arguments() {
        return SimpleHigherOrderFunction.arguments$(this);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        return SimpleHigherOrderFunction.argumentTypes$(this);
    }

    @Override
    public Seq<Expression> functions() {
        return SimpleHigherOrderFunction.functions$(this);
    }

    @Override
    public AbstractDataType functionType() {
        return SimpleHigherOrderFunction.functionType$(this);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        return SimpleHigherOrderFunction.functionTypes$(this);
    }

    @Override
    public Expression functionForEval() {
        return SimpleHigherOrderFunction.functionForEval$(this);
    }

    @Override
    public Object eval(InternalRow inputRow) {
        return SimpleHigherOrderFunction.eval$(this, inputRow);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public Seq<Expression> children() {
        return HigherOrderFunction.children$(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    private boolean argumentsResolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    @Override
    public Expression argument() {
        return this.argument;
    }

    @Override
    public Expression function() {
        return this.function;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.argument().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public ArrayType dataType() {
        return (ArrayType)this.argument().dataType();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        block5: {
            block4: {
                var3_1 = this.checkArgumentDataTypes();
                if (!TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(var3_1)) break block4;
                var4_2 = false;
                var5_3 = null;
                var6_4 = this.argument().dataType();
                if (!(var6_4 instanceof ArrayType)) ** GOTO lbl-1000
                var4_2 = true;
                var5_3 = (ArrayType)var6_4;
                dt = var5_3.elementType();
                if (RowOrdering$.MODULE$.isOrderable(dt)) {
                    v0 = this.function().dataType();
                    var8_6 = IntegerType$.MODULE$;
                    var2_7 /* !! */  = !(v0 != null ? v0.equals(var8_6) == false : var8_6 != null) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure("Return type of the given function has to be IntegerType");
                } else if (var4_2) {
                    dt = var5_3.elementType();
                    dtSimple = dt.catalogString();
                    var2_7 /* !! */  = new TypeCheckResult.TypeCheckFailure(new StringBuilder(63).append(this.prettyName()).append(" does not support sorting array of type ").append(dtSimple).append(" which is not ").append("orderable").toString());
                } else {
                    var2_7 /* !! */  = new TypeCheckResult.TypeCheckFailure(new StringBuilder(27).append(this.prettyName()).append(" only supports array input.").toString());
                }
                var1_10 = var2_7 /* !! */ ;
                break block5;
            }
            var1_10 = var3_1;
        }
        return var1_10;
    }

    @Override
    public ArraySort bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType dataType = this.argument().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        Tuple2 tuple22 = tuple2;
        DataType elementType2 = (DataType)tuple22._1();
        boolean containsNull2 = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        Tuple2 tuple24 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple24).$colon$colon((Object)tuple23));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, x$1);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$18$lzycompute() {
        block5: {
            ArraySort arraySort = this;
            synchronized (arraySort) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression secondElemVar;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block6;
                        NamedExpression firstElemVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        secondElemVar = (NamedExpression)((SeqLike)some.get()).apply(1);
                        if (!(firstElemVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)firstElemVar;
                        if (secondElemVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)secondElemVar;
                Tuple2 tuple2 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.x$18 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$18;
    }

    private /* synthetic */ Tuple2 x$18() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$18$lzycompute() : this.x$18;
    }

    private NamedLambdaVariable firstElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.firstElemVar = (NamedLambdaVariable)this.x$18()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.firstElemVar;
    }

    public NamedLambdaVariable firstElemVar() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.firstElemVar$lzycompute() : this.firstElemVar;
    }

    private NamedLambdaVariable secondElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.secondElemVar = (NamedLambdaVariable)this.x$18()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.secondElemVar;
    }

    public NamedLambdaVariable secondElemVar() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.secondElemVar$lzycompute() : this.secondElemVar;
    }

    public Comparator<Object> comparator(InternalRow inputRow) {
        Expression f = this.functionForEval();
        return (o1, o2) -> {
            this.firstElemVar().value().set(o1);
            this.secondElemVar().value().set(o2);
            return BoxesRunTime.unboxToInt((Object)f.eval(inputRow));
        };
    }

    @Override
    public Object nullSafeEval(InternalRow inputRow, Object argumentValue) {
        Object[] arr = (Object[])((ArrayData)argumentValue).toArray(this.elementType(), ClassTag$.MODULE$.AnyRef());
        DataType dataType = this.elementType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
            Arrays.sort(arr, this.comparator(inputRow));
        }
        return new GenericArrayData(arr);
    }

    @Override
    public String prettyName() {
        return "array_sort";
    }

    public ArraySort copy(Expression argument, Expression function) {
        return new ArraySort(argument, function);
    }

    public Expression copy$default$1() {
        return this.argument();
    }

    public Expression copy$default$2() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.argument();
                break;
            }
            case 1: {
                expression = this.function();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        Expression expression = this.argument();
        Expression expression2 = arraySort.argument();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.function();
        Expression expression4 = arraySort.function();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression argument, Expression function) {
        this.argument = argument;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        SimpleHigherOrderFunction.$init$(this);
        ArrayBasedSimpleHigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
    }

    public ArraySort(Expression argument) {
        this(argument, ArraySort$.MODULE$.defaultComparator());
    }
}

