/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.PartialResultException;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001B\u000f\u001f\u0001-B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011)\u0019!C\u0001\u0001\"AQ\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015Q\u0005\u0001\"\u0001L\u000b\u0011\u0001\u0006\u0001B)\t\u000f\u0001\u0004!\u0019!C\u0005C\"11\u000f\u0001Q\u0001\n\tDq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001e\u0005\tu\u0002A)\u0019!C\u0005w\"Q\u0011Q\u0001\u0001\t\u0006\u0004%I!a\u0002\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011%\t\t\u0005\u0001b\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002h\u0001\u0001\u000b\u0011BA#\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!!\u001e\u0001\t\u0013\t9\bC\u0005\u0002*\u0002\u0011\r\u0011\"\u0003\u0002,\"9\u0011Q\u0016\u0001!\u0002\u00139\u0005bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011%\t)\u000eAI\u0001\n\u0013\t9\u000eC\u0004\u0002n\u0002!I!a<\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\"9!1\u0002\u0001\u0005\u0002\t5!!\u0004&bG.\u001cxN\u001c)beN,'O\u0003\u0002 A\u0005!!n]8o\u0015\t\t#%\u0001\u0005dCR\fG._:u\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\r\u0001AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\"\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005]\"$a\u0002'pO\u001eLgnZ\u0001\u0007g\u000eDW-\\1\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0012\u0013!\u0002;za\u0016\u001c\u0018B\u0001 <\u0005!!\u0015\r^1UsB,\u0017aB8qi&|gn]\u000b\u0002\u0003B\u0011!iQ\u0007\u0002=%\u0011AI\b\u0002\f\u0015N{ej\u00149uS>t7/\u0001\u0005paRLwN\\:!\u0003M\tG\u000e\\8x\u0003J\u0014\u0018-_!t'R\u0014Xo\u0019;t!\ti\u0003*\u0003\u0002J]\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0003M\u001b:{\u0005C\u0001\"\u0001\u0011\u0015AT\u00011\u0001:\u0011\u0015yT\u00011\u0001B\u0011\u00151U\u00011\u0001H\u000591\u0016\r\\;f\u0007>tg/\u001a:uKJ\u0004B!\f*UY%\u00111K\f\u0002\n\rVt7\r^5p]F\u0002\"!\u00160\u000e\u0003YS!a\u0016-\u0002\t\r|'/\u001a\u0006\u00033j\u000bqA[1dWN|gN\u0003\u0002\\9\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0002;\u0006\u00191m\\7\n\u0005}3&A\u0003&t_:\u0004\u0016M]:fe\u0006i!o\\8u\u0007>tg/\u001a:uKJ,\u0012A\u0019\t\u0005[I#6\rE\u0002eY>t!!\u001a6\u000f\u0005\u0019LW\"A4\u000b\u0005!T\u0013A\u0002\u001fs_>$h(C\u00010\u0013\tYg&A\u0004qC\u000e\\\u0017mZ3\n\u00055t'\u0001C%uKJ\f'\r\\3\u000b\u0005-t\u0003C\u00019r\u001b\u0005\u0001\u0013B\u0001:!\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u001dI|w\u000e^\"p]Z,'\u000f^3sA\u00059a-Y2u_JLX#\u0001<\u0011\u0005U;\u0018B\u0001=W\u0005-Q5o\u001c8GC\u000e$xN]=\u0002\u0011\u0019\f7\r^8ss\u0002\n!\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;feV\tA\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\u0002\nA!\u001e;jY&\u0019\u00111\u0001@\u0003%QKW.Z:uC6\u0004hi\u001c:nCR$XM]\u0001\u000eI\u0006$XMR8s[\u0006$H/\u001a:\u0016\u0005\u0005%\u0001cA?\u0002\f%\u0019\u0011Q\u0002@\u0003\u001b\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u0003Ei\u0017m[3S_>$8i\u001c8wKJ$XM\u001d\u000b\u0004E\u0006M\u0001BBA\u000b\u001b\u0001\u0007\u0011(\u0001\u0002ei\u00069R.Y6f'R\u0014Xo\u0019;S_>$8i\u001c8wKJ$XM\u001d\u000b\u0004E\u0006m\u0001bBA\u000f\u001d\u0001\u0007\u0011qD\u0001\u0003gR\u00042AOA\u0011\u0013\r\t\u0019c\u000f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001F7bW\u0016l\u0015\r\u001d*p_R\u001cuN\u001c<feR,'\u000fF\u0002c\u0003SAq!a\u000b\u0010\u0001\u0004\ti#\u0001\u0002niB\u0019!(a\f\n\u0007\u0005E2HA\u0004NCB$\u0016\u0010]3\u0002-5\f7.Z!se\u0006L(k\\8u\u0007>tg/\u001a:uKJ$2AYA\u001c\u0011\u001d\tI\u0004\u0005a\u0001\u0003w\t!!\u0019;\u0011\u0007i\ni$C\u0002\u0002@m\u0012\u0011\"\u0011:sCf$\u0016\u0010]3\u0002\u001b\u0011,7-[7bYB\u000b'o]3s+\t\t)\u0005\u0005\u0004.%\u0006\u001d\u0013q\u000b\t\u0005\u0003\u0013\n\tF\u0004\u0003\u0002L\u00055\u0003C\u00014/\u0013\r\tyEL\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0013Q\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=c\u0006\u0005\u0003\u0002Z\u0005\rTBAA.\u0015\u0011\ti&a\u0018\u0002\t5\fG\u000f\u001b\u0006\u0003\u0003C\nAA[1wC&!\u0011QMA.\u0005)\u0011\u0015n\u001a#fG&l\u0017\r\\\u0001\u000fI\u0016\u001c\u0017.\\1m!\u0006\u00148/\u001a:!\u00035i\u0017m[3D_:4XM\u001d;feR!\u0011QNA9!\r\tyGB\u0007\u0002\u0001!1\u00111O\nA\u0002e\n\u0001\u0002Z1uCRK\b/Z\u0001\u000fa\u0006\u00148/\u001a&t_:$vn[3o+\u0011\tI(!!\u0015\r\u0005m\u00141UAT)\u0011\ti(a%\u0011\t\u0005}\u0014\u0011\u0011\u0007\u0001\t\u001d\t\u0019\t\u0006b\u0001\u0003\u000b\u0013\u0011AU\t\u0005\u0003\u000f\u000bi\tE\u0002.\u0003\u0013K1!a#/\u0005\u0011qU\u000f\u001c7\u0011\u00075\ny)C\u0002\u0002\u0012:\u00121!\u00118z\u0011\u001d\t)\n\u0006a\u0001\u0003/\u000b\u0011A\u001a\t\b[\u0005e\u0015QTA?\u0013\r\tYJ\f\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0019Q+a(\n\u0007\u0005\u0005fKA\u0005Kg>tGk\\6f]\"1\u0011Q\u0015\u000bA\u0002Q\u000ba\u0001]1sg\u0016\u0014\bBBA:)\u0001\u0007\u0011(\u0001\tbY2|w/R7qif\u001cFO]5oOV\tq)A\tbY2|w/R7qif\u001cFO]5oO\u0002\n\u0001CZ1jY\u0016$7i\u001c8wKJ\u001c\u0018n\u001c8\u0016\t\u0005M\u0016\u0011\u0018\u000b\u0007\u0003k\u000bY,!0\u0011\u000f5\nI*!(\u00028B!\u0011qPA]\t\u001d\t\u0019i\u0006b\u0001\u0003\u000bCa!!*\u0018\u0001\u0004!\u0006BBA:/\u0001\u0007\u0011(A\u0007d_:4XM\u001d;PE*,7\r\u001e\u000b\n_\u0006\r\u0017QYAd\u0003#Da!!*\u0019\u0001\u0004!\u0006B\u0002\u001d\u0019\u0001\u0004\ty\u0002C\u0004\u0002Jb\u0001\r!a3\u0002\u001f\u0019LW\r\u001c3D_:4XM\u001d;feN\u0004R!LAg\u0003[J1!a4/\u0005\u0015\t%O]1z\u0011!\t\u0019\u000e\u0007I\u0001\u0002\u00049\u0015AB5t%>|G/A\fd_:4XM\u001d;PE*,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u001c\u0016\u0004\u000f\u0006m7FAAo!\u0011\ty.!;\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dh&\u0001\u0006b]:|G/\u0019;j_:LA!a;\u0002b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0015\r|gN^3si6\u000b\u0007\u000f\u0006\u0004\u0002r\u0006]\u0018\u0011 \t\u0004{\u0006M\u0018bAA{}\n9Q*\u00199ECR\f\u0007BBAS5\u0001\u0007A\u000bC\u0004\u0002|j\u0001\r!!\u001c\u0002\u001d\u0019LW\r\u001c3D_:4XM\u001d;fe\u0006a1m\u001c8wKJ$\u0018I\u001d:bsR1!\u0011\u0001B\u0004\u0005\u0013\u00012! B\u0002\u0013\r\u0011)A \u0002\n\u0003J\u0014\u0018-\u001f#bi\u0006Da!!*\u001c\u0001\u0004!\u0006bBA~7\u0001\u0007\u0011QN\u0001\u0006a\u0006\u00148/Z\u000b\u0005\u0005\u001f\u00119\u0002F\u0004d\u0005#\u0011\u0019C!\f\t\u000f\tMA\u00041\u0001\u0003\u0016\u00051!/Z2pe\u0012\u0004B!a \u0003\u0018\u00119!\u0011\u0004\u000fC\u0002\tm!!\u0001+\u0012\t\tu\u0011Q\u0012\t\u0004[\t}\u0011b\u0001B\u0011]\t9aj\u001c;iS:<\u0007b\u0002B\u00139\u0001\u0007!qE\u0001\rGJ,\u0017\r^3QCJ\u001cXM\u001d\t\b[\t%bO!\u0006U\u0013\r\u0011YC\f\u0002\n\rVt7\r^5p]JBqAa\f\u001d\u0001\u0004\u0011\t$A\u0007sK\u000e|'\u000f\u001a'ji\u0016\u0014\u0018\r\u001c\t\u0007[I\u0013)Ba\r\u0011\t\tU\"QH\u0007\u0003\u0005oQ1\u0001\u0010B\u001d\u0015\r\u0011Y\u0004J\u0001\u0007k:\u001c\u0018MZ3\n\t\t}\"q\u0007\u0002\u000b+R3\u0005h\u0015;sS:<\u0007")
public class JacksonParser
implements Logging {
    private TimestampFormatter org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter;
    private DateFormatter org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter;
    public final DataType org$apache$spark$sql$catalyst$json$JacksonParser$$schema;
    private final JSONOptions options;
    public final boolean org$apache$spark$sql$catalyst$json$JacksonParser$$allowArrayAsStructs;
    private final Function1<JsonParser, Iterable<InternalRow>> rootConverter;
    private final JsonFactory org$apache$spark$sql$catalyst$json$JacksonParser$$factory;
    private final Function1<String, BigDecimal> org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser;
    private final boolean org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public JSONOptions options() {
        return this.options;
    }

    private Function1<JsonParser, Iterable<InternalRow>> rootConverter() {
        return this.rootConverter;
    }

    public JsonFactory org$apache$spark$sql$catalyst$json$JacksonParser$$factory() {
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        JacksonParser jacksonParser = this;
        synchronized (jacksonParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampFormat(), this.options().zoneId(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter;
    }

    public TimestampFormatter org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.timestampFormatter$lzycompute() : this.org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        JacksonParser jacksonParser = this;
        synchronized (jacksonParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormat(), this.options().zoneId(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter;
    }

    public DateFormatter org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dateFormatter$lzycompute() : this.org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter;
    }

    private Function1<JsonParser, Iterable<InternalRow>> makeRootConverter(DataType dt) {
        Function1<JsonParser, Iterable<InternalRow>> function1;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            function1 = this.makeStructRootConverter(structType);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            function1 = this.makeMapRootConverter(mapType);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            function1 = this.makeArrayRootConverter(arrayType);
        } else {
            throw new MatchError((Object)dataType);
        }
        return function1;
    }

    private Function1<JsonParser, Iterable<InternalRow>> makeStructRootConverter(StructType st) {
        Function1<JsonParser, Object> elementConverter = this.makeConverter(st);
        Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)st.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
        return (Function1 & Serializable & scala.Serializable)parser -> (Iterable)this.parseJsonToken((JsonParser)parser, st, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, st, fieldConverters, (Function1)elementConverter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$1;
            private final StructType st$1;
            private final Function1[] fieldConverters$1;
            private final Function1 elementConverter$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                Object var5_4 = null;
                A1 A1 = x1;
                if (JsonToken.START_OBJECT.equals(A1)) {
                    object = Option$.MODULE$.option2Iterable((Option)new Some((Object)this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$1, this.st$1, this.fieldConverters$1, true)));
                    return (B1)object;
                }
                if (JsonToken.START_ARRAY.equals(A1)) {
                    bl = true;
                    var5_4 = A1;
                    if (this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$allowArrayAsStructs) {
                        ArrayData array = this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$1, (Function1<JsonParser, Object>)this.elementConverter$1);
                        object = array.numElements() == 0 ? Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class))) : Predef$.MODULE$.wrapRefArray((Object[])array.toArray(this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$schema, ClassTag$.MODULE$.apply(InternalRow.class)));
                        return (B1)object;
                    }
                }
                if (bl) {
                    throw new RuntimeException("Parsing JSON arrays as structs is forbidden.");
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(JsonToken x1) {
                boolean bl = false;
                JsonToken jsonToken = null;
                JsonToken jsonToken2 = x1;
                if (JsonToken.START_OBJECT.equals(jsonToken2)) {
                    return true;
                }
                if (JsonToken.START_ARRAY.equals(jsonToken2)) {
                    bl = true;
                    jsonToken = jsonToken2;
                    if (this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$allowArrayAsStructs) {
                        return true;
                    }
                }
                if (!bl) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$1 = parser$1;
                this.st$1 = st$1;
                this.fieldConverters$1 = fieldConverters$1;
                this.elementConverter$1 = elementConverter$1;
            }
        });
    }

    private Function1<JsonParser, Iterable<InternalRow>> makeMapRootConverter(MapType mt) {
        Function1<JsonParser, Object> fieldConverter = this.makeConverter(mt.valueType());
        return (Function1 & Serializable & scala.Serializable)parser -> (Iterable)this.parseJsonToken((JsonParser)parser, mt, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)fieldConverter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$2;
            private final Function1 fieldConverter$1;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = JsonToken.START_OBJECT.equals(A1) ? Option$.MODULE$.option2Iterable((Option)new Some((Object)InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(this.parser$2, (Function1<JsonParser, Object>)this.fieldConverter$1)})))) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$2 = parser$2;
                this.fieldConverter$1 = fieldConverter$1;
            }
        });
    }

    private Function1<JsonParser, Iterable<InternalRow>> makeArrayRootConverter(ArrayType at) {
        Function1<JsonParser, Object> elemConverter = this.makeConverter(at.elementType());
        return (Function1 & Serializable & scala.Serializable)parser -> (Iterable)this.parseJsonToken((JsonParser)parser, at, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)elemConverter, at){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$3;
            private final Function1 elemConverter$1;
            private final ArrayType at$1;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (JsonToken.START_ARRAY.equals(A1)) {
                    object = Option$.MODULE$.option2Iterable((Option)new Some((Object)InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$3, (Function1<JsonParser, Object>)this.elemConverter$1)}))));
                } else if (JsonToken.START_OBJECT.equals(A1) && this.at$1.elementType() instanceof StructType) {
                    StructType st = (StructType)this.at$1.elementType();
                    Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)st.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> $this.$outer.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
                    object = Option$.MODULE$.option2Iterable((Option)new Some((Object)InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new GenericArrayData((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$3, st, fieldConverters, this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject$default$4())}))))}))));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                boolean bl = JsonToken.START_ARRAY.equals(jsonToken) ? true : JsonToken.START_OBJECT.equals(jsonToken) && this.at$1.elementType() instanceof StructType;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$3 = parser$3;
                this.elemConverter$1 = elemConverter$1;
                this.at$1 = at$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.types.StructField ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeArrayRootConverter$1$1 org.apache.spark.sql.types.DataType )}, serializedLambda);
            }
        });
    }

    public Function1<String, BigDecimal> org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser() {
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser;
    }

    public Function1<JsonParser, Object> makeConverter(DataType dataType2) {
        Function1 & Serializable & scala.Serializable intersect;
        DataType dataType3 = dataType2;
        if (BooleanType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Boolean)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = JsonToken.VALUE_TRUE.equals(A1) ? Predef$.MODULE$.boolean2Boolean(true) : (JsonToken.VALUE_FALSE.equals(A1) ? Predef$.MODULE$.boolean2Boolean(false) : function1.apply(x1));
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x1) {
                    JsonToken jsonToken = x1;
                    boolean bl = JsonToken.VALUE_TRUE.equals(jsonToken) ? true : JsonToken.VALUE_FALSE.equals(jsonToken);
                    return bl;
                }
            });
        } else if (ByteType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Byte)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$4;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.byte2Byte(this.parser$4.getByteValue()) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x2) {
                    JsonToken jsonToken = x2;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$4 = parser$4;
                }
            });
        } else if (ShortType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Short)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$5;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.short2Short(this.parser$5.getShortValue()) : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x3) {
                    JsonToken jsonToken = x3;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$5 = parser$5;
                }
            });
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Integer)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$6;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.int2Integer(this.parser$6.getIntValue()) : function1.apply(x4);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x4) {
                    JsonToken jsonToken = x4;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$6 = parser$6;
                }
            });
        } else if (LongType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$7;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    A1 A1 = x5;
                    Object object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.long2Long(this.parser$7.getLongValue()) : function1.apply(x5);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x5) {
                    JsonToken jsonToken = x5;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$7 = parser$7;
                }
            });
        } else if (FloatType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Float)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$8;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x6;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Predef$.MODULE$.float2Float(this.parser$8.getFloatValue());
                    } else if (JsonToken.VALUE_STRING.equals(A1) && this.parser$8.getTextLength() >= 1) {
                        Float f;
                        String string = this.parser$8.getText();
                        if ("NaN".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.NaN);
                        } else if ("Infinity".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.POSITIVE_INFINITY);
                        } else if ("-Infinity".equals(string)) {
                            f = Predef$.MODULE$.float2Float(Float.NEGATIVE_INFINITY);
                        } else {
                            throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(FloatType$.MODULE$.catalogString()).append(".").toString());
                        }
                        object = f;
                    } else {
                        object = function1.apply(x6);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x6) {
                    JsonToken jsonToken = x6;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$8.getTextLength() >= 1;
                    return bl2;
                }
                {
                    this.parser$8 = parser$8;
                }
            });
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Double)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$9;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x7;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Predef$.MODULE$.double2Double(this.parser$9.getDoubleValue());
                    } else if (JsonToken.VALUE_STRING.equals(A1) && this.parser$9.getTextLength() >= 1) {
                        Double d;
                        String string = this.parser$9.getText();
                        if ("NaN".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.NaN);
                        } else if ("Infinity".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.POSITIVE_INFINITY);
                        } else if ("-Infinity".equals(string)) {
                            d = Predef$.MODULE$.double2Double(Double.NEGATIVE_INFINITY);
                        } else {
                            throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(DoubleType$.MODULE$.catalogString()).append(".").toString());
                        }
                        object = d;
                    } else {
                        object = function1.apply(x7);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x7) {
                    JsonToken jsonToken = x7;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$9.getTextLength() >= 1;
                    return bl2;
                }
                {
                    this.parser$9 = parser$9;
                }
            });
        } else if (StringType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (UTF8String)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$10;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                    UTF8String uTF8String;
                    A1 A1 = x8;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        uTF8String = UTF8String.fromString((String)this.parser$10.getText());
                    } else {
                        ByteArrayOutputStream writer = new ByteArrayOutputStream();
                        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$factory().createGenerator((OutputStream)writer, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> {
                            $anonfun$$nestedInanonfun$makeConverter$8$1.$anonfun$applyOrElse$4(this, generator);
                            return BoxedUnit.UNIT;
                        });
                        uTF8String = UTF8String.fromBytes((byte[])writer.toByteArray());
                    }
                    return (B1)uTF8String;
                }

                public final boolean isDefinedAt(JsonToken x8) {
                    JsonToken jsonToken = x8;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) ? true : true;
                    return bl;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$4($anonfun$$nestedInanonfun$makeConverter$8$1 $this, JsonGenerator generator) {
                    generator.copyCurrentStructure($this.parser$10);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$10 = parser$10;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$8$1 java.io.ByteArrayOutputStream ), $anonfun$applyOrElse$4$adapted(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$8$1 com.fasterxml.jackson.core.JsonGenerator )}, serializedLambda);
                }
            });
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$11;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x9;
                    if (JsonToken.VALUE_STRING.equals(A1) && this.parser$11.getTextLength() >= 1) {
                        Long l;
                        try {
                            l = Predef$.MODULE$.long2Long(this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$timestampFormatter().parse(this.parser$11.getText()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            UTF8String str = UTF8String.fromString((String)DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(this.parser$11.getText()));
                            Long l2 = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(str, this.$outer.options().zoneId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                throw e;
                            })));
                            l = l2;
                        }
                        object = l;
                    } else {
                        object = JsonToken.VALUE_NUMBER_INT.equals(A1) ? Predef$.MODULE$.long2Long(this.parser$11.getLongValue() * 1000000L) : function1.apply(x9);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x9) {
                    JsonToken jsonToken = x9;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$11.getTextLength() >= 1 ? true : JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$11 = parser$11;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(java.lang.Throwable )}, serializedLambda);
                }
            });
        } else if (DateType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Integer)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$12;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x10;
                    if (JsonToken.VALUE_STRING.equals(A1) && this.parser$12.getTextLength() >= 1) {
                        Integer n;
                        try {
                            n = Predef$.MODULE$.int2Integer(this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$dateFormatter().parse(this.parser$12.getText()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)option.get();
                            UTF8String str = UTF8String.fromString((String)DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(this.parser$12.getText()));
                            Integer n2 = (Integer)DateTimeUtils$.MODULE$.stringToDate(str, this.$outer.options().zoneId()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                                int n;
                                try {
                                    n = RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(new StringOps(Predef$.MODULE$.augmentString($this.parser$12.getText())).toInt());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw e;
                                }
                                return n;
                            });
                            n = n2;
                        }
                        object = n;
                    } else {
                        object = function1.apply(x10);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x10) {
                    JsonToken jsonToken = x10;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$12.getTextLength() >= 1;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$12 = parser$12;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(org.apache.spark.sql.catalyst.json.JacksonParser$$anonfun$$nestedInanonfun$makeConverter$10$1 java.lang.Throwable )}, serializedLambda);
                }
            });
        } else if (BinaryType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (byte[])this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$13;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                    A1 A1 = x11;
                    Object object = JsonToken.VALUE_STRING.equals(A1) ? this.parser$13.getBinaryValue() : (Object)function1.apply(x11);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x11) {
                    JsonToken jsonToken = x11;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$13 = parser$13;
                }
            });
        } else if (dataType3 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType3;
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (Decimal)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, decimalType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$14;
                private final DecimalType x13$1;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x12;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1);
                    if (bl) {
                        object = Decimal$.MODULE$.apply(this.parser$14.getDecimalValue(), this.x13$1.precision(), this.x13$1.scale());
                    } else if (JsonToken.VALUE_STRING.equals(A1) && this.parser$14.getTextLength() >= 1) {
                        BigDecimal bigDecimal = (BigDecimal)this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser().apply((Object)this.parser$14.getText());
                        object = Decimal$.MODULE$.apply(bigDecimal, this.x13$1.precision(), this.x13$1.scale());
                    } else {
                        object = function1.apply(x12);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x12) {
                    JsonToken jsonToken = x12;
                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                    boolean bl2 = bl ? true : JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$14.getTextLength() >= 1;
                    return bl2;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$14 = parser$14;
                    this.x13$1 = x13$1;
                }
            });
        } else if (CalendarIntervalType$.MODULE$.equals(dataType3)) {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (CalendarInterval)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$15;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                    A1 A1 = x13;
                    Object object = JsonToken.VALUE_STRING.equals(A1) ? IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)this.parser$15.getText())) : function1.apply(x13);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x13) {
                    JsonToken jsonToken = x13;
                    boolean bl = JsonToken.VALUE_STRING.equals(jsonToken);
                    return bl;
                }
                {
                    this.parser$15 = parser$15;
                }
            });
        } else if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (InternalRow)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, structType, fieldConverters){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$16;
                private final StructType x15$1;
                private final Function1[] fieldConverters$2;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                    A1 A1 = x14;
                    Object object = JsonToken.START_OBJECT.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(this.parser$16, this.x15$1, this.fieldConverters$2, this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject$default$4()) : function1.apply(x14);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x14) {
                    JsonToken jsonToken = x14;
                    boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$16 = parser$16;
                    this.x15$1 = x15$1;
                    this.fieldConverters$2 = fieldConverters$2;
                }
            });
        } else if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            Function1<JsonParser, Object> elementConverter = this.makeConverter(arrayType.elementType());
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (ArrayData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)elementConverter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$17;
                private final Function1 elementConverter$2;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                    A1 A1 = x15;
                    Object object = JsonToken.START_ARRAY.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(this.parser$17, (Function1<JsonParser, Object>)this.elementConverter$2) : function1.apply(x15);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x15) {
                    JsonToken jsonToken = x15;
                    boolean bl = JsonToken.START_ARRAY.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$17 = parser$17;
                    this.elementConverter$2 = elementConverter$2;
                }
            });
        } else if (dataType3 instanceof MapType) {
            MapType mapType = (MapType)dataType3;
            Function1<JsonParser, Object> valueConverter = this.makeConverter(mapType.valueType());
            intersect = (Function1 & Serializable & scala.Serializable)parser -> (MapData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)valueConverter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonParser $outer;
                private final JsonParser parser$18;
                private final Function1 valueConverter$1;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x16, Function1<A1, B1> function1) {
                    A1 A1 = x16;
                    Object object = JsonToken.START_OBJECT.equals(A1) ? this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(this.parser$18, (Function1<JsonParser, Object>)this.valueConverter$1) : function1.apply(x16);
                    return (B1)object;
                }

                public final boolean isDefinedAt(JsonToken x16) {
                    JsonToken jsonToken = x16;
                    boolean bl = JsonToken.START_OBJECT.equals(jsonToken);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$18 = parser$18;
                    this.valueConverter$1 = valueConverter$1;
                }
            });
        } else if (dataType3 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            intersect = this.makeConverter(userDefinedType.sqlType());
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)parser -> this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)PartialFunction$.MODULE$.empty());
        }
        return intersect;
    }

    private <R> R parseJsonToken(JsonParser parser, DataType dataType, PartialFunction<JsonToken, R> f) {
        JsonToken jsonToken;
        while (JsonToken.FIELD_NAME.equals(jsonToken = parser.getCurrentToken())) {
            parser.nextToken();
        }
        boolean bl = jsonToken == null ? true : JsonToken.VALUE_NULL.equals(jsonToken);
        Object object = bl ? null : f.applyOrElse((Object)jsonToken, this.failedConversion(parser, dataType));
        return (R)object;
    }

    public boolean org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString() {
        return this.org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString;
    }

    private <R> PartialFunction<JsonToken, R> failedConversion(JsonParser parser, DataType dataType) {
        return new scala.Serializable(this, parser, dataType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonParser $outer;
            private final JsonParser parser$19;
            private final DataType dataType$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                Object var7_4 = null;
                A1 A1 = x1;
                if (JsonToken.VALUE_STRING.equals(A1)) {
                    bl = true;
                    var7_4 = A1;
                    if (this.parser$19.getTextLength() < 1 && this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString()) {
                        B1 B1;
                        DataType dataType = this.dataType$2;
                        boolean bl2 = FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType)));
                        if (bl2) {
                            throw new RuntimeException(new StringBuilder(46).append("Failed to parse an empty string for data type ").append(this.dataType$2.catalogString()).toString());
                        }
                        B1 B12 = B1 = null;
                        return B12;
                    }
                }
                if (!bl) throw new RuntimeException(new StringBuilder(57).append("Failed to parse a value for data type ").append(this.dataType$2.catalogString()).append(" (current token: ").append(A1).append(").").toString());
                if (this.parser$19.getTextLength() >= 1) throw new RuntimeException(new StringBuilder(57).append("Failed to parse a value for data type ").append(this.dataType$2.catalogString()).append(" (current token: ").append(A1).append(").").toString());
                throw new RuntimeException(new StringBuilder(46).append("Failed to parse an empty string for data type ").append(this.dataType$2.catalogString()).toString());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(JsonToken x1) {
                boolean bl = false;
                JsonToken jsonToken = null;
                JsonToken jsonToken2 = x1;
                if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
                    bl = true;
                    jsonToken = jsonToken2;
                    if (this.parser$19.getTextLength() < 1 && this.$outer.org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString()) {
                        return true;
                    }
                }
                if (!bl) return true;
                if (this.parser$19.getTextLength() >= 1) return true;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$19 = parser$19;
                this.dataType$2 = dataType$2;
            }
        };
    }

    public InternalRow org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject(JsonParser parser, StructType schema, Function1<JsonParser, Object>[] fieldConverters, boolean isRoot) {
        GenericInternalRow row = new GenericInternalRow(schema.length());
        None$ badRecordException = None$.MODULE$;
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            JsonParser jsonParser;
            Option<Object> option;
            block10: {
                BoxedUnit boxedUnit;
                option = schema.getFieldIndex(parser.getCurrentName());
                if (!(option instanceof Some)) break block10;
                Some some = (Some)option;
                int index = BoxesRunTime.unboxToInt((Object)some.value());
                try {
                    row.update(index, fieldConverters[index].apply((Object)parser));
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable e;
                    block12: {
                        block11: {
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof SparkUpgradeException) {
                                SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable2;
                                throw sparkUpgradeException;
                            }
                            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                            if (option2.isEmpty()) break block11;
                            e = (Throwable)option2.get();
                            if (isRoot) break block12;
                        }
                        throw throwable;
                    }
                    badRecordException = badRecordException.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)e));
                    JsonParser jsonParser2 = parser.skipChildren();
                    boxedUnit = jsonParser2;
                }
                jsonParser = boxedUnit;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                jsonParser = parser.skipChildren();
                continue;
            }
            throw new MatchError(option);
        }
        if (!badRecordException.isEmpty()) {
            throw new PartialResultException(row, (Throwable)badRecordException.get());
        }
        return row;
    }

    public boolean org$apache$spark$sql$catalyst$json$JacksonParser$$convertObject$default$4() {
        return false;
    }

    public MapData org$apache$spark$sql$catalyst$json$JacksonParser$$convertMap(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            keys.$plus$eq((Object)UTF8String.fromString((String)parser.getCurrentName()));
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return ArrayBasedMapData$.MODULE$.apply(keys.toArray(ClassTag$.MODULE$.apply(UTF8String.class)), values.toArray(ClassTag$.MODULE$.Any()));
    }

    public ArrayData org$apache$spark$sql$catalyst$json$JacksonParser$$convertArray(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return new GenericArrayData((Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    public <T> Iterable<InternalRow> parse(T record, Function2<JsonFactory, T, JsonParser> createParser, Function1<T, UTF8String> recordLiteral) {
        Iterable iterable;
        try {
            iterable = (Iterable)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory(), record), (Function1 & Serializable & scala.Serializable)parser -> {
                Iterable iterable;
                JsonToken jsonToken = parser.nextToken();
                if (jsonToken == null) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    Iterable iterable2;
                    Iterable iterable3 = (Iterable)this.rootConverter().apply(parser);
                    if (iterable3 == null) {
                        throw new RuntimeException("Root converter returned null");
                    }
                    iterable = iterable2 = iterable3;
                }
                return iterable;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SparkUpgradeException) {
                SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable2;
                throw sparkUpgradeException;
            }
            boolean bl = throwable2 instanceof RuntimeException ? true : (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException);
            if (bl) {
                throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, throwable2);
            }
            if (throwable2 instanceof CharConversionException) {
                CharConversionException charConversionException = (CharConversionException)throwable2;
                if (this.options().encoding().isEmpty()) {
                    String msg = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n            |Specifying encoding as an input option explicitly might help to resolve the issue.\n            |")).stripMargin()).append(charConversionException.getMessage()).toString();
                    CharConversionException wrappedCharException = new CharConversionException(msg);
                    wrappedCharException.initCause(charConversionException);
                    throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, wrappedCharException);
                }
            }
            if (throwable2 instanceof PartialResultException) {
                PartialResultException partialResultException = (PartialResultException)throwable2;
                InternalRow row = partialResultException.partialResult();
                Throwable cause = partialResultException.cause();
                throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> new Some((Object)row), cause);
            }
            throw throwable;
        }
        return iterable;
    }

    public JacksonParser(DataType schema, JSONOptions options, boolean allowArrayAsStructs) {
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$schema = schema;
        this.options = options;
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$allowArrayAsStructs = allowArrayAsStructs;
        Logging.$init$((Logging)this);
        this.rootConverter = this.makeRootConverter(schema);
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$factory = options.buildJsonFactory();
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.org$apache$spark$sql$catalyst$json$JacksonParser$$allowEmptyString = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_ALLOW_EMPTY_STRING_IN_JSON()));
    }
}

