/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regex, limit) - Splits `str` around occurrences that match `regex` and returns an array with a length of at most `limit`", arguments="\n    Arguments:\n      * str - a string expression to split.\n      * regex - a string representing a regular expression. The regex string should be a\n        Java regular expression.\n      * limit - an integer expression which controls the number of times the regex is applied.\n          * limit > 0: The resulting array's length will not be more than `limit`,\n            and the resulting array's last entry will contain all input\n            beyond the last matched regex.\n          * limit <= 0: `regex` will be applied as many times as possible, and\n            the resulting array can be of any size.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', -1);\n       [\"one\",\"two\",\"three\",\"\"]\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]', 2);\n       [\"one\",\"twoBthreeC\"]\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011!9\u0005A!f\u0001\n\u0003\u0001\u0005\u0002\u0003%\u0001\u0005#\u0005\u000b\u0011B!\t\u000b%\u0003A\u0011\u0001&\t\u000b=\u0003A\u0011\t)\t\u000b]\u0003A\u0011\t-\t\u000b\u0015\u0004A\u0011\t4\t\u000b%\u0003A\u0011\u00015\t\u000b1\u0004A\u0011I7\t\u000bU\u0004A\u0011\t<\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!I\u0011Q\u0004\u0001\u0002\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0003O\u0001\u0011\u0013!C\u0001\u0003SA\u0011\"a\u0010\u0001#\u0003%\t!!\u000b\t\u0013\u0005\u0005\u0003!%A\u0005\u0002\u0005%\u0002\"CA\"\u0001\u0005\u0005I\u0011IA#\u0011%\t)\u0006AA\u0001\n\u0003\t9\u0006C\u0005\u0002`\u0001\t\t\u0011\"\u0001\u0002b!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000e\u0005\n\u0003o\u0002\u0011\u0011!C\u0001\u0003sB\u0011\"a!\u0001\u0003\u0003%\t%!\"\b\u0013\u0005%\u0016%!A\t\u0002\u0005-f\u0001\u0003\u0011\"\u0003\u0003E\t!!,\t\r%SB\u0011AA^\u0011%\tiLGA\u0001\n\u000b\ny\fC\u0005\u0002Bj\t\t\u0011\"!\u0002D\"I\u00111\u001a\u000e\u0002\u0002\u0013\u0005\u0015Q\u001a\u0005\n\u0003?T\u0012\u0011!C\u0005\u0003C\u00141b\u0015;sS:<7\u000b\u001d7ji*\u0011!eI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002%K\u0005A1-\u0019;bYf\u001cHO\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001_M2D\b\u0005\u00021c5\t\u0011%\u0003\u00023C\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005A\"\u0014BA\u001b\"\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$a\u0002)s_\u0012,8\r\u001e\t\u0003ouJ!A\u0010\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007M$(/F\u0001B!\t\u0001$)\u0003\u0002DC\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\tM$(\u000fI\u0001\u0006e\u0016<W\r_\u0001\u0007e\u0016<W\r\u001f\u0011\u0002\u000b1LW.\u001b;\u0002\r1LW.\u001b;!\u0003\u0019a\u0014N\\5u}Q!1\nT'O!\t\u0001\u0004\u0001C\u0003@\u000f\u0001\u0007\u0011\tC\u0003F\u000f\u0001\u0007\u0011\tC\u0003H\u000f\u0001\u0007\u0011)\u0001\u0005eCR\fG+\u001f9f+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+&\u0003\u0015!\u0018\u0010]3t\u0013\t16K\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u00023B\u0019!LY)\u000f\u0005m\u0003gB\u0001/`\u001b\u0005i&B\u00010.\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u0002bq\u00059\u0001/Y2lC\u001e,\u0017BA2e\u0005\r\u0019V-\u001d\u0006\u0003Cb\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002OB\u0019!LY!\u0015\u0007-K7\u000eC\u0003k\u0017\u0001\u0007\u0011)A\u0002fqBDQ!R\u0006A\u0002\u0005\u000bAB\\;mYN\u000bg-Z#wC2$BA\\9tiB\u0011qg\\\u0005\u0003ab\u00121!\u00118z\u0011\u0015\u0011H\u00021\u0001o\u0003\u0019\u0019HO]5oO\")Q\t\u0004a\u0001]\")q\t\u0004a\u0001]\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005ov\f)\u0001\u0005\u0002yw6\t\u0011P\u0003\u0002{C\u000591m\u001c3fO\u0016t\u0017B\u0001?z\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002@\u000e\u0001\u0004y\u0018aA2uqB\u0019\u00010!\u0001\n\u0007\u0005\r\u0011P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005\u001dQ\u00021\u0001x\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0004\u0011\t\u0005=\u0011q\u0003\b\u0005\u0003#\t\u0019\u0002\u0005\u0002]q%\u0019\u0011Q\u0003\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)\u0002O\u0001\u0005G>\u0004\u0018\u0010F\u0004L\u0003C\t\u0019#!\n\t\u000f}z\u0001\u0013!a\u0001\u0003\"9Qi\u0004I\u0001\u0002\u0004\t\u0005bB$\u0010!\u0003\u0005\r!Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYCK\u0002B\u0003[Y#!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003sA\u0014AC1o]>$\u0018\r^5p]&!\u0011QHA\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\nA\u0001\\1oO*\u0011\u0011\u0011K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001a\u0005-\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA-!\r9\u00141L\u0005\u0004\u0003;B$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00018\u0002d!I\u0011QM\u000b\u0002\u0002\u0003\u0007\u0011\u0011L\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005-\u0004#BA7\u0003grWBAA8\u0015\r\t\t\bO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA;\u0003_\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111PAA!\r9\u0014QP\u0005\u0004\u0003\u007fB$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003K:\u0012\u0011!a\u0001]\u00061Q-];bYN$B!a\u001f\u0002\b\"A\u0011Q\r\r\u0002\u0002\u0003\u0007a\u000eK\n\u0001\u0003\u0017\u000b\t*a%\u0002\u0018\u0006e\u0015QTAP\u0003G\u000b)\u000bE\u00021\u0003\u001bK1!a$\"\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!&\u0002\u0003\u0013yf)\u0016(D?\"\u001aHO\u001d\u0017!e\u0016<W\r\u001f\u0017!Y&l\u0017\u000e^\u0015![\u0001\u001a\u0006\u000f\\5ug\u0002\u00027\u000f\u001e:aA\u0005\u0014x.\u001e8eA=\u001c7-\u001e:sK:\u001cWm\u001d\u0011uQ\u0006$\b%\\1uG\"\u0004\u0003M]3hKb\u0004\u0007%\u00198eAI,G/\u001e:og\u0002\ng\u000eI1se\u0006L\be^5uQ\u0002\n\u0007\u0005\\3oORD\u0007e\u001c4!CR\u0004Sn\\:uA\u0001d\u0017.\\5uA\u0006I\u0011M]4v[\u0016tGo]\u0011\u0003\u00037\u000bA\u0011\u0019\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011u_\u0002\u001a\b\u000f\\5u])\u0001\u0003\u0005\t\u0011!A)\u0002#/Z4fq\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011sKB\u0014Xm]3oi&tw\rI1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gN\f\u0011UQ\u0016\u0004#/Z4fq\u0002\u001aHO]5oO\u0002\u001a\bn\\;mI\u0002\u0012W\rI1\u000bA\u0001\u0002\u0003\u0005\t\u0011!A)\u000bg/\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>tgF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011mS6LG\u000fI\u0017!C:\u0004\u0013N\u001c;fO\u0016\u0014\b%\u001a=qe\u0016\u001c8/[8oA]D\u0017n\u00195!G>tGO]8mg\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002\"\u0018.\\3tAQDW\r\t:fO\u0016D\b%[:!CB\u0004H.[3e])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0016!Y&l\u0017\u000e\u001e\u0011?AAR\u0004\u0005\u00165fAI,7/\u001e7uS:<\u0007%\u0019:sCf<3\u000f\t7f]\u001e$\b\u000eI<jY2\u0004cn\u001c;!E\u0016\u0004Sn\u001c:fAQD\u0017M\u001c\u0011aY&l\u0017\u000e\u001e1-\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004C\u000f[3!e\u0016\u001cX\u000f\u001c;j]\u001e\u0004\u0013M\u001d:bs\u001e\u001a\b\u0005\\1ti\u0002*g\u000e\u001e:zA]LG\u000e\u001c\u0011d_:$\u0018-\u001b8!C2d\u0007%\u001b8qkRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\t,\u0017p\u001c8eAQDW\r\t7bgR\u0004S.\u0019;dQ\u0016$\u0007E]3hKbt#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!U\u0001b\u0017.\\5uAqj\u0004\u0005\r\u001e!AJ,w-\u001a=aA]LG\u000e\u001c\u0011cK\u0002\n\u0007\u000f\u001d7jK\u0012\u0004\u0013m\u001d\u0011nC:L\b\u0005^5nKN\u0004\u0013m\u001d\u0011q_N\u001c\u0018N\u00197fY\u0001\ng\u000e\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u001e5fAI,7/\u001e7uS:<\u0007%\u0019:sCf\u00043-\u00198!E\u0016\u0004sN\u001a\u0011b]f\u00043/\u001b>f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\t+\u0001B\u000b\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":sN\\3Bi^|'\t\u001e5sK\u0016\u001cu\u0005\f\u0011(7\u0006\u00135)X\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&e\u001c8fE1\u0012Co^8#Y\t\"\bN]3fE1\u0012#%\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O=tW-\u0011;x_\n#\bN]3f\u0007\u001eb\u0003eJ.B\u0005\u000ekv\u0005\f\u0011.c%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012p]\u0016\u0014CF\t;x_\nb#\u0005\u001e5sK\u0016\u0014CF\t\u0012^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":sN\\3Bi^|'\t\u001e5sK\u0016\u001cu\u0005\f\u0011(7\u0006\u00135)X\u0014-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.#_:,'\u0005\f\u0012uo>\u0014E\u000f\u001b:fK\u000e\u0013SL\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t9+A\u00032]Ur\u0003'A\u0006TiJLgnZ*qY&$\bC\u0001\u0019\u001b'\u0011Q\u0012q\u0016\u001f\u0011\u0011\u0005E\u0016qW!B\u0003.k!!a-\u000b\u0007\u0005U\u0006(A\u0004sk:$\u0018.\\3\n\t\u0005e\u00161\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAV\u0003!!xn\u0015;sS:<GCAA$\u0003\u0015\t\u0007\u000f\u001d7z)\u001dY\u0015QYAd\u0003\u0013DQaP\u000fA\u0002\u0005CQ!R\u000fA\u0002\u0005CQaR\u000fA\u0002\u0005\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002P\u0006m\u0007#B\u001c\u0002R\u0006U\u0017bAAjq\t1q\n\u001d;j_:\u0004baNAl\u0003\u0006\u000b\u0015bAAmq\t1A+\u001e9mKNB\u0001\"!8\u001f\u0003\u0003\u0005\raS\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a9\u0011\t\u0005%\u0013Q]\u0005\u0005\u0003O\fYE\u0001\u0004PE*,7\r\u001e")
public class StringSplit
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression str;
    private final Expression regex;
    private final Expression limit;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringSplit stringSplit) {
        return StringSplit$.MODULE$.unapply(stringSplit);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringSplit>>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression regex() {
        return this.regex;
    }

    public Expression limit() {
        return this.limit;
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.regex();
        Expression expression3 = this.limit();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Object nullSafeEval(Object string, Object regex, Object limit) {
        UTF8String[] strings = ((UTF8String)string).split((UTF8String)regex, BoxesRunTime.unboxToInt((Object)limit));
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, regex, limit) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(19).append(ev.value()).append(" = new ").append(arrayClass).append("(").append((String)str).append(".split(").append((String)regex).append(",").append((String)limit).append("));").toString())).stripMargin());
    }

    @Override
    public String prettyName() {
        return "split";
    }

    public StringSplit copy(Expression str, Expression regex, Expression limit) {
        return new StringSplit(str, regex, limit);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.regex();
    }

    public Expression copy$default$3() {
        return this.limit();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.regex();
                break;
            }
            case 2: {
                expression = this.limit();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regex();
        Expression expression4 = stringSplit.regex();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.limit();
        Expression expression6 = stringSplit.limit();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression regex, Expression limit) {
        this.str = str;
        this.regex = regex;
        this.limit = limit;
        ExpectsInputTypes.$init$(this);
    }

    public StringSplit(Expression exp, Expression regex) {
        this(exp, regex, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1)));
    }
}

