/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Like$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ pattern[ ESCAPE escape] - Returns true if str matches `pattern` with `escape`, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally, with\n          exception to the following special symbols:\n\n          _ matches any one character in the input (similar to . in posix regular expressions)\n\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)\n\n          Since Spark 2.0, string literals are unescaped in our SQL parser. For example, in order\n          to match \"\\abc\", the pattern should be \"\\\\abc\".\n\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it fallbacks\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".\n      * escape - an character added since Spark 3.0. The default escape character is the '\\'.\n          If an escape character precedes a special symbol or another escape character, the\n          following character is matched literally. It is invalid to escape any other character.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', '_park');\n      true\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\Users%';\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT '%SystemDrive%\\\\Users\\\\John' _FUNC_ '\\%SystemDrive\\%\\\\\\\\Users%';\n      true\n      > SELECT '%SystemDrive%/Users/John' _FUNC_ '/%SystemDrive/%//Users%' ESCAPE '/';\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001\u0002\u0010 \u00012B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011!\u0011\u0005A!f\u0001\n\u0003\u0019\u0005\u0002C$\u0001\u0005#\u0005\u000b\u0011\u0002#\t\u000b!\u0003A\u0011A%\t\u000b!\u0003A\u0011\u0001(\t\u000bE\u0003A\u0011\t*\t\u000b\u0001\u0004A\u0011I1\t\u000bI\u0004A\u0011I:\t\u000bQ\u0004A\u0011K;\t\u0013\u0005\u001d\u0001!!A\u0005\u0002\u0005%\u0001\"CA\t\u0001E\u0005I\u0011AA\n\u0011%\tI\u0003AI\u0001\n\u0003\t\u0019\u0002C\u0005\u0002,\u0001\t\n\u0011\"\u0001\u0002.!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003\u007f\u0001\u0011\u0011!C\u0001\u0003\u0003B\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\t\u0013\u0005]\u0003!!A\u0005B\u0005e\u0003\"CA4\u0001\u0005\u0005I\u0011AA5\u0011%\ti\u0007AA\u0001\n\u0003\nygB\u0005\u0002\u001a~\t\t\u0011#\u0001\u0002\u001c\u001aAadHA\u0001\u0012\u0003\ti\n\u0003\u0004I1\u0011\u0005\u00111\u0016\u0005\teb\t\t\u0011\"\u0012\u0002.\"I\u0011q\u0016\r\u0002\u0002\u0013\u0005\u0015\u0011\u0017\u0005\n\u0003sC\u0012\u0011!CA\u0003wC\u0011\"!4\u0019\u0003\u0003%I!a4\u0003\t1K7.\u001a\u0006\u0003A\u0005\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011!eI\u0001\tG\u0006$\u0018\r\\=ti*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M!\u0001!L\u00198!\tqs&D\u0001 \u0013\t\u0001tDA\u000bTiJLgn\u001a*fO\u0016DX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u000fA\u0013x\u000eZ;diB\u0011!\u0007O\u0005\u0003sM\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\tA\b\u0005\u0002/{%\u0011ah\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0006fg\u000e\f\u0007/Z\"iCJ,\u0012\u0001\u0012\t\u0003e\u0015K!AR\u001a\u0003\t\rC\u0017M]\u0001\fKN\u001c\u0017\r]3DQ\u0006\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005\u0015.cU\n\u0005\u0002/\u0001!)!h\u0002a\u0001y!)\u0001i\u0002a\u0001y!)!i\u0002a\u0001\tR\u0019!j\u0014)\t\u000biB\u0001\u0019\u0001\u001f\t\u000b\u0001C\u0001\u0019\u0001\u001f\u0002\r\u0015\u001c8-\u00199f)\t\u0019f\f\u0005\u0002U7:\u0011Q+\u0017\t\u0003-Nj\u0011a\u0016\u0006\u00031.\na\u0001\u0010:p_Rt\u0014B\u0001.4\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u001b\u0004\"B0\n\u0001\u0004\u0019\u0016!\u0001<\u0002\u000f5\fGo\u00195fgR\u0019!-\u001a9\u0011\u0005I\u001a\u0017B\u000134\u0005\u001d\u0011un\u001c7fC:DQA\u001a\u0006A\u0002\u001d\fQA]3hKb\u0004\"\u0001\u001b8\u000e\u0003%T!A\u001a6\u000b\u0005-d\u0017\u0001B;uS2T\u0011!\\\u0001\u0005U\u00064\u0018-\u0003\u0002pS\n9\u0001+\u0019;uKJt\u0007\"B9\u000b\u0001\u0004\u0019\u0016aA:ue\u0006AAo\\*ue&tw\rF\u0001T\u0003%!wnR3o\u0007>$W\r\u0006\u0003wy\u0006\r\u0001CA<{\u001b\u0005A(BA= \u0003\u001d\u0019w\u000eZ3hK:L!a\u001f=\u0003\u0011\u0015C\bO]\"pI\u0016DQ! \u0007A\u0002y\f1a\u0019;y!\t9x0C\u0002\u0002\u0002a\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u00061\u0001\rA^\u0001\u0003KZ\fAaY8qsR9!*a\u0003\u0002\u000e\u0005=\u0001b\u0002\u001e\u000e!\u0003\u0005\r\u0001\u0010\u0005\b\u00016\u0001\n\u00111\u0001=\u0011\u001d\u0011U\u0002%AA\u0002\u0011\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0016)\u001aA(a\u0006,\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\t4\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\tiBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005=\"f\u0001#\u0002\u0018\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u000e\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000fm\u0003\u0011a\u0017M\\4\n\u0007q\u000bI$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002DA\u0019!'!\u0012\n\u0007\u0005\u001d3GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002N\u0005M\u0003c\u0001\u001a\u0002P%\u0019\u0011\u0011K\u001a\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002VM\t\t\u00111\u0001\u0002D\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0017\u0011\r\u0005u\u00131MA'\u001b\t\tyFC\u0002\u0002bM\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)'a\u0018\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004E\u0006-\u0004\"CA++\u0005\u0005\t\u0019AA'\u0003\u0019)\u0017/^1mgR\u0019!-!\u001d\t\u0013\u0005Uc#!AA\u0002\u00055\u0003f\u0006\u0001\u0002v\u0005m\u0014QPAA\u0003\u0007\u000b9)!#\u0002\u000e\u0006=\u00151SAK!\rq\u0013qO\u0005\u0004\u0003sz\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u007f\n\u0011QC:ue\u0002zf)\u0016(D?\u0002\u0002\u0018\r\u001e;fe:\\\u0006%R*D\u0003B+\u0005%Z:dCB,W\fI\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u001aHO\u001d\u0011nCR\u001c\u0007.Z:!AB\fG\u000f^3s]\u0002\u0004s/\u001b;iA\u0001,7oY1qK\u0002d\u0003E\\;mY\u0002Jg\rI1os\u0002\n'oZ;nK:$8\u000fI1sK\u0002rW\u000f\u001c7-A\u0019\fGn]3!_RDWM]<jg\u0016t\u0013!C1sOVlWM\u001c;tC\t\t))\u0001ER\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u0002\u0018\r\u001e;fe:\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>tg\u0006\t+iK\u0002\u0002\u0018\r\u001e;fe:\u0004\u0013n\u001d\u0011bAM$(/\u001b8hA]D\u0017n\u00195!SN\u0004S.\u0019;dQ\u0016$\u0007\u0005\\5uKJ\fG\u000e\\=-A]LG\u000f\u001b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001*\u0007pY3qi&|g\u000e\t;pAQDW\r\t4pY2|w/\u001b8hAM\u0004XmY5bY\u0002\u001a\u00180\u001c2pYNT$B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A}\u0003S.\u0019;dQ\u0016\u001c\b%\u00198zA=tW\rI2iCJ\f7\r^3sA%t\u0007\u0005\u001e5fA%t\u0007/\u001e;!QMLW.\u001b7be\u0002\"x\u000e\t\u0018!S:\u0004\u0003o\\:jq\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tS)Q\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011&A5\fGo\u00195fg\u0002RXM]8!_J\u0004Sn\u001c:fA\rD\u0017M]1di\u0016\u00148\u000fI5oAQDW\rI5oaV$\b\u0005K:j[&d\u0017M\u001d\u0011u_\u0002r#\u0006I5oAA|7/\u001b=!e\u0016<W\u000f\\1s\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a=qe\u0016\u001c8/[8og&R!\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'&t7-\u001a\u0011Ta\u0006\u00148\u000e\t\u001a/a1\u00023\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d7\u000fI1sK\u0002*h.Z:dCB,G\rI5oA=,(\u000fI*R\u0019\u0002\u0002\u0018M]:fe:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001Jg\u000eI8sI\u0016\u0014(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u0004S.\u0019;dQ\u0002\u0012C,\u00192dE1\u0002C\u000f[3!a\u0006$H/\u001a:oAMDw.\u001e7eA\t,\u0007E\t/]C\n\u001c'E\f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002s\u000b[3oAM\u000bF\nI2p]\u001aLw\rI\u0014ta\u0006\u00148NL:rY:\u0002\u0018M]:fe:*7oY1qK\u0012\u001cFO]5oO2KG/\u001a:bYN<\u0003%[:!K:\f'\r\\3eY\u0001JG\u000f\t4bY2\u0014\u0017mY6t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005^8!'B\f'o\u001b\u00112]Y\u0002#-\u001a5bm&|'\u000f\t:fO\u0006\u0014H-\u001b8hAM$(/\u001b8hA1LG/\u001a:bY\u0002\u0002\u0018M]:j]\u001et\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002\u0013N\u001a\u0011uQ\u0016\u00043m\u001c8gS\u001e\u0004\u0013n\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001*g.\u00192mK\u0012d\u0003\u0005\u001e5fAA\fG\u000f^3s]\u0002\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014\u0003e\u001d5pk2$\u0007EY3!Eq\u000b'm\u0019\u0012/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*7oY1qK\u0002j\u0003%\u00198!G\"\f'/Y2uKJ\u0004\u0013\r\u001a3fI\u0002\u001a\u0018N\\2fAM\u0003\u0018M]6!g9\u0002d\u0006\t+iK\u0002\"WMZ1vYR\u0004Sm]2ba\u0016\u00043\r[1sC\u000e$XM\u001d\u0011jg\u0002\"\b.\u001a\u0011(9\u001er#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0013M\u001c\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002\u0002(/Z2fI\u0016\u001c\b%\u0019\u0011ta\u0016\u001c\u0017.\u00197!gfl'm\u001c7!_J\u0004\u0013M\\8uQ\u0016\u0014\b%Z:dCB,\u0007e\u00195be\u0006\u001cG/\u001a:-AQDWM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019|G\u000e\\8xS:<\u0007e\u00195be\u0006\u001cG/\u001a:!SN\u0004S.\u0019;dQ\u0016$\u0007\u0005\\5uKJ\fG\u000e\\=/A%#\b%[:!S:4\u0018\r\\5eAQ|\u0007%Z:dCB,\u0007%\u00198zA=$\b.\u001a:!G\"\f'/Y2uKJt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a#\u0002\tGR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\w\u0005\f\u0011(?B\f'o[\u0014*w)\u0001\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016#\u0006e\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197t{Q\u0014X/Z\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ta\u0006\u00148NL:rY:\u0002\u0018M]:fe:*7oY1qK\u0012\u001cFO]5oO2KG/\u001a:bYNLAO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002:SeU=ti\u0016lGI]5wK\u0016bVk]3sgrSu\u000e\u001b8(A}3UKT\"`A\u001dbVeU=ti\u0016lGI]5wKr+C\fX+tKJ\u001cXeJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F)\u0002\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u001fgC2\u001cXm\u000f\u0006!A\u0001\u0002\u0003\u0005I:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mg&1\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002:SeU=ti\u0016lGI]5wK\u0016bF,V:feNdFLS8i]\u001e\u0002sLR+O\u0007~\u0003s\u0005X\u0013TsN$X-\u001c#sSZ,G,\n/]9r+6/\u001a:tK\u001dZ$\u0002\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002:SeU=ti\u0016lGI]5wK\u0016zSk]3sg>Ru\u000e\u001b8(A}3UKT\"`A\u001dzSeU=ti\u0016lGI]5wK>*sfL+tKJ\u001cXe\n\u0011F'\u000e\u000b\u0005+\u0012\u0011(_\u001dZ$\u0002\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f#!!%\u0002{)\u0001\u0003\u0005\t\u0011Vg\u0016\u0004#\u000bT%L\u000b\u0002\"x\u000eI7bi\u000eD\u0007e^5uQ\u0002\u001aH/\u00198eCJ$\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]Nt#\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005]\u0015!B\u0019/a9\u0002\u0014\u0001\u0002'jW\u0016\u0004\"A\f\r\u0014\ta\tyj\u000e\t\t\u0003C\u000b9\u000b\u0010\u001fE\u00156\u0011\u00111\u0015\u0006\u0004\u0003K\u001b\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003S\u000b\u0019KA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a'\u0015\u0005\u0005U\u0012!B1qa2LHc\u0002&\u00024\u0006U\u0016q\u0017\u0005\u0006um\u0001\r\u0001\u0010\u0005\u0006\u0001n\u0001\r\u0001\u0010\u0005\u0006\u0005n\u0001\r\u0001R\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti,!3\u0011\u000bI\ny,a1\n\u0007\u0005\u00057G\u0001\u0004PaRLwN\u001c\t\u0007e\u0005\u0015G\b\u0010#\n\u0007\u0005\u001d7G\u0001\u0004UkBdWm\r\u0005\t\u0003\u0017d\u0012\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u0004B!a\u000e\u0002T&!\u0011Q[A\u001d\u0005\u0019y%M[3di\u0002")
public class Like
extends StringRegexExpression
implements scala.Serializable {
    private final Expression left;
    private final Expression right;
    private final char escapeChar;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Like like) {
        return Like$.MODULE$.unapply(like);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, Like> tupled() {
        return Like$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Like>>> curried() {
        return Like$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public char escapeChar() {
        return this.escapeChar;
    }

    @Override
    public String escape(String v) {
        return StringUtils$.MODULE$.escapeLikeRegex(v, this.escapeChar());
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).matches();
    }

    @Override
    public String toString() {
        String string;
        char c = this.escapeChar();
        switch (c) {
            case '\\': {
                string = new StringBuilder(6).append(this.left()).append(" LIKE ").append(this.right()).toString();
                break;
            }
            default: {
                string = new StringBuilder(16).append(this.left()).append(" LIKE ").append(this.right()).append(" ESCAPE '").append(c).append("'").toString();
                break;
            }
        }
        return string;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String escapeFunc = new StringBuilder(16).append(new StringOps(Predef$.MODULE$.augmentString(StringUtils$.MODULE$.getClass().getName())).stripSuffix("$")).append(".escapeLikeRegex").toString();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)this.escape(((UTF8String)rVal).toString()));
                String pattern = ctx.addMutableState(patternClass, "patternLike", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).matches();\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String pattern = ctx.freshName("pattern");
            String rightStr = ctx.freshName("rightStr");
            String escapedEscapeChar = StringEscapeUtils.escapeJava((String)((Object)BoxesRunTime.boxToCharacter((char)this.escapeChar())).toString());
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(133).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(\n            ").append(escapeFunc).append("(").append(rightStr).append(", '").append(escapedEscapeChar).append("'));\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).matches();\n        ").toString());
        }
        return exprCode;
    }

    public Like copy(Expression left, Expression right, char escapeChar) {
        return new Like(left, right, escapeChar);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public char copy$default$3() {
        return this.escapeChar();
    }

    @Override
    public String productPrefix() {
        return "Like";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToCharacter((char)this.escapeChar());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Like;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Like)) return false;
        boolean bl = true;
        if (!bl) return false;
        Like like = (Like)x$1;
        Expression expression = this.left();
        Expression expression2 = like.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = like.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.escapeChar() != like.escapeChar()) return false;
        if (!like.canEqual(this)) return false;
        return true;
    }

    public Like(Expression left, Expression right, char escapeChar) {
        this.left = left;
        this.right = right;
        this.escapeChar = escapeChar;
    }

    public Like(Expression left, Expression right) {
        this(left, right, '\\');
    }
}

