/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.Except;
import org.apache.spark.sql.catalyst.plans.logical.Expand;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Generate;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.Intersect;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlanVisitor;
import org.apache.spark.sql.catalyst.plans.logical.Pivot;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Repartition;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.ScriptTransformation;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.plans.logical.UnaryNode;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SizeInBytesOnlyStatsPlanVisitor$
implements LogicalPlanVisitor<Statistics> {
    public static SizeInBytesOnlyStatsPlanVisitor$ MODULE$;

    static {
        new SizeInBytesOnlyStatsPlanVisitor$();
    }

    @Override
    public Object visit(LogicalPlan p) {
        return LogicalPlanVisitor.visit$(this, p);
    }

    private Statistics visitUnaryNode(UnaryNode p) {
        BigInt childRowSize = EstimationUtils$.MODULE$.getSizePerRow(p.child().output(), EstimationUtils$.MODULE$.getSizePerRow$default$2());
        BigInt outputRowSize = EstimationUtils$.MODULE$.getSizePerRow(p.output(), EstimationUtils$.MODULE$.getSizePerRow$default$2());
        BigInt sizeInBytes = p.child().stats().sizeInBytes().$times(outputRowSize).$div(childRowSize);
        if (BoxesRunTime.equalsNumObject((Number)sizeInBytes, (Object)BoxesRunTime.boxToInteger((int)0))) {
            sizeInBytes = BigInt$.MODULE$.int2bigInt(1);
        }
        BigInt x$1 = sizeInBytes;
        HintInfo x$2 = p.child().stats().hints();
        Option<BigInt> x$3 = Statistics$.MODULE$.apply$default$2();
        AttributeMap<ColumnStat> x$4 = Statistics$.MODULE$.apply$default$3();
        return new Statistics(x$1, x$3, x$4, x$2);
    }

    @Override
    public Statistics default(LogicalPlan p) {
        Statistics statistics;
        LogicalPlan logicalPlan = p;
        if (logicalPlan instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)logicalPlan;
            statistics = leafNode.computeStats();
        } else if (logicalPlan != null) {
            statistics = new Statistics((BigInt)((TraversableOnce)p.children().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.stats().sizeInBytes(), Seq$.MODULE$.canBuildFrom())).product((Numeric)Numeric.BigIntIsIntegral$.MODULE$), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
        } else {
            throw new MatchError((Object)logicalPlan);
        }
        return statistics;
    }

    @Override
    public Statistics visitAggregate(Aggregate p) {
        Statistics statistics;
        if (p.groupingExpressions().isEmpty()) {
            BigInt x$1 = EstimationUtils$.MODULE$.getOutputSize(p.output(), BigInt$.MODULE$.int2bigInt(1), EstimationUtils$.MODULE$.getOutputSize$default$3());
            Some x$2 = new Some((Object)BigInt$.MODULE$.int2bigInt(1));
            HintInfo x$3 = p.child().stats().hints();
            AttributeMap<ColumnStat> x$4 = Statistics$.MODULE$.apply$default$3();
            statistics = new Statistics(x$1, (Option<BigInt>)x$2, x$4, x$3);
        } else {
            statistics = this.visitUnaryNode(p);
        }
        return statistics;
    }

    @Override
    public Statistics visitDistinct(Distinct p) {
        return this.default(p);
    }

    @Override
    public Statistics visitExcept(Except p) {
        Statistics qual$1 = p.left().stats();
        BigInt x$1 = qual$1.copy$default$1();
        Option<BigInt> x$2 = qual$1.copy$default$2();
        AttributeMap<ColumnStat> x$3 = qual$1.copy$default$3();
        HintInfo x$4 = qual$1.copy$default$4();
        return qual$1.copy(x$1, x$2, x$3, x$4);
    }

    @Override
    public Statistics visitExpand(Expand p) {
        BigInt sizeInBytes = this.visitUnaryNode(p).sizeInBytes().$times(BigInt$.MODULE$.int2bigInt(p.projections().length()));
        return new Statistics(sizeInBytes, Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
    }

    @Override
    public Statistics visitFilter(Filter p) {
        return this.visitUnaryNode(p);
    }

    @Override
    public Statistics visitGenerate(Generate p) {
        return this.default(p);
    }

    @Override
    public Statistics visitGlobalLimit(GlobalLimit p) {
        int limit = BoxesRunTime.unboxToInt((Object)p.limitExpr().eval(p.limitExpr().eval$default$1()));
        Statistics childStats = p.child().stats();
        BigInt rowCount = (BigInt)childStats.rowCount().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.min(BigInt$.MODULE$.int2bigInt(limit))).getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInt$.MODULE$.int2bigInt(limit));
        BigInt x$1 = EstimationUtils$.MODULE$.getOutputSize(p.output(), rowCount, childStats.attributeStats());
        Some x$22 = new Some((Object)rowCount);
        HintInfo x$3 = childStats.hints();
        AttributeMap<ColumnStat> x$4 = Statistics$.MODULE$.apply$default$3();
        return new Statistics(x$1, (Option<BigInt>)x$22, x$4, x$3);
    }

    @Override
    public Statistics visitHint(ResolvedHint p) {
        Statistics qual$1 = p.child().stats();
        HintInfo x$1 = p.hints();
        BigInt x$2 = qual$1.copy$default$1();
        Option<BigInt> x$3 = qual$1.copy$default$2();
        AttributeMap<ColumnStat> x$4 = qual$1.copy$default$3();
        return qual$1.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public Statistics visitIntersect(Intersect p) {
        BigInt rightSize;
        BigInt sizeInBytes;
        BigInt leftSize = p.left().stats().sizeInBytes();
        BigInt x$1 = sizeInBytes = leftSize.$less((Object)(rightSize = p.right().stats().sizeInBytes())) ? leftSize : rightSize;
        HintInfo x$2 = p.left().stats().hints().resetForJoin();
        Option<BigInt> x$3 = Statistics$.MODULE$.apply$default$2();
        AttributeMap<ColumnStat> x$4 = Statistics$.MODULE$.apply$default$3();
        return new Statistics(x$1, x$3, x$4, x$2);
    }

    @Override
    public Statistics visitJoin(Join p) {
        Statistics statistics;
        JoinType joinType = p.joinType();
        boolean bl = LeftAnti$.MODULE$.equals(joinType) ? true : LeftSemi$.MODULE$.equals(joinType);
        if (bl) {
            statistics = p.left().stats();
        } else {
            Statistics stats = this.default(p);
            HintInfo x$1 = stats.hints().resetForJoin();
            BigInt x$2 = stats.copy$default$1();
            Option<BigInt> x$3 = stats.copy$default$2();
            AttributeMap<ColumnStat> x$4 = stats.copy$default$3();
            statistics = stats.copy(x$2, x$3, x$4, x$1);
        }
        return statistics;
    }

    @Override
    public Statistics visitLocalLimit(LocalLimit p) {
        Statistics statistics;
        int limit = BoxesRunTime.unboxToInt((Object)p.limitExpr().eval(p.limitExpr().eval$default$1()));
        Statistics childStats = p.child().stats();
        if (limit == 0) {
            BigInt x$1 = BigInt$.MODULE$.int2bigInt(1);
            Some x$2 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
            HintInfo x$3 = childStats.hints();
            AttributeMap<ColumnStat> x$4 = Statistics$.MODULE$.apply$default$3();
            statistics = new Statistics(x$1, (Option<BigInt>)x$2, x$4, x$3);
        } else {
            AttributeMap<ColumnStat> x$5 = AttributeMap$.MODULE$.apply(Nil$.MODULE$);
            BigInt x$6 = childStats.copy$default$1();
            Option<BigInt> x$7 = childStats.copy$default$2();
            HintInfo x$8 = childStats.copy$default$4();
            statistics = childStats.copy(x$6, x$7, x$5, x$8);
        }
        return statistics;
    }

    @Override
    public Statistics visitPivot(Pivot p) {
        return this.default(p);
    }

    @Override
    public Statistics visitProject(Project p) {
        return this.visitUnaryNode(p);
    }

    @Override
    public Statistics visitRepartition(Repartition p) {
        return this.default(p);
    }

    @Override
    public Statistics visitRepartitionByExpr(RepartitionByExpression p) {
        return this.default(p);
    }

    @Override
    public Statistics visitSample(Sample p) {
        double ratio = p.upperBound() - p.lowerBound();
        BigInt sizeInBytes = EstimationUtils$.MODULE$.ceil(package$.MODULE$.BigDecimal().apply(p.child().stats().sizeInBytes()).$times(BigDecimal$.MODULE$.double2bigDecimal(ratio)));
        if (BoxesRunTime.equalsNumObject((Number)sizeInBytes, (Object)BoxesRunTime.boxToInteger((int)0))) {
            sizeInBytes = BigInt$.MODULE$.int2bigInt(1);
        }
        Option sampleRows = p.child().stats().rowCount().map((Function1 & Serializable & scala.Serializable)c -> EstimationUtils$.MODULE$.ceil(package$.MODULE$.BigDecimal().apply(c).$times(BigDecimal$.MODULE$.double2bigDecimal(ratio))));
        BigInt x$1 = sizeInBytes;
        Option x$2 = sampleRows;
        HintInfo x$3 = p.child().stats().hints();
        AttributeMap<ColumnStat> x$4 = Statistics$.MODULE$.apply$default$3();
        return new Statistics(x$1, (Option<BigInt>)x$2, x$4, x$3);
    }

    @Override
    public Statistics visitScriptTransform(ScriptTransformation p) {
        return this.default(p);
    }

    @Override
    public Statistics visitUnion(Union p) {
        return new Statistics((BigInt)((TraversableOnce)p.children().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.stats().sizeInBytes(), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.BigIntIsIntegral$.MODULE$), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
    }

    @Override
    public Statistics visitWindow(Window p) {
        return this.visitUnaryNode(p);
    }

    private SizeInBytesOnlyStatsPlanVisitor$() {
        MODULE$ = this;
        LogicalPlanVisitor.$init$(this);
    }
}

