/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See `java.text.SimpleDateFormat` for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005J\u0001\tE\t\u0015!\u0003G\u0011!Q\u0005A!f\u0001\n\u0003y\u0004\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002!\t\u000b1\u0003A\u0011A'\t\u000b1\u0003A\u0011\u0001*\t\u000b1\u0003A\u0011A+\t\u000b]\u0003A\u0011\t-\t\u000b\u0015\u0002A\u0011\t5\t\u000bE\u0004A\u0011\t5\t\u000bI\u0004A\u0011I:\t\u000fi\u0004\u0011\u0011!C\u0001w\"Aq\u0010AI\u0001\n\u0003\t\t\u0001C\u0005\u0002\u0018\u0001\t\n\u0011\"\u0001\u0002\u001a!I\u0011Q\u0004\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\n\u0003?\u0001\u0011\u0011!C!\u0003CA\u0011\"!\r\u0001\u0003\u0003%\t!a\r\t\u0013\u0005m\u0002!!A\u0005\u0002\u0005u\u0002\"CA\"\u0001\u0005\u0005I\u0011IA#\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002^\u0001\t\t\u0011\"\u0011\u0002`\u001dI\u00111\u0011\u0011\u0002\u0002#\u0005\u0011Q\u0011\u0004\t?\u0001\n\t\u0011#\u0001\u0002\b\"1A*\u0007C\u0001\u0003+C\u0011\"a&\u001a\u0003\u0003%)%!'\t\u0013\u0005m\u0015$!A\u0005\u0002\u0006u\u0005\"CAS3\u0005\u0005I\u0011QAT\u0011%\t),GA\u0001\n\u0013\t9L\u0001\tQCJ\u001cX\rV8US6,7\u000f^1na*\u0011\u0011EI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002$I\u0005A1-\u0019;bYf\u001cHO\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001]I*4\b\u0005\u00020a5\t\u0001%\u0003\u00022A\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00020g%\u0011A\u0007\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005Yb\u0014BA\u001f8\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003\u0001\u0003\"aL!\n\u0005\t\u0003#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u00051am\u001c:nCR,\u0012A\u0012\t\u0004m\u001d\u0003\u0015B\u0001%8\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013!B2iS2$\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001d>\u0003\u0016\u000b\u0005\u00020\u0001!)ah\u0002a\u0001\u0001\")Ai\u0002a\u0001\r\")!j\u0002a\u0001\u0001R\u0019aj\u0015+\t\u000byB\u0001\u0019\u0001!\t\u000b\u0011C\u0001\u0019\u0001!\u0015\u000593\u0006\"\u0002 \n\u0001\u0004\u0001\u0015!\u00044mCR\f%oZ;nK:$8/F\u0001Z!\rQ&-\u001a\b\u00037\u0002t!\u0001X0\u000e\u0003uS!A\u0018\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014BA18\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\u0011%#XM]1u_JT!!Y\u001c\u0011\u0005Y2\u0017BA48\u0005\r\te._\u000b\u0002SB\u0011!N\u001c\b\u0003W2\u0004\"\u0001X\u001c\n\u00055<\u0014A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\\u001c\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0005eCR\fG+\u001f9f+\u0005!\bCA;y\u001b\u00051(BA<%\u0003\u0015!\u0018\u0010]3t\u0013\tIhO\u0001\u0005ECR\fG+\u001f9f\u0003\u0011\u0019w\u000e]=\u0015\t9cXP \u0005\b}9\u0001\n\u00111\u0001A\u0011\u001d!e\u0002%AA\u0002\u0019CqA\u0013\b\u0011\u0002\u0003\u0007\u0001)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r!f\u0001!\u0002\u0006-\u0012\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012]\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)\"a\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m!f\u0001$\u0002\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001\u00027b]\u001eT!!!\f\u0002\t)\fg/Y\u0005\u0004_\u0006\u001d\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001b!\r1\u0014qG\u0005\u0004\u0003s9$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA3\u0002@!I\u0011\u0011\t\u000b\u0002\u0002\u0003\u0007\u0011QG\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0003#BA%\u0003\u001f*WBAA&\u0015\r\tieN\u0001\u000bG>dG.Z2uS>t\u0017bA2\u0002L\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002V\u0005m\u0003c\u0001\u001c\u0002X%\u0019\u0011\u0011L\u001c\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\t\f\u0002\u0002\u0003\u0007Q-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003+\n\t\u0007\u0003\u0005\u0002B]\t\t\u00111\u0001fQM\u0001\u0011QMA6\u0003[\n\t(a\u001d\u0002x\u0005e\u0014QPA@!\ry\u0013qM\u0005\u0004\u0003S\u0002#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003_\n\u0011\u0011\u001d\u0006!A\u0001\u0002sLR+O\u0007~CC/[7fgR\fW\u000e]0tiJ\\F\u0006\t4nivK\u0003%\f\u0011QCJ\u001cXm\u001d\u0011uQ\u0016\u0004\u0003\r^5nKN$\u0018-\u001c9`gR\u0014\b\rI3yaJ,7o]5p]\u0002:\u0018\u000e\u001e5!i\",\u0007\u0005\u00194ni\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011u_\u0002\n\u0007\u0005^5nKN$\u0018-\u001c9/AI+G/\u001e:og\u0002rW\u000f\u001c7!o&$\b\u000eI5om\u0006d\u0017\u000e\u001a\u0011j]B,HO\f\u0011Cs\u0002\"WMZ1vYRd\u0003%\u001b;!M>dGn\\<tA\r\f7\u000f^5oO\u0002\u0012X\u000f\\3tAQ|'\u0002\t\u0011!A\u0001\u0002\u0013\r\t;j[\u0016\u001cH/Y7qA%4\u0007\u0005\u001e5fA\u00014W\u000e\u001e1!SN\u0004s.\\5ui\u0016$gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002v\u0005\t\tL\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lWm\u001d;b[B|6\u000f\u001e:![\u0001\n\u0005e\u001d;sS:<\u0007\u0005^8!E\u0016\u0004\u0003/\u0019:tK\u0012\u0004Co\u001c\u0011uS6,7\u000f^1na:R\u0001\u0005\t\u0011!A\u0001R\u0003EZ7uA5\u0002C+[7fgR\fW\u000e\u001d\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8!i>\u0004cm\u001c7m_^t\u0003eU3fA\u0001T\u0017M^1/i\u0016DHOL*j[BdW\rR1uK\u001a{'/\\1uA\u00022wN\u001d\u0011wC2LGM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t3bi\u0016\u0004\u0013M\u001c3!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005m\u0014!!\u0015\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'\r\u001c.cIj3'\r\u00111ai\n$G\u000f\u00191O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\n$'L\u001a2AA\u0002$(\r\u001a;aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0013GM\u00174c\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0013GM\u00174c\u0001\u0002\u0004G\u000f\u00191uA\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0005\u0015!\u0002\u001a/e9\u0002\u0014\u0001\u0005)beN,Gk\u001c+j[\u0016\u001cH/Y7q!\ty\u0013d\u0005\u0003\u001a\u0003\u0013[\u0004\u0003CAF\u0003#\u0003e\t\u0011(\u000e\u0005\u00055%bAAHo\u00059!/\u001e8uS6,\u0017\u0002BAJ\u0003\u001b\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\t))\u0001\u0005u_N#(/\u001b8h)\t\t\u0019#A\u0003baBd\u0017\u0010F\u0004O\u0003?\u000b\t+a)\t\u000byb\u0002\u0019\u0001!\t\u000b\u0011c\u0002\u0019\u0001$\t\u000b)c\u0002\u0019\u0001!\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011VAY!\u00111t)a+\u0011\rY\ni\u000b\u0011$A\u0013\r\tyk\u000e\u0002\u0007)V\u0004H.Z\u001a\t\u0011\u0005MV$!AA\u00029\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005e\u0006\u0003BA\u0013\u0003wKA!!0\u0002(\t1qJ\u00196fGR\u0004")
public class ParseToTimestamp
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToTimestamp parseToTimestamp) {
        return ParseToTimestamp$.MODULE$.unapply(parseToTimestamp);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToTimestamp>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String sql() {
        return this.format().isDefined() ? new StringBuilder(4).append(this.prettyName()).append("(").append(this.left().sql()).append(", ").append(((Expression)this.format().get()).sql()).append(")").toString() : new StringBuilder(2).append(this.prettyName()).append("(").append(this.left().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "to_timestamp";
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToTimestamp(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToTimestamp.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new Cast(new UnixTimestamp(left, format, UnixTimestamp$.MODULE$.apply$default$3()), TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

