/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See `java.text.SimpleDateFormat` for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u0010 \u00012B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005A\t\u0003\u0005I\u0001\tE\t\u0015!\u0003F\u0011!I\u0005A!f\u0001\n\u0003q\u0004\u0002\u0003&\u0001\u0005#\u0005\u000b\u0011B \t\u000b-\u0003A\u0011\u0001'\t\u000b-\u0003A\u0011A)\t\u000b-\u0003A\u0011\u0001+\t\u000bY\u0003A\u0011I,\t\u000b\u0011\u0002A\u0011I4\t\u000bA\u0004A\u0011I4\t\u000fE\u0004\u0011\u0011!C\u0001e\"9a\u000fAI\u0001\n\u00039\b\"CA\u0003\u0001E\u0005I\u0011AA\u0004\u0011!\tY\u0001AI\u0001\n\u00039\b\"CA\u0007\u0001\u0005\u0005I\u0011IA\b\u0011%\ty\u0002AA\u0001\n\u0003\t\t\u0003C\u0005\u0002*\u0001\t\t\u0011\"\u0001\u0002,!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003\u007f\u0001\u0011\u0011!C\u0001\u0003\u0003B\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\b\u0013\u0005Et$!A\t\u0002\u0005Md\u0001\u0003\u0010 \u0003\u0003E\t!!\u001e\t\r-CB\u0011AAB\u0011%\t)\tGA\u0001\n\u000b\n9\tC\u0005\u0002\nb\t\t\u0011\"!\u0002\f\"I\u00111\u0013\r\u0002\u0002\u0013\u0005\u0015Q\u0013\u0005\n\u0003GC\u0012\u0011!C\u0005\u0003K\u00131\u0002U1sg\u0016$v\u000eR1uK*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1-\u0019;bYf\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001[E\"$\b\u0005\u0002/_5\tq$\u0003\u00021?\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0004Qe>$Wo\u0019;\u0011\u0005UZ\u0014B\u0001\u001f7\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003}\u0002\"A\f!\n\u0005\u0005{\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u00051am\u001c:nCR,\u0012!\u0012\t\u0004k\u0019{\u0014BA$7\u0005\u0019y\u0005\u000f^5p]\u00069am\u001c:nCR\u0004\u0013!B2iS2$\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005\u001b:{\u0005\u000b\u0005\u0002/\u0001!)Qh\u0002a\u0001\u007f!)1i\u0002a\u0001\u000b\")\u0011j\u0002a\u0001\u007fQ\u0019QJU*\t\u000buB\u0001\u0019A \t\u000b\rC\u0001\u0019A \u0015\u00055+\u0006\"B\u001f\n\u0001\u0004y\u0014!\u00044mCR\f%oZ;nK:$8/F\u0001Y!\rI\u0016\r\u001a\b\u00035~s!a\u00170\u000e\u0003qS!!X\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u000117\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\u0011%#XM]1u_JT!\u0001\u0019\u001c\u0011\u0005U*\u0017B\u000147\u0005\r\te._\u000b\u0002QB\u0011\u0011.\u001c\b\u0003U.\u0004\"a\u0017\u001c\n\u000514\u0014A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\u001c\u001c\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u0003d_BLH\u0003B'tiVDq!P\u0007\u0011\u0002\u0003\u0007q\bC\u0004D\u001bA\u0005\t\u0019A#\t\u000f%k\u0001\u0013!a\u0001\u007f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001=+\u0005}J8&\u0001>\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0005v]\u000eDWmY6fI*\u0011qPN\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0002y\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0002\u0016\u0003\u000bf\fabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"\u0001\u0003mC:<'BAA\u000e\u0003\u0011Q\u0017M^1\n\u00079\f)\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002$A\u0019Q'!\n\n\u0007\u0005\u001dbGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002e\u0003[A\u0011\"a\f\u0014\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0004E\u0003\u00028\u0005uB-\u0004\u0002\u0002:)\u0019\u00111\b\u001c\u0002\u0015\r|G\u000e\\3di&|g.C\u0002c\u0003s\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0007\nI\u0005E\u00026\u0003\u000bJ1!a\u00127\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\f\u0016\u0003\u0003\u0005\r\u0001Z\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0013q\n\u0005\t\u0003_1\u0012\u0011!a\u0001I\"\u001a\u0002!a\u0015\u0002Z\u0005m\u0013qLA1\u0003K\n9'a\u001b\u0002nA\u0019a&!\u0016\n\u0007\u0005]sDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005u\u0013!!/\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006Z1uK~\u001bHO].-A\u0019lG/X\u0015![\u0001\u0002\u0016M]:fg\u0002\"\b.\u001a\u0011aI\u0006$XmX:ue\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!o&$\b\u000e\t;iK\u0002\u0002g-\u001c;aA\u0015D\bO]3tg&|g\u000e\t;p\u0015\u0001\u0002\u0003\u0005\t\u0011!C\u0002\"\u0017\r^3/AI+G/\u001e:og\u0002rW\u000f\u001c7!o&$\b\u000eI5om\u0006d\u0017\u000e\u001a\u0011j]B,HO\f\u0011Cs\u0002\"WMZ1vYRd\u0003%\u001b;!M>dGn\\<tA\r\f7\u000f^5oO\u0002\u0012X\u000f\\3tAQ|\u0007%\u0019\u0011eCR,\u0007%\u001b4\u000bA\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u0004\u0003MZ7uA\u0002J7\u000fI8nSR$X\r\u001a\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005\r\u0014!a%\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0017\r^3`gR\u0014\b%\f\u0011BAM$(/\u001b8hAQ|\u0007EY3!a\u0006\u00148/\u001a3!i>\u0004C-\u0019;f])\u0001\u0003\u0005\t\u0011!A)\u0002c-\u001c;![\u0001\"\u0015\r^3!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I*fK\u0002\u0002'.\u0019<b]Q,\u0007\u0010\u001e\u0018TS6\u0004H.\u001a#bi\u00164uN]7bi\u0002\u0004cm\u001c:!m\u0006d\u0017\u000e\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011eCR,\u0007%\u00198eAQLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI'AA\u0017\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1aej\u0003gN\u00174a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\n$'L\u001a2O1\u0002s%_=zs6jU*\f3eO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\n$'L\u001a2\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA8\u0003\u0015\td&\u000e\u00181\u0003-\u0001\u0016M]:f)>$\u0015\r^3\u0011\u00059B2\u0003\u0002\r\u0002xi\u0002\u0002\"!\u001f\u0002\u0000}*u(T\u0007\u0003\u0003wR1!! 7\u0003\u001d\u0011XO\u001c;j[\u0016LA!!!\u0002|\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005M\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0011!B1qa2LHcB'\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\u0006{m\u0001\ra\u0010\u0005\u0006\u0007n\u0001\r!\u0012\u0005\u0006\u0013n\u0001\raP\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9*a(\u0011\tU2\u0015\u0011\u0014\t\u0007k\u0005mu(R \n\u0007\u0005ueG\u0001\u0004UkBdWm\r\u0005\t\u0003Cc\u0012\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003O\u0003B!a\u0005\u0002*&!\u00111VA\u000b\u0005\u0019y%M[3di\u0002")
public class ParseToDate
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToDate parseToDate) {
        return ParseToDate$.MODULE$.unapply(parseToDate);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToDate>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String sql() {
        return this.format().isDefined() ? new StringBuilder(4).append(this.prettyName()).append("(").append(this.left().sql()).append(", ").append(((Expression)this.format().get()).sql()).append(")").toString() : new StringBuilder(2).append(this.prettyName()).append("(").append(this.left().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToDate(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToDate.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new Cast(new Cast(new UnixTimestamp(left, format, UnixTimestamp$.MODULE$.apply$default$3()), TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()), DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, DateType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

