/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(keys, values) - Creates a map with a pair of the given key/value arrays. All elements\n      in keys should not be null", examples="\n    Examples:\n      > SELECT _FUNC_(array(1.0, 3.0), array('2', '4'));\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005y!A\u0001\t\u0001BK\u0002\u0013\u00051\b\u0003\u0005B\u0001\tE\t\u0015!\u0003=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015A\b\u0001\"\u0011z\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003O\u0001\u0011\u0011!C!\u0003SA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\r\u0003!!A\u0005\u0002\u0005\u0015\u0003\"CA&\u0001\u0005\u0005I\u0011IA'\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j\u001dI\u0011q\u0011\u000f\u0002\u0002#\u0005\u0011\u0011\u0012\u0004\t7q\t\t\u0011#\u0001\u0002\f\"1!)\u0006C\u0001\u00033C\u0011\"a'\u0016\u0003\u0003%)%!(\t\u0013\u0005}U#!A\u0005\u0002\u0006\u0005\u0006\"CAT+\u0005\u0005I\u0011QAU\u0011%\tY,FA\u0001\n\u0013\tiLA\u0007NCB4%o\\7BeJ\f\u0017p\u001d\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M)\u0001A\u000b\u00182oA\u00111\u0006L\u0007\u00029%\u0011Q\u0006\b\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"aK\u0018\n\u0005Ab\"!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t9\u0001K]8ek\u000e$\bC\u0001\u001a9\u0013\tI4G\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#\u0001\u001f\u0011\u0005-j\u0014B\u0001 \u001d\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r!UI\u0012\t\u0003W\u0001AQAO\u0003A\u0002qBQ\u0001Q\u0003A\u0002q\n!\"\u001b8qkR$\u0016\u0010]3t+\u0005I\u0005c\u0001&S+:\u00111\n\u0015\b\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\"\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0005E\u001b\u0014a\u00029bG.\fw-Z\u0005\u0003'R\u00131aU3r\u0015\t\t6\u0007\u0005\u0002W36\tqK\u0003\u0002YA\u0005)A/\u001f9fg&\u0011!l\u0016\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002;B\u0011aKX\u0005\u0003?^\u0013\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004E\u0016<\u0007C\u0001\u001ad\u0013\t!7GA\u0002B]fDQA\u001a\u0005A\u0002\t\f\u0001b[3z\u0003J\u0014\u0018-\u001f\u0005\u0006Q\"\u0001\rAY\u0001\u000bm\u0006dW/Z!se\u0006L\u0018!\u00033p\u000f\u0016t7i\u001c3f)\rY\u0017O\u001e\t\u0003Y>l\u0011!\u001c\u0006\u0003]r\tqaY8eK\u001e,g.\u0003\u0002q[\nAQ\t\u001f9s\u0007>$W\rC\u0003s\u0013\u0001\u00071/A\u0002dib\u0004\"\u0001\u001c;\n\u0005Ul'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006o&\u0001\ra[\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\u0005Q\bCA>\u0000\u001d\taX\u0010\u0005\u0002Mg%\u0011apM\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u001c\u0014\u0001B2paf$R\u0001RA\u0005\u0003\u0017AqAO\u0006\u0011\u0002\u0003\u0007A\bC\u0004A\u0017A\u0005\t\u0019\u0001\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0003\u0016\u0004y\u0005M1FAA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}1'\u0001\u0006b]:|G/\u0019;j_:LA!a\t\u0002\u001a\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u000b\u0011\t\u00055\u0012qG\u0007\u0003\u0003_QA!!\r\u00024\u0005!A.\u00198h\u0015\t\t)$\u0001\u0003kCZ\f\u0017\u0002BA\u0001\u0003_\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0010\u0011\u0007I\ny$C\u0002\u0002BM\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2AYA$\u0011%\tI\u0005EA\u0001\u0002\u0004\ti$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u001f\u0002R!!\u0015\u0002X\tl!!a\u0015\u000b\u0007\u0005U3'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0017\u0002T\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty&!\u001a\u0011\u0007I\n\t'C\u0002\u0002dM\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002JI\t\t\u00111\u0001c\u0003\u0019)\u0017/^1mgR!\u0011qLA6\u0011!\tIeEA\u0001\u0002\u0004\u0011\u0007f\u0004\u0001\u0002p\u0005U\u0014qOA>\u0003{\n\t)a!\u0011\u0007-\n\t(C\u0002\u0002tq\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002z\u0005\t)A\u0003\u0011!A\u0001zf)\u0016(D?\"ZW-_:-AY\fG.^3tS\u0001j\u0003e\u0011:fCR,7\u000fI1![\u0006\u0004\be^5uQ\u0002\n\u0007\u0005]1je\u0002zg\r\t;iK\u0002:\u0017N^3oA-,\u0017p\f<bYV,\u0007%\u0019:sCf\u001ch\u0006I!mY\u0002*G.Z7f]R\u001c(\u0002\t\u0011!A\u0001\u0002\u0013N\u001c\u0011lKf\u001c\be\u001d5pk2$\u0007E\\8uA\t,\u0007E\\;mY\u0006AQ\r_1na2,7/\t\u0002\u0002\u0000\u0005\u0019'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u00181Y\u0001\u001ad\u0006M\u0015-A\u0005\u0014(/Y=)OI:C\u0006I\u00145O%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>2]AR$E\r\u0012-g9\u0002$H\t\u001b#{*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\u0006\u0006)!G\f\u001b/a\u0005iQ*\u00199Ge>l\u0017I\u001d:bsN\u0004\"aK\u000b\u0014\tU\tii\u000e\t\b\u0003\u001f\u000b)\n\u0010\u001fE\u001b\t\t\tJC\u0002\u0002\u0014N\nqA];oi&lW-\u0003\u0003\u0002\u0018\u0006E%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011\u0011R\u0001\ti>\u001cFO]5oOR\u0011\u00111F\u0001\u0006CB\u0004H.\u001f\u000b\u0006\t\u0006\r\u0016Q\u0015\u0005\u0006ua\u0001\r\u0001\u0010\u0005\u0006\u0001b\u0001\r\u0001P\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY+a.\u0011\u000bI\ni+!-\n\u0007\u0005=6G\u0001\u0004PaRLwN\u001c\t\u0006e\u0005MF\bP\u0005\u0004\u0003k\u001b$A\u0002+va2,'\u0007\u0003\u0005\u0002:f\t\t\u00111\u0001E\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002@B!\u0011QFAa\u0013\u0011\t\u0019-a\f\u0003\r=\u0013'.Z2u\u0001")
public class MapFromArrays
extends BinaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(MapFromArrays mapFromArrays) {
        return MapFromArrays$.MODULE$.unapply(mapFromArrays);
    }

    public static Function1<Tuple2<Expression, Expression>, MapFromArrays> tupled() {
        return MapFromArrays$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MapFromArrays>> curried() {
        return MapFromArrays$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$, ArrayType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return new MapType(((ArrayType)this.left().dataType()).elementType(), ((ArrayType)this.right().dataType()).elementType(), ((ArrayType)this.right().dataType()).containsNull());
    }

    @Override
    public Object nullSafeEval(Object keyArray, Object valueArray) {
        ArrayData keyArrayData = (ArrayData)keyArray;
        ArrayData valueArrayData = (ArrayData)valueArray;
        if (keyArrayData.numElements() != valueArrayData.numElements()) {
            throw new RuntimeException("The given two arrays should have the same length");
        }
        ArrayType leftArrayType = (ArrayType)this.left().dataType();
        if (leftArrayType.containsNull()) {
            for (int i = 0; i < keyArrayData.numElements(); ++i) {
                if (!keyArrayData.isNullAt(i)) continue;
                throw new RuntimeException("Cannot use null as map key!");
            }
        }
        return new ArrayBasedMapData(keyArrayData.copy(), valueArrayData.copy());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(keyArrayData, valueArrayData) -> {
            String string;
            String arrayBasedMapData = ArrayBasedMapData.class.getName();
            ArrayType leftArrayType = (ArrayType)this.left().dataType();
            if (!leftArrayType.containsNull()) {
                string = "";
            } else {
                String i = ctx.freshName("i");
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(200).append("\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)keyArrayData).append(".numElements(); ").append(i).append("++) {\n           |  if (").append((String)keyArrayData).append(".isNullAt(").append(i).append(")) {\n           |    throw new RuntimeException(\"Cannot use null as map key!\");\n           |  }\n           |}\n         ").toString())).stripMargin();
            }
            String keyArrayElemNullCheck = string;
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(210).append("\n         |if (").append((String)keyArrayData).append(".numElements() != ").append((String)valueArrayData).append(".numElements()) {\n         |  throw new RuntimeException(\"The given two arrays should have the same length\");\n         |}\n         |").append(keyArrayElemNullCheck).append("\n         |").append(ev.value()).append(" = new ").append(arrayBasedMapData).append("(").append((String)keyArrayData).append(".copy(), ").append((String)valueArrayData).append(".copy());\n       ").toString())).stripMargin();
        });
    }

    @Override
    public String prettyName() {
        return "map_from_arrays";
    }

    public MapFromArrays copy(Expression left, Expression right) {
        return new MapFromArrays(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "MapFromArrays";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapFromArrays;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapFromArrays)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapFromArrays mapFromArrays = (MapFromArrays)x$1;
        Expression expression = this.left();
        Expression expression2 = mapFromArrays.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapFromArrays.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!mapFromArrays.canEqual(this)) return false;
        return true;
    }

    public MapFromArrays(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

