/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.In$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_(expr2, expr3, ...) - Returns true if `expr` equals to any valN.", arguments="\n    Arguments:\n      * expr1, expr2, expr3, ... - the arguments must be same type.\n  ", examples="\n    Examples:\n      > SELECT 1 _FUNC_(1, 2, 3);\n       true\n      > SELECT 1 _FUNC_(2, 3, 4);\n       false\n      > SELECT named_struct('a', 1, 'b', 2) _FUNC_(named_struct('a', 1, 'b', 1), named_struct('a', 1, 'b', 3));\n       false\n      > SELECT named_struct('a', 1, 'b', 2) _FUNC_(named_struct('a', 1, 'b', 2), named_struct('a', 1, 'b', 3));\n       true\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005_!A!\t\u0001BK\u0002\u0013\u00051\t\u0003\u0005Q\u0001\tE\t\u0015!\u0003E\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015q\u0006\u0001\"\u0011D\u0011!y\u0006\u0001#b\u0001\n\u0003\u0001\u0007\u0002\u00033\u0001\u0011\u000b\u0007I\u0011B3\t\u000b1\u0004A\u0011\t1\t\u000b5\u0004A\u0011\t1\t\u000b9\u0004A\u0011I8\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!1a\u0005\u0001C!\u0003?A\u0011\"!\t\u0001\u0003\u0003%\t!a\t\t\u0013\u0005%\u0002!%A\u0005\u0002\u0005-\u0002\"CA!\u0001E\u0005I\u0011AA\"\u0011%\t9\u0005AA\u0001\n\u0003\nI\u0005C\u0005\u0002Z\u0001\t\t\u0011\"\u0001\u0002\\!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003W\u0002\u0011\u0011!C!\u0003[B\u0011\"a\u001f\u0001\u0003\u0003%\t!! \t\u0013\u0005\u0005\u0005!!A\u0005B\u0005\ru!CAQC\u0005\u0005\t\u0012AAR\r!\u0001\u0013%!A\t\u0002\u0005\u0015\u0006BB)\u001b\t\u0003\t\u0019\f\u0003\u0005o5\u0005\u0005IQIA[\u0011%\t9LGA\u0001\n\u0003\u000bI\fC\u0005\u0002@j\t\t\u0011\"!\u0002B\"I\u00111\u001b\u000e\u0002\u0002\u0013%\u0011Q\u001b\u0002\u0003\u0013:T!AI\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003I\u0015\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0006\u0001=\u001ad\u0007\u0010\t\u0003aEj\u0011!I\u0005\u0003e\u0005\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t\u0001D'\u0003\u00026C\tI\u0001K]3eS\u000e\fG/\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b!J|G-^2u!\t9T(\u0003\u0002?q\ta1+\u001a:jC2L'0\u00192mK\u0006)a/\u00197vKV\tq&\u0001\u0004wC2,X\rI\u0001\u0005Y&\u001cH/F\u0001E!\r)Uj\f\b\u0003\r.s!a\u0012&\u000e\u0003!S!!S\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014B\u0001'9\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u0007M+\u0017O\u0003\u0002Mq\u0005)A.[:uA\u00051A(\u001b8jiz\"2a\u0015+V!\t\u0001\u0004\u0001C\u0003@\u000b\u0001\u0007q\u0006C\u0003C\u000b\u0001\u0007A)A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001Y!\tIF,D\u0001[\u0015\tY6%\u0001\u0005b]\u0006d\u0017p]5t\u0013\ti&LA\bUsB,7\t[3dWJ+7/\u001e7u\u0003!\u0019\u0007.\u001b7ee\u0016t\u0017\u0001E5o'\u0016$8i\u001c8wKJ$\u0018N\u00197f+\u0005\t\u0007CA\u001cc\u0013\t\u0019\u0007HA\u0004C_>dW-\u00198\u0002\u0011=\u0014H-\u001a:j]\u001e,\u0012A\u001a\t\u0004\u000b\u001eL\u0017B\u00015P\u0005!y%\u000fZ3sS:<\u0007CA\u001ck\u0013\tY\u0007HA\u0002B]f\f\u0001B\\;mY\u0006\u0014G.Z\u0001\tM>dG-\u00192mK\u0006AAo\\*ue&tw\rF\u0001q!\t\tXO\u0004\u0002sgB\u0011q\tO\u0005\u0003ib\na\u0001\u0015:fI\u00164\u0017B\u0001<x\u0005\u0019\u0019FO]5oO*\u0011A\u000fO\u0001\u0005KZ\fG\u000e\u0006\u0002ju\"910\u0004I\u0001\u0002\u0004a\u0018!B5oaV$\bCA?\u007f\u001b\u0005\u0019\u0013BA@$\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u0003\u0003#\tY\u0002\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY!I\u0001\bG>$WmZ3o\u0013\u0011\ty!!\u0003\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0005\u000f\u0001\u0004\t)\"A\u0002dib\u0004B!a\u0002\u0002\u0018%!\u0011\u0011DA\u0005\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\b\u000f\u0001\u0004\t)!\u0001\u0002fmV\t\u0001/\u0001\u0003d_BLH#B*\u0002&\u0005\u001d\u0002bB \u0011!\u0003\u0005\ra\f\u0005\b\u0005B\u0001\n\u00111\u0001E\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\f+\u0007=\nyc\u000b\u0002\u00022A!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012!C;oG\",7m[3e\u0015\r\tY\u0004O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA \u0003k\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0012+\u0007\u0011\u000by#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002X5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&\u0001\u0003mC:<'BAA+\u0003\u0011Q\u0017M^1\n\u0007Y\fy%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002^A\u0019q'a\u0018\n\u0007\u0005\u0005\u0004HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002j\u0003OB\u0011\"!\u001b\u0016\u0003\u0003\u0005\r!!\u0018\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u0007E\u0003\u0002r\u0005]\u0014.\u0004\u0002\u0002t)\u0019\u0011Q\u000f\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002z\u0005M$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!YA@\u0011!\tIgFA\u0001\u0002\u0004I\u0017AB3rk\u0006d7\u000fF\u0002b\u0003\u000bC\u0001\"!\u001b\u0019\u0003\u0003\u0005\r!\u001b\u0015\u0010\u0001\u0005%\u0015qRAI\u0003+\u000b9*a'\u0002\u001eB\u0019\u0001'a#\n\u0007\u00055\u0015EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005M\u0015\u0001T3yaJ\f\u0004e\u0018$V\u001d\u000e{\u0006&\u001a=qeJb\u0003%\u001a=qeNb\u0003E\f\u0018/S\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011aKb\u0004(\u000f\u0019\u0011fcV\fGn\u001d\u0011u_\u0002\ng.\u001f\u0011wC2te&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011\u0011T\u0001W\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9sc1\u0002S\r\u001f9se1\u0002S\r\u001f9sg1\u0002cF\f\u0018![\u0001\"\b.\u001a\u0011be\u001e,X.\u001a8ug\u0002jWo\u001d;!E\u0016\u00043/Y7fAQL\b/\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003?\u000b!q\u001a\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!c\u0001zf)\u0016(D?\"\nD\u0006\t\u001a-AMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\r\u0011`\rVs5i\u0018\u00153Y\u0001\u001aD\u0006\t\u001b*w)\u0001\u0003\u0005\t\u0011!A\u00012\u0017\r\\:f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002r\u0017-\\3e?N$(/^2uQ\u001d\nw\u0005\f\u00112Y\u0001:#m\n\u0017!e%\u0002sLR+O\u0007~Cc.Y7fI~\u001bHO];di\":\u0013m\n\u0017!c1\u0002sEY\u0014-AEJC\u0006\t8b[\u0016$wl\u001d;sk\u000e$\bfJ1(Y\u0001\nD\u0006I\u0014cO1\u00023'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fGn]3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA9\fW.\u001a3`gR\u0014Xo\u0019;)O\u0005<C\u0006I\u0019-A\u001d\u0012w\u0005\f\u00113S\u0001zf)\u0016(D?\"r\u0017-\\3e?N$(/^2uQ\u001d\nw\u0005\f\u00112Y\u0001:#m\n\u0017!e%b\u0003E\\1nK\u0012|6\u000f\u001e:vGRDs%Y\u0014-AEb\u0003e\n2(Y\u0001\u001a\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!\u0003\tIe\u000e\u0005\u000215M!!$a*=!\u001d\tI+a,0\tNk!!a+\u000b\u0007\u00055\u0006(A\u0004sk:$\u0018.\\3\n\t\u0005E\u00161\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAR)\t\tY%A\u0003baBd\u0017\u0010F\u0003T\u0003w\u000bi\fC\u0003@;\u0001\u0007q\u0006C\u0003C;\u0001\u0007A)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u0017q\u001a\t\u0006o\u0005\u0015\u0017\u0011Z\u0005\u0004\u0003\u000fD$AB(qi&|g\u000eE\u00038\u0003\u0017|C)C\u0002\u0002Nb\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAi=\u0005\u0005\t\u0019A*\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAl!\u0011\ti%!7\n\t\u0005m\u0017q\n\u0002\u0007\u001f\nTWm\u0019;")
public class In
extends Expression
implements Predicate,
scala.Serializable {
    private boolean inSetConvertible;
    private Ordering<Object> ordering;
    private final Expression value;
    private final Seq<Expression> list;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Seq<Expression>>> unapply(In in) {
        return In$.MODULE$.unapply(in);
    }

    public static Function1<Tuple2<Expression, Seq<Expression>>, In> tupled() {
        return In$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Seq<Expression>, In>> curried() {
        return In$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    public Expression value() {
        return this.value;
    }

    public Seq<Expression> list() {
        return this.list;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        Option mismatchOpt = this.list().find((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.boxToBoolean((boolean)In.$anonfun$checkInputDataTypes$6(this, l)));
        return mismatchOpt.isDefined() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(42).append("Arguments must be same type but were: ").append(this.value().dataType().catalogString()).append(" != ").append(((Expression)mismatchOpt.get()).dataType().catalogString()).toString()) : TypeUtils$.MODULE$.checkForOrderingExpr(this.value().dataType(), new StringBuilder(9).append("function ").append(this.prettyName()).toString());
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.value();
        return (Seq)this.list().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    private boolean inSetConvertible$lzycompute() {
        In in = this;
        synchronized (in) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.inSetConvertible = this.list().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)In.$anonfun$inSetConvertible$1(x$10)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.inSetConvertible;
    }

    public boolean inSetConvertible() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.inSetConvertible$lzycompute() : this.inSetConvertible;
    }

    private Ordering<Object> ordering$lzycompute() {
        In in = this;
        synchronized (in) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.value().dataType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.foldable()));
    }

    @Override
    public String toString() {
        return new StringBuilder(4).append(this.value()).append(" IN ").append(this.list().mkString("(", ",", ")")).toString();
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object object2 = new Object();
        try {
            Object evaluatedValue = this.value().eval(input);
            if (evaluatedValue == null) {
                object = null;
            } else {
                BooleanRef hasNull = BooleanRef.create((boolean)false);
                this.list().foreach((Function1 & Serializable & scala.Serializable)e -> {
                    In.$anonfun$eval$1(this, input, hasNull, evaluatedValue, object2, e);
                    return BoxedUnit.UNIT;
                });
                object = hasNull.elem ? null : BoxesRunTime.boxToBoolean((boolean)false);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String javaDataType = CodeGenerator$.MODULE$.javaType(this.value().dataType());
        ExprCode valueGen = this.value().genCode(ctx);
        Seq listGen = (Seq)this.list().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        int HAS_NULL = -1;
        int NOT_MATCHED = 0;
        int MATCHED = 1;
        String tmpResult = ctx.freshName("inTmpResult");
        String valueArg = ctx.freshName("valueArg");
        Seq listCode = (Seq)listGen.map((Function1 & Serializable & scala.Serializable)x -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(164).append("\n         |").append(x.code()).append("\n         |if (").append(x.isNull()).append(") {\n         |  ").append(tmpResult).append(" = ").append(HAS_NULL).append("; // ").append(ev.isNull()).append(" = true;\n         |} else if (").append(ctx.genEqual(this.value().dataType(), valueArg, ExprValue$.MODULE$.exprValueToString(x.value()))).append(") {\n         |  ").append(tmpResult).append(" = ").append(MATCHED).append("; // ").append(ev.isNull()).append(" = false; ").append(ev.value()).append(" = true;\n         |  continue;\n         |}\n       ").toString())).stripMargin(), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = new Tuple2((Object)javaDataType, (Object)valueArg);
        Tuple2 tuple22 = new Tuple2((Object)"byte", (Object)tmpResult);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)listCode, "valueIn", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple22).$colon$colon((Object)tuple2), "byte", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)body -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("\n           |do {\n           |  ").append((String)body).append("\n           |} while (false);\n           |return ").append(tmpResult).append(";\n         ").toString())).stripMargin(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)x$16 -> ((TraversableOnce)x$16.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n           |").append(tmpResult).append(" = ").append((String)funcCall).append(";\n           |if (").append(tmpResult).append(" == ").append(MATCHED).append(") {\n           |  continue;\n           |}\n         ").toString())).stripMargin(), Seq$.MODULE$.canBuildFrom())).mkString("\n"));
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |byte ", " = ", ";\n         |if (!", ") {\n         |  ", " = ", ";\n         |  ", " ", " = ", ";\n         |  do {\n         |    ", "\n         |  } while (false);\n         |}\n         |final boolean ", " = (", " == ", ");\n         |final boolean ", " = (", " == ", ");\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{valueGen.code(), tmpResult, BoxesRunTime.boxToInteger((int)HAS_NULL), valueGen.isNull(), tmpResult, BoxesRunTime.boxToInteger((int)NOT_MATCHED), javaDataType, valueArg, valueGen.value(), codes, ev.isNull(), tmpResult, BoxesRunTime.boxToInteger((int)HAS_NULL), ev.value(), tmpResult, BoxesRunTime.boxToInteger((int)MATCHED)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String sql() {
        String valueSQL = this.value().sql();
        String listSQL = ((TraversableOnce)this.list().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.sql(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return new StringBuilder(8).append("(").append(valueSQL).append(" IN (").append(listSQL).append("))").toString();
    }

    public In copy(Expression value, Seq<Expression> list) {
        return new In(value, list);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Seq<Expression> copy$default$2() {
        return this.list();
    }

    @Override
    public String productPrefix() {
        return "In";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<Expression> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.value();
                break;
            }
            case 1: {
                seq = this.list();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return seq;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof In;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof In)) return false;
        boolean bl = true;
        if (!bl) return false;
        In in = (In)x$1;
        Expression expression = this.value();
        Expression expression2 = in.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Seq<Expression> seq = this.list();
        Seq<Expression> seq2 = in.list();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!in.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$6(In $this, Expression l) {
        return !DataType$.MODULE$.equalsStructurally(l.dataType(), $this.value().dataType(), true);
    }

    public static final /* synthetic */ boolean $anonfun$inSetConvertible$1(Expression x$10) {
        return x$10 instanceof Literal;
    }

    public static final /* synthetic */ void $anonfun$eval$1(In $this, InternalRow input$1, BooleanRef hasNull$1, Object evaluatedValue$1, Object nonLocalReturnKey1$1, Expression e) {
        Object v = e.eval(input$1);
        if (v == null) {
            hasNull$1.elem = true;
        } else if ($this.ordering().equiv(v, evaluatedValue$1)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    public In(Expression value, Seq<Expression> list) {
        this.value = value;
        this.list = list;
        Predicate.$init$(this);
        Predef$.MODULE$.require(list != null, (Function0 & Serializable & scala.Serializable)() -> "list should not be null");
    }
}

