/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` equals `expr2`, or false otherwise.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       NULL\n      > SELECT NULL _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u00151\u0006\u0001\"\u0015X\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u001da\u0007!!A\u0005\u00025Dq\u0001\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u000fC\u0004}\u0001E\u0005I\u0011A9\t\u000fu\u0004\u0011\u0011!C!}\"I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003/\u0001\u0011\u0011!C\u0001\u00033A\u0011\"a\b\u0001\u0003\u0003%\t%!\t\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0002\"CA\u001e\u0001\u0005\u0005I\u0011IA\u001f\u000f%\tYFGA\u0001\u0012\u0003\tiF\u0002\u0005\u001a5\u0005\u0005\t\u0012AA0\u0011\u0019!5\u0003\"\u0001\u0002n!I\u0011qN\n\u0002\u0002\u0013\u0015\u0013\u0011\u000f\u0005\n\u0003g\u001a\u0012\u0011!CA\u0003kB\u0011\"a\u001f\u0014\u0003\u0003%\t)! \t\u0013\u0005=5#!A\u0005\n\u0005E%aB#rk\u0006dGk\u001c\u0006\u00037q\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QDH\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000b\u00174sA\u0011\u0011FK\u0007\u00025%\u00111F\u0007\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"!\f\u0019\u000f\u0005%r\u0013BA\u0018\u001b\u0003\u001d\u0001\u0018mY6bO\u0016L!!\r\u001a\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011qF\u0007\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\b!J|G-^2u!\t!$(\u0003\u0002<k\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005q\u0004CA\u0015@\u0013\t\u0001%D\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002G\u000f\"\u0003\"!\u000b\u0001\t\u000bq*\u0001\u0019\u0001 \t\u000b\t+\u0001\u0019\u0001 \u0002\rMLXNY8m+\u0005Y\u0005C\u0001'T\u001d\ti\u0015\u000b\u0005\u0002Ok5\tqJ\u0003\u0002QM\u00051AH]8pizJ!AU\u001b\u0002\rA\u0013X\rZ3g\u0013\t!VK\u0001\u0004TiJLgn\u001a\u0006\u0003%V\nAB\\;mYN\u000bg-Z#wC2$2\u0001W.]!\t!\u0014,\u0003\u0002[k\t\u0019\u0011I\\=\t\u000bq:\u0001\u0019\u0001-\t\u000b\t;\u0001\u0019\u0001-\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA0fUB\u0011\u0001mY\u0007\u0002C*\u0011!MG\u0001\bG>$WmZ3o\u0013\t!\u0017M\u0001\u0005FqB\u00148i\u001c3f\u0011\u00151\u0007\u00021\u0001h\u0003\r\u0019G\u000f\u001f\t\u0003A\"L!![1\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")1\u000e\u0003a\u0001?\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0002G]>Dq\u0001P\u0005\u0011\u0002\u0003\u0007a\bC\u0004C\u0013A\u0005\t\u0019\u0001 \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t!O\u000b\u0002?g.\nA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003sV\n!\"\u00198o_R\fG/[8o\u0013\tYhOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u00027b]\u001eT!!!\u0003\u0002\t)\fg/Y\u0005\u0004)\u0006\r\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\t!\r!\u00141C\u0005\u0004\u0003+)$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001-\u0002\u001c!I\u0011Q\u0004\b\u0002\u0002\u0003\u0007\u0011\u0011C\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0002#BA\u0013\u0003WAVBAA\u0014\u0015\r\tI#N\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0017\u0003O\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111GA\u001d!\r!\u0014QG\u0005\u0004\u0003o)$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003;\u0001\u0012\u0011!a\u00011\u00061Q-];bYN$B!a\r\u0002@!A\u0011QD\t\u0002\u0002\u0003\u0007\u0001\fK\b\u0001\u0003\u0007\nI%a\u0013\u0002P\u0005E\u0013QKA,!\rI\u0013QI\u0005\u0004\u0003\u000fR\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u001b\n\u0001+\u001a=qeF\u0002sLR+O\u0007~\u0003S\r\u001f9se\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011aKb\u0004(/\r1!KF,\u0018\r\\:!A\u0016D\bO\u001d\u001aaY\u0001z'\u000f\t4bYN,\u0007e\u001c;iKJ<\u0018n]3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002T\u0005\u0011iF\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(/\r\u0017!Kb\u0004(O\r\u0011.AQDW\r\t;x_\u0002*\u0007\u0010\u001d:fgNLwN\\:![V\u001cH\u000f\t2fAM\fW.\u001a\u0011usB,\u0007e\u001c:!G\u0006t\u0007EY3!G\u0006\u001cH/\u001a3!i>\u0004\u0013\rI2p[6|g\u000e\t;za\u0016d#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C:$\u0007%\\;ti\u0002\u0012W\rI1!if\u0004X\r\t;iCR\u00043-\u00198!E\u0016\u0004So]3eA%t\u0007%Z9vC2LG/\u001f\u0011d_6\u0004\u0018M]5t_:t\u0003%T1qAQL\b/\u001a\u0011jg\u0002rw\u000e\u001e\u0011tkB\u0004xN\u001d;fI:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011G_J\u00043m\\7qY\u0016D\b\u0005^=qKN\u00043/^2iA\u0005\u0014(/Y=0gR\u0014Xo\u0019;-AQDW\r\t3bi\u0006\u0004C/\u001f9fg\u0002zg\r\t4jK2$7\u000fI7vgR\u0004#-\u001a\u0011pe\u0012,'/\u00192mK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011L\u0001\u0002x)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#\u0007I0G+:\u001bu\f\t\u001a<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!c\u0001zf)\u0016(D?\u0002:\u0013gJ\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011ueV,\u0007e\u0018$V\u001d\u000e{\u0006ET+M\u0019nR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002rU\u000b\u0014'!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000f\u0015\u000bX/\u00197U_B\u0011\u0011fE\n\u0005'\u0005\u0005\u0014\bE\u0004\u0002d\u0005%dH\u0010$\u000e\u0005\u0005\u0015$bAA4k\u00059!/\u001e8uS6,\u0017\u0002BA6\u0003K\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\ti&\u0001\u0005u_N#(/\u001b8h)\u0005y\u0018!B1qa2LH#\u0002$\u0002x\u0005e\u0004\"\u0002\u001f\u0017\u0001\u0004q\u0004\"\u0002\"\u0017\u0001\u0004q\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u007f\nY\tE\u00035\u0003\u0003\u000b))C\u0002\u0002\u0004V\u0012aa\u00149uS>t\u0007#\u0002\u001b\u0002\bzr\u0014bAAEk\t1A+\u001e9mKJB\u0001\"!$\u0018\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a%\u0011\t\u0005\u0005\u0011QS\u0005\u0005\u0003/\u000b\u0019A\u0001\u0004PE*,7\r\u001e")
public class EqualTo
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualTo equalTo) {
        return EqualTo$.MODULE$.unapply(equalTo);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualTo> tupled() {
        return EqualTo$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualTo>> curried() {
        return EqualTo$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "=";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(left, right));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & java.io.Serializable & Serializable)(c1, c2) -> ctx.genEqual(this.left().dataType(), (String)c1, (String)c2));
    }

    public EqualTo copy(Expression left, Expression right) {
        return new EqualTo(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualTo";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualTo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualTo equalTo = (EqualTo)x$1;
        Expression expression = this.left();
        Expression expression2 = equalTo.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalTo.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalTo.canEqual(this)) return false;
        return true;
    }

    public EqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

