/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayBinaryLike;
import org.apache.spark.sql.catalyst.expressions.ArrayIntersect$;
import org.apache.spark.sql.catalyst.expressions.ArraySetLike;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.collection.OpenHashSet;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n  _FUNC_(array1, array2) - Returns an array of the elements in the intersection of array1 and\n    array2, without duplicates.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(1, 3, 5));\n       [1,3]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u000e\u001d\u0001&B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!A1\t\u0001BK\u0002\u0013\u0005a\b\u0003\u0005E\u0001\tE\t\u0015!\u0003@\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Q\u0005\u0001\"\u0011L\u0011!\u0011\u0006\u0001#b\u0001\n\u0003\u0019\u0006\"B1\u0001\t\u0003\u0012\u0007\"\u00026\u0001\t\u0003Z\u0007\"B=\u0001\t\u0003R\b\"CA\u0007\u0001\u0005\u0005I\u0011AA\b\u0011%\t)\u0002AI\u0001\n\u0003\t9\u0002C\u0005\u0002.\u0001\t\n\u0011\"\u0001\u0002\u0018!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0007\u0005\n\u0003\u0003\u0002\u0011\u0011!C\u0001\u0003\u0007B\u0011\"a\u0013\u0001\u0003\u0003%\t!!\u0014\t\u0013\u0005M\u0003!!A\u0005B\u0005U\u0003\"CA2\u0001\u0005\u0005I\u0011AA3\u0011%\ty\u0007AA\u0001\n\u0003\n\thB\u0005\u0002\u0010r\t\t\u0011#\u0001\u0002\u0012\u001aA1\u0004HA\u0001\u0012\u0003\t\u0019\n\u0003\u0004F+\u0011\u0005\u0011\u0011\u0015\u0005\n\u0003G+\u0012\u0011!C#\u0003KC\u0011\"a*\u0016\u0003\u0003%\t)!+\t\u0013\u0005=V#!A\u0005\u0002\u0006E\u0006\"CAb+\u0005\u0005I\u0011BAc\u00059\t%O]1z\u0013:$XM]:fGRT!!\b\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003?\u0001\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0007\u0001)r\u0013\u0007\u000e\u001e\u0011\u0005-bS\"\u0001\u000f\n\u00055b\"\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYs&\u0003\u000219\ty\u0011I\u001d:bs\nKg.\u0019:z\u0019&\\W\r\u0005\u0002,e%\u00111\u0007\b\u0002\u001d\u0007>l\u0007\u000f\\3y)f\u0004X-T3sO&tw-\u0012=qe\u0016\u001c8/[8o!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u001d\u0001&o\u001c3vGR\u0004\"!N\u001e\n\u0005q2$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012a\u0010\t\u0003W\u0001K!!\u0011\u000f\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dC\u0015\n\u0005\u0002,\u0001!)Q(\u0002a\u0001\u007f!)1)\u0002a\u0001\u007f\u0005AA-\u0019;b)f\u0004X-F\u0001M!\ti\u0005+D\u0001O\u0015\ty\u0005%A\u0003usB,7/\u0003\u0002R\u001d\nAA)\u0019;b)f\u0004X-A\u0007fm\u0006d\u0017J\u001c;feN,7\r^\u000b\u0002)B)Q'V,X/&\u0011aK\u000e\u0002\n\rVt7\r^5p]J\u0002\"\u0001W.\u000e\u0003eS!A\u0017\u0010\u0002\tU$\u0018\u000e\\\u0005\u00039f\u0013\u0011\"\u0011:sCf$\u0015\r^1)\u0005\u001dq\u0006CA\u001b`\u0013\t\u0001gGA\u0005ue\u0006t7/[3oi\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u00191M\u001a5\u0011\u0005U\"\u0017BA37\u0005\r\te.\u001f\u0005\u0006O\"\u0001\raY\u0001\u0007S:\u0004X\u000f^\u0019\t\u000b%D\u0001\u0019A2\u0002\r%t\u0007/\u001e;3\u0003%!wnR3o\u0007>$W\rF\u0002me^\u0004\"!\u001c9\u000e\u00039T!a\u001c\u000f\u0002\u000f\r|G-Z4f]&\u0011\u0011O\u001c\u0002\t\u000bb\u0004(oQ8eK\")1/\u0003a\u0001i\u0006\u00191\r\u001e=\u0011\u00055,\u0018B\u0001<o\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ\u0001_\u0005A\u00021\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001|!\ra\u0018q\u0001\b\u0004{\u0006\r\u0001C\u0001@7\u001b\u0005y(bAA\u0001Q\u00051AH]8pizJ1!!\u00027\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0001\u001c\u0002\t\r|\u0007/\u001f\u000b\u0006\u000f\u0006E\u00111\u0003\u0005\b{-\u0001\n\u00111\u0001@\u0011\u001d\u00195\u0002%AA\u0002}\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001a)\u001aq(a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\n7\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0003mC:<'BAA\u001f\u0003\u0011Q\u0017M^1\n\t\u0005%\u0011qG\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000b\u00022!NA$\u0013\r\tIE\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004G\u0006=\u0003\"CA)!\u0005\u0005\t\u0019AA#\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u000b\t\u0006\u00033\nyfY\u0007\u0003\u00037R1!!\u00187\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\nYF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA4\u0003[\u00022!NA5\u0013\r\tYG\u000e\u0002\b\u0005>|G.Z1o\u0011!\t\tFEA\u0001\u0002\u0004\u0019\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002h\u0005M\u0004\u0002CA)'\u0005\u0005\t\u0019A2)\u001f\u0001\t9(! \u0002\u0000\u0005\r\u0015QQAE\u0003\u0017\u00032aKA=\u0013\r\tY\b\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t)AA\u0002\u0015\u0001\u0002sLR+O\u0007~C\u0013M\u001d:bsFb\u0003%\u0019:sCf\u0014\u0014\u0006I\u0017!%\u0016$XO\u001d8tA\u0005t\u0007%\u0019:sCf\u0004sN\u001a\u0011uQ\u0016\u0004S\r\\3nK:$8\u000fI5oAQDW\rI5oi\u0016\u00148/Z2uS>t\u0007e\u001c4!CJ\u0014\u0018-_\u0019!C:$'\u0002\t\u0011!A\u0005\u0014(/Y=3Y\u0001:\u0018\u000e\u001e5pkR\u0004C-\u001e9mS\u000e\fG/Z:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0015!\u0016\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a*Y\u0001\n'O]1zQEb\u0003e\r\u0017!k%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YMj&\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u00055\u0015!\u0002\u001a/i9\u0002\u0014AD!se\u0006L\u0018J\u001c;feN,7\r\u001e\t\u0003WU\u0019B!FAKuA9\u0011qSAO\u007f}:UBAAM\u0015\r\tYJN\u0001\beVtG/[7f\u0013\u0011\ty*!'\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002\u0012\u0006AAo\\*ue&tw\r\u0006\u0002\u00024\u0005)\u0011\r\u001d9msR)q)a+\u0002.\")Q\b\u0007a\u0001\u007f!)1\t\u0007a\u0001\u007f\u00059QO\\1qa2LH\u0003BAZ\u0003\u007f\u0003R!NA[\u0003sK1!a.7\u0005\u0019y\u0005\u000f^5p]B)Q'a/@\u007f%\u0019\u0011Q\u0018\u001c\u0003\rQ+\b\u000f\\33\u0011!\t\t-GA\u0001\u0002\u00049\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\r\u0005\u0003\u00026\u0005%\u0017\u0002BAf\u0003o\u0011aa\u00142kK\u000e$\b")
public class ArrayIntersect
extends BinaryExpression
implements ArrayBinaryLike,
ComplexTypeMergingExpression,
scala.Serializable {
    private transient Function2<ArrayData, ArrayData, ArrayData> evalIntersect;
    private final Expression left;
    private final Expression right;
    private transient Seq<DataType> inputTypesForMerging;
    private transient boolean canUseSpecializedHashSet;
    private transient Ordering<Object> ordering;
    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    private transient String hsPostFix;
    private transient String hsTypeName;
    private transient String hsValueCast;
    private transient String nullValueHolder;
    private transient DataType elementType;
    private volatile transient int bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayIntersect arrayIntersect) {
        return ArrayIntersect$.MODULE$.unapply(arrayIntersect);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayIntersect> tupled() {
        return ArrayIntersect$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayIntersect>> curried() {
        return ArrayIntersect$.MODULE$.curried();
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$ArrayBinaryLike$$super$checkInputDataTypes() {
        return BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
    }

    @Override
    public DataType dt() {
        return ArrayBinaryLike.dt$(this);
    }

    @Override
    public DataType et() {
        return ArrayBinaryLike.et$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayBinaryLike.checkInputDataTypes$(this);
    }

    @Override
    public String genGetValue(String array, String i) {
        return ArraySetLike.genGetValue$(this, array, i);
    }

    @Override
    public String withResultArrayNullCheck(String body, String value, String nullElementIndex) {
        return ArraySetLike.withResultArrayNullCheck$(this, body, value, nullElementIndex);
    }

    @Override
    public String buildResultArray(String builder, String value, String size, String nullElementIndex) {
        return ArraySetLike.buildResultArray$(this, builder, value, size, nullElementIndex);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return (this.bitmap$trans$0 & 2) == 0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    private boolean canUseSpecializedHashSet$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.canUseSpecializedHashSet = ArraySetLike.canUseSpecializedHashSet$(this);
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.canUseSpecializedHashSet;
    }

    @Override
    public boolean canUseSpecializedHashSet() {
        return (this.bitmap$trans$0 & 4) == 0 ? this.canUseSpecializedHashSet$lzycompute() : this.canUseSpecializedHashSet;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.ordering = ArraySetLike.ordering$(this);
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.ordering;
    }

    @Override
    public Ordering<Object> ordering() {
        return (this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71 = ArraySetLike.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    }

    @Override
    public /* synthetic */ Tuple2 org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    }

    private String hsPostFix$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.hsPostFix = ArraySetLike.hsPostFix$(this);
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.hsPostFix;
    }

    @Override
    public String hsPostFix() {
        return (this.bitmap$trans$0 & 0x10) == 0 ? this.hsPostFix$lzycompute() : this.hsPostFix;
    }

    private String hsTypeName$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.hsTypeName = ArraySetLike.hsTypeName$(this);
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.hsTypeName;
    }

    @Override
    public String hsTypeName() {
        return (this.bitmap$trans$0 & 0x20) == 0 ? this.hsTypeName$lzycompute() : this.hsTypeName;
    }

    private String hsValueCast$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.hsValueCast = ArraySetLike.hsValueCast$(this);
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.hsValueCast;
    }

    @Override
    public String hsValueCast() {
        return (this.bitmap$trans$0 & 0x40) == 0 ? this.hsValueCast$lzycompute() : this.hsValueCast;
    }

    private String nullValueHolder$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.nullValueHolder = ArraySetLike.nullValueHolder$(this);
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.nullValueHolder;
    }

    @Override
    public String nullValueHolder() {
        return (this.bitmap$trans$0 & 0x80) == 0 ? this.nullValueHolder$lzycompute() : this.nullValueHolder;
    }

    private DataType elementType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (this.bitmap$trans$0 & 0x100) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        this.dataTypeCheck();
        return new ArrayType(this.elementType(), ((ArrayType)this.left().dataType()).containsNull() && ((ArrayType)this.right().dataType()).containsNull());
    }

    private Function2<ArrayData, ArrayData, ArrayData> evalIntersect$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.evalIntersect = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                    GenericArrayData genericArrayData;
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        int i;
                        OpenHashSet hs = new OpenHashSet(ClassTag$.MODULE$.Any());
                        OpenHashSet hsResult = new OpenHashSet(ClassTag$.MODULE$.Any());
                        boolean foundNullElement = false;
                        for (i = 0; i < array2.numElements(); ++i) {
                            if (array2.isNullAt(i)) {
                                foundNullElement = true;
                                continue;
                            }
                            Object elem = array2.get(i, this.elementType());
                            hs.add(elem);
                        }
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        for (i = 0; i < array1.numElements(); ++i) {
                            if (array1.isNullAt(i)) {
                                if (!foundNullElement) continue;
                                arrayBuffer.$plus$eq(null);
                                foundNullElement = false;
                                continue;
                            }
                            Object elem = array1.get(i, this.elementType());
                            if (!hs.contains(elem) || hsResult.contains(elem)) continue;
                            arrayBuffer.$plus$eq(elem);
                            hsResult.add(elem);
                        }
                        genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer);
                    } else {
                        genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                    }
                    return genericArrayData;
                } : (Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                    GenericArrayData genericArrayData;
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        boolean alreadySeenNull = false;
                        for (int i = 0; i < array1.numElements(); ++i) {
                            boolean found = false;
                            Object elem1 = array1.get(i, this.elementType());
                            if (array1.isNullAt(i)) {
                                if (!alreadySeenNull) {
                                    for (int j = 0; !found && j < array2.numElements(); ++j) {
                                        found = array2.isNullAt(j);
                                    }
                                    alreadySeenNull = true;
                                }
                            } else {
                                for (int j = 0; !found && j < array2.numElements(); ++j) {
                                    if (array2.isNullAt(j)) continue;
                                    Object elem2 = array2.get(j, this.elementType());
                                    if (!this.ordering().equiv(elem1, elem2)) continue;
                                    boolean foundArrayBuffer = false;
                                    for (int k = 0; !foundArrayBuffer && k < arrayBuffer.size(); ++k) {
                                        Object va = arrayBuffer.apply(k);
                                        foundArrayBuffer = va != null && this.ordering().equiv(va, elem1);
                                    }
                                    found = !foundArrayBuffer;
                                }
                            }
                            Object object = found ? arrayBuffer.$plus$eq(elem1) : BoxedUnit.UNIT;
                        }
                        genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer);
                    } else {
                        genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                    }
                    return genericArrayData;
                };
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.evalIntersect;
    }

    public Function2<ArrayData, ArrayData, ArrayData> evalIntersect() {
        return (this.bitmap$trans$0 & 1) == 0 ? this.evalIntersect$lzycompute() : this.evalIntersect;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        ArrayData array1 = (ArrayData)input1;
        ArrayData array2 = (ArrayData)input2;
        return this.evalIntersect().apply((Object)array1, (Object)array2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String i = ctx.freshName("i");
        String value = ctx.freshName("value");
        String size = ctx.freshName("size");
        if (this.canUseSpecializedHashSet()) {
            String jt = CodeGenerator$.MODULE$.javaType(this.elementType());
            String ptName = CodeGenerator$.MODULE$.primitiveTypeName(jt);
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                String foundNullElement = ctx.freshName("foundNullElement");
                String nullElementIndex = ctx.freshName("nullElementIndex");
                String builder = ctx.freshName("builder");
                String openHashSet = OpenHashSet.class.getName();
                String classTag = new StringBuilder(34).append("scala.reflect.ClassTag$.MODULE$.").append(this.hsTypeName()).append("()").toString();
                String hashSet = ctx.freshName("hashSet");
                String hashSetResult = ctx.freshName("hashSetResult");
                String arrayBuilder = ArrayBuilder.class.getName();
                String arrayBuilderClass = new StringBuilder(3).append(arrayBuilder).append("$of").append(ptName).toString();
                String writeArray2ToHashSet = this.withArray2NullCheck$1(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(54).append("\n             |").append(jt).append(" ").append(value).append(" = ").append(this.genGetValue((String)array2, i)).append(";\n             |").append(hashSet).append(".add").append(this.hsPostFix()).append("(").append(this.hsValueCast()).append(value).append(");\n           ").toString())).stripMargin(), (String)array2, i, foundNullElement);
                String processArray1 = this.withArray1NullAssignment$1(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(240).append("\n             |").append(jt).append(" ").append(value).append(" = ").append(this.genGetValue((String)array1, i)).append(";\n             |if (").append(hashSet).append(".contains(").append(this.hsValueCast()).append(value).append(") &&\n             |    !").append(hashSetResult).append(".contains(").append(this.hsValueCast()).append(value).append(")) {\n             |  if (++").append(size).append(" > ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(") {\n             |    break;\n             |  }\n             |  ").append(hashSetResult).append(".add").append(this.hsPostFix()).append("(").append(this.hsValueCast()).append(value).append(");\n             |  ").append(builder).append(".$plus$eq(").append(value).append(");\n             |}\n           ").toString())).stripMargin(), (String)array1, i, foundNullElement, nullElementIndex, size, builder);
                String declareNullTrackVariables = ((ArrayType)this.dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n             |boolean ").append(foundNullElement).append(" = false;\n             |int ").append(nullElementIndex).append(" = -1;\n           ").toString())).stripMargin() : "";
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(292).append("\n           |").append(openHashSet).append(" ").append(hashSet).append(" = new ").append(openHashSet).append(this.hsPostFix()).append("(").append(classTag).append(");\n           |").append(openHashSet).append(" ").append(hashSetResult).append(" = new ").append(openHashSet).append(this.hsPostFix()).append("(").append(classTag).append(");\n           |").append(declareNullTrackVariables).append("\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)array2).append(".numElements(); ").append(i).append("++) {\n           |  ").append(writeArray2ToHashSet).append("\n           |}\n           |").append(arrayBuilderClass).append(" ").append(builder).append(" = new ").append(arrayBuilderClass).append("();\n           |int ").append(size).append(" = 0;\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)array1).append(".numElements(); ").append(i).append("++) {\n           |  ").append(processArray1).append("\n           |}\n           |").append(this.buildResultArray(builder, ExprValue$.MODULE$.exprValueToString(ev.value()), size, nullElementIndex)).append("\n         ").toString())).stripMargin();
            });
        } else {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                String expr = ctx.addReferenceObj("arrayIntersectExpr", this, ctx.addReferenceObj$default$3());
                return new StringBuilder(32).append(ev.value()).append(" = (ArrayData)").append(expr).append(".nullSafeEval(").append((String)array1).append(", ").append((String)array2).append(");").toString();
            });
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "array_intersect";
    }

    public ArrayIntersect copy(Expression left, Expression right) {
        return new ArrayIntersect(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayIntersect";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayIntersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayIntersect)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayIntersect arrayIntersect = (ArrayIntersect)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayIntersect.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayIntersect.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayIntersect.canEqual(this)) return false;
        return true;
    }

    private final String withArray2NullCheck$1(String body, String array2$1, String i$5, String foundNullElement$4) {
        return ((ArrayType)this.right().dataType()).containsNull() ? (((ArrayType)this.left().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("\n                 |if (").append(array2$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  ").append(foundNullElement$4).append(" = true;\n                 |} else {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n                 |if (!").append(array2$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin()) : body;
    }

    private final String withArray1NullAssignment$1(String body, String array1$1, String i$5, String foundNullElement$4, String nullElementIndex$3, String size$3, String builder$3) {
        return ((ArrayType)this.left().dataType()).containsNull() ? (((ArrayType)this.right().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(291).append("\n                 |if (").append(array1$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  if (").append(foundNullElement$4).append(") {\n                 |    ").append(nullElementIndex$3).append(" = ").append(size$3).append(";\n                 |    ").append(foundNullElement$4).append(" = false;\n                 |    ").append(size$3).append("++;\n                 |    ").append(builder$3).append(".$plus$eq(").append(this.nullValueHolder()).append(");\n                 |  }\n                 |} else {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n                 |if (!").append(array1$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin()) : body;
    }

    public ArrayIntersect(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        ArraySetLike.$init$(this);
        ArrayBinaryLike.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
    }
}

