/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function2;
import scala.Serializable;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M3Q\u0001B\u0003\u0002\u0002IAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\u0002yAQa\u0010\u0001\u0005\u0002\u0001\u0013qbR3u\u001b\u0006\u0004h+\u00197vKV#\u0018\u000e\u001c\u0006\u0003\r\u001d\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001\"C\u0001\tG\u0006$\u0018\r\\=ti*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\f\u0011\u0005Q)R\"A\u0003\n\u0005Y)!\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t!\u0002$\u0003\u0002\u001a\u000b\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7/\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011A\u0003A\u0001\rO\u0016$h+\u00197vK\u00163\u0018\r\u001c\u000b\u0006?\u0015:\u0013&\r\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0004\u0003:L\b\"\u0002\u0014\u0003\u0001\u0004y\u0012!\u0002<bYV,\u0007\"\u0002\u0015\u0003\u0001\u0004y\u0012aB8sI&t\u0017\r\u001c\u0005\u0006U\t\u0001\raK\u0001\bW\u0016LH+\u001f9f!\tas&D\u0001.\u0015\tq\u0013\"A\u0003usB,7/\u0003\u00021[\tAA)\u0019;b)f\u0004X\rC\u00033\u0005\u0001\u00071'\u0001\u0005pe\u0012,'/\u001b8h!\r!Dh\b\b\u0003kir!AN\u001d\u000e\u0003]R!\u0001O\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013BA\u001e\"\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0010 \u0003\u0011=\u0013H-\u001a:j]\u001eT!aO\u0011\u0002#\u0011|w)\u001a;WC2,XmR3o\u0007>$W\r\u0006\u0003B\u000f2s\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\u0006\u0003\u001d\u0019w\u000eZ3hK:L!AR\"\u0003\u0011\u0015C\bO]\"pI\u0016DQ\u0001S\u0002A\u0002%\u000b1a\u0019;y!\t\u0011%*\u0003\u0002L\u0007\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B'\u0004\u0001\u0004\t\u0015AA3w\u0011\u0015y5\u00011\u0001Q\u0003\u001di\u0017\r\u001d+za\u0016\u0004\"\u0001L)\n\u0005Ik#aB'baRK\b/\u001a")
public abstract class GetMapValueUtil
extends BinaryExpression
implements ImplicitCastInputTypes {
    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering) {
        MapData map = (MapData)value;
        int length = map.numElements();
        ArrayData keys = map.keyArray();
        ArrayData values = map.valueArray();
        int i = 0;
        boolean found = false;
        while (i < length && !found) {
            if (ordering.equiv(keys.get(i, keyType), ordinal)) {
                found = true;
                continue;
            }
            ++i;
        }
        return !found || values.isNullAt(i) ? null : values.get(i, this.dataType());
    }

    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType) {
        String index = ctx.freshName("index");
        String length = ctx.freshName("length");
        String keys = ctx.freshName("keys");
        String found = ctx.freshName("found");
        String key = ctx.freshName("key");
        String values = ctx.freshName("values");
        DataType keyType = mapType.keyType();
        String nullCheck = mapType.valueContainsNull() ? new StringBuilder(15).append(" || ").append(values).append(".isNullAt(").append(index).append(")").toString() : "";
        String keyJavaType = CodeGenerator$.MODULE$.javaType(keyType);
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & java.io.Serializable & Serializable)(eval1, eval2) -> new StringBuilder(395).append("\n        final int ").append(length).append(" = ").append((String)eval1).append(".numElements();\n        final ArrayData ").append(keys).append(" = ").append((String)eval1).append(".keyArray();\n        final ArrayData ").append(values).append(" = ").append((String)eval1).append(".valueArray();\n\n        int ").append(index).append(" = 0;\n        boolean ").append(found).append(" = false;\n        while (").append(index).append(" < ").append(length).append(" && !").append(found).append(") {\n          final ").append(keyJavaType).append(" ").append(key).append(" = ").append(CodeGenerator$.MODULE$.getValue(keys, keyType, index)).append(";\n          if (").append(ctx.genEqual(keyType, key, (String)eval2)).append(") {\n            ").append(found).append(" = true;\n          } else {\n            ").append(index).append("++;\n          }\n        }\n\n        if (!").append(found).append(nullCheck).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue(values, this.dataType(), index)).append(";\n        }\n      ").toString());
    }

    public GetMapValueUtil() {
        ExpectsInputTypes.$init$(this);
    }
}

